package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * DomainNameAttributes domainNameAttributes = DomainNameAttributes.builder()
 *         .domainName("domainName")
 *         .domainNameAliasHostedZoneId("domainNameAliasHostedZoneId")
 *         .domainNameAliasTarget("domainNameAliasTarget")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:48.356Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.DomainNameAttributes")
@software.amazon.jsii.Jsii.Proxy(DomainNameAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DomainNameAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The domain name (e.g. `example.com`).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * The Route53 hosted zone ID to use in order to connect a record set to this domain through an alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainNameAliasHostedZoneId();

    /**
     * The Route53 alias target to use in order to connect a record set to this domain through an alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainNameAliasTarget();

    /**
     * @return a {@link Builder} of {@link DomainNameAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DomainNameAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DomainNameAttributes> {
        java.lang.String domainName;
        java.lang.String domainNameAliasHostedZoneId;
        java.lang.String domainNameAliasTarget;

        /**
         * Sets the value of {@link DomainNameAttributes#getDomainName}
         * @param domainName The domain name (e.g. `example.com`). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link DomainNameAttributes#getDomainNameAliasHostedZoneId}
         * @param domainNameAliasHostedZoneId The Route53 hosted zone ID to use in order to connect a record set to this domain through an alias. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainNameAliasHostedZoneId(java.lang.String domainNameAliasHostedZoneId) {
            this.domainNameAliasHostedZoneId = domainNameAliasHostedZoneId;
            return this;
        }

        /**
         * Sets the value of {@link DomainNameAttributes#getDomainNameAliasTarget}
         * @param domainNameAliasTarget The Route53 alias target to use in order to connect a record set to this domain through an alias. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainNameAliasTarget(java.lang.String domainNameAliasTarget) {
            this.domainNameAliasTarget = domainNameAliasTarget;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DomainNameAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DomainNameAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DomainNameAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainNameAttributes {
        private final java.lang.String domainName;
        private final java.lang.String domainNameAliasHostedZoneId;
        private final java.lang.String domainNameAliasTarget;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainNameAliasHostedZoneId = software.amazon.jsii.Kernel.get(this, "domainNameAliasHostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainNameAliasTarget = software.amazon.jsii.Kernel.get(this, "domainNameAliasTarget", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.domainNameAliasHostedZoneId = java.util.Objects.requireNonNull(builder.domainNameAliasHostedZoneId, "domainNameAliasHostedZoneId is required");
            this.domainNameAliasTarget = java.util.Objects.requireNonNull(builder.domainNameAliasTarget, "domainNameAliasTarget is required");
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.String getDomainNameAliasHostedZoneId() {
            return this.domainNameAliasHostedZoneId;
        }

        @Override
        public final java.lang.String getDomainNameAliasTarget() {
            return this.domainNameAliasTarget;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainName", om.valueToTree(this.getDomainName()));
            data.set("domainNameAliasHostedZoneId", om.valueToTree(this.getDomainNameAliasHostedZoneId()));
            data.set("domainNameAliasTarget", om.valueToTree(this.getDomainNameAliasTarget()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.DomainNameAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DomainNameAttributes.Jsii$Proxy that = (DomainNameAttributes.Jsii$Proxy) o;

            if (!domainName.equals(that.domainName)) return false;
            if (!domainNameAliasHostedZoneId.equals(that.domainNameAliasHostedZoneId)) return false;
            return this.domainNameAliasTarget.equals(that.domainNameAliasTarget);
        }

        @Override
        public final int hashCode() {
            int result = this.domainName.hashCode();
            result = 31 * result + (this.domainNameAliasHostedZoneId.hashCode());
            result = 31 * result + (this.domainNameAliasTarget.hashCode());
            return result;
        }
    }
}
