package software.amazon.awscdk.services.apigateway;

/**
 * An API Gateway ApiKey, for which a rate limiting configuration can be specified.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * RestApi api;
 * RateLimitedApiKey key = RateLimitedApiKey.Builder.create(this, "rate-limited-api-key")
 *         .customerId("hello-customer")
 *         .resources(List.of(api))
 *         .quota(QuotaSettings.builder()
 *                 .limit(10000)
 *                 .period(Period.MONTH)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:48.461Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.RateLimitedApiKey")
public class RateLimitedApiKey extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.apigateway.IApiKey {

    protected RateLimitedApiKey(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RateLimitedApiKey(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RateLimitedApiKey(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.RateLimitedApiKeyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RateLimitedApiKey(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Permits the IAM principal all read operations through this key.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Permits the IAM principal all read and write operations through this key.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantReadWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Permits the IAM principal all write operations through this key.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * The API key ARN.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "keyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The API key ID.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKeyId() {
        return software.amazon.jsii.Kernel.get(this, "keyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.RateLimitedApiKey}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.RateLimitedApiKey> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.apigateway.RateLimitedApiKeyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Adds a CORS preflight OPTIONS method to this resource and all child resources.
         * <p>
         * You can add CORS at the resource-level using <code>addCorsPreflight</code>.
         * <p>
         * Default: - CORS is disabled
         * <p>
         * @return {@code this}
         * @param defaultCorsPreflightOptions Adds a CORS preflight OPTIONS method to this resource and all child resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCorsPreflightOptions(final software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions) {
            this.props().defaultCorsPreflightOptions(defaultCorsPreflightOptions);
            return this;
        }

        /**
         * An integration to use as a default for all methods created within this API unless an integration is specified.
         * <p>
         * Default: - Inherited from parent.
         * <p>
         * @return {@code this}
         * @param defaultIntegration An integration to use as a default for all methods created within this API unless an integration is specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultIntegration(final software.amazon.awscdk.services.apigateway.Integration defaultIntegration) {
            this.props().defaultIntegration(defaultIntegration);
            return this;
        }

        /**
         * Method options to use as a default for all methods created within this API unless custom options are specified.
         * <p>
         * Default: - Inherited from parent.
         * <p>
         * @return {@code this}
         * @param defaultMethodOptions Method options to use as a default for all methods created within this API unless custom options are specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultMethodOptions(final software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions) {
            this.props().defaultMethodOptions(defaultMethodOptions);
            return this;
        }

        /**
         * A name for the API key.
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the API key name.
         * <p>
         * Default: automically generated name
         * <p>
         * @return {@code this}
         * @param apiKeyName A name for the API key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyName(final java.lang.String apiKeyName) {
            this.props().apiKeyName(apiKeyName);
            return this;
        }

        /**
         * A description of the purpose of the API key.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param description A description of the purpose of the API key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * The value of the API key.
         * <p>
         * Must be at least 20 characters long.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param value The value of the API key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder value(final java.lang.String value) {
            this.props().value(value);
            return this;
        }

        /**
         * An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param customerId An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerId(final java.lang.String customerId) {
            this.props().customerId(customerId);
            return this;
        }

        /**
         * Indicates whether the API key can be used by clients.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled Indicates whether the API key can be used by clients. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props().enabled(enabled);
            return this;
        }

        /**
         * Specifies whether the key identifier is distinct from the created API key value.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param generateDistinctId Specifies whether the key identifier is distinct from the created API key value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateDistinctId(final java.lang.Boolean generateDistinctId) {
            this.props().generateDistinctId(generateDistinctId);
            return this;
        }

        /**
         * A list of resources this api key is associated with.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param resources A list of resources this api key is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resources(final java.util.List<? extends software.amazon.awscdk.services.apigateway.IRestApi> resources) {
            this.props().resources(resources);
            return this;
        }

        /**
         * API Stages to be associated with the RateLimitedApiKey.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param apiStages API Stages to be associated with the RateLimitedApiKey. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiStages(final java.util.List<? extends software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> apiStages) {
            this.props().apiStages(apiStages);
            return this;
        }

        /**
         * Number of requests clients can make in a given time period.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param quota Number of requests clients can make in a given time period. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quota(final software.amazon.awscdk.services.apigateway.QuotaSettings quota) {
            this.props().quota(quota);
            return this;
        }

        /**
         * Overall throttle settings for the API.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param throttle Overall throttle settings for the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttle(final software.amazon.awscdk.services.apigateway.ThrottleSettings throttle) {
            this.props().throttle(throttle);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.RateLimitedApiKey}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.RateLimitedApiKey build() {
            return new software.amazon.awscdk.services.apigateway.RateLimitedApiKey(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.apigateway.RateLimitedApiKeyProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.apigateway.RateLimitedApiKeyProps.Builder();
            }
            return this.props;
        }
    }
}
