package software.amazon.awscdk.services.apigateway;

/**
 * Time period for which quota settings apply.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * RestApi api;
 * RateLimitedApiKey key = RateLimitedApiKey.Builder.create(this, "rate-limited-api-key")
 *         .customerId("hello-customer")
 *         .resources(List.of(api))
 *         .quota(QuotaSettings.builder()
 *                 .limit(10000)
 *                 .period(Period.MONTH)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.73.0 (build 6faeda3)", date = "2023-01-31T18:36:58.264Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.Period")
public enum Period {
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DAY,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WEEK,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTH,
}
