package software.amazon.awscdk.services.apigateway;

/**
 * A CloudFormation `AWS::ApiGateway::Method`.
 * <p>
 * The <code>AWS::ApiGateway::Method</code> resource creates API Gateway methods that define the parameters and body that clients must send in their requests.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * CfnMethod cfnMethod = CfnMethod.Builder.create(this, "MyCfnMethod")
 *         .httpMethod("httpMethod")
 *         .resourceId("resourceId")
 *         .restApiId("restApiId")
 *         // the properties below are optional
 *         .apiKeyRequired(false)
 *         .authorizationScopes(List.of("authorizationScopes"))
 *         .authorizationType("authorizationType")
 *         .authorizerId("authorizerId")
 *         .integration(IntegrationProperty.builder()
 *                 .cacheKeyParameters(List.of("cacheKeyParameters"))
 *                 .cacheNamespace("cacheNamespace")
 *                 .connectionId("connectionId")
 *                 .connectionType("connectionType")
 *                 .contentHandling("contentHandling")
 *                 .credentials("credentials")
 *                 .integrationHttpMethod("integrationHttpMethod")
 *                 .integrationResponses(List.of(IntegrationResponseProperty.builder()
 *                         .statusCode("statusCode")
 *                         // the properties below are optional
 *                         .contentHandling("contentHandling")
 *                         .responseParameters(Map.of(
 *                                 "responseParametersKey", "responseParameters"))
 *                         .responseTemplates(Map.of(
 *                                 "responseTemplatesKey", "responseTemplates"))
 *                         .selectionPattern("selectionPattern")
 *                         .build()))
 *                 .passthroughBehavior("passthroughBehavior")
 *                 .requestParameters(Map.of(
 *                         "requestParametersKey", "requestParameters"))
 *                 .requestTemplates(Map.of(
 *                         "requestTemplatesKey", "requestTemplates"))
 *                 .timeoutInMillis(123)
 *                 .type("type")
 *                 .uri("uri")
 *                 .build())
 *         .methodResponses(List.of(MethodResponseProperty.builder()
 *                 .statusCode("statusCode")
 *                 // the properties below are optional
 *                 .responseModels(Map.of(
 *                         "responseModelsKey", "responseModels"))
 *                 .responseParameters(Map.of(
 *                         "responseParametersKey", false))
 *                 .build()))
 *         .operationName("operationName")
 *         .requestModels(Map.of(
 *                 "requestModelsKey", "requestModels"))
 *         .requestParameters(Map.of(
 *                 "requestParametersKey", false))
 *         .requestValidatorId("requestValidatorId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-15T20:01:43.176Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnMethod")
public class CfnMethod extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnMethod(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMethod(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnMethod.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ApiGateway::Method`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMethod(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.CfnMethodProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The method's HTTP verb.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getHttpMethod() {
        return software.amazon.jsii.Kernel.get(this, "httpMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The method's HTTP verb.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHttpMethod(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "httpMethod", java.util.Objects.requireNonNull(value, "httpMethod is required"));
    }

    /**
     * The Resource identifier for the MethodResponse resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceId() {
        return software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Resource identifier for the MethodResponse resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceId", java.util.Objects.requireNonNull(value, "resourceId is required"));
    }

    /**
     * The string identifier of the associated RestApi.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRestApiId() {
        return software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The string identifier of the associated RestApi.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestApiId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "restApiId", java.util.Objects.requireNonNull(value, "restApiId is required"));
    }

    /**
     * A boolean flag specifying whether a valid ApiKey is required to invoke this method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getApiKeyRequired() {
        return software.amazon.jsii.Kernel.get(this, "apiKeyRequired", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A boolean flag specifying whether a valid ApiKey is required to invoke this method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApiKeyRequired(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "apiKeyRequired", value);
    }

    /**
     * A boolean flag specifying whether a valid ApiKey is required to invoke this method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApiKeyRequired(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "apiKeyRequired", value);
    }

    /**
     * A list of authorization scopes configured on the method.
     * <p>
     * The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAuthorizationScopes() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "authorizationScopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of authorization scopes configured on the method.
     * <p>
     * The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthorizationScopes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "authorizationScopes", value);
    }

    /**
     * The method's authorization type.
     * <p>
     * This parameter is required. For valid values, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_Method.html">Method</a> in the <em>API Gateway API Reference</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>AuthorizerId</code> property, specify <code>CUSTOM</code> or <code>COGNITO_USER_POOLS</code> for this property.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAuthorizationType() {
        return software.amazon.jsii.Kernel.get(this, "authorizationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The method's authorization type.
     * <p>
     * This parameter is required. For valid values, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_Method.html">Method</a> in the <em>API Gateway API Reference</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>AuthorizerId</code> property, specify <code>CUSTOM</code> or <code>COGNITO_USER_POOLS</code> for this property.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthorizationType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "authorizationType", value);
    }

    /**
     * The identifier of an Authorizer to use on this method.
     * <p>
     * The <code>authorizationType</code> must be <code>CUSTOM</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerId() {
        return software.amazon.jsii.Kernel.get(this, "authorizerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of an Authorizer to use on this method.
     * <p>
     * The <code>authorizationType</code> must be <code>CUSTOM</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthorizerId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "authorizerId", value);
    }

    /**
     * Represents an `HTTP` , `HTTP_PROXY` , `AWS` , `AWS_PROXY` , or Mock integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIntegration() {
        return software.amazon.jsii.Kernel.get(this, "integration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Represents an `HTTP` , `HTTP_PROXY` , `AWS` , `AWS_PROXY` , or Mock integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIntegration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "integration", value);
    }

    /**
     * Represents an `HTTP` , `HTTP_PROXY` , `AWS` , `AWS_PROXY` , or Mock integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIntegration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CfnMethod.IntegrationProperty value) {
        software.amazon.jsii.Kernel.set(this, "integration", value);
    }

    /**
     * Gets a method response associated with a given HTTP status code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMethodResponses() {
        return software.amazon.jsii.Kernel.get(this, "methodResponses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Gets a method response associated with a given HTTP status code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMethodResponses(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "methodResponses", value);
    }

    /**
     * Gets a method response associated with a given HTTP status code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMethodResponses(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.apigateway.CfnMethod.MethodResponseProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.apigateway.CfnMethod.MethodResponseProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "methodResponses", value);
    }

    /**
     * A human-friendly operation identifier for the method.
     * <p>
     * For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOperationName() {
        return software.amazon.jsii.Kernel.get(this, "operationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A human-friendly operation identifier for the method.
     * <p>
     * For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOperationName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "operationName", value);
    }

    /**
     * A key-value map specifying data schemas, represented by Model resources, (as the mapped value) of the request payloads of given content types (as the mapping key).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRequestModels() {
        return software.amazon.jsii.Kernel.get(this, "requestModels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A key-value map specifying data schemas, represented by Model resources, (as the mapped value) of the request payloads of given content types (as the mapping key).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequestModels(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "requestModels", value);
    }

    /**
     * A key-value map specifying data schemas, represented by Model resources, (as the mapped value) of the request payloads of given content types (as the mapping key).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequestModels(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "requestModels", value);
    }

    /**
     * A key-value map defining required or optional method request parameters that can be accepted by API Gateway.
     * <p>
     * A key is a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code> , where <code>location</code> is <code>querystring</code> , <code>path</code> , or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required ( <code>true</code> ) or optional ( <code>false</code> ). The method request parameter names defined here are available in Integration to be mapped to integration request parameters or templates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRequestParameters() {
        return software.amazon.jsii.Kernel.get(this, "requestParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A key-value map defining required or optional method request parameters that can be accepted by API Gateway.
     * <p>
     * A key is a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code> , where <code>location</code> is <code>querystring</code> , <code>path</code> , or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required ( <code>true</code> ) or optional ( <code>false</code> ). The method request parameter names defined here are available in Integration to be mapped to integration request parameters or templates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequestParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "requestParameters", value);
    }

    /**
     * A key-value map defining required or optional method request parameters that can be accepted by API Gateway.
     * <p>
     * A key is a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code> , where <code>location</code> is <code>querystring</code> , <code>path</code> , or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required ( <code>true</code> ) or optional ( <code>false</code> ). The method request parameter names defined here are available in Integration to be mapped to integration request parameters or templates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequestParameters(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof java.lang.Boolean)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: java.lang.Boolean, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "requestParameters", value);
    }

    /**
     * The identifier of a RequestValidator for request validation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRequestValidatorId() {
        return software.amazon.jsii.Kernel.get(this, "requestValidatorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of a RequestValidator for request validation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequestValidatorId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "requestValidatorId", value);
    }
    /**
     * `Integration` is a property of the [AWS::ApiGateway::Method](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html) resource that specifies information about the target backend that a method calls.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigateway.*;
     * IntegrationProperty integrationProperty = IntegrationProperty.builder()
     *         .cacheKeyParameters(List.of("cacheKeyParameters"))
     *         .cacheNamespace("cacheNamespace")
     *         .connectionId("connectionId")
     *         .connectionType("connectionType")
     *         .contentHandling("contentHandling")
     *         .credentials("credentials")
     *         .integrationHttpMethod("integrationHttpMethod")
     *         .integrationResponses(List.of(IntegrationResponseProperty.builder()
     *                 .statusCode("statusCode")
     *                 // the properties below are optional
     *                 .contentHandling("contentHandling")
     *                 .responseParameters(Map.of(
     *                         "responseParametersKey", "responseParameters"))
     *                 .responseTemplates(Map.of(
     *                         "responseTemplatesKey", "responseTemplates"))
     *                 .selectionPattern("selectionPattern")
     *                 .build()))
     *         .passthroughBehavior("passthroughBehavior")
     *         .requestParameters(Map.of(
     *                 "requestParametersKey", "requestParameters"))
     *         .requestTemplates(Map.of(
     *                 "requestTemplatesKey", "requestTemplates"))
     *         .timeoutInMillis(123)
     *         .type("type")
     *         .uri("uri")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnMethod.IntegrationProperty")
    @software.amazon.jsii.Jsii.Proxy(IntegrationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntegrationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of request parameters whose values API Gateway caches.
         * <p>
         * To be valid values for <code>cacheKeyParameters</code> , these parameters must also be specified for Method <code>requestParameters</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCacheKeyParameters() {
            return null;
        }

        /**
         * Specifies a group of related cached parameters.
         * <p>
         * By default, API Gateway uses the resource ID as the <code>cacheNamespace</code> . You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCacheNamespace() {
            return null;
        }

        /**
         * The ID of the VpcLink used for the integration when `connectionType=VPC_LINK` and undefined, otherwise.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionId() {
            return null;
        }

        /**
         * The type of the network connection to the integration endpoint.
         * <p>
         * The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionType() {
            return null;
        }

        /**
         * Specifies how to handle request payload content type conversions.
         * <p>
         * Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code> , with the following behaviors:
         * <p>
         * If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContentHandling() {
            return null;
        }

        /**
         * Specifies the credentials required for the integration, if any.
         * <p>
         * For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code> . To use resource-based permissions on supported AWS services, specify null.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCredentials() {
            return null;
        }

        /**
         * Specifies the integration's HTTP method type.
         * <p>
         * For the Type property, if you specify <code>MOCK</code> , this property is optional. For Lambda integrations, you must set the integration method to <code>POST</code> . For all other types, you must specify this property.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIntegrationHttpMethod() {
            return null;
        }

        /**
         * Specifies the integration's responses.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntegrationResponses() {
            return null;
        }

        /**
         * Specifies how the method request body of an unmapped content type will be passed through the integration request to the back end without transformation.
         * <p>
         * A content type is unmapped if no mapping template is defined in the integration or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code> . The valid value is one of the following: <code>WHEN_NO_MATCH</code> : passes the method request body through the integration request to the back end without transformation when the method request content type does not match any content type associated with the mapping templates defined in the integration request. <code>WHEN_NO_TEMPLATES</code> : passes the method request body through the integration request to the back end without transformation when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request of an unmapped content-type will be rejected with an HTTP 415 Unsupported Media Type response. <code>NEVER</code> : rejects the method request with an HTTP 415 Unsupported Media Type response when either the method request content type does not match any content type associated with the mapping templates defined in the integration request or no mapping template is defined in the integration request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassthroughBehavior() {
            return null;
        }

        /**
         * A key-value map specifying request parameters that are passed from the method request to the back end.
         * <p>
         * The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of <code>method.request.{location}.{name}</code> , where <code>location</code> is <code>querystring</code> , <code>path</code> , or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequestParameters() {
            return null;
        }

        /**
         * Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client.
         * <p>
         * The content type value is the key in this map, and the template (as a String) is the value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequestTemplates() {
            return null;
        }

        /**
         * Custom timeout between 50 and 29,000 milliseconds.
         * <p>
         * The default value is 29,000 milliseconds or 29 seconds.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInMillis() {
            return null;
        }

        /**
         * Specifies an API method integration type. The valid value is one of the following:.
         * <p>
         * For the HTTP and HTTP proxy integrations, each integration can specify a protocol ( <code>http/https</code> ), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * Specifies Uniform Resource Identifier (URI) of the integration endpoint.
         * <p>
         * For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification for standard integrations. If <code>connectionType</code> is <code>VPC_LINK</code> specify the Network Load Balancer DNS name. For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code> . Here, {Region} is the API Gateway region (e.g., us-east-1); {service} is the name of the integrated AWS service (e.g., s3); and {subdomain} is a designated subdomain supported by certain AWS service for fast host-name lookup. action can be used for an AWS service action-based API, using an Action={name}&amp;{p1}={v1}&amp;p2={v2}... query string. The ensuing {service_api} refers to a supported action {name} plus any required input parameters. Alternatively, path can be used for an AWS service path-based API. The ensuing service_api refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of GetObject, the uri can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&amp;Bucket={bucket}&amp;Key={key}</code> or <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IntegrationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntegrationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntegrationProperty> {
            java.util.List<java.lang.String> cacheKeyParameters;
            java.lang.String cacheNamespace;
            java.lang.String connectionId;
            java.lang.String connectionType;
            java.lang.String contentHandling;
            java.lang.String credentials;
            java.lang.String integrationHttpMethod;
            java.lang.Object integrationResponses;
            java.lang.String passthroughBehavior;
            java.lang.Object requestParameters;
            java.lang.Object requestTemplates;
            java.lang.Number timeoutInMillis;
            java.lang.String type;
            java.lang.String uri;

            /**
             * Sets the value of {@link IntegrationProperty#getCacheKeyParameters}
             * @param cacheKeyParameters A list of request parameters whose values API Gateway caches.
             *                           To be valid values for <code>cacheKeyParameters</code> , these parameters must also be specified for Method <code>requestParameters</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheKeyParameters(java.util.List<java.lang.String> cacheKeyParameters) {
                this.cacheKeyParameters = cacheKeyParameters;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getCacheNamespace}
             * @param cacheNamespace Specifies a group of related cached parameters.
             *                       By default, API Gateway uses the resource ID as the <code>cacheNamespace</code> . You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheNamespace(java.lang.String cacheNamespace) {
                this.cacheNamespace = cacheNamespace;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getConnectionId}
             * @param connectionId The ID of the VpcLink used for the integration when `connectionType=VPC_LINK` and undefined, otherwise.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionId(java.lang.String connectionId) {
                this.connectionId = connectionId;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getConnectionType}
             * @param connectionType The type of the network connection to the integration endpoint.
             *                       The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionType(java.lang.String connectionType) {
                this.connectionType = connectionType;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getContentHandling}
             * @param contentHandling Specifies how to handle request payload content type conversions.
             *                        Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code> , with the following behaviors:
             *                        <p>
             *                        If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentHandling(java.lang.String contentHandling) {
                this.contentHandling = contentHandling;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getCredentials}
             * @param credentials Specifies the credentials required for the integration, if any.
             *                    For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code> . To use resource-based permissions on supported AWS services, specify null.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentials(java.lang.String credentials) {
                this.credentials = credentials;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getIntegrationHttpMethod}
             * @param integrationHttpMethod Specifies the integration's HTTP method type.
             *                              For the Type property, if you specify <code>MOCK</code> , this property is optional. For Lambda integrations, you must set the integration method to <code>POST</code> . For all other types, you must specify this property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integrationHttpMethod(java.lang.String integrationHttpMethod) {
                this.integrationHttpMethod = integrationHttpMethod;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getIntegrationResponses}
             * @param integrationResponses Specifies the integration's responses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integrationResponses(software.amazon.awscdk.core.IResolvable integrationResponses) {
                this.integrationResponses = integrationResponses;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getIntegrationResponses}
             * @param integrationResponses Specifies the integration's responses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integrationResponses(java.util.List<? extends java.lang.Object> integrationResponses) {
                this.integrationResponses = integrationResponses;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getPassthroughBehavior}
             * @param passthroughBehavior Specifies how the method request body of an unmapped content type will be passed through the integration request to the back end without transformation.
             *                            A content type is unmapped if no mapping template is defined in the integration or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code> . The valid value is one of the following: <code>WHEN_NO_MATCH</code> : passes the method request body through the integration request to the back end without transformation when the method request content type does not match any content type associated with the mapping templates defined in the integration request. <code>WHEN_NO_TEMPLATES</code> : passes the method request body through the integration request to the back end without transformation when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request of an unmapped content-type will be rejected with an HTTP 415 Unsupported Media Type response. <code>NEVER</code> : rejects the method request with an HTTP 415 Unsupported Media Type response when either the method request content type does not match any content type associated with the mapping templates defined in the integration request or no mapping template is defined in the integration request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder passthroughBehavior(java.lang.String passthroughBehavior) {
                this.passthroughBehavior = passthroughBehavior;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getRequestParameters}
             * @param requestParameters A key-value map specifying request parameters that are passed from the method request to the back end.
             *                          The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of <code>method.request.{location}.{name}</code> , where <code>location</code> is <code>querystring</code> , <code>path</code> , or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestParameters(software.amazon.awscdk.core.IResolvable requestParameters) {
                this.requestParameters = requestParameters;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getRequestParameters}
             * @param requestParameters A key-value map specifying request parameters that are passed from the method request to the back end.
             *                          The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of <code>method.request.{location}.{name}</code> , where <code>location</code> is <code>querystring</code> , <code>path</code> , or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestParameters(java.util.Map<java.lang.String, java.lang.String> requestParameters) {
                this.requestParameters = requestParameters;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getRequestTemplates}
             * @param requestTemplates Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client.
             *                         The content type value is the key in this map, and the template (as a String) is the value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestTemplates(software.amazon.awscdk.core.IResolvable requestTemplates) {
                this.requestTemplates = requestTemplates;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getRequestTemplates}
             * @param requestTemplates Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client.
             *                         The content type value is the key in this map, and the template (as a String) is the value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestTemplates(java.util.Map<java.lang.String, java.lang.String> requestTemplates) {
                this.requestTemplates = requestTemplates;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getTimeoutInMillis}
             * @param timeoutInMillis Custom timeout between 50 and 29,000 milliseconds.
             *                        The default value is 29,000 milliseconds or 29 seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutInMillis(java.lang.Number timeoutInMillis) {
                this.timeoutInMillis = timeoutInMillis;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getType}
             * @param type Specifies an API method integration type. The valid value is one of the following:.
             *             For the HTTP and HTTP proxy integrations, each integration can specify a protocol ( <code>http/https</code> ), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getUri}
             * @param uri Specifies Uniform Resource Identifier (URI) of the integration endpoint.
             *            For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification for standard integrations. If <code>connectionType</code> is <code>VPC_LINK</code> specify the Network Load Balancer DNS name. For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code> . Here, {Region} is the API Gateway region (e.g., us-east-1); {service} is the name of the integrated AWS service (e.g., s3); and {subdomain} is a designated subdomain supported by certain AWS service for fast host-name lookup. action can be used for an AWS service action-based API, using an Action={name}&amp;{p1}={v1}&amp;p2={v2}... query string. The ensuing {service_api} refers to a supported action {name} plus any required input parameters. Alternatively, path can be used for an AWS service path-based API. The ensuing service_api refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of GetObject, the uri can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&amp;Bucket={bucket}&amp;Key={key}</code> or <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uri(java.lang.String uri) {
                this.uri = uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntegrationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntegrationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntegrationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegrationProperty {
            private final java.util.List<java.lang.String> cacheKeyParameters;
            private final java.lang.String cacheNamespace;
            private final java.lang.String connectionId;
            private final java.lang.String connectionType;
            private final java.lang.String contentHandling;
            private final java.lang.String credentials;
            private final java.lang.String integrationHttpMethod;
            private final java.lang.Object integrationResponses;
            private final java.lang.String passthroughBehavior;
            private final java.lang.Object requestParameters;
            private final java.lang.Object requestTemplates;
            private final java.lang.Number timeoutInMillis;
            private final java.lang.String type;
            private final java.lang.String uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cacheKeyParameters = software.amazon.jsii.Kernel.get(this, "cacheKeyParameters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cacheNamespace = software.amazon.jsii.Kernel.get(this, "cacheNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectionId = software.amazon.jsii.Kernel.get(this, "connectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectionType = software.amazon.jsii.Kernel.get(this, "connectionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.contentHandling = software.amazon.jsii.Kernel.get(this, "contentHandling", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.integrationHttpMethod = software.amazon.jsii.Kernel.get(this, "integrationHttpMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.integrationResponses = software.amazon.jsii.Kernel.get(this, "integrationResponses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.passthroughBehavior = software.amazon.jsii.Kernel.get(this, "passthroughBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.requestParameters = software.amazon.jsii.Kernel.get(this, "requestParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requestTemplates = software.amazon.jsii.Kernel.get(this, "requestTemplates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeoutInMillis = software.amazon.jsii.Kernel.get(this, "timeoutInMillis", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.uri = software.amazon.jsii.Kernel.get(this, "uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cacheKeyParameters = builder.cacheKeyParameters;
                this.cacheNamespace = builder.cacheNamespace;
                this.connectionId = builder.connectionId;
                this.connectionType = builder.connectionType;
                this.contentHandling = builder.contentHandling;
                this.credentials = builder.credentials;
                this.integrationHttpMethod = builder.integrationHttpMethod;
                this.integrationResponses = builder.integrationResponses;
                this.passthroughBehavior = builder.passthroughBehavior;
                this.requestParameters = builder.requestParameters;
                this.requestTemplates = builder.requestTemplates;
                this.timeoutInMillis = builder.timeoutInMillis;
                this.type = builder.type;
                this.uri = builder.uri;
            }

            @Override
            public final java.util.List<java.lang.String> getCacheKeyParameters() {
                return this.cacheKeyParameters;
            }

            @Override
            public final java.lang.String getCacheNamespace() {
                return this.cacheNamespace;
            }

            @Override
            public final java.lang.String getConnectionId() {
                return this.connectionId;
            }

            @Override
            public final java.lang.String getConnectionType() {
                return this.connectionType;
            }

            @Override
            public final java.lang.String getContentHandling() {
                return this.contentHandling;
            }

            @Override
            public final java.lang.String getCredentials() {
                return this.credentials;
            }

            @Override
            public final java.lang.String getIntegrationHttpMethod() {
                return this.integrationHttpMethod;
            }

            @Override
            public final java.lang.Object getIntegrationResponses() {
                return this.integrationResponses;
            }

            @Override
            public final java.lang.String getPassthroughBehavior() {
                return this.passthroughBehavior;
            }

            @Override
            public final java.lang.Object getRequestParameters() {
                return this.requestParameters;
            }

            @Override
            public final java.lang.Object getRequestTemplates() {
                return this.requestTemplates;
            }

            @Override
            public final java.lang.Number getTimeoutInMillis() {
                return this.timeoutInMillis;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getUri() {
                return this.uri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCacheKeyParameters() != null) {
                    data.set("cacheKeyParameters", om.valueToTree(this.getCacheKeyParameters()));
                }
                if (this.getCacheNamespace() != null) {
                    data.set("cacheNamespace", om.valueToTree(this.getCacheNamespace()));
                }
                if (this.getConnectionId() != null) {
                    data.set("connectionId", om.valueToTree(this.getConnectionId()));
                }
                if (this.getConnectionType() != null) {
                    data.set("connectionType", om.valueToTree(this.getConnectionType()));
                }
                if (this.getContentHandling() != null) {
                    data.set("contentHandling", om.valueToTree(this.getContentHandling()));
                }
                if (this.getCredentials() != null) {
                    data.set("credentials", om.valueToTree(this.getCredentials()));
                }
                if (this.getIntegrationHttpMethod() != null) {
                    data.set("integrationHttpMethod", om.valueToTree(this.getIntegrationHttpMethod()));
                }
                if (this.getIntegrationResponses() != null) {
                    data.set("integrationResponses", om.valueToTree(this.getIntegrationResponses()));
                }
                if (this.getPassthroughBehavior() != null) {
                    data.set("passthroughBehavior", om.valueToTree(this.getPassthroughBehavior()));
                }
                if (this.getRequestParameters() != null) {
                    data.set("requestParameters", om.valueToTree(this.getRequestParameters()));
                }
                if (this.getRequestTemplates() != null) {
                    data.set("requestTemplates", om.valueToTree(this.getRequestTemplates()));
                }
                if (this.getTimeoutInMillis() != null) {
                    data.set("timeoutInMillis", om.valueToTree(this.getTimeoutInMillis()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getUri() != null) {
                    data.set("uri", om.valueToTree(this.getUri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnMethod.IntegrationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntegrationProperty.Jsii$Proxy that = (IntegrationProperty.Jsii$Proxy) o;

                if (this.cacheKeyParameters != null ? !this.cacheKeyParameters.equals(that.cacheKeyParameters) : that.cacheKeyParameters != null) return false;
                if (this.cacheNamespace != null ? !this.cacheNamespace.equals(that.cacheNamespace) : that.cacheNamespace != null) return false;
                if (this.connectionId != null ? !this.connectionId.equals(that.connectionId) : that.connectionId != null) return false;
                if (this.connectionType != null ? !this.connectionType.equals(that.connectionType) : that.connectionType != null) return false;
                if (this.contentHandling != null ? !this.contentHandling.equals(that.contentHandling) : that.contentHandling != null) return false;
                if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
                if (this.integrationHttpMethod != null ? !this.integrationHttpMethod.equals(that.integrationHttpMethod) : that.integrationHttpMethod != null) return false;
                if (this.integrationResponses != null ? !this.integrationResponses.equals(that.integrationResponses) : that.integrationResponses != null) return false;
                if (this.passthroughBehavior != null ? !this.passthroughBehavior.equals(that.passthroughBehavior) : that.passthroughBehavior != null) return false;
                if (this.requestParameters != null ? !this.requestParameters.equals(that.requestParameters) : that.requestParameters != null) return false;
                if (this.requestTemplates != null ? !this.requestTemplates.equals(that.requestTemplates) : that.requestTemplates != null) return false;
                if (this.timeoutInMillis != null ? !this.timeoutInMillis.equals(that.timeoutInMillis) : that.timeoutInMillis != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                return this.uri != null ? this.uri.equals(that.uri) : that.uri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cacheKeyParameters != null ? this.cacheKeyParameters.hashCode() : 0;
                result = 31 * result + (this.cacheNamespace != null ? this.cacheNamespace.hashCode() : 0);
                result = 31 * result + (this.connectionId != null ? this.connectionId.hashCode() : 0);
                result = 31 * result + (this.connectionType != null ? this.connectionType.hashCode() : 0);
                result = 31 * result + (this.contentHandling != null ? this.contentHandling.hashCode() : 0);
                result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
                result = 31 * result + (this.integrationHttpMethod != null ? this.integrationHttpMethod.hashCode() : 0);
                result = 31 * result + (this.integrationResponses != null ? this.integrationResponses.hashCode() : 0);
                result = 31 * result + (this.passthroughBehavior != null ? this.passthroughBehavior.hashCode() : 0);
                result = 31 * result + (this.requestParameters != null ? this.requestParameters.hashCode() : 0);
                result = 31 * result + (this.requestTemplates != null ? this.requestTemplates.hashCode() : 0);
                result = 31 * result + (this.timeoutInMillis != null ? this.timeoutInMillis.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `IntegrationResponse` is a property of the [Amazon API Gateway Method Integration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html) property type that specifies the response that API Gateway sends after a method's backend finishes processing a request.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigateway.*;
     * IntegrationResponseProperty integrationResponseProperty = IntegrationResponseProperty.builder()
     *         .statusCode("statusCode")
     *         // the properties below are optional
     *         .contentHandling("contentHandling")
     *         .responseParameters(Map.of(
     *                 "responseParametersKey", "responseParameters"))
     *         .responseTemplates(Map.of(
     *                 "responseTemplatesKey", "responseTemplates"))
     *         .selectionPattern("selectionPattern")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnMethod.IntegrationResponseProperty")
    @software.amazon.jsii.Jsii.Proxy(IntegrationResponseProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntegrationResponseProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the status code that is used to map the integration response to an existing MethodResponse.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatusCode();

        /**
         * Specifies how to handle response payload content type conversions.
         * <p>
         * Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code> , with the following behaviors:
         * <p>
         * If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContentHandling() {
            return null;
        }

        /**
         * A key-value map specifying response parameters that are passed to the method response from the back end.
         * <p>
         * The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code> , where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code> , where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResponseParameters() {
            return null;
        }

        /**
         * Specifies the templates used to transform the integration response body.
         * <p>
         * Response templates are represented as a key/value map, with a content-type as the key and a template as the value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResponseTemplates() {
            return null;
        }

        /**
         * Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end.
         * <p>
         * For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline ( <code>\n</code> ) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSelectionPattern() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IntegrationResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntegrationResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntegrationResponseProperty> {
            java.lang.String statusCode;
            java.lang.String contentHandling;
            java.lang.Object responseParameters;
            java.lang.Object responseTemplates;
            java.lang.String selectionPattern;

            /**
             * Sets the value of {@link IntegrationResponseProperty#getStatusCode}
             * @param statusCode Specifies the status code that is used to map the integration response to an existing MethodResponse. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusCode(java.lang.String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationResponseProperty#getContentHandling}
             * @param contentHandling Specifies how to handle response payload content type conversions.
             *                        Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code> , with the following behaviors:
             *                        <p>
             *                        If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentHandling(java.lang.String contentHandling) {
                this.contentHandling = contentHandling;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationResponseProperty#getResponseParameters}
             * @param responseParameters A key-value map specifying response parameters that are passed to the method response from the back end.
             *                           The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code> , where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code> , where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseParameters(software.amazon.awscdk.core.IResolvable responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationResponseProperty#getResponseParameters}
             * @param responseParameters A key-value map specifying response parameters that are passed to the method response from the back end.
             *                           The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code> , where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code> , where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseParameters(java.util.Map<java.lang.String, java.lang.String> responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationResponseProperty#getResponseTemplates}
             * @param responseTemplates Specifies the templates used to transform the integration response body.
             *                          Response templates are represented as a key/value map, with a content-type as the key and a template as the value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseTemplates(software.amazon.awscdk.core.IResolvable responseTemplates) {
                this.responseTemplates = responseTemplates;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationResponseProperty#getResponseTemplates}
             * @param responseTemplates Specifies the templates used to transform the integration response body.
             *                          Response templates are represented as a key/value map, with a content-type as the key and a template as the value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseTemplates(java.util.Map<java.lang.String, java.lang.String> responseTemplates) {
                this.responseTemplates = responseTemplates;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationResponseProperty#getSelectionPattern}
             * @param selectionPattern Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end.
             *                         For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline ( <code>\n</code> ) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectionPattern(java.lang.String selectionPattern) {
                this.selectionPattern = selectionPattern;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntegrationResponseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntegrationResponseProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntegrationResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegrationResponseProperty {
            private final java.lang.String statusCode;
            private final java.lang.String contentHandling;
            private final java.lang.Object responseParameters;
            private final java.lang.Object responseTemplates;
            private final java.lang.String selectionPattern;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statusCode = software.amazon.jsii.Kernel.get(this, "statusCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.contentHandling = software.amazon.jsii.Kernel.get(this, "contentHandling", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.responseParameters = software.amazon.jsii.Kernel.get(this, "responseParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.responseTemplates = software.amazon.jsii.Kernel.get(this, "responseTemplates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.selectionPattern = software.amazon.jsii.Kernel.get(this, "selectionPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statusCode = java.util.Objects.requireNonNull(builder.statusCode, "statusCode is required");
                this.contentHandling = builder.contentHandling;
                this.responseParameters = builder.responseParameters;
                this.responseTemplates = builder.responseTemplates;
                this.selectionPattern = builder.selectionPattern;
            }

            @Override
            public final java.lang.String getStatusCode() {
                return this.statusCode;
            }

            @Override
            public final java.lang.String getContentHandling() {
                return this.contentHandling;
            }

            @Override
            public final java.lang.Object getResponseParameters() {
                return this.responseParameters;
            }

            @Override
            public final java.lang.Object getResponseTemplates() {
                return this.responseTemplates;
            }

            @Override
            public final java.lang.String getSelectionPattern() {
                return this.selectionPattern;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statusCode", om.valueToTree(this.getStatusCode()));
                if (this.getContentHandling() != null) {
                    data.set("contentHandling", om.valueToTree(this.getContentHandling()));
                }
                if (this.getResponseParameters() != null) {
                    data.set("responseParameters", om.valueToTree(this.getResponseParameters()));
                }
                if (this.getResponseTemplates() != null) {
                    data.set("responseTemplates", om.valueToTree(this.getResponseTemplates()));
                }
                if (this.getSelectionPattern() != null) {
                    data.set("selectionPattern", om.valueToTree(this.getSelectionPattern()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnMethod.IntegrationResponseProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntegrationResponseProperty.Jsii$Proxy that = (IntegrationResponseProperty.Jsii$Proxy) o;

                if (!statusCode.equals(that.statusCode)) return false;
                if (this.contentHandling != null ? !this.contentHandling.equals(that.contentHandling) : that.contentHandling != null) return false;
                if (this.responseParameters != null ? !this.responseParameters.equals(that.responseParameters) : that.responseParameters != null) return false;
                if (this.responseTemplates != null ? !this.responseTemplates.equals(that.responseTemplates) : that.responseTemplates != null) return false;
                return this.selectionPattern != null ? this.selectionPattern.equals(that.selectionPattern) : that.selectionPattern == null;
            }

            @Override
            public final int hashCode() {
                int result = this.statusCode.hashCode();
                result = 31 * result + (this.contentHandling != null ? this.contentHandling.hashCode() : 0);
                result = 31 * result + (this.responseParameters != null ? this.responseParameters.hashCode() : 0);
                result = 31 * result + (this.responseTemplates != null ? this.responseTemplates.hashCode() : 0);
                result = 31 * result + (this.selectionPattern != null ? this.selectionPattern.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a method response of a given HTTP status code returned to the client.
     * <p>
     * The method response is passed from the back end through the associated integration response that can be transformed using a mapping template.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigateway.*;
     * MethodResponseProperty methodResponseProperty = MethodResponseProperty.builder()
     *         .statusCode("statusCode")
     *         // the properties below are optional
     *         .responseModels(Map.of(
     *                 "responseModelsKey", "responseModels"))
     *         .responseParameters(Map.of(
     *                 "responseParametersKey", false))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnMethod.MethodResponseProperty")
    @software.amazon.jsii.Jsii.Proxy(MethodResponseProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MethodResponseProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The method response's status code.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatusCode();

        /**
         * Specifies the Model resources used for the response's content-type.
         * <p>
         * Response models are represented as a key/value map, with a content-type as the key and a Model name as the value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResponseModels() {
            return null;
        }

        /**
         * A key-value map specifying required or optional response parameters that API Gateway can send back to the caller.
         * <p>
         * A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code> , where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's IntegrationResponse. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code> , a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code> ), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code> , where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResponseParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MethodResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MethodResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MethodResponseProperty> {
            java.lang.String statusCode;
            java.lang.Object responseModels;
            java.lang.Object responseParameters;

            /**
             * Sets the value of {@link MethodResponseProperty#getStatusCode}
             * @param statusCode The method response's status code. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusCode(java.lang.String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            /**
             * Sets the value of {@link MethodResponseProperty#getResponseModels}
             * @param responseModels Specifies the Model resources used for the response's content-type.
             *                       Response models are represented as a key/value map, with a content-type as the key and a Model name as the value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseModels(software.amazon.awscdk.core.IResolvable responseModels) {
                this.responseModels = responseModels;
                return this;
            }

            /**
             * Sets the value of {@link MethodResponseProperty#getResponseModels}
             * @param responseModels Specifies the Model resources used for the response's content-type.
             *                       Response models are represented as a key/value map, with a content-type as the key and a Model name as the value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseModels(java.util.Map<java.lang.String, java.lang.String> responseModels) {
                this.responseModels = responseModels;
                return this;
            }

            /**
             * Sets the value of {@link MethodResponseProperty#getResponseParameters}
             * @param responseParameters A key-value map specifying required or optional response parameters that API Gateway can send back to the caller.
             *                           A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code> , where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's IntegrationResponse. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code> , a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code> ), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code> , where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseParameters(software.amazon.awscdk.core.IResolvable responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            /**
             * Sets the value of {@link MethodResponseProperty#getResponseParameters}
             * @param responseParameters A key-value map specifying required or optional response parameters that API Gateway can send back to the caller.
             *                           A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code> , where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's IntegrationResponse. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code> , a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code> ), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code> , where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseParameters(java.util.Map<java.lang.String, ? extends java.lang.Object> responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MethodResponseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MethodResponseProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MethodResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MethodResponseProperty {
            private final java.lang.String statusCode;
            private final java.lang.Object responseModels;
            private final java.lang.Object responseParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statusCode = software.amazon.jsii.Kernel.get(this, "statusCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.responseModels = software.amazon.jsii.Kernel.get(this, "responseModels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.responseParameters = software.amazon.jsii.Kernel.get(this, "responseParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statusCode = java.util.Objects.requireNonNull(builder.statusCode, "statusCode is required");
                this.responseModels = builder.responseModels;
                this.responseParameters = builder.responseParameters;
            }

            @Override
            public final java.lang.String getStatusCode() {
                return this.statusCode;
            }

            @Override
            public final java.lang.Object getResponseModels() {
                return this.responseModels;
            }

            @Override
            public final java.lang.Object getResponseParameters() {
                return this.responseParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statusCode", om.valueToTree(this.getStatusCode()));
                if (this.getResponseModels() != null) {
                    data.set("responseModels", om.valueToTree(this.getResponseModels()));
                }
                if (this.getResponseParameters() != null) {
                    data.set("responseParameters", om.valueToTree(this.getResponseParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnMethod.MethodResponseProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MethodResponseProperty.Jsii$Proxy that = (MethodResponseProperty.Jsii$Proxy) o;

                if (!statusCode.equals(that.statusCode)) return false;
                if (this.responseModels != null ? !this.responseModels.equals(that.responseModels) : that.responseModels != null) return false;
                return this.responseParameters != null ? this.responseParameters.equals(that.responseParameters) : that.responseParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.statusCode.hashCode();
                result = 31 * result + (this.responseModels != null ? this.responseModels.hashCode() : 0);
                result = 31 * result + (this.responseParameters != null ? this.responseParameters.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.CfnMethod}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.CfnMethod> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.CfnMethodProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.CfnMethodProps.Builder();
        }

        /**
         * The method's HTTP verb.
         * <p>
         * @return {@code this}
         * @param httpMethod The method's HTTP verb. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpMethod(final java.lang.String httpMethod) {
            this.props.httpMethod(httpMethod);
            return this;
        }

        /**
         * The Resource identifier for the MethodResponse resource.
         * <p>
         * @return {@code this}
         * @param resourceId The Resource identifier for the MethodResponse resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(final java.lang.String resourceId) {
            this.props.resourceId(resourceId);
            return this;
        }

        /**
         * The string identifier of the associated RestApi.
         * <p>
         * @return {@code this}
         * @param restApiId The string identifier of the associated RestApi. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiId(final java.lang.String restApiId) {
            this.props.restApiId(restApiId);
            return this;
        }

        /**
         * A boolean flag specifying whether a valid ApiKey is required to invoke this method.
         * <p>
         * @return {@code this}
         * @param apiKeyRequired A boolean flag specifying whether a valid ApiKey is required to invoke this method. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyRequired(final java.lang.Boolean apiKeyRequired) {
            this.props.apiKeyRequired(apiKeyRequired);
            return this;
        }
        /**
         * A boolean flag specifying whether a valid ApiKey is required to invoke this method.
         * <p>
         * @return {@code this}
         * @param apiKeyRequired A boolean flag specifying whether a valid ApiKey is required to invoke this method. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyRequired(final software.amazon.awscdk.core.IResolvable apiKeyRequired) {
            this.props.apiKeyRequired(apiKeyRequired);
            return this;
        }

        /**
         * A list of authorization scopes configured on the method.
         * <p>
         * The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
         * <p>
         * @return {@code this}
         * @param authorizationScopes A list of authorization scopes configured on the method. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationScopes(final java.util.List<java.lang.String> authorizationScopes) {
            this.props.authorizationScopes(authorizationScopes);
            return this;
        }

        /**
         * The method's authorization type.
         * <p>
         * This parameter is required. For valid values, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_Method.html">Method</a> in the <em>API Gateway API Reference</em> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify the <code>AuthorizerId</code> property, specify <code>CUSTOM</code> or <code>COGNITO_USER_POOLS</code> for this property.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param authorizationType The method's authorization type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationType(final java.lang.String authorizationType) {
            this.props.authorizationType(authorizationType);
            return this;
        }

        /**
         * The identifier of an Authorizer to use on this method.
         * <p>
         * The <code>authorizationType</code> must be <code>CUSTOM</code> .
         * <p>
         * @return {@code this}
         * @param authorizerId The identifier of an Authorizer to use on this method. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerId(final java.lang.String authorizerId) {
            this.props.authorizerId(authorizerId);
            return this;
        }

        /**
         * Represents an `HTTP` , `HTTP_PROXY` , `AWS` , `AWS_PROXY` , or Mock integration.
         * <p>
         * @return {@code this}
         * @param integration Represents an `HTTP` , `HTTP_PROXY` , `AWS` , `AWS_PROXY` , or Mock integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integration(final software.amazon.awscdk.core.IResolvable integration) {
            this.props.integration(integration);
            return this;
        }
        /**
         * Represents an `HTTP` , `HTTP_PROXY` , `AWS` , `AWS_PROXY` , or Mock integration.
         * <p>
         * @return {@code this}
         * @param integration Represents an `HTTP` , `HTTP_PROXY` , `AWS` , `AWS_PROXY` , or Mock integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integration(final software.amazon.awscdk.services.apigateway.CfnMethod.IntegrationProperty integration) {
            this.props.integration(integration);
            return this;
        }

        /**
         * Gets a method response associated with a given HTTP status code.
         * <p>
         * @return {@code this}
         * @param methodResponses Gets a method response associated with a given HTTP status code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder methodResponses(final software.amazon.awscdk.core.IResolvable methodResponses) {
            this.props.methodResponses(methodResponses);
            return this;
        }
        /**
         * Gets a method response associated with a given HTTP status code.
         * <p>
         * @return {@code this}
         * @param methodResponses Gets a method response associated with a given HTTP status code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder methodResponses(final java.util.List<? extends java.lang.Object> methodResponses) {
            this.props.methodResponses(methodResponses);
            return this;
        }

        /**
         * A human-friendly operation identifier for the method.
         * <p>
         * For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.
         * <p>
         * @return {@code this}
         * @param operationName A human-friendly operation identifier for the method. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operationName(final java.lang.String operationName) {
            this.props.operationName(operationName);
            return this;
        }

        /**
         * A key-value map specifying data schemas, represented by Model resources, (as the mapped value) of the request payloads of given content types (as the mapping key).
         * <p>
         * @return {@code this}
         * @param requestModels A key-value map specifying data schemas, represented by Model resources, (as the mapped value) of the request payloads of given content types (as the mapping key). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestModels(final software.amazon.awscdk.core.IResolvable requestModels) {
            this.props.requestModels(requestModels);
            return this;
        }
        /**
         * A key-value map specifying data schemas, represented by Model resources, (as the mapped value) of the request payloads of given content types (as the mapping key).
         * <p>
         * @return {@code this}
         * @param requestModels A key-value map specifying data schemas, represented by Model resources, (as the mapped value) of the request payloads of given content types (as the mapping key). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestModels(final java.util.Map<java.lang.String, java.lang.String> requestModels) {
            this.props.requestModels(requestModels);
            return this;
        }

        /**
         * A key-value map defining required or optional method request parameters that can be accepted by API Gateway.
         * <p>
         * A key is a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code> , where <code>location</code> is <code>querystring</code> , <code>path</code> , or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required ( <code>true</code> ) or optional ( <code>false</code> ). The method request parameter names defined here are available in Integration to be mapped to integration request parameters or templates.
         * <p>
         * @return {@code this}
         * @param requestParameters A key-value map defining required or optional method request parameters that can be accepted by API Gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(final software.amazon.awscdk.core.IResolvable requestParameters) {
            this.props.requestParameters(requestParameters);
            return this;
        }
        /**
         * A key-value map defining required or optional method request parameters that can be accepted by API Gateway.
         * <p>
         * A key is a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code> , where <code>location</code> is <code>querystring</code> , <code>path</code> , or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required ( <code>true</code> ) or optional ( <code>false</code> ). The method request parameter names defined here are available in Integration to be mapped to integration request parameters or templates.
         * <p>
         * @return {@code this}
         * @param requestParameters A key-value map defining required or optional method request parameters that can be accepted by API Gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(final java.util.Map<java.lang.String, ? extends java.lang.Object> requestParameters) {
            this.props.requestParameters(requestParameters);
            return this;
        }

        /**
         * The identifier of a RequestValidator for request validation.
         * <p>
         * @return {@code this}
         * @param requestValidatorId The identifier of a RequestValidator for request validation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestValidatorId(final java.lang.String requestValidatorId) {
            this.props.requestValidatorId(requestValidatorId);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.CfnMethod}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.CfnMethod build() {
            return new software.amazon.awscdk.services.apigateway.CfnMethod(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
