package software.amazon.awscdk.services.apigateway;

/**
 * You can integrate an API method with an HTTP endpoint using the HTTP proxy integration or the HTTP custom integration,.
 * <p>
 * With the proxy integration, the setup is simple. You only need to set the
 * HTTP method and the HTTP endpoint URI, according to the backend requirements,
 * if you are not concerned with content encoding or caching.
 * <p>
 * With the custom integration, the setup is more involved. In addition to the
 * proxy integration setup steps, you need to specify how the incoming request
 * data is mapped to the integration request and how the resulting integration
 * response data is mapped to the method response.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function authFn;
 * Resource books;
 * RequestAuthorizer auth = RequestAuthorizer.Builder.create(this, "booksAuthorizer")
 *         .handler(authFn)
 *         .identitySources(List.of(IdentitySource.header("Authorization")))
 *         .build();
 * books.addMethod("GET", new HttpIntegration("http://amazon.com"), MethodOptions.builder()
 *         .authorizer(auth)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-14T16:25:33.365Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.HttpIntegration")
public class HttpIntegration extends software.amazon.awscdk.services.apigateway.Integration {

    protected HttpIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param url This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HttpIntegration(final @org.jetbrains.annotations.NotNull java.lang.String url, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.HttpIntegrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(url, "url is required"), props });
    }

    /**
     * @param url This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HttpIntegration(final @org.jetbrains.annotations.NotNull java.lang.String url) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(url, "url is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.HttpIntegration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.HttpIntegration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param url This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String url) {
            return new Builder(url);
        }

        private final java.lang.String url;
        private software.amazon.awscdk.services.apigateway.HttpIntegrationProps.Builder props;

        private Builder(final java.lang.String url) {
            this.url = url;
        }

        /**
         * HTTP method to use when invoking the backend URL.
         * <p>
         * Default: GET
         * <p>
         * @return {@code this}
         * @param httpMethod HTTP method to use when invoking the backend URL. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpMethod(final java.lang.String httpMethod) {
            this.props().httpMethod(httpMethod);
            return this;
        }

        /**
         * Integration options, such as request/resopnse mapping, content handling, etc.
         * <p>
         * Default: defaults based on `IntegrationOptions` defaults
         * <p>
         * @return {@code this}
         * @param options Integration options, such as request/resopnse mapping, content handling, etc. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(final software.amazon.awscdk.services.apigateway.IntegrationOptions options) {
            this.props().options(options);
            return this;
        }

        /**
         * Determines whether to use proxy integration or custom integration.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param proxy Determines whether to use proxy integration or custom integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxy(final java.lang.Boolean proxy) {
            this.props().proxy(proxy);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.HttpIntegration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.HttpIntegration build() {
            return new software.amazon.awscdk.services.apigateway.HttpIntegration(
                this.url,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.apigateway.HttpIntegrationProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.apigateway.HttpIntegrationProps.Builder();
            }
            return this.props;
        }
    }
}
