package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * import path.*;
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.core.App;
 * import software.amazon.awscdk.core.Stack;
 * import software.amazon.awscdk.services.apigateway.MockIntegration;
 * import software.amazon.awscdk.services.apigateway.PassthroughBehavior;
 * import software.amazon.awscdk.services.apigateway.RestApi;
 * import software.amazon.awscdk.services.apigateway.RequestAuthorizer;
 * import software.amazon.awscdk.services.apigateway.IdentitySource;
 * // Against the RestApi endpoint from the stack output, run
 * // `curl -s -o /dev/null -w "%{http_code}" &lt;url&gt;` should return 401
 * // `curl -s -o /dev/null -w "%{http_code}" -H 'Authorization: deny' &lt;url&gt;?allow=yes` should return 403
 * // `curl -s -o /dev/null -w "%{http_code}" -H 'Authorization: allow' &lt;url&gt;?allow=yes` should return 200
 * App app = new App();
 * Stack stack = new Stack(app, "RequestAuthorizerInteg");
 * Function authorizerFn = Function.Builder.create(stack, "MyAuthorizerFunction")
 *         .runtime(Runtime.NODEJS_14_X)
 *         .handler("index.handler")
 *         .code(AssetCode.fromAsset(join(__dirname, "integ.request-authorizer.handler")))
 *         .build();
 * RestApi restapi = new RestApi(stack, "MyRestApi");
 * RequestAuthorizer authorizer = RequestAuthorizer.Builder.create(stack, "MyAuthorizer")
 *         .handler(authorizerFn)
 *         .identitySources(List.of(IdentitySource.header("Authorization"), IdentitySource.queryString("allow")))
 *         .build();
 * restapi.root.addMethod("ANY", MockIntegration.Builder.create()
 *         .integrationResponses(List.of(IntegrationResponse.builder().statusCode("200").build()))
 *         .passthroughBehavior(PassthroughBehavior.NEVER)
 *         .requestTemplates(Map.of(
 *                 "application/json", "{ \"statusCode\": 200 }"))
 *         .build(), MethodOptions.builder()
 *         .methodResponses(List.of(MethodResponse.builder().statusCode("200").build()))
 *         .authorizer(authorizer)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-14T16:25:33.436Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.PassthroughBehavior")
public enum PassthroughBehavior {
    /**
     * Passes the request body for unmapped content types through to the integration back end without transformation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WHEN_NO_MATCH,
    /**
     * Rejects unmapped content types with an HTTP 415 'Unsupported Media Type' response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NEVER,
    /**
     * Allows pass-through when the integration has NO content types mapped to templates.
     * <p>
     * However if there is at least one content type defined,
     * unmapped content types will be rejected with the same 415 response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WHEN_NO_TEMPLATES,
}
