package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a `CfnDocumentationPart`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * CfnDocumentationPartProps cfnDocumentationPartProps = CfnDocumentationPartProps.builder()
 *         .location(LocationProperty.builder()
 *                 .method("method")
 *                 .name("name")
 *                 .path("path")
 *                 .statusCode("statusCode")
 *                 .type("type")
 *                 .build())
 *         .properties("properties")
 *         .restApiId("restApiId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-04-20T17:18:11.175Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnDocumentationPartProps")
@software.amazon.jsii.Jsii.Proxy(CfnDocumentationPartProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDocumentationPartProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The location of the targeted API entity of the to-be-created documentation part.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getLocation();

    /**
     * The new documentation content map of the targeted API entity.
     * <p>
     * Enclosed key-value pairs are API-specific, but only OpenAPI-compliant key-value pairs can be exported and, hence, published.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProperties();

    /**
     * The string identifier of the associated RestApi.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRestApiId();

    /**
     * @return a {@link Builder} of {@link CfnDocumentationPartProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDocumentationPartProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDocumentationPartProps> {
        java.lang.Object location;
        java.lang.String properties;
        java.lang.String restApiId;

        /**
         * Sets the value of {@link CfnDocumentationPartProps#getLocation}
         * @param location The location of the targeted API entity of the to-be-created documentation part. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder location(software.amazon.awscdk.core.IResolvable location) {
            this.location = location;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentationPartProps#getLocation}
         * @param location The location of the targeted API entity of the to-be-created documentation part. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder location(software.amazon.awscdk.services.apigateway.CfnDocumentationPart.LocationProperty location) {
            this.location = location;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentationPartProps#getProperties}
         * @param properties The new documentation content map of the targeted API entity. This parameter is required.
         *                   Enclosed key-value pairs are API-specific, but only OpenAPI-compliant key-value pairs can be exported and, hence, published.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder properties(java.lang.String properties) {
            this.properties = properties;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentationPartProps#getRestApiId}
         * @param restApiId The string identifier of the associated RestApi. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiId(java.lang.String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDocumentationPartProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDocumentationPartProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDocumentationPartProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDocumentationPartProps {
        private final java.lang.Object location;
        private final java.lang.String properties;
        private final java.lang.String restApiId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.properties = software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.restApiId = software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.location = java.util.Objects.requireNonNull(builder.location, "location is required");
            this.properties = java.util.Objects.requireNonNull(builder.properties, "properties is required");
            this.restApiId = java.util.Objects.requireNonNull(builder.restApiId, "restApiId is required");
        }

        @Override
        public final java.lang.Object getLocation() {
            return this.location;
        }

        @Override
        public final java.lang.String getProperties() {
            return this.properties;
        }

        @Override
        public final java.lang.String getRestApiId() {
            return this.restApiId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("location", om.valueToTree(this.getLocation()));
            data.set("properties", om.valueToTree(this.getProperties()));
            data.set("restApiId", om.valueToTree(this.getRestApiId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnDocumentationPartProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDocumentationPartProps.Jsii$Proxy that = (CfnDocumentationPartProps.Jsii$Proxy) o;

            if (!location.equals(that.location)) return false;
            if (!properties.equals(that.properties)) return false;
            return this.restApiId.equals(that.restApiId);
        }

        @Override
        public final int hashCode() {
            int result = this.location.hashCode();
            result = 31 * result + (this.properties.hashCode());
            result = 31 * result + (this.restApiId.hashCode());
            return result;
        }
    }
}
