package software.amazon.awscdk.services.apigateway;

/**
 * Represents an identity source.
 * <p>
 * The source can be specified either as a literal value (e.g: <code>Auth</code>) which
 * cannot be blank, or as an unresolved string token.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function authFn;
 * Resource books;
 * RequestAuthorizer auth = RequestAuthorizer.Builder.create(this, "booksAuthorizer")
 *         .handler(authFn)
 *         .identitySources(List.of(IdentitySource.header("Authorization")))
 *         .build();
 * books.addMethod("GET", new HttpIntegration("http://amazon.com"), MethodOptions.builder()
 *         .authorizer(auth)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-04-20T17:18:11.352Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.IdentitySource")
public class IdentitySource extends software.amazon.jsii.JsiiObject {

    protected IdentitySource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected IdentitySource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public IdentitySource() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Provides a properly formatted request context identity source.
     * <p>
     * @return a request context identity source.
     * @param context the name of the context variable the `IdentitySource` will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String context(final @org.jetbrains.annotations.NotNull java.lang.String context) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.IdentitySource.class, "context", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(context, "context is required") });
    }

    /**
     * Provides a properly formatted header identity source.
     * <p>
     * @return a header identity source.
     * @param headerName the name of the header the `IdentitySource` will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String header(final @org.jetbrains.annotations.NotNull java.lang.String headerName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.IdentitySource.class, "header", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(headerName, "headerName is required") });
    }

    /**
     * Provides a properly formatted query string identity source.
     * <p>
     * @return a query string identity source.
     * @param queryString the name of the query string the `IdentitySource` will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String queryString(final @org.jetbrains.annotations.NotNull java.lang.String queryString) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.IdentitySource.class, "queryString", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(queryString, "queryString is required") });
    }

    /**
     * Provides a properly formatted API Gateway stage variable identity source.
     * <p>
     * @return an API Gateway stage variable identity source.
     * @param stageVariable the name of the stage variable the `IdentitySource` will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String stageVariable(final @org.jetbrains.annotations.NotNull java.lang.String stageVariable) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.IdentitySource.class, "stageVariable", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(stageVariable, "stageVariable is required") });
    }
}
