package software.amazon.awscdk.services.apigateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.2 (build e881f16)", date = "2019-07-25T16:44:24.035Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeploymentProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The Rest API to deploy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.IRestApi getApi();
    /**
     * A description of the purpose of the API Gateway deployment.
     * 
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDescription();
    /**
     * When an API Gateway model is updated, a new deployment will automatically be created. If this is true (default), the old API Gateway Deployment resource will not be deleted. This will allow manually reverting back to a previous deployment in case for example.
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getRetainDeployments();

    /**
     * @return a {@link Builder} of {@link DeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link DeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.apigateway.IRestApi _api;
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.lang.Boolean _retainDeployments;

        /**
         * Sets the value of Api
         * @param value The Rest API to deploy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withApi(final software.amazon.awscdk.services.apigateway.IRestApi value) {
            this._api = java.util.Objects.requireNonNull(value, "api is required");
            return this;
        }
        /**
         * Sets the value of Description
         * @param value A description of the purpose of the API Gateway deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of RetainDeployments
         * @param value When an API Gateway model is updated, a new deployment will automatically be created. If this is true (default), the old API Gateway Deployment resource will not be deleted. This will allow manually reverting back to a previous deployment in case for example.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withRetainDeployments(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._retainDeployments = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeploymentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public DeploymentProps build() {
            return new DeploymentProps() {
                private final software.amazon.awscdk.services.apigateway.IRestApi $api = java.util.Objects.requireNonNull(_api, "api is required");
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;
                @javax.annotation.Nullable
                private final java.lang.Boolean $retainDeployments = _retainDeployments;

                @Override
                public software.amazon.awscdk.services.apigateway.IRestApi getApi() {
                    return this.$api;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public java.lang.Boolean getRetainDeployments() {
                    return this.$retainDeployments;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("api", om.valueToTree(this.getApi()));
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree(this.getDescription()));
                    }
                    if (this.getRetainDeployments() != null) {
                        obj.set("retainDeployments", om.valueToTree(this.getRetainDeployments()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.DeploymentProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The Rest API to deploy.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.apigateway.IRestApi getApi() {
            return this.jsiiGet("api", software.amazon.awscdk.services.apigateway.IRestApi.class);
        }

        /**
         * A description of the purpose of the API Gateway deployment.
         * 
         * Default: - No description.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * When an API Gateway model is updated, a new deployment will automatically be created. If this is true (default), the old API Gateway Deployment resource will not be deleted. This will allow manually reverting back to a previous deployment in case for example.
         * 
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getRetainDeployments() {
            return this.jsiiGet("retainDeployments", java.lang.Boolean.class);
        }
    }
}
