package software.amazon.awscdk.services.apigateway;

/**
 * Container for defining throttling parameters to API stages or methods.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.2 (build e881f16)", date = "2019-07-25T16:44:24.071Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ThrottleSettings extends software.amazon.jsii.JsiiSerializable {
    /**
     * The maximum API request rate limit over a time ranging from one to a few seconds.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getBurstLimit();
    /**
     * The API request steady-state rate limit (average requests per second over an extended period of time).
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getRateLimit();

    /**
     * @return a {@link Builder} of {@link ThrottleSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ThrottleSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Number _burstLimit;
        @javax.annotation.Nullable
        private java.lang.Number _rateLimit;

        /**
         * Sets the value of BurstLimit
         * @param value The maximum API request rate limit over a time ranging from one to a few seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withBurstLimit(@javax.annotation.Nullable final java.lang.Number value) {
            this._burstLimit = value;
            return this;
        }
        /**
         * Sets the value of RateLimit
         * @param value The API request steady-state rate limit (average requests per second over an extended period of time).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withRateLimit(@javax.annotation.Nullable final java.lang.Number value) {
            this._rateLimit = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ThrottleSettings}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ThrottleSettings build() {
            return new ThrottleSettings() {
                @javax.annotation.Nullable
                private final java.lang.Number $burstLimit = _burstLimit;
                @javax.annotation.Nullable
                private final java.lang.Number $rateLimit = _rateLimit;

                @Override
                public java.lang.Number getBurstLimit() {
                    return this.$burstLimit;
                }

                @Override
                public java.lang.Number getRateLimit() {
                    return this.$rateLimit;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getBurstLimit() != null) {
                        obj.set("burstLimit", om.valueToTree(this.getBurstLimit()));
                    }
                    if (this.getRateLimit() != null) {
                        obj.set("rateLimit", om.valueToTree(this.getRateLimit()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.ThrottleSettings {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The maximum API request rate limit over a time ranging from one to a few seconds.
         * 
         * Default: none
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getBurstLimit() {
            return this.jsiiGet("burstLimit", java.lang.Number.class);
        }

        /**
         * The API request steady-state rate limit (average requests per second over an extended period of time).
         * 
         * Default: none
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getRateLimit() {
            return this.jsiiGet("rateLimit", java.lang.Number.class);
        }
    }
}
