package software.amazon.awscdk.services.apigateway;

/**
 * A CloudFormation `AWS::ApiGatewayV2::Authorizer`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.21.1 (build 9ff44cb)", date = "2020-01-07T23:10:59.080Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnAuthorizerV2")
public class CfnAuthorizerV2 extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnAuthorizerV2(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAuthorizerV2(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnAuthorizerV2.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ApiGatewayV2::Authorizer`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnAuthorizerV2(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.apigateway.CfnAuthorizerV2Props props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", Void.class, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::ApiGatewayV2::Authorizer.ApiId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-apiid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getApiId() {
        return this.jsiiGet("apiId", java.lang.String.class);
    }

    /**
     * `AWS::ApiGatewayV2::Authorizer.ApiId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-apiid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setApiId(final java.lang.String value) {
        this.jsiiSet("apiId", java.util.Objects.requireNonNull(value, "apiId is required"));
    }

    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizertype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAuthorizerType() {
        return this.jsiiGet("authorizerType", java.lang.String.class);
    }

    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizertype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAuthorizerType(final java.lang.String value) {
        this.jsiiSet("authorizerType", java.util.Objects.requireNonNull(value, "authorizerType is required"));
    }

    /**
     * `AWS::ApiGatewayV2::Authorizer.IdentitySource`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identitysource
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.util.List<java.lang.String> getIdentitySource() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("identitySource", java.util.List.class));
    }

    /**
     * `AWS::ApiGatewayV2::Authorizer.IdentitySource`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identitysource
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setIdentitySource(final java.util.List<java.lang.String> value) {
        this.jsiiSet("identitySource", java.util.Objects.requireNonNull(value, "identitySource is required"));
    }

    /**
     * `AWS::ApiGatewayV2::Authorizer.Name`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getName() {
        return this.jsiiGet("name", java.lang.String.class);
    }

    /**
     * `AWS::ApiGatewayV2::Authorizer.Name`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setName(final java.lang.String value) {
        this.jsiiSet("name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerCredentialsArn`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizercredentialsarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAuthorizerCredentialsArn() {
        return this.jsiiGet("authorizerCredentialsArn", java.lang.String.class);
    }

    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerCredentialsArn`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizercredentialsarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAuthorizerCredentialsArn(final java.lang.String value) {
        this.jsiiSet("authorizerCredentialsArn", value);
    }

    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerResultTtlInSeconds`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizerresultttlinseconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Number getAuthorizerResultTtlInSeconds() {
        return this.jsiiGet("authorizerResultTtlInSeconds", java.lang.Number.class);
    }

    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerResultTtlInSeconds`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizerresultttlinseconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAuthorizerResultTtlInSeconds(final java.lang.Number value) {
        this.jsiiSet("authorizerResultTtlInSeconds", value);
    }

    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerUri`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizeruri
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAuthorizerUri() {
        return this.jsiiGet("authorizerUri", java.lang.String.class);
    }

    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerUri`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizeruri
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAuthorizerUri(final java.lang.String value) {
        this.jsiiSet("authorizerUri", value);
    }

    /**
     * `AWS::ApiGatewayV2::Authorizer.IdentityValidationExpression`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identityvalidationexpression
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getIdentityValidationExpression() {
        return this.jsiiGet("identityValidationExpression", java.lang.String.class);
    }

    /**
     * `AWS::ApiGatewayV2::Authorizer.IdentityValidationExpression`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identityvalidationexpression
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setIdentityValidationExpression(final java.lang.String value) {
        this.jsiiSet("identityValidationExpression", value);
    }

    /**
     * `AWS::ApiGatewayV2::Authorizer.JwtConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-jwtconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getJwtConfiguration() {
        return this.jsiiGet("jwtConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGatewayV2::Authorizer.JwtConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-jwtconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setJwtConfiguration(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("jwtConfiguration", value);
    }

    /**
     * `AWS::ApiGatewayV2::Authorizer.JwtConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-jwtconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setJwtConfiguration(final software.amazon.awscdk.services.apigateway.CfnAuthorizerV2.JWTConfigurationProperty value) {
        this.jsiiSet("jwtConfiguration", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-authorizer-jwtconfiguration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnAuthorizerV2.JWTConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(JWTConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface JWTConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnAuthorizerV2.JWTConfigurationProperty.Audience`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-authorizer-jwtconfiguration.html#cfn-apigatewayv2-authorizer-jwtconfiguration-audience
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.util.List<java.lang.String> getAudience() {
            return null;
        }

        /**
         * `CfnAuthorizerV2.JWTConfigurationProperty.Issuer`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-authorizer-jwtconfiguration.html#cfn-apigatewayv2-authorizer-jwtconfiguration-issuer
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getIssuer() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JWTConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JWTConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.util.List<java.lang.String> audience;
            private java.lang.String issuer;

            /**
             * Sets the value of {@link JWTConfigurationProperty#getAudience}
             * @param audience `CfnAuthorizerV2.JWTConfigurationProperty.Audience`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder audience(java.util.List<java.lang.String> audience) {
                this.audience = audience;
                return this;
            }

            /**
             * Sets the value of {@link JWTConfigurationProperty#getIssuer}
             * @param issuer `CfnAuthorizerV2.JWTConfigurationProperty.Issuer`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder issuer(java.lang.String issuer) {
                this.issuer = issuer;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JWTConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public JWTConfigurationProperty build() {
                return new Jsii$Proxy(audience, issuer);
            }
        }

        /**
         * An implementation for {@link JWTConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JWTConfigurationProperty {
            private final java.util.List<java.lang.String> audience;
            private final java.lang.String issuer;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audience = this.jsiiGet("audience", java.util.List.class);
                this.issuer = this.jsiiGet("issuer", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.util.List<java.lang.String> audience, final java.lang.String issuer) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audience = audience;
                this.issuer = issuer;
            }

            @Override
            public java.util.List<java.lang.String> getAudience() {
                return this.audience;
            }

            @Override
            public java.lang.String getIssuer() {
                return this.issuer;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudience() != null) {
                    data.set("audience", om.valueToTree(this.getAudience()));
                }
                if (this.getIssuer() != null) {
                    data.set("issuer", om.valueToTree(this.getIssuer()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnAuthorizerV2.JWTConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JWTConfigurationProperty.Jsii$Proxy that = (JWTConfigurationProperty.Jsii$Proxy) o;

                if (this.audience != null ? !this.audience.equals(that.audience) : that.audience != null) return false;
                return this.issuer != null ? this.issuer.equals(that.issuer) : that.issuer == null;
            }

            @Override
            public int hashCode() {
                int result = this.audience != null ? this.audience.hashCode() : 0;
                result = 31 * result + (this.issuer != null ? this.issuer.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.CfnAuthorizerV2}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.CfnAuthorizerV2Props.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.CfnAuthorizerV2Props.Builder();
        }

        /**
         * `AWS::ApiGatewayV2::Authorizer.ApiId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-apiid
         * @param apiId `AWS::ApiGatewayV2::Authorizer.ApiId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder apiId(final java.lang.String apiId) {
            this.props.apiId(apiId);
            return this;
        }

        /**
         * `AWS::ApiGatewayV2::Authorizer.AuthorizerType`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizertype
         * @param authorizerType `AWS::ApiGatewayV2::Authorizer.AuthorizerType`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder authorizerType(final java.lang.String authorizerType) {
            this.props.authorizerType(authorizerType);
            return this;
        }

        /**
         * `AWS::ApiGatewayV2::Authorizer.IdentitySource`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identitysource
         * @param identitySource `AWS::ApiGatewayV2::Authorizer.IdentitySource`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder identitySource(final java.util.List<java.lang.String> identitySource) {
            this.props.identitySource(identitySource);
            return this;
        }

        /**
         * `AWS::ApiGatewayV2::Authorizer.Name`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-name
         * @param name `AWS::ApiGatewayV2::Authorizer.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * `AWS::ApiGatewayV2::Authorizer.AuthorizerCredentialsArn`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizercredentialsarn
         * @param authorizerCredentialsArn `AWS::ApiGatewayV2::Authorizer.AuthorizerCredentialsArn`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder authorizerCredentialsArn(final java.lang.String authorizerCredentialsArn) {
            this.props.authorizerCredentialsArn(authorizerCredentialsArn);
            return this;
        }

        /**
         * `AWS::ApiGatewayV2::Authorizer.AuthorizerResultTtlInSeconds`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizerresultttlinseconds
         * @param authorizerResultTtlInSeconds `AWS::ApiGatewayV2::Authorizer.AuthorizerResultTtlInSeconds`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder authorizerResultTtlInSeconds(final java.lang.Number authorizerResultTtlInSeconds) {
            this.props.authorizerResultTtlInSeconds(authorizerResultTtlInSeconds);
            return this;
        }

        /**
         * `AWS::ApiGatewayV2::Authorizer.AuthorizerUri`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizeruri
         * @param authorizerUri `AWS::ApiGatewayV2::Authorizer.AuthorizerUri`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder authorizerUri(final java.lang.String authorizerUri) {
            this.props.authorizerUri(authorizerUri);
            return this;
        }

        /**
         * `AWS::ApiGatewayV2::Authorizer.IdentityValidationExpression`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identityvalidationexpression
         * @param identityValidationExpression `AWS::ApiGatewayV2::Authorizer.IdentityValidationExpression`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder identityValidationExpression(final java.lang.String identityValidationExpression) {
            this.props.identityValidationExpression(identityValidationExpression);
            return this;
        }

        /**
         * `AWS::ApiGatewayV2::Authorizer.JwtConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-jwtconfiguration
         * @param jwtConfiguration `AWS::ApiGatewayV2::Authorizer.JwtConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder jwtConfiguration(final software.amazon.awscdk.core.IResolvable jwtConfiguration) {
            this.props.jwtConfiguration(jwtConfiguration);
            return this;
        }
        /**
         * `AWS::ApiGatewayV2::Authorizer.JwtConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-jwtconfiguration
         * @param jwtConfiguration `AWS::ApiGatewayV2::Authorizer.JwtConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder jwtConfiguration(final software.amazon.awscdk.services.apigateway.CfnAuthorizerV2.JWTConfigurationProperty jwtConfiguration) {
            this.props.jwtConfiguration(jwtConfiguration);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.CfnAuthorizerV2}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.apigateway.CfnAuthorizerV2 build() {
            return new software.amazon.awscdk.services.apigateway.CfnAuthorizerV2(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
