package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a `CfnResource`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * CfnResourceProps cfnResourceProps = CfnResourceProps.builder()
 *         .parentId("parentId")
 *         .pathPart("pathPart")
 *         .restApiId("restApiId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-10T17:06:00.073Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnResourceProps")
@software.amazon.jsii.Jsii.Proxy(CfnResourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The parent resource's identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getParentId();

    /**
     * The last path segment for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPathPart();

    /**
     * The string identifier of the associated RestApi.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRestApiId();

    /**
     * @return a {@link Builder} of {@link CfnResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResourceProps> {
        java.lang.String parentId;
        java.lang.String pathPart;
        java.lang.String restApiId;

        /**
         * Sets the value of {@link CfnResourceProps#getParentId}
         * @param parentId The parent resource's identifier. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parentId(java.lang.String parentId) {
            this.parentId = parentId;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceProps#getPathPart}
         * @param pathPart The last path segment for this resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathPart(java.lang.String pathPart) {
            this.pathPart = pathPart;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceProps#getRestApiId}
         * @param restApiId The string identifier of the associated RestApi. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiId(java.lang.String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnResourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResourceProps {
        private final java.lang.String parentId;
        private final java.lang.String pathPart;
        private final java.lang.String restApiId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.parentId = software.amazon.jsii.Kernel.get(this, "parentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pathPart = software.amazon.jsii.Kernel.get(this, "pathPart", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.restApiId = software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.parentId = java.util.Objects.requireNonNull(builder.parentId, "parentId is required");
            this.pathPart = java.util.Objects.requireNonNull(builder.pathPart, "pathPart is required");
            this.restApiId = java.util.Objects.requireNonNull(builder.restApiId, "restApiId is required");
        }

        @Override
        public final java.lang.String getParentId() {
            return this.parentId;
        }

        @Override
        public final java.lang.String getPathPart() {
            return this.pathPart;
        }

        @Override
        public final java.lang.String getRestApiId() {
            return this.restApiId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("parentId", om.valueToTree(this.getParentId()));
            data.set("pathPart", om.valueToTree(this.getPathPart()));
            data.set("restApiId", om.valueToTree(this.getRestApiId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnResourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResourceProps.Jsii$Proxy that = (CfnResourceProps.Jsii$Proxy) o;

            if (!parentId.equals(that.parentId)) return false;
            if (!pathPart.equals(that.pathPart)) return false;
            return this.restApiId.equals(that.restApiId);
        }

        @Override
        public final int hashCode() {
            int result = this.parentId.hashCode();
            result = 31 * result + (this.pathPart.hashCode());
            result = 31 * result + (this.restApiId.hashCode());
            return result;
        }
    }
}
