package software.amazon.awscdk.services.apigateway;

/**
 * ApiKey Properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * import software.amazon.awscdk.core.*;
 * Authorizer authorizer;
 * Integration integration;
 * Model model;
 * RequestValidator requestValidator;
 * RestApi restApi;
 * ApiKeyProps apiKeyProps = ApiKeyProps.builder()
 *         .apiKeyName("apiKeyName")
 *         .customerId("customerId")
 *         .defaultCorsPreflightOptions(CorsOptions.builder()
 *                 .allowOrigins(List.of("allowOrigins"))
 *                 // the properties below are optional
 *                 .allowCredentials(false)
 *                 .allowHeaders(List.of("allowHeaders"))
 *                 .allowMethods(List.of("allowMethods"))
 *                 .disableCache(false)
 *                 .exposeHeaders(List.of("exposeHeaders"))
 *                 .maxAge(Duration.minutes(30))
 *                 .statusCode(123)
 *                 .build())
 *         .defaultIntegration(integration)
 *         .defaultMethodOptions(MethodOptions.builder()
 *                 .apiKeyRequired(false)
 *                 .authorizationScopes(List.of("authorizationScopes"))
 *                 .authorizationType(AuthorizationType.NONE)
 *                 .authorizer(authorizer)
 *                 .methodResponses(List.of(MethodResponse.builder()
 *                         .statusCode("statusCode")
 *                         // the properties below are optional
 *                         .responseModels(Map.of(
 *                                 "responseModelsKey", model))
 *                         .responseParameters(Map.of(
 *                                 "responseParametersKey", false))
 *                         .build()))
 *                 .operationName("operationName")
 *                 .requestModels(Map.of(
 *                         "requestModelsKey", model))
 *                 .requestParameters(Map.of(
 *                         "requestParametersKey", false))
 *                 .requestValidator(requestValidator)
 *                 .requestValidatorOptions(RequestValidatorOptions.builder()
 *                         .requestValidatorName("requestValidatorName")
 *                         .validateRequestBody(false)
 *                         .validateRequestParameters(false)
 *                         .build())
 *                 .build())
 *         .description("description")
 *         .enabled(false)
 *         .generateDistinctId(false)
 *         .resources(List.of(restApi))
 *         .value("value")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.84.0 (build 5404dcf)", date = "2023-06-19T16:30:44.699Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.ApiKeyProps")
@software.amazon.jsii.Jsii.Proxy(ApiKeyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApiKeyProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.ApiKeyOptions {

    /**
     * An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomerId() {
        return null;
    }

    /**
     * Indicates whether the API key can be used by clients.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * Specifies whether the key identifier is distinct from the created API key value.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getGenerateDistinctId() {
        return null;
    }

    /**
     * A list of resources this api key is associated with.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.apigateway.IRestApi> getResources() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApiKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApiKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApiKeyProps> {
        java.lang.String customerId;
        java.lang.Boolean enabled;
        java.lang.Boolean generateDistinctId;
        java.util.List<software.amazon.awscdk.services.apigateway.IRestApi> resources;
        java.lang.String apiKeyName;
        java.lang.String description;
        java.lang.String value;
        software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions;
        software.amazon.awscdk.services.apigateway.Integration defaultIntegration;
        software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions;

        /**
         * Sets the value of {@link ApiKeyProps#getCustomerId}
         * @param customerId An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerId(java.lang.String customerId) {
            this.customerId = customerId;
            return this;
        }

        /**
         * Sets the value of {@link ApiKeyProps#getEnabled}
         * @param enabled Indicates whether the API key can be used by clients.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link ApiKeyProps#getGenerateDistinctId}
         * @param generateDistinctId Specifies whether the key identifier is distinct from the created API key value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateDistinctId(java.lang.Boolean generateDistinctId) {
            this.generateDistinctId = generateDistinctId;
            return this;
        }

        /**
         * Sets the value of {@link ApiKeyProps#getResources}
         * @param resources A list of resources this api key is associated with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder resources(java.util.List<? extends software.amazon.awscdk.services.apigateway.IRestApi> resources) {
            this.resources = (java.util.List<software.amazon.awscdk.services.apigateway.IRestApi>)resources;
            return this;
        }

        /**
         * Sets the value of {@link ApiKeyProps#getApiKeyName}
         * @param apiKeyName A name for the API key.
         *                   If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the API key name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyName(java.lang.String apiKeyName) {
            this.apiKeyName = apiKeyName;
            return this;
        }

        /**
         * Sets the value of {@link ApiKeyProps#getDescription}
         * @param description A description of the purpose of the API key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ApiKeyProps#getValue}
         * @param value The value of the API key.
         *              Must be at least 20 characters long.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder value(java.lang.String value) {
            this.value = value;
            return this;
        }

        /**
         * Sets the value of {@link ApiKeyProps#getDefaultCorsPreflightOptions}
         * @param defaultCorsPreflightOptions Adds a CORS preflight OPTIONS method to this resource and all child resources.
         *                                    You can add CORS at the resource-level using <code>addCorsPreflight</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCorsPreflightOptions(software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions) {
            this.defaultCorsPreflightOptions = defaultCorsPreflightOptions;
            return this;
        }

        /**
         * Sets the value of {@link ApiKeyProps#getDefaultIntegration}
         * @param defaultIntegration An integration to use as a default for all methods created within this API unless an integration is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultIntegration(software.amazon.awscdk.services.apigateway.Integration defaultIntegration) {
            this.defaultIntegration = defaultIntegration;
            return this;
        }

        /**
         * Sets the value of {@link ApiKeyProps#getDefaultMethodOptions}
         * @param defaultMethodOptions Method options to use as a default for all methods created within this API unless custom options are specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultMethodOptions(software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions) {
            this.defaultMethodOptions = defaultMethodOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApiKeyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApiKeyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApiKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiKeyProps {
        private final java.lang.String customerId;
        private final java.lang.Boolean enabled;
        private final java.lang.Boolean generateDistinctId;
        private final java.util.List<software.amazon.awscdk.services.apigateway.IRestApi> resources;
        private final java.lang.String apiKeyName;
        private final java.lang.String description;
        private final java.lang.String value;
        private final software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions;
        private final software.amazon.awscdk.services.apigateway.Integration defaultIntegration;
        private final software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.customerId = software.amazon.jsii.Kernel.get(this, "customerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.generateDistinctId = software.amazon.jsii.Kernel.get(this, "generateDistinctId", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.resources = software.amazon.jsii.Kernel.get(this, "resources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IRestApi.class)));
            this.apiKeyName = software.amazon.jsii.Kernel.get(this, "apiKeyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultCorsPreflightOptions = software.amazon.jsii.Kernel.get(this, "defaultCorsPreflightOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.CorsOptions.class));
            this.defaultIntegration = software.amazon.jsii.Kernel.get(this, "defaultIntegration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.Integration.class));
            this.defaultMethodOptions = software.amazon.jsii.Kernel.get(this, "defaultMethodOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.MethodOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.customerId = builder.customerId;
            this.enabled = builder.enabled;
            this.generateDistinctId = builder.generateDistinctId;
            this.resources = (java.util.List<software.amazon.awscdk.services.apigateway.IRestApi>)builder.resources;
            this.apiKeyName = builder.apiKeyName;
            this.description = builder.description;
            this.value = builder.value;
            this.defaultCorsPreflightOptions = builder.defaultCorsPreflightOptions;
            this.defaultIntegration = builder.defaultIntegration;
            this.defaultMethodOptions = builder.defaultMethodOptions;
        }

        @Override
        public final java.lang.String getCustomerId() {
            return this.customerId;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.Boolean getGenerateDistinctId() {
            return this.generateDistinctId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.apigateway.IRestApi> getResources() {
            return this.resources;
        }

        @Override
        public final java.lang.String getApiKeyName() {
            return this.apiKeyName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getValue() {
            return this.value;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.CorsOptions getDefaultCorsPreflightOptions() {
            return this.defaultCorsPreflightOptions;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.Integration getDefaultIntegration() {
            return this.defaultIntegration;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.MethodOptions getDefaultMethodOptions() {
            return this.defaultMethodOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCustomerId() != null) {
                data.set("customerId", om.valueToTree(this.getCustomerId()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getGenerateDistinctId() != null) {
                data.set("generateDistinctId", om.valueToTree(this.getGenerateDistinctId()));
            }
            if (this.getResources() != null) {
                data.set("resources", om.valueToTree(this.getResources()));
            }
            if (this.getApiKeyName() != null) {
                data.set("apiKeyName", om.valueToTree(this.getApiKeyName()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getValue() != null) {
                data.set("value", om.valueToTree(this.getValue()));
            }
            if (this.getDefaultCorsPreflightOptions() != null) {
                data.set("defaultCorsPreflightOptions", om.valueToTree(this.getDefaultCorsPreflightOptions()));
            }
            if (this.getDefaultIntegration() != null) {
                data.set("defaultIntegration", om.valueToTree(this.getDefaultIntegration()));
            }
            if (this.getDefaultMethodOptions() != null) {
                data.set("defaultMethodOptions", om.valueToTree(this.getDefaultMethodOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.ApiKeyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApiKeyProps.Jsii$Proxy that = (ApiKeyProps.Jsii$Proxy) o;

            if (this.customerId != null ? !this.customerId.equals(that.customerId) : that.customerId != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.generateDistinctId != null ? !this.generateDistinctId.equals(that.generateDistinctId) : that.generateDistinctId != null) return false;
            if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) return false;
            if (this.apiKeyName != null ? !this.apiKeyName.equals(that.apiKeyName) : that.apiKeyName != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.value != null ? !this.value.equals(that.value) : that.value != null) return false;
            if (this.defaultCorsPreflightOptions != null ? !this.defaultCorsPreflightOptions.equals(that.defaultCorsPreflightOptions) : that.defaultCorsPreflightOptions != null) return false;
            if (this.defaultIntegration != null ? !this.defaultIntegration.equals(that.defaultIntegration) : that.defaultIntegration != null) return false;
            return this.defaultMethodOptions != null ? this.defaultMethodOptions.equals(that.defaultMethodOptions) : that.defaultMethodOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.customerId != null ? this.customerId.hashCode() : 0;
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.generateDistinctId != null ? this.generateDistinctId.hashCode() : 0);
            result = 31 * result + (this.resources != null ? this.resources.hashCode() : 0);
            result = 31 * result + (this.apiKeyName != null ? this.apiKeyName.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            result = 31 * result + (this.defaultCorsPreflightOptions != null ? this.defaultCorsPreflightOptions.hashCode() : 0);
            result = 31 * result + (this.defaultIntegration != null ? this.defaultIntegration.hashCode() : 0);
            result = 31 * result + (this.defaultMethodOptions != null ? this.defaultMethodOptions.hashCode() : 0);
            return result;
        }
    }
}
