package software.amazon.awscdk.services.apigateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-02-19T09:09:45.981Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.IntegrationOptions")
@software.amazon.jsii.Jsii.Proxy(IntegrationOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IntegrationOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of request parameters whose values are to be cached.
     * <p>
     * It determines
     * request parameters that will make it into the cache key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<java.lang.String> getCacheKeyParameters() {
        return null;
    }

    /**
     * An API-specific tag group of related cached parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.String getCacheNamespace() {
        return null;
    }

    /**
     * The type of network connection to the integration endpoint.
     * <p>
     * Default: ConnectionType.Internet
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.apigateway.ConnectionType getConnectionType() {
        return null;
    }

    /**
     * Specifies how to handle request payload content type conversions.
     * <p>
     * Default: none if this property isn't defined, the request payload is passed
     * through from the method request to the integration request without
     * modification, provided that the `passthroughBehaviors` property is
     * configured to support payload pass-through.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.apigateway.ContentHandling getContentHandling() {
        return null;
    }

    /**
     * Requires that the caller's identity be passed through from the request.
     * <p>
     * Default: Caller identity is not passed through
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Boolean getCredentialsPassthrough() {
        return null;
    }

    /**
     * An IAM role that API Gateway assumes.
     * <p>
     * Mutually exclusive with <code>credentialsPassThrough</code>.
     * <p>
     * Default: A role is not assumed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.iam.IRole getCredentialsRole() {
        return null;
    }

    /**
     * The response that API Gateway provides after a method's backend completes processing a request.
     * <p>
     * API Gateway intercepts the response from the
     * backend so that you can control how API Gateway surfaces backend
     * responses. For example, you can map the backend status codes to codes
     * that you define.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> getIntegrationResponses() {
        return null;
    }

    /**
     * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource.
     * <p>
     * There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and
     * NEVER.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.apigateway.PassthroughBehavior getPassthroughBehavior() {
        return null;
    }

    /**
     * The request parameters that API Gateway sends with the backend request.
     * <p>
     * Specify request parameters as key-value pairs (string-to-string
     * mappings), with a destination as the key and a source as the value.
     * <p>
     * Specify the destination by using the following pattern
     * integration.request.location.name, where location is querystring, path,
     * or header, and name is a valid, unique parameter name.
     * <p>
     * The source must be an existing method request parameter or a static
     * value. You must enclose static values in single quotation marks and
     * pre-encode these values based on their destination in the request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.Map<java.lang.String, java.lang.String> getRequestParameters() {
        return null;
    }

    /**
     * A map of Apache Velocity templates that are applied on the request payload.
     * <p>
     * The template that API Gateway uses is based on the value of the
     * Content-Type header that's sent by the client. The content type value is
     * the key, and the template is the value (specified as a string), such as
     * the following snippet:
     * <p>
     * { "application/json": "{\n  "statusCode": "200"\n}" }
     * <p>
     * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.Map<java.lang.String, java.lang.String> getRequestTemplates() {
        return null;
    }

    /**
     * The VpcLink used for the integration.
     * <p>
     * Required if connectionType is VPC_LINK
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.apigateway.VpcLink getVpcLink() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link IntegrationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IntegrationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.util.List<java.lang.String> cacheKeyParameters;
        private java.lang.String cacheNamespace;
        private software.amazon.awscdk.services.apigateway.ConnectionType connectionType;
        private software.amazon.awscdk.services.apigateway.ContentHandling contentHandling;
        private java.lang.Boolean credentialsPassthrough;
        private software.amazon.awscdk.services.iam.IRole credentialsRole;
        private java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> integrationResponses;
        private software.amazon.awscdk.services.apigateway.PassthroughBehavior passthroughBehavior;
        private java.util.Map<java.lang.String, java.lang.String> requestParameters;
        private java.util.Map<java.lang.String, java.lang.String> requestTemplates;
        private software.amazon.awscdk.services.apigateway.VpcLink vpcLink;

        /**
         * Sets the value of {@link IntegrationOptions#getCacheKeyParameters}
         * @param cacheKeyParameters A list of request parameters whose values are to be cached.
         *                           It determines
         *                           request parameters that will make it into the cache key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheKeyParameters(java.util.List<java.lang.String> cacheKeyParameters) {
            this.cacheKeyParameters = cacheKeyParameters;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationOptions#getCacheNamespace}
         * @param cacheNamespace An API-specific tag group of related cached parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheNamespace(java.lang.String cacheNamespace) {
            this.cacheNamespace = cacheNamespace;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationOptions#getConnectionType}
         * @param connectionType The type of network connection to the integration endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionType(software.amazon.awscdk.services.apigateway.ConnectionType connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationOptions#getContentHandling}
         * @param contentHandling Specifies how to handle request payload content type conversions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentHandling(software.amazon.awscdk.services.apigateway.ContentHandling contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationOptions#getCredentialsPassthrough}
         * @param credentialsPassthrough Requires that the caller's identity be passed through from the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsPassthrough(java.lang.Boolean credentialsPassthrough) {
            this.credentialsPassthrough = credentialsPassthrough;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationOptions#getCredentialsRole}
         * @param credentialsRole An IAM role that API Gateway assumes.
         *                        Mutually exclusive with <code>credentialsPassThrough</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsRole(software.amazon.awscdk.services.iam.IRole credentialsRole) {
            this.credentialsRole = credentialsRole;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationOptions#getIntegrationResponses}
         * @param integrationResponses The response that API Gateway provides after a method's backend completes processing a request.
         *                             API Gateway intercepts the response from the
         *                             backend so that you can control how API Gateway surfaces backend
         *                             responses. For example, you can map the backend status codes to codes
         *                             that you define.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationResponses(java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> integrationResponses) {
            this.integrationResponses = integrationResponses;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationOptions#getPassthroughBehavior}
         * @param passthroughBehavior Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource.
         *                            There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and
         *                            NEVER.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passthroughBehavior(software.amazon.awscdk.services.apigateway.PassthroughBehavior passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationOptions#getRequestParameters}
         * @param requestParameters The request parameters that API Gateway sends with the backend request.
         *                          Specify request parameters as key-value pairs (string-to-string
         *                          mappings), with a destination as the key and a source as the value.
         *                          <p>
         *                          Specify the destination by using the following pattern
         *                          integration.request.location.name, where location is querystring, path,
         *                          or header, and name is a valid, unique parameter name.
         *                          <p>
         *                          The source must be an existing method request parameter or a static
         *                          value. You must enclose static values in single quotation marks and
         *                          pre-encode these values based on their destination in the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(java.util.Map<java.lang.String, java.lang.String> requestParameters) {
            this.requestParameters = requestParameters;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationOptions#getRequestTemplates}
         * @param requestTemplates A map of Apache Velocity templates that are applied on the request payload.
         *                         The template that API Gateway uses is based on the value of the
         *                         Content-Type header that's sent by the client. The content type value is
         *                         the key, and the template is the value (specified as a string), such as
         *                         the following snippet:
         *                         <p>
         *                         { "application/json": "{\n  "statusCode": "200"\n}" }
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestTemplates(java.util.Map<java.lang.String, java.lang.String> requestTemplates) {
            this.requestTemplates = requestTemplates;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationOptions#getVpcLink}
         * @param vpcLink The VpcLink used for the integration.
         *                Required if connectionType is VPC_LINK
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcLink(software.amazon.awscdk.services.apigateway.VpcLink vpcLink) {
            this.vpcLink = vpcLink;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IntegrationOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public IntegrationOptions build() {
            return new Jsii$Proxy(cacheKeyParameters, cacheNamespace, connectionType, contentHandling, credentialsPassthrough, credentialsRole, integrationResponses, passthroughBehavior, requestParameters, requestTemplates, vpcLink);
        }
    }

    /**
     * An implementation for {@link IntegrationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegrationOptions {
        private final java.util.List<java.lang.String> cacheKeyParameters;
        private final java.lang.String cacheNamespace;
        private final software.amazon.awscdk.services.apigateway.ConnectionType connectionType;
        private final software.amazon.awscdk.services.apigateway.ContentHandling contentHandling;
        private final java.lang.Boolean credentialsPassthrough;
        private final software.amazon.awscdk.services.iam.IRole credentialsRole;
        private final java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> integrationResponses;
        private final software.amazon.awscdk.services.apigateway.PassthroughBehavior passthroughBehavior;
        private final java.util.Map<java.lang.String, java.lang.String> requestParameters;
        private final java.util.Map<java.lang.String, java.lang.String> requestTemplates;
        private final software.amazon.awscdk.services.apigateway.VpcLink vpcLink;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cacheKeyParameters = this.jsiiGet("cacheKeyParameters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cacheNamespace = this.jsiiGet("cacheNamespace", java.lang.String.class);
            this.connectionType = this.jsiiGet("connectionType", software.amazon.awscdk.services.apigateway.ConnectionType.class);
            this.contentHandling = this.jsiiGet("contentHandling", software.amazon.awscdk.services.apigateway.ContentHandling.class);
            this.credentialsPassthrough = this.jsiiGet("credentialsPassthrough", java.lang.Boolean.class);
            this.credentialsRole = this.jsiiGet("credentialsRole", software.amazon.awscdk.services.iam.IRole.class);
            this.integrationResponses = this.jsiiGet("integrationResponses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IntegrationResponse.class)));
            this.passthroughBehavior = this.jsiiGet("passthroughBehavior", software.amazon.awscdk.services.apigateway.PassthroughBehavior.class);
            this.requestParameters = this.jsiiGet("requestParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.requestTemplates = this.jsiiGet("requestTemplates", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.vpcLink = this.jsiiGet("vpcLink", software.amazon.awscdk.services.apigateway.VpcLink.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<java.lang.String> cacheKeyParameters, final java.lang.String cacheNamespace, final software.amazon.awscdk.services.apigateway.ConnectionType connectionType, final software.amazon.awscdk.services.apigateway.ContentHandling contentHandling, final java.lang.Boolean credentialsPassthrough, final software.amazon.awscdk.services.iam.IRole credentialsRole, final java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> integrationResponses, final software.amazon.awscdk.services.apigateway.PassthroughBehavior passthroughBehavior, final java.util.Map<java.lang.String, java.lang.String> requestParameters, final java.util.Map<java.lang.String, java.lang.String> requestTemplates, final software.amazon.awscdk.services.apigateway.VpcLink vpcLink) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cacheKeyParameters = cacheKeyParameters;
            this.cacheNamespace = cacheNamespace;
            this.connectionType = connectionType;
            this.contentHandling = contentHandling;
            this.credentialsPassthrough = credentialsPassthrough;
            this.credentialsRole = credentialsRole;
            this.integrationResponses = integrationResponses;
            this.passthroughBehavior = passthroughBehavior;
            this.requestParameters = requestParameters;
            this.requestTemplates = requestTemplates;
            this.vpcLink = vpcLink;
        }

        @Override
        public java.util.List<java.lang.String> getCacheKeyParameters() {
            return this.cacheKeyParameters;
        }

        @Override
        public java.lang.String getCacheNamespace() {
            return this.cacheNamespace;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.ConnectionType getConnectionType() {
            return this.connectionType;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.ContentHandling getContentHandling() {
            return this.contentHandling;
        }

        @Override
        public java.lang.Boolean getCredentialsPassthrough() {
            return this.credentialsPassthrough;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getCredentialsRole() {
            return this.credentialsRole;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> getIntegrationResponses() {
            return this.integrationResponses;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.PassthroughBehavior getPassthroughBehavior() {
            return this.passthroughBehavior;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getRequestParameters() {
            return this.requestParameters;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getRequestTemplates() {
            return this.requestTemplates;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.VpcLink getVpcLink() {
            return this.vpcLink;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCacheKeyParameters() != null) {
                data.set("cacheKeyParameters", om.valueToTree(this.getCacheKeyParameters()));
            }
            if (this.getCacheNamespace() != null) {
                data.set("cacheNamespace", om.valueToTree(this.getCacheNamespace()));
            }
            if (this.getConnectionType() != null) {
                data.set("connectionType", om.valueToTree(this.getConnectionType()));
            }
            if (this.getContentHandling() != null) {
                data.set("contentHandling", om.valueToTree(this.getContentHandling()));
            }
            if (this.getCredentialsPassthrough() != null) {
                data.set("credentialsPassthrough", om.valueToTree(this.getCredentialsPassthrough()));
            }
            if (this.getCredentialsRole() != null) {
                data.set("credentialsRole", om.valueToTree(this.getCredentialsRole()));
            }
            if (this.getIntegrationResponses() != null) {
                data.set("integrationResponses", om.valueToTree(this.getIntegrationResponses()));
            }
            if (this.getPassthroughBehavior() != null) {
                data.set("passthroughBehavior", om.valueToTree(this.getPassthroughBehavior()));
            }
            if (this.getRequestParameters() != null) {
                data.set("requestParameters", om.valueToTree(this.getRequestParameters()));
            }
            if (this.getRequestTemplates() != null) {
                data.set("requestTemplates", om.valueToTree(this.getRequestTemplates()));
            }
            if (this.getVpcLink() != null) {
                data.set("vpcLink", om.valueToTree(this.getVpcLink()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.IntegrationOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IntegrationOptions.Jsii$Proxy that = (IntegrationOptions.Jsii$Proxy) o;

            if (this.cacheKeyParameters != null ? !this.cacheKeyParameters.equals(that.cacheKeyParameters) : that.cacheKeyParameters != null) return false;
            if (this.cacheNamespace != null ? !this.cacheNamespace.equals(that.cacheNamespace) : that.cacheNamespace != null) return false;
            if (this.connectionType != null ? !this.connectionType.equals(that.connectionType) : that.connectionType != null) return false;
            if (this.contentHandling != null ? !this.contentHandling.equals(that.contentHandling) : that.contentHandling != null) return false;
            if (this.credentialsPassthrough != null ? !this.credentialsPassthrough.equals(that.credentialsPassthrough) : that.credentialsPassthrough != null) return false;
            if (this.credentialsRole != null ? !this.credentialsRole.equals(that.credentialsRole) : that.credentialsRole != null) return false;
            if (this.integrationResponses != null ? !this.integrationResponses.equals(that.integrationResponses) : that.integrationResponses != null) return false;
            if (this.passthroughBehavior != null ? !this.passthroughBehavior.equals(that.passthroughBehavior) : that.passthroughBehavior != null) return false;
            if (this.requestParameters != null ? !this.requestParameters.equals(that.requestParameters) : that.requestParameters != null) return false;
            if (this.requestTemplates != null ? !this.requestTemplates.equals(that.requestTemplates) : that.requestTemplates != null) return false;
            return this.vpcLink != null ? this.vpcLink.equals(that.vpcLink) : that.vpcLink == null;
        }

        @Override
        public int hashCode() {
            int result = this.cacheKeyParameters != null ? this.cacheKeyParameters.hashCode() : 0;
            result = 31 * result + (this.cacheNamespace != null ? this.cacheNamespace.hashCode() : 0);
            result = 31 * result + (this.connectionType != null ? this.connectionType.hashCode() : 0);
            result = 31 * result + (this.contentHandling != null ? this.contentHandling.hashCode() : 0);
            result = 31 * result + (this.credentialsPassthrough != null ? this.credentialsPassthrough.hashCode() : 0);
            result = 31 * result + (this.credentialsRole != null ? this.credentialsRole.hashCode() : 0);
            result = 31 * result + (this.integrationResponses != null ? this.integrationResponses.hashCode() : 0);
            result = 31 * result + (this.passthroughBehavior != null ? this.passthroughBehavior.hashCode() : 0);
            result = 31 * result + (this.requestParameters != null ? this.requestParameters.hashCode() : 0);
            result = 31 * result + (this.requestTemplates != null ? this.requestTemplates.hashCode() : 0);
            result = 31 * result + (this.vpcLink != null ? this.vpcLink.hashCode() : 0);
            return result;
        }
    }
}
