package software.amazon.awscdk.services.apigateway;

/**
 * Integrates an AWS Lambda function to an API Gateway method.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>{@code
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var handler = new Function(this, "MyFunction", ...);
 * api.addMethod("GET", new LambdaIntegration(handler));}</pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-02-19T09:09:45.984Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.LambdaIntegration")
public class LambdaIntegration extends software.amazon.awscdk.services.apigateway.AwsIntegration {

    protected LambdaIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LambdaIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param handler This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LambdaIntegration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction handler, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.LambdaIntegrationOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(handler, "handler is required"), options });
    }

    /**
     * @param handler This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LambdaIntegration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction handler) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(handler, "handler is required") });
    }

    /**
     * Can be overridden by subclasses to allow the integration to interact with the method being integrated, access the REST API object, method ARNs, etc.
     * <p>
     * @param method This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.Method method) {
        this.jsiiCall("bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(method, "method is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.LambdaIntegration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param handler This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.lambda.IFunction handler) {
            return new Builder(handler);
        }

        private final software.amazon.awscdk.services.lambda.IFunction handler;
        private software.amazon.awscdk.services.apigateway.LambdaIntegrationOptions.Builder options;

        private Builder(final software.amazon.awscdk.services.lambda.IFunction handler) {
            this.handler = handler;
        }

        /**
         * A list of request parameters whose values are to be cached.
         * <p>
         * It determines
         * request parameters that will make it into the cache key.
         * <p>
         * @return {@code this}
         * @param cacheKeyParameters A list of request parameters whose values are to be cached. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheKeyParameters(final java.util.List<java.lang.String> cacheKeyParameters) {
            this.options().cacheKeyParameters(cacheKeyParameters);
            return this;
        }

        /**
         * An API-specific tag group of related cached parameters.
         * <p>
         * @return {@code this}
         * @param cacheNamespace An API-specific tag group of related cached parameters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheNamespace(final java.lang.String cacheNamespace) {
            this.options().cacheNamespace(cacheNamespace);
            return this;
        }

        /**
         * The type of network connection to the integration endpoint.
         * <p>
         * Default: ConnectionType.Internet
         * <p>
         * @return {@code this}
         * @param connectionType The type of network connection to the integration endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionType(final software.amazon.awscdk.services.apigateway.ConnectionType connectionType) {
            this.options().connectionType(connectionType);
            return this;
        }

        /**
         * Specifies how to handle request payload content type conversions.
         * <p>
         * Default: none if this property isn't defined, the request payload is passed
         * through from the method request to the integration request without
         * modification, provided that the `passthroughBehaviors` property is
         * configured to support payload pass-through.
         * <p>
         * @return {@code this}
         * @param contentHandling Specifies how to handle request payload content type conversions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentHandling(final software.amazon.awscdk.services.apigateway.ContentHandling contentHandling) {
            this.options().contentHandling(contentHandling);
            return this;
        }

        /**
         * Requires that the caller's identity be passed through from the request.
         * <p>
         * Default: Caller identity is not passed through
         * <p>
         * @return {@code this}
         * @param credentialsPassthrough Requires that the caller's identity be passed through from the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsPassthrough(final java.lang.Boolean credentialsPassthrough) {
            this.options().credentialsPassthrough(credentialsPassthrough);
            return this;
        }

        /**
         * An IAM role that API Gateway assumes.
         * <p>
         * Mutually exclusive with <code>credentialsPassThrough</code>.
         * <p>
         * Default: A role is not assumed
         * <p>
         * @return {@code this}
         * @param credentialsRole An IAM role that API Gateway assumes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsRole(final software.amazon.awscdk.services.iam.IRole credentialsRole) {
            this.options().credentialsRole(credentialsRole);
            return this;
        }

        /**
         * The response that API Gateway provides after a method's backend completes processing a request.
         * <p>
         * API Gateway intercepts the response from the
         * backend so that you can control how API Gateway surfaces backend
         * responses. For example, you can map the backend status codes to codes
         * that you define.
         * <p>
         * @return {@code this}
         * @param integrationResponses The response that API Gateway provides after a method's backend completes processing a request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationResponses(final java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> integrationResponses) {
            this.options().integrationResponses(integrationResponses);
            return this;
        }

        /**
         * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource.
         * <p>
         * There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and
         * NEVER.
         * <p>
         * @return {@code this}
         * @param passthroughBehavior Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passthroughBehavior(final software.amazon.awscdk.services.apigateway.PassthroughBehavior passthroughBehavior) {
            this.options().passthroughBehavior(passthroughBehavior);
            return this;
        }

        /**
         * The request parameters that API Gateway sends with the backend request.
         * <p>
         * Specify request parameters as key-value pairs (string-to-string
         * mappings), with a destination as the key and a source as the value.
         * <p>
         * Specify the destination by using the following pattern
         * integration.request.location.name, where location is querystring, path,
         * or header, and name is a valid, unique parameter name.
         * <p>
         * The source must be an existing method request parameter or a static
         * value. You must enclose static values in single quotation marks and
         * pre-encode these values based on their destination in the request.
         * <p>
         * @return {@code this}
         * @param requestParameters The request parameters that API Gateway sends with the backend request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(final java.util.Map<java.lang.String, java.lang.String> requestParameters) {
            this.options().requestParameters(requestParameters);
            return this;
        }

        /**
         * A map of Apache Velocity templates that are applied on the request payload.
         * <p>
         * The template that API Gateway uses is based on the value of the
         * Content-Type header that's sent by the client. The content type value is
         * the key, and the template is the value (specified as a string), such as
         * the following snippet:
         * <p>
         * { "application/json": "{\n  "statusCode": "200"\n}" }
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html
         * @param requestTemplates A map of Apache Velocity templates that are applied on the request payload. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestTemplates(final java.util.Map<java.lang.String, java.lang.String> requestTemplates) {
            this.options().requestTemplates(requestTemplates);
            return this;
        }

        /**
         * The VpcLink used for the integration.
         * <p>
         * Required if connectionType is VPC_LINK
         * <p>
         * @return {@code this}
         * @param vpcLink The VpcLink used for the integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcLink(final software.amazon.awscdk.services.apigateway.VpcLink vpcLink) {
            this.options().vpcLink(vpcLink);
            return this;
        }

        /**
         * Allow invoking method from AWS Console UI (for testing purposes).
         * <p>
         * This will add another permission to the AWS Lambda resource policy which
         * will allow the <code>test-invoke-stage</code> stage to invoke this handler. If this
         * is set to <code>false</code>, the function will only be usable from the deployment
         * endpoint.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param allowTestInvoke Allow invoking method from AWS Console UI (for testing purposes). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowTestInvoke(final java.lang.Boolean allowTestInvoke) {
            this.options().allowTestInvoke(allowTestInvoke);
            return this;
        }

        /**
         * Use proxy integration or normal (request/response mapping) integration.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param proxy Use proxy integration or normal (request/response mapping) integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxy(final java.lang.Boolean proxy) {
            this.options().proxy(proxy);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.LambdaIntegration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.apigateway.LambdaIntegration build() {
            return new software.amazon.awscdk.services.apigateway.LambdaIntegration(
                this.handler,
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.services.apigateway.LambdaIntegrationOptions.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.services.apigateway.LambdaIntegrationOptions.Builder();
            }
            return this.options;
        }
    }
}
