package software.amazon.awscdk.services.apigateway;

/**
 * ApiKey Properties.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-02T10:20:13.321Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApiKeyProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.ResourceOptions {
    /**
     * A name for the API key.
     * 
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the API key name.
     * 
     * Default: automically generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getApiKeyName();
    /**
     * An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getCustomerId();
    /**
     * A description of the purpose of the API key.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDescription();
    /**
     * Indicates whether the API key can be used by clients.
     * 
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getEnabled();
    /**
     * Specifies whether the key identifier is distinct from the created API key value.
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getGenerateDistinctId();
    /**
     * A list of resources this api key is associated with.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.apigateway.RestApi> getResources();

    /**
     * @return a {@link Builder} of {@link ApiKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ApiKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _apiKeyName;
        @javax.annotation.Nullable
        private java.lang.String _customerId;
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.lang.Boolean _enabled;
        @javax.annotation.Nullable
        private java.lang.Boolean _generateDistinctId;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.apigateway.RestApi> _resources;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.Integration _defaultIntegration;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.MethodOptions _defaultMethodOptions;

        /**
         * Sets the value of ApiKeyName
         * @param value A name for the API key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withApiKeyName(@javax.annotation.Nullable final java.lang.String value) {
            this._apiKeyName = value;
            return this;
        }
        /**
         * Sets the value of CustomerId
         * @param value An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withCustomerId(@javax.annotation.Nullable final java.lang.String value) {
            this._customerId = value;
            return this;
        }
        /**
         * Sets the value of Description
         * @param value A description of the purpose of the API key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of Enabled
         * @param value Indicates whether the API key can be used by clients.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._enabled = value;
            return this;
        }
        /**
         * Sets the value of GenerateDistinctId
         * @param value Specifies whether the key identifier is distinct from the created API key value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withGenerateDistinctId(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._generateDistinctId = value;
            return this;
        }
        /**
         * Sets the value of Resources
         * @param value A list of resources this api key is associated with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withResources(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.apigateway.RestApi> value) {
            this._resources = value;
            return this;
        }
        /**
         * Sets the value of DefaultIntegration
         * @param value An integration to use as a default for all methods created within this API unless an integration is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDefaultIntegration(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.Integration value) {
            this._defaultIntegration = value;
            return this;
        }
        /**
         * Sets the value of DefaultMethodOptions
         * @param value Method options to use as a default for all methods created within this API unless custom options are specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDefaultMethodOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.MethodOptions value) {
            this._defaultMethodOptions = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApiKeyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ApiKeyProps build() {
            return new ApiKeyProps() {
                @javax.annotation.Nullable
                private final java.lang.String $apiKeyName = _apiKeyName;
                @javax.annotation.Nullable
                private final java.lang.String $customerId = _customerId;
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;
                @javax.annotation.Nullable
                private final java.lang.Boolean $enabled = _enabled;
                @javax.annotation.Nullable
                private final java.lang.Boolean $generateDistinctId = _generateDistinctId;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.apigateway.RestApi> $resources = _resources;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.Integration $defaultIntegration = _defaultIntegration;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.MethodOptions $defaultMethodOptions = _defaultMethodOptions;

                @Override
                public java.lang.String getApiKeyName() {
                    return this.$apiKeyName;
                }

                @Override
                public java.lang.String getCustomerId() {
                    return this.$customerId;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public java.lang.Boolean getEnabled() {
                    return this.$enabled;
                }

                @Override
                public java.lang.Boolean getGenerateDistinctId() {
                    return this.$generateDistinctId;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.apigateway.RestApi> getResources() {
                    return this.$resources;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.Integration getDefaultIntegration() {
                    return this.$defaultIntegration;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.MethodOptions getDefaultMethodOptions() {
                    return this.$defaultMethodOptions;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getApiKeyName() != null) {
                        obj.set("apiKeyName", om.valueToTree(this.getApiKeyName()));
                    }
                    if (this.getCustomerId() != null) {
                        obj.set("customerId", om.valueToTree(this.getCustomerId()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree(this.getDescription()));
                    }
                    if (this.getEnabled() != null) {
                        obj.set("enabled", om.valueToTree(this.getEnabled()));
                    }
                    if (this.getGenerateDistinctId() != null) {
                        obj.set("generateDistinctId", om.valueToTree(this.getGenerateDistinctId()));
                    }
                    if (this.getResources() != null) {
                        obj.set("resources", om.valueToTree(this.getResources()));
                    }
                    if (this.getDefaultIntegration() != null) {
                        obj.set("defaultIntegration", om.valueToTree(this.getDefaultIntegration()));
                    }
                    if (this.getDefaultMethodOptions() != null) {
                        obj.set("defaultMethodOptions", om.valueToTree(this.getDefaultMethodOptions()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.ApiKeyProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * A name for the API key.
         * 
         * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the API key name.
         * 
         * Default: automically generated name
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getApiKeyName() {
            return this.jsiiGet("apiKeyName", java.lang.String.class);
        }

        /**
         * An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace.
         * 
         * Default: none
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getCustomerId() {
            return this.jsiiGet("customerId", java.lang.String.class);
        }

        /**
         * A description of the purpose of the API key.
         * 
         * Default: none
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * Indicates whether the API key can be used by clients.
         * 
         * Default: true
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getEnabled() {
            return this.jsiiGet("enabled", java.lang.Boolean.class);
        }

        /**
         * Specifies whether the key identifier is distinct from the created API key value.
         * 
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getGenerateDistinctId() {
            return this.jsiiGet("generateDistinctId", java.lang.Boolean.class);
        }

        /**
         * A list of resources this api key is associated with.
         * 
         * Default: none
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.apigateway.RestApi> getResources() {
            return this.jsiiGet("resources", java.util.List.class);
        }

        /**
         * An integration to use as a default for all methods created within this API unless an integration is specified.
         * 
         * Default: - Inherited from parent.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.Integration getDefaultIntegration() {
            return this.jsiiGet("defaultIntegration", software.amazon.awscdk.services.apigateway.Integration.class);
        }

        /**
         * Method options to use as a default for all methods created within this API unless custom options are specified.
         * 
         * Default: - Inherited from parent.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.MethodOptions getDefaultMethodOptions() {
            return this.jsiiGet("defaultMethodOptions", software.amazon.awscdk.services.apigateway.MethodOptions.class);
        }
    }
}
