package software.amazon.awscdk.services.apigateway;

/**
 * Specifies the maximum number of requests that clients can make to API Gateway APIs.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-02T10:20:13.418Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface QuotaSettings extends software.amazon.jsii.JsiiSerializable {
    /**
     * The maximum number of requests that users can make within the specified time period.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getLimit();
    /**
     * For the initial time period, the number of requests to subtract from the specified limit.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getOffset();
    /**
     * The time period for which the maximum limit of requests applies.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.Period getPeriod();

    /**
     * @return a {@link Builder} of {@link QuotaSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link QuotaSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Number _limit;
        @javax.annotation.Nullable
        private java.lang.Number _offset;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.Period _period;

        /**
         * Sets the value of Limit
         * @param value The maximum number of requests that users can make within the specified time period.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withLimit(@javax.annotation.Nullable final java.lang.Number value) {
            this._limit = value;
            return this;
        }
        /**
         * Sets the value of Offset
         * @param value For the initial time period, the number of requests to subtract from the specified limit.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withOffset(@javax.annotation.Nullable final java.lang.Number value) {
            this._offset = value;
            return this;
        }
        /**
         * Sets the value of Period
         * @param value The time period for which the maximum limit of requests applies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPeriod(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.Period value) {
            this._period = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link QuotaSettings}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public QuotaSettings build() {
            return new QuotaSettings() {
                @javax.annotation.Nullable
                private final java.lang.Number $limit = _limit;
                @javax.annotation.Nullable
                private final java.lang.Number $offset = _offset;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.Period $period = _period;

                @Override
                public java.lang.Number getLimit() {
                    return this.$limit;
                }

                @Override
                public java.lang.Number getOffset() {
                    return this.$offset;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.Period getPeriod() {
                    return this.$period;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getLimit() != null) {
                        obj.set("limit", om.valueToTree(this.getLimit()));
                    }
                    if (this.getOffset() != null) {
                        obj.set("offset", om.valueToTree(this.getOffset()));
                    }
                    if (this.getPeriod() != null) {
                        obj.set("period", om.valueToTree(this.getPeriod()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.QuotaSettings {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The maximum number of requests that users can make within the specified time period.
         * 
         * Default: none
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getLimit() {
            return this.jsiiGet("limit", java.lang.Number.class);
        }

        /**
         * For the initial time period, the number of requests to subtract from the specified limit.
         * 
         * Default: none
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getOffset() {
            return this.jsiiGet("offset", java.lang.Number.class);
        }

        /**
         * The time period for which the maximum limit of requests applies.
         * 
         * Default: none
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.Period getPeriod() {
            return this.jsiiGet("period", software.amazon.awscdk.services.apigateway.Period.class);
        }
    }
}
