/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.apigateway.AuthorizationType;
import software.amazon.awscdk.services.apigateway.IAuthorizer;
import software.amazon.awscdk.services.apigateway.IModel;
import software.amazon.awscdk.services.apigateway.IRequestValidator;
import software.amazon.awscdk.services.apigateway.MethodResponse;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface MethodOptions
extends JsiiSerializable {
    public Boolean getApiKeyRequired();

    public AuthorizationType getAuthorizationType();

    public IAuthorizer getAuthorizer();

    public List<MethodResponse> getMethodResponses();

    public String getOperationName();

    public Map<String, IModel> getRequestModels();

    public Map<String, Boolean> getRequestParameters();

    public IRequestValidator getRequestValidator();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private Boolean _apiKeyRequired;
        @Nullable
        private AuthorizationType _authorizationType;
        @Nullable
        private IAuthorizer _authorizer;
        @Nullable
        private List<MethodResponse> _methodResponses;
        @Nullable
        private String _operationName;
        @Nullable
        private Map<String, IModel> _requestModels;
        @Nullable
        private Map<String, Boolean> _requestParameters;
        @Nullable
        private IRequestValidator _requestValidator;

        public Builder withApiKeyRequired(@Nullable Boolean value) {
            this._apiKeyRequired = value;
            return this;
        }

        public Builder withAuthorizationType(@Nullable AuthorizationType value) {
            this._authorizationType = value;
            return this;
        }

        public Builder withAuthorizer(@Nullable IAuthorizer value) {
            this._authorizer = value;
            return this;
        }

        public Builder withMethodResponses(@Nullable List<MethodResponse> value) {
            this._methodResponses = value;
            return this;
        }

        public Builder withOperationName(@Nullable String value) {
            this._operationName = value;
            return this;
        }

        public Builder withRequestModels(@Nullable Map<String, IModel> value) {
            this._requestModels = value;
            return this;
        }

        public Builder withRequestParameters(@Nullable Map<String, Boolean> value) {
            this._requestParameters = value;
            return this;
        }

        public Builder withRequestValidator(@Nullable IRequestValidator value) {
            this._requestValidator = value;
            return this;
        }

        public MethodOptions build() {
            return new MethodOptions(){
                @Nullable
                private final Boolean $apiKeyRequired;
                @Nullable
                private final AuthorizationType $authorizationType;
                @Nullable
                private final IAuthorizer $authorizer;
                @Nullable
                private final List<MethodResponse> $methodResponses;
                @Nullable
                private final String $operationName;
                @Nullable
                private final Map<String, IModel> $requestModels;
                @Nullable
                private final Map<String, Boolean> $requestParameters;
                @Nullable
                private final IRequestValidator $requestValidator;
                {
                    this.$apiKeyRequired = _apiKeyRequired;
                    this.$authorizationType = _authorizationType;
                    this.$authorizer = _authorizer;
                    this.$methodResponses = _methodResponses;
                    this.$operationName = _operationName;
                    this.$requestModels = _requestModels;
                    this.$requestParameters = _requestParameters;
                    this.$requestValidator = _requestValidator;
                }

                @Override
                public Boolean getApiKeyRequired() {
                    return this.$apiKeyRequired;
                }

                @Override
                public AuthorizationType getAuthorizationType() {
                    return this.$authorizationType;
                }

                @Override
                public IAuthorizer getAuthorizer() {
                    return this.$authorizer;
                }

                @Override
                public List<MethodResponse> getMethodResponses() {
                    return this.$methodResponses;
                }

                @Override
                public String getOperationName() {
                    return this.$operationName;
                }

                @Override
                public Map<String, IModel> getRequestModels() {
                    return this.$requestModels;
                }

                @Override
                public Map<String, Boolean> getRequestParameters() {
                    return this.$requestParameters;
                }

                @Override
                public IRequestValidator getRequestValidator() {
                    return this.$requestValidator;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    if (this.getApiKeyRequired() != null) {
                        obj.set("apiKeyRequired", om.valueToTree((Object)this.getApiKeyRequired()));
                    }
                    if (this.getAuthorizationType() != null) {
                        obj.set("authorizationType", om.valueToTree((Object)this.getAuthorizationType()));
                    }
                    if (this.getAuthorizer() != null) {
                        obj.set("authorizer", om.valueToTree((Object)this.getAuthorizer()));
                    }
                    if (this.getMethodResponses() != null) {
                        obj.set("methodResponses", om.valueToTree(this.getMethodResponses()));
                    }
                    if (this.getOperationName() != null) {
                        obj.set("operationName", om.valueToTree((Object)this.getOperationName()));
                    }
                    if (this.getRequestModels() != null) {
                        obj.set("requestModels", om.valueToTree(this.getRequestModels()));
                    }
                    if (this.getRequestParameters() != null) {
                        obj.set("requestParameters", om.valueToTree(this.getRequestParameters()));
                    }
                    if (this.getRequestValidator() != null) {
                        obj.set("requestValidator", om.valueToTree((Object)this.getRequestValidator()));
                    }
                    return obj;
                }
            };
        }
    }
}

