/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.apigateway.JsonSchema;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface ModelOptions
extends JsiiSerializable {
    public JsonSchema getSchema();

    public String getContentType();

    public String getDescription();

    public String getModelName();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private JsonSchema _schema;
        @Nullable
        private String _contentType;
        @Nullable
        private String _description;
        @Nullable
        private String _modelName;

        public Builder withSchema(JsonSchema value) {
            this._schema = Objects.requireNonNull(value, "schema is required");
            return this;
        }

        public Builder withContentType(@Nullable String value) {
            this._contentType = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withModelName(@Nullable String value) {
            this._modelName = value;
            return this;
        }

        public ModelOptions build() {
            return new ModelOptions(){
                private final JsonSchema $schema;
                @Nullable
                private final String $contentType;
                @Nullable
                private final String $description;
                @Nullable
                private final String $modelName;
                {
                    this.$schema = Objects.requireNonNull(_schema, "schema is required");
                    this.$contentType = _contentType;
                    this.$description = _description;
                    this.$modelName = _modelName;
                }

                @Override
                public JsonSchema getSchema() {
                    return this.$schema;
                }

                @Override
                public String getContentType() {
                    return this.$contentType;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public String getModelName() {
                    return this.$modelName;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("schema", om.valueToTree((Object)this.getSchema()));
                    if (this.getContentType() != null) {
                        obj.set("contentType", om.valueToTree((Object)this.getContentType()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree((Object)this.getDescription()));
                    }
                    if (this.getModelName() != null) {
                        obj.set("modelName", om.valueToTree((Object)this.getModelName()));
                    }
                    return obj;
                }
            };
        }
    }
}

