/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.apigateway.IResource;
import software.amazon.awscdk.services.apigateway.Integration;
import software.amazon.awscdk.services.apigateway.MethodOptions;
import software.amazon.awscdk.services.apigateway.ResourceOptions;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface ResourceProps
extends JsiiSerializable,
ResourceOptions {
    public IResource getParent();

    public String getPathPart();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IResource _parent;
        private String _pathPart;
        @Nullable
        private Integration _defaultIntegration;
        @Nullable
        private MethodOptions _defaultMethodOptions;

        public Builder withParent(IResource value) {
            this._parent = Objects.requireNonNull(value, "parent is required");
            return this;
        }

        public Builder withPathPart(String value) {
            this._pathPart = Objects.requireNonNull(value, "pathPart is required");
            return this;
        }

        public Builder withDefaultIntegration(@Nullable Integration value) {
            this._defaultIntegration = value;
            return this;
        }

        public Builder withDefaultMethodOptions(@Nullable MethodOptions value) {
            this._defaultMethodOptions = value;
            return this;
        }

        public ResourceProps build() {
            return new ResourceProps(){
                private final IResource $parent;
                private final String $pathPart;
                @Nullable
                private final Integration $defaultIntegration;
                @Nullable
                private final MethodOptions $defaultMethodOptions;
                {
                    this.$parent = Objects.requireNonNull(_parent, "parent is required");
                    this.$pathPart = Objects.requireNonNull(_pathPart, "pathPart is required");
                    this.$defaultIntegration = _defaultIntegration;
                    this.$defaultMethodOptions = _defaultMethodOptions;
                }

                @Override
                public IResource getParent() {
                    return this.$parent;
                }

                @Override
                public String getPathPart() {
                    return this.$pathPart;
                }

                @Override
                public Integration getDefaultIntegration() {
                    return this.$defaultIntegration;
                }

                @Override
                public MethodOptions getDefaultMethodOptions() {
                    return this.$defaultMethodOptions;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("parent", om.valueToTree((Object)this.getParent()));
                    obj.set("pathPart", om.valueToTree((Object)this.getPathPart()));
                    if (this.getDefaultIntegration() != null) {
                        obj.set("defaultIntegration", om.valueToTree((Object)this.getDefaultIntegration()));
                    }
                    if (this.getDefaultMethodOptions() != null) {
                        obj.set("defaultMethodOptions", om.valueToTree((Object)this.getDefaultMethodOptions()));
                    }
                    return obj;
                }
            };
        }
    }
}

