/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.apigateway.ApiKeySourceType;
import software.amazon.awscdk.services.apigateway.DomainNameOptions;
import software.amazon.awscdk.services.apigateway.EndpointType;
import software.amazon.awscdk.services.apigateway.IRestApi;
import software.amazon.awscdk.services.apigateway.Integration;
import software.amazon.awscdk.services.apigateway.MethodOptions;
import software.amazon.awscdk.services.apigateway.ResourceOptions;
import software.amazon.awscdk.services.apigateway.StageOptions;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface RestApiProps
extends JsiiSerializable,
ResourceOptions {
    public ApiKeySourceType getApiKeySourceType();

    public List<String> getBinaryMediaTypes();

    public IRestApi getCloneFrom();

    public Boolean getCloudWatchRole();

    public Boolean getDeploy();

    public StageOptions getDeployOptions();

    public String getDescription();

    public DomainNameOptions getDomainName();

    public List<EndpointType> getEndpointTypes();

    public Boolean getFailOnWarnings();

    public Number getMinimumCompressionSize();

    public Map<String, String> getParameters();

    public PolicyDocument getPolicy();

    public String getRestApiName();

    public Boolean getRetainDeployments();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private ApiKeySourceType _apiKeySourceType;
        @Nullable
        private List<String> _binaryMediaTypes;
        @Nullable
        private IRestApi _cloneFrom;
        @Nullable
        private Boolean _cloudWatchRole;
        @Nullable
        private Boolean _deploy;
        @Nullable
        private StageOptions _deployOptions;
        @Nullable
        private String _description;
        @Nullable
        private DomainNameOptions _domainName;
        @Nullable
        private List<EndpointType> _endpointTypes;
        @Nullable
        private Boolean _failOnWarnings;
        @Nullable
        private Number _minimumCompressionSize;
        @Nullable
        private Map<String, String> _parameters;
        @Nullable
        private PolicyDocument _policy;
        @Nullable
        private String _restApiName;
        @Nullable
        private Boolean _retainDeployments;
        @Nullable
        private Integration _defaultIntegration;
        @Nullable
        private MethodOptions _defaultMethodOptions;

        public Builder withApiKeySourceType(@Nullable ApiKeySourceType value) {
            this._apiKeySourceType = value;
            return this;
        }

        public Builder withBinaryMediaTypes(@Nullable List<String> value) {
            this._binaryMediaTypes = value;
            return this;
        }

        public Builder withCloneFrom(@Nullable IRestApi value) {
            this._cloneFrom = value;
            return this;
        }

        public Builder withCloudWatchRole(@Nullable Boolean value) {
            this._cloudWatchRole = value;
            return this;
        }

        public Builder withDeploy(@Nullable Boolean value) {
            this._deploy = value;
            return this;
        }

        public Builder withDeployOptions(@Nullable StageOptions value) {
            this._deployOptions = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withDomainName(@Nullable DomainNameOptions value) {
            this._domainName = value;
            return this;
        }

        public Builder withEndpointTypes(@Nullable List<EndpointType> value) {
            this._endpointTypes = value;
            return this;
        }

        public Builder withFailOnWarnings(@Nullable Boolean value) {
            this._failOnWarnings = value;
            return this;
        }

        public Builder withMinimumCompressionSize(@Nullable Number value) {
            this._minimumCompressionSize = value;
            return this;
        }

        public Builder withParameters(@Nullable Map<String, String> value) {
            this._parameters = value;
            return this;
        }

        public Builder withPolicy(@Nullable PolicyDocument value) {
            this._policy = value;
            return this;
        }

        public Builder withRestApiName(@Nullable String value) {
            this._restApiName = value;
            return this;
        }

        public Builder withRetainDeployments(@Nullable Boolean value) {
            this._retainDeployments = value;
            return this;
        }

        public Builder withDefaultIntegration(@Nullable Integration value) {
            this._defaultIntegration = value;
            return this;
        }

        public Builder withDefaultMethodOptions(@Nullable MethodOptions value) {
            this._defaultMethodOptions = value;
            return this;
        }

        public RestApiProps build() {
            return new RestApiProps(){
                @Nullable
                private final ApiKeySourceType $apiKeySourceType;
                @Nullable
                private final List<String> $binaryMediaTypes;
                @Nullable
                private final IRestApi $cloneFrom;
                @Nullable
                private final Boolean $cloudWatchRole;
                @Nullable
                private final Boolean $deploy;
                @Nullable
                private final StageOptions $deployOptions;
                @Nullable
                private final String $description;
                @Nullable
                private final DomainNameOptions $domainName;
                @Nullable
                private final List<EndpointType> $endpointTypes;
                @Nullable
                private final Boolean $failOnWarnings;
                @Nullable
                private final Number $minimumCompressionSize;
                @Nullable
                private final Map<String, String> $parameters;
                @Nullable
                private final PolicyDocument $policy;
                @Nullable
                private final String $restApiName;
                @Nullable
                private final Boolean $retainDeployments;
                @Nullable
                private final Integration $defaultIntegration;
                @Nullable
                private final MethodOptions $defaultMethodOptions;
                {
                    this.$apiKeySourceType = _apiKeySourceType;
                    this.$binaryMediaTypes = _binaryMediaTypes;
                    this.$cloneFrom = _cloneFrom;
                    this.$cloudWatchRole = _cloudWatchRole;
                    this.$deploy = _deploy;
                    this.$deployOptions = _deployOptions;
                    this.$description = _description;
                    this.$domainName = _domainName;
                    this.$endpointTypes = _endpointTypes;
                    this.$failOnWarnings = _failOnWarnings;
                    this.$minimumCompressionSize = _minimumCompressionSize;
                    this.$parameters = _parameters;
                    this.$policy = _policy;
                    this.$restApiName = _restApiName;
                    this.$retainDeployments = _retainDeployments;
                    this.$defaultIntegration = _defaultIntegration;
                    this.$defaultMethodOptions = _defaultMethodOptions;
                }

                @Override
                public ApiKeySourceType getApiKeySourceType() {
                    return this.$apiKeySourceType;
                }

                @Override
                public List<String> getBinaryMediaTypes() {
                    return this.$binaryMediaTypes;
                }

                @Override
                public IRestApi getCloneFrom() {
                    return this.$cloneFrom;
                }

                @Override
                public Boolean getCloudWatchRole() {
                    return this.$cloudWatchRole;
                }

                @Override
                public Boolean getDeploy() {
                    return this.$deploy;
                }

                @Override
                public StageOptions getDeployOptions() {
                    return this.$deployOptions;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public DomainNameOptions getDomainName() {
                    return this.$domainName;
                }

                @Override
                public List<EndpointType> getEndpointTypes() {
                    return this.$endpointTypes;
                }

                @Override
                public Boolean getFailOnWarnings() {
                    return this.$failOnWarnings;
                }

                @Override
                public Number getMinimumCompressionSize() {
                    return this.$minimumCompressionSize;
                }

                @Override
                public Map<String, String> getParameters() {
                    return this.$parameters;
                }

                @Override
                public PolicyDocument getPolicy() {
                    return this.$policy;
                }

                @Override
                public String getRestApiName() {
                    return this.$restApiName;
                }

                @Override
                public Boolean getRetainDeployments() {
                    return this.$retainDeployments;
                }

                @Override
                public Integration getDefaultIntegration() {
                    return this.$defaultIntegration;
                }

                @Override
                public MethodOptions getDefaultMethodOptions() {
                    return this.$defaultMethodOptions;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    if (this.getApiKeySourceType() != null) {
                        obj.set("apiKeySourceType", om.valueToTree((Object)this.getApiKeySourceType()));
                    }
                    if (this.getBinaryMediaTypes() != null) {
                        obj.set("binaryMediaTypes", om.valueToTree(this.getBinaryMediaTypes()));
                    }
                    if (this.getCloneFrom() != null) {
                        obj.set("cloneFrom", om.valueToTree((Object)this.getCloneFrom()));
                    }
                    if (this.getCloudWatchRole() != null) {
                        obj.set("cloudWatchRole", om.valueToTree((Object)this.getCloudWatchRole()));
                    }
                    if (this.getDeploy() != null) {
                        obj.set("deploy", om.valueToTree((Object)this.getDeploy()));
                    }
                    if (this.getDeployOptions() != null) {
                        obj.set("deployOptions", om.valueToTree((Object)this.getDeployOptions()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree((Object)this.getDescription()));
                    }
                    if (this.getDomainName() != null) {
                        obj.set("domainName", om.valueToTree((Object)this.getDomainName()));
                    }
                    if (this.getEndpointTypes() != null) {
                        obj.set("endpointTypes", om.valueToTree(this.getEndpointTypes()));
                    }
                    if (this.getFailOnWarnings() != null) {
                        obj.set("failOnWarnings", om.valueToTree((Object)this.getFailOnWarnings()));
                    }
                    if (this.getMinimumCompressionSize() != null) {
                        obj.set("minimumCompressionSize", om.valueToTree((Object)this.getMinimumCompressionSize()));
                    }
                    if (this.getParameters() != null) {
                        obj.set("parameters", om.valueToTree(this.getParameters()));
                    }
                    if (this.getPolicy() != null) {
                        obj.set("policy", om.valueToTree((Object)this.getPolicy()));
                    }
                    if (this.getRestApiName() != null) {
                        obj.set("restApiName", om.valueToTree((Object)this.getRestApiName()));
                    }
                    if (this.getRetainDeployments() != null) {
                        obj.set("retainDeployments", om.valueToTree((Object)this.getRetainDeployments()));
                    }
                    if (this.getDefaultIntegration() != null) {
                        obj.set("defaultIntegration", om.valueToTree((Object)this.getDefaultIntegration()));
                    }
                    if (this.getDefaultMethodOptions() != null) {
                        obj.set("defaultMethodOptions", om.valueToTree((Object)this.getDefaultMethodOptions()));
                    }
                    return obj;
                }
            };
        }
    }
}

