package software.amazon.awscdk.services.apigateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-03-18T17:03:27.681Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.StageProps")
@software.amazon.jsii.Jsii.Proxy(StageProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StageProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.StageOptions {

    /**
     * The deployment that this stage points to [disable-awslint:ref-via-interface].
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.Deployment getDeployment();

    /**
     * @return a {@link Builder} of {@link StageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.apigateway.Deployment deployment;
        private java.lang.Boolean cacheClusterEnabled;
        private java.lang.String cacheClusterSize;
        private java.lang.String clientCertificateId;
        private java.lang.String description;
        private java.lang.String documentationVersion;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> methodOptions;
        private java.lang.String stageName;
        private java.lang.Boolean tracingEnabled;
        private java.util.Map<java.lang.String, java.lang.String> variables;
        private java.lang.Boolean cacheDataEncrypted;
        private software.amazon.awscdk.core.Duration cacheTtl;
        private java.lang.Boolean cachingEnabled;
        private java.lang.Boolean dataTraceEnabled;
        private software.amazon.awscdk.services.apigateway.MethodLoggingLevel loggingLevel;
        private java.lang.Boolean metricsEnabled;
        private java.lang.Number throttlingBurstLimit;
        private java.lang.Number throttlingRateLimit;

        /**
         * Sets the value of {@link StageProps#getDeployment}
         * @param deployment The deployment that this stage points to [disable-awslint:ref-via-interface]. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployment(software.amazon.awscdk.services.apigateway.Deployment deployment) {
            this.deployment = deployment;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getCacheClusterEnabled}
         * @param cacheClusterEnabled Indicates whether cache clustering is enabled for the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheClusterEnabled(java.lang.Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getCacheClusterSize}
         * @param cacheClusterSize The stage's cache cluster size.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheClusterSize(java.lang.String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getClientCertificateId}
         * @param clientCertificateId The identifier of the client certificate that API Gateway uses to call your integration endpoints in the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientCertificateId(java.lang.String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getDescription}
         * @param description A description of the purpose of the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getDocumentationVersion}
         * @param documentationVersion The version identifier of the API documentation snapshot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentationVersion(java.lang.String documentationVersion) {
            this.documentationVersion = documentationVersion;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getMethodOptions}
         * @param methodOptions Method deployment options for specific resources/methods.
         *                      These will
         *                      override common options defined in <code>StageOptions#methodOptions</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder methodOptions(java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> methodOptions) {
            this.methodOptions = methodOptions;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getStageName}
         * @param stageName The name of the stage, which API Gateway uses as the first path segment in the invoked Uniform Resource Identifier (URI).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageName(java.lang.String stageName) {
            this.stageName = stageName;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getTracingEnabled}
         * @param tracingEnabled Specifies whether Amazon X-Ray tracing is enabled for this method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracingEnabled(java.lang.Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getVariables}
         * @param variables A map that defines the stage variables.
         *                  Variable names must consist of
         *                  alphanumeric characters, and the values must match the following regular
         *                  expression: [A-Za-z0-9-._~:/?#&amp;=,]+.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variables(java.util.Map<java.lang.String, java.lang.String> variables) {
            this.variables = variables;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getCacheDataEncrypted}
         * @param cacheDataEncrypted Indicates whether the cached responses are encrypted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheDataEncrypted(java.lang.Boolean cacheDataEncrypted) {
            this.cacheDataEncrypted = cacheDataEncrypted;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getCacheTtl}
         * @param cacheTtl Specifies the time to live (TTL), in seconds, for cached responses.
         *                 The
         *                 higher the TTL, the longer the response will be cached.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheTtl(software.amazon.awscdk.core.Duration cacheTtl) {
            this.cacheTtl = cacheTtl;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getCachingEnabled}
         * @param cachingEnabled Specifies whether responses should be cached and returned for requests.
         *                       A
         *                       cache cluster must be enabled on the stage for responses to be cached.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachingEnabled(java.lang.Boolean cachingEnabled) {
            this.cachingEnabled = cachingEnabled;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getDataTraceEnabled}
         * @param dataTraceEnabled Specifies whether data trace logging is enabled for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataTraceEnabled(java.lang.Boolean dataTraceEnabled) {
            this.dataTraceEnabled = dataTraceEnabled;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getLoggingLevel}
         * @param loggingLevel Specifies the logging level for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingLevel(software.amazon.awscdk.services.apigateway.MethodLoggingLevel loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getMetricsEnabled}
         * @param metricsEnabled Specifies whether Amazon CloudWatch metrics are enabled for this method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsEnabled(java.lang.Boolean metricsEnabled) {
            this.metricsEnabled = metricsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getThrottlingBurstLimit}
         * @param throttlingBurstLimit Specifies the throttling burst limit.
         *                             The total rate of all requests in your AWS account is limited to 5,000 requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttlingBurstLimit(java.lang.Number throttlingBurstLimit) {
            this.throttlingBurstLimit = throttlingBurstLimit;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getThrottlingRateLimit}
         * @param throttlingRateLimit Specifies the throttling rate limit.
         *                            The total rate of all requests in your AWS account is limited to 10,000 requests per second (rps).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttlingRateLimit(java.lang.Number throttlingRateLimit) {
            this.throttlingRateLimit = throttlingRateLimit;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public StageProps build() {
            return new Jsii$Proxy(deployment, cacheClusterEnabled, cacheClusterSize, clientCertificateId, description, documentationVersion, methodOptions, stageName, tracingEnabled, variables, cacheDataEncrypted, cacheTtl, cachingEnabled, dataTraceEnabled, loggingLevel, metricsEnabled, throttlingBurstLimit, throttlingRateLimit);
        }
    }

    /**
     * An implementation for {@link StageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StageProps {
        private final software.amazon.awscdk.services.apigateway.Deployment deployment;
        private final java.lang.Boolean cacheClusterEnabled;
        private final java.lang.String cacheClusterSize;
        private final java.lang.String clientCertificateId;
        private final java.lang.String description;
        private final java.lang.String documentationVersion;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> methodOptions;
        private final java.lang.String stageName;
        private final java.lang.Boolean tracingEnabled;
        private final java.util.Map<java.lang.String, java.lang.String> variables;
        private final java.lang.Boolean cacheDataEncrypted;
        private final software.amazon.awscdk.core.Duration cacheTtl;
        private final java.lang.Boolean cachingEnabled;
        private final java.lang.Boolean dataTraceEnabled;
        private final software.amazon.awscdk.services.apigateway.MethodLoggingLevel loggingLevel;
        private final java.lang.Boolean metricsEnabled;
        private final java.lang.Number throttlingBurstLimit;
        private final java.lang.Number throttlingRateLimit;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deployment = this.jsiiGet("deployment", software.amazon.awscdk.services.apigateway.Deployment.class);
            this.cacheClusterEnabled = this.jsiiGet("cacheClusterEnabled", java.lang.Boolean.class);
            this.cacheClusterSize = this.jsiiGet("cacheClusterSize", java.lang.String.class);
            this.clientCertificateId = this.jsiiGet("clientCertificateId", java.lang.String.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.documentationVersion = this.jsiiGet("documentationVersion", java.lang.String.class);
            this.methodOptions = this.jsiiGet("methodOptions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.MethodDeploymentOptions.class)));
            this.stageName = this.jsiiGet("stageName", java.lang.String.class);
            this.tracingEnabled = this.jsiiGet("tracingEnabled", java.lang.Boolean.class);
            this.variables = this.jsiiGet("variables", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cacheDataEncrypted = this.jsiiGet("cacheDataEncrypted", java.lang.Boolean.class);
            this.cacheTtl = this.jsiiGet("cacheTtl", software.amazon.awscdk.core.Duration.class);
            this.cachingEnabled = this.jsiiGet("cachingEnabled", java.lang.Boolean.class);
            this.dataTraceEnabled = this.jsiiGet("dataTraceEnabled", java.lang.Boolean.class);
            this.loggingLevel = this.jsiiGet("loggingLevel", software.amazon.awscdk.services.apigateway.MethodLoggingLevel.class);
            this.metricsEnabled = this.jsiiGet("metricsEnabled", java.lang.Boolean.class);
            this.throttlingBurstLimit = this.jsiiGet("throttlingBurstLimit", java.lang.Number.class);
            this.throttlingRateLimit = this.jsiiGet("throttlingRateLimit", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.apigateway.Deployment deployment, final java.lang.Boolean cacheClusterEnabled, final java.lang.String cacheClusterSize, final java.lang.String clientCertificateId, final java.lang.String description, final java.lang.String documentationVersion, final java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> methodOptions, final java.lang.String stageName, final java.lang.Boolean tracingEnabled, final java.util.Map<java.lang.String, java.lang.String> variables, final java.lang.Boolean cacheDataEncrypted, final software.amazon.awscdk.core.Duration cacheTtl, final java.lang.Boolean cachingEnabled, final java.lang.Boolean dataTraceEnabled, final software.amazon.awscdk.services.apigateway.MethodLoggingLevel loggingLevel, final java.lang.Boolean metricsEnabled, final java.lang.Number throttlingBurstLimit, final java.lang.Number throttlingRateLimit) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deployment = java.util.Objects.requireNonNull(deployment, "deployment is required");
            this.cacheClusterEnabled = cacheClusterEnabled;
            this.cacheClusterSize = cacheClusterSize;
            this.clientCertificateId = clientCertificateId;
            this.description = description;
            this.documentationVersion = documentationVersion;
            this.methodOptions = methodOptions;
            this.stageName = stageName;
            this.tracingEnabled = tracingEnabled;
            this.variables = variables;
            this.cacheDataEncrypted = cacheDataEncrypted;
            this.cacheTtl = cacheTtl;
            this.cachingEnabled = cachingEnabled;
            this.dataTraceEnabled = dataTraceEnabled;
            this.loggingLevel = loggingLevel;
            this.metricsEnabled = metricsEnabled;
            this.throttlingBurstLimit = throttlingBurstLimit;
            this.throttlingRateLimit = throttlingRateLimit;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.Deployment getDeployment() {
            return this.deployment;
        }

        @Override
        public java.lang.Boolean getCacheClusterEnabled() {
            return this.cacheClusterEnabled;
        }

        @Override
        public java.lang.String getCacheClusterSize() {
            return this.cacheClusterSize;
        }

        @Override
        public java.lang.String getClientCertificateId() {
            return this.clientCertificateId;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.String getDocumentationVersion() {
            return this.documentationVersion;
        }

        @Override
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> getMethodOptions() {
            return this.methodOptions;
        }

        @Override
        public java.lang.String getStageName() {
            return this.stageName;
        }

        @Override
        public java.lang.Boolean getTracingEnabled() {
            return this.tracingEnabled;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getVariables() {
            return this.variables;
        }

        @Override
        public java.lang.Boolean getCacheDataEncrypted() {
            return this.cacheDataEncrypted;
        }

        @Override
        public software.amazon.awscdk.core.Duration getCacheTtl() {
            return this.cacheTtl;
        }

        @Override
        public java.lang.Boolean getCachingEnabled() {
            return this.cachingEnabled;
        }

        @Override
        public java.lang.Boolean getDataTraceEnabled() {
            return this.dataTraceEnabled;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.MethodLoggingLevel getLoggingLevel() {
            return this.loggingLevel;
        }

        @Override
        public java.lang.Boolean getMetricsEnabled() {
            return this.metricsEnabled;
        }

        @Override
        public java.lang.Number getThrottlingBurstLimit() {
            return this.throttlingBurstLimit;
        }

        @Override
        public java.lang.Number getThrottlingRateLimit() {
            return this.throttlingRateLimit;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("deployment", om.valueToTree(this.getDeployment()));
            if (this.getCacheClusterEnabled() != null) {
                data.set("cacheClusterEnabled", om.valueToTree(this.getCacheClusterEnabled()));
            }
            if (this.getCacheClusterSize() != null) {
                data.set("cacheClusterSize", om.valueToTree(this.getCacheClusterSize()));
            }
            if (this.getClientCertificateId() != null) {
                data.set("clientCertificateId", om.valueToTree(this.getClientCertificateId()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDocumentationVersion() != null) {
                data.set("documentationVersion", om.valueToTree(this.getDocumentationVersion()));
            }
            if (this.getMethodOptions() != null) {
                data.set("methodOptions", om.valueToTree(this.getMethodOptions()));
            }
            if (this.getStageName() != null) {
                data.set("stageName", om.valueToTree(this.getStageName()));
            }
            if (this.getTracingEnabled() != null) {
                data.set("tracingEnabled", om.valueToTree(this.getTracingEnabled()));
            }
            if (this.getVariables() != null) {
                data.set("variables", om.valueToTree(this.getVariables()));
            }
            if (this.getCacheDataEncrypted() != null) {
                data.set("cacheDataEncrypted", om.valueToTree(this.getCacheDataEncrypted()));
            }
            if (this.getCacheTtl() != null) {
                data.set("cacheTtl", om.valueToTree(this.getCacheTtl()));
            }
            if (this.getCachingEnabled() != null) {
                data.set("cachingEnabled", om.valueToTree(this.getCachingEnabled()));
            }
            if (this.getDataTraceEnabled() != null) {
                data.set("dataTraceEnabled", om.valueToTree(this.getDataTraceEnabled()));
            }
            if (this.getLoggingLevel() != null) {
                data.set("loggingLevel", om.valueToTree(this.getLoggingLevel()));
            }
            if (this.getMetricsEnabled() != null) {
                data.set("metricsEnabled", om.valueToTree(this.getMetricsEnabled()));
            }
            if (this.getThrottlingBurstLimit() != null) {
                data.set("throttlingBurstLimit", om.valueToTree(this.getThrottlingBurstLimit()));
            }
            if (this.getThrottlingRateLimit() != null) {
                data.set("throttlingRateLimit", om.valueToTree(this.getThrottlingRateLimit()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.StageProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StageProps.Jsii$Proxy that = (StageProps.Jsii$Proxy) o;

            if (!deployment.equals(that.deployment)) return false;
            if (this.cacheClusterEnabled != null ? !this.cacheClusterEnabled.equals(that.cacheClusterEnabled) : that.cacheClusterEnabled != null) return false;
            if (this.cacheClusterSize != null ? !this.cacheClusterSize.equals(that.cacheClusterSize) : that.cacheClusterSize != null) return false;
            if (this.clientCertificateId != null ? !this.clientCertificateId.equals(that.clientCertificateId) : that.clientCertificateId != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.documentationVersion != null ? !this.documentationVersion.equals(that.documentationVersion) : that.documentationVersion != null) return false;
            if (this.methodOptions != null ? !this.methodOptions.equals(that.methodOptions) : that.methodOptions != null) return false;
            if (this.stageName != null ? !this.stageName.equals(that.stageName) : that.stageName != null) return false;
            if (this.tracingEnabled != null ? !this.tracingEnabled.equals(that.tracingEnabled) : that.tracingEnabled != null) return false;
            if (this.variables != null ? !this.variables.equals(that.variables) : that.variables != null) return false;
            if (this.cacheDataEncrypted != null ? !this.cacheDataEncrypted.equals(that.cacheDataEncrypted) : that.cacheDataEncrypted != null) return false;
            if (this.cacheTtl != null ? !this.cacheTtl.equals(that.cacheTtl) : that.cacheTtl != null) return false;
            if (this.cachingEnabled != null ? !this.cachingEnabled.equals(that.cachingEnabled) : that.cachingEnabled != null) return false;
            if (this.dataTraceEnabled != null ? !this.dataTraceEnabled.equals(that.dataTraceEnabled) : that.dataTraceEnabled != null) return false;
            if (this.loggingLevel != null ? !this.loggingLevel.equals(that.loggingLevel) : that.loggingLevel != null) return false;
            if (this.metricsEnabled != null ? !this.metricsEnabled.equals(that.metricsEnabled) : that.metricsEnabled != null) return false;
            if (this.throttlingBurstLimit != null ? !this.throttlingBurstLimit.equals(that.throttlingBurstLimit) : that.throttlingBurstLimit != null) return false;
            return this.throttlingRateLimit != null ? this.throttlingRateLimit.equals(that.throttlingRateLimit) : that.throttlingRateLimit == null;
        }

        @Override
        public int hashCode() {
            int result = this.deployment.hashCode();
            result = 31 * result + (this.cacheClusterEnabled != null ? this.cacheClusterEnabled.hashCode() : 0);
            result = 31 * result + (this.cacheClusterSize != null ? this.cacheClusterSize.hashCode() : 0);
            result = 31 * result + (this.clientCertificateId != null ? this.clientCertificateId.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.documentationVersion != null ? this.documentationVersion.hashCode() : 0);
            result = 31 * result + (this.methodOptions != null ? this.methodOptions.hashCode() : 0);
            result = 31 * result + (this.stageName != null ? this.stageName.hashCode() : 0);
            result = 31 * result + (this.tracingEnabled != null ? this.tracingEnabled.hashCode() : 0);
            result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
            result = 31 * result + (this.cacheDataEncrypted != null ? this.cacheDataEncrypted.hashCode() : 0);
            result = 31 * result + (this.cacheTtl != null ? this.cacheTtl.hashCode() : 0);
            result = 31 * result + (this.cachingEnabled != null ? this.cachingEnabled.hashCode() : 0);
            result = 31 * result + (this.dataTraceEnabled != null ? this.dataTraceEnabled.hashCode() : 0);
            result = 31 * result + (this.loggingLevel != null ? this.loggingLevel.hashCode() : 0);
            result = 31 * result + (this.metricsEnabled != null ? this.metricsEnabled.hashCode() : 0);
            result = 31 * result + (this.throttlingBurstLimit != null ? this.throttlingBurstLimit.hashCode() : 0);
            result = 31 * result + (this.throttlingRateLimit != null ? this.throttlingRateLimit.hashCode() : 0);
            return result;
        }
    }
}
