package software.amazon.awscdk.services.apigateway;

/**
 * This resource creates a base path that clients who call your API must use in the invocation URL.
 * <p>
 * In most cases, you will probably want to use
 * <code>DomainName.addBasePathMapping()</code> to define mappings.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.1.0 (build df55f5e)", date = "2020-04-07T12:30:45.565Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.BasePathMapping")
public class BasePathMapping extends software.amazon.awscdk.core.Resource {

    protected BasePathMapping(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BasePathMapping(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BasePathMapping(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.BasePathMappingProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.BasePathMapping}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.BasePathMappingProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.BasePathMappingProps.Builder();
        }

        /**
         * The base path name that callers of the API must provide in the URL after the domain name (e.g. `example.com/base-path`). If you specify this property, it can't be an empty string.
         * <p>
         * Default: - map requests from the domain root (e.g. `example.com`). If this
         * is undefined, no additional mappings will be allowed on this domain name.
         * <p>
         * @return {@code this}
         * @param basePath The base path name that callers of the API must provide in the URL after the domain name (e.g. `example.com/base-path`). If you specify this property, it can't be an empty string. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder basePath(final java.lang.String basePath) {
            this.props.basePath(basePath);
            return this;
        }

        /**
         * The Deployment stage of API [disable-awslint:ref-via-interface].
         * <p>
         * Default: - map to deploymentStage of restApi otherwise stage needs to pass in URL
         * <p>
         * @return {@code this}
         * @param stage The Deployment stage of API [disable-awslint:ref-via-interface]. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stage(final software.amazon.awscdk.services.apigateway.Stage stage) {
            this.props.stage(stage);
            return this;
        }

        /**
         * The DomainName to associate with this base path mapping.
         * <p>
         * @return {@code this}
         * @param domainName The DomainName to associate with this base path mapping. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final software.amazon.awscdk.services.apigateway.IDomainName domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * The RestApi resource to target.
         * <p>
         * @return {@code this}
         * @param restApi The RestApi resource to target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApi(final software.amazon.awscdk.services.apigateway.IRestApi restApi) {
            this.props.restApi(restApi);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.BasePathMapping}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.apigateway.BasePathMapping build() {
            return new software.amazon.awscdk.services.apigateway.BasePathMapping(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
