package software.amazon.awscdk.services.apigateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.3.0 (build 8ae966b)", date = "2020-04-17T19:11:34.520Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.DomainNameOptions")
@software.amazon.jsii.Jsii.Proxy(DomainNameOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DomainNameOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The reference to an AWS-managed certificate for use by the edge-optimized endpoint for the domain name.
     * <p>
     * For "EDGE" domain names, the certificate
     * needs to be in the US East (N. Virginia) region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate();

    /**
     * The custom domain name for your API.
     * <p>
     * Uppercase letters are not supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * The type of endpoint for this DomainName.
     * <p>
     * Default: REGIONAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.EndpointType getEndpointType() {
        return null;
    }

    /**
     * The Transport Layer Security (TLS) version + cipher suite for this domain name.
     * <p>
     * Default: SecurityPolicy.TLS_1_0
     * <p>
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.SecurityPolicy getSecurityPolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DomainNameOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DomainNameOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        private java.lang.String domainName;
        private software.amazon.awscdk.services.apigateway.EndpointType endpointType;
        private software.amazon.awscdk.services.apigateway.SecurityPolicy securityPolicy;

        /**
         * Sets the value of {@link DomainNameOptions#getCertificate}
         * @param certificate The reference to an AWS-managed certificate for use by the edge-optimized endpoint for the domain name. This parameter is required.
         *                    For "EDGE" domain names, the certificate
         *                    needs to be in the US East (N. Virginia) region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificate(software.amazon.awscdk.services.certificatemanager.ICertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Sets the value of {@link DomainNameOptions#getDomainName}
         * @param domainName The custom domain name for your API. This parameter is required.
         *                   Uppercase letters are not supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link DomainNameOptions#getEndpointType}
         * @param endpointType The type of endpoint for this DomainName.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointType(software.amazon.awscdk.services.apigateway.EndpointType endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        /**
         * Sets the value of {@link DomainNameOptions#getSecurityPolicy}
         * @param securityPolicy The Transport Layer Security (TLS) version + cipher suite for this domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityPolicy(software.amazon.awscdk.services.apigateway.SecurityPolicy securityPolicy) {
            this.securityPolicy = securityPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DomainNameOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public DomainNameOptions build() {
            return new Jsii$Proxy(certificate, domainName, endpointType, securityPolicy);
        }
    }

    /**
     * An implementation for {@link DomainNameOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainNameOptions {
        private final software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        private final java.lang.String domainName;
        private final software.amazon.awscdk.services.apigateway.EndpointType endpointType;
        private final software.amazon.awscdk.services.apigateway.SecurityPolicy securityPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.certificate = this.jsiiGet("certificate", software.amazon.awscdk.services.certificatemanager.ICertificate.class);
            this.domainName = this.jsiiGet("domainName", java.lang.String.class);
            this.endpointType = this.jsiiGet("endpointType", software.amazon.awscdk.services.apigateway.EndpointType.class);
            this.securityPolicy = this.jsiiGet("securityPolicy", software.amazon.awscdk.services.apigateway.SecurityPolicy.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.certificatemanager.ICertificate certificate, final java.lang.String domainName, final software.amazon.awscdk.services.apigateway.EndpointType endpointType, final software.amazon.awscdk.services.apigateway.SecurityPolicy securityPolicy) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.certificate = java.util.Objects.requireNonNull(certificate, "certificate is required");
            this.domainName = java.util.Objects.requireNonNull(domainName, "domainName is required");
            this.endpointType = endpointType;
            this.securityPolicy = securityPolicy;
        }

        @Override
        public software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
            return this.certificate;
        }

        @Override
        public java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.EndpointType getEndpointType() {
            return this.endpointType;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.SecurityPolicy getSecurityPolicy() {
            return this.securityPolicy;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("certificate", om.valueToTree(this.getCertificate()));
            data.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getEndpointType() != null) {
                data.set("endpointType", om.valueToTree(this.getEndpointType()));
            }
            if (this.getSecurityPolicy() != null) {
                data.set("securityPolicy", om.valueToTree(this.getSecurityPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.DomainNameOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DomainNameOptions.Jsii$Proxy that = (DomainNameOptions.Jsii$Proxy) o;

            if (!certificate.equals(that.certificate)) return false;
            if (!domainName.equals(that.domainName)) return false;
            if (this.endpointType != null ? !this.endpointType.equals(that.endpointType) : that.endpointType != null) return false;
            return this.securityPolicy != null ? this.securityPolicy.equals(that.securityPolicy) : that.securityPolicy == null;
        }

        @Override
        public int hashCode() {
            int result = this.certificate.hashCode();
            result = 31 * result + (this.domainName.hashCode());
            result = 31 * result + (this.endpointType != null ? this.endpointType.hashCode() : 0);
            result = 31 * result + (this.securityPolicy != null ? this.securityPolicy.hashCode() : 0);
            return result;
        }
    }
}
