package software.amazon.awscdk.services.apigateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-05-08T05:31:28.444Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.AwsIntegrationProps")
@software.amazon.jsii.Jsii.Proxy(AwsIntegrationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AwsIntegrationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the integrated AWS service (e.g. `s3`).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getService();

    /**
     * The AWS action to perform in the integration.
     * <p>
     * Use <code>actionParams</code> to specify key-value params for the action.
     * <p>
     * Mutually exclusive with <code>path</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAction() {
        return null;
    }

    /**
     * Parameters for the action.
     * <p>
     * <code>action</code> must be set, and <code>path</code> must be undefined.
     * The action params will be URL encoded.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getActionParameters() {
        return null;
    }

    /**
     * The integration's HTTP method type.
     * <p>
     * Default: POST
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIntegrationHttpMethod() {
        return null;
    }

    /**
     * Integration options, such as content handling, request/response mapping, etc.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions() {
        return null;
    }

    /**
     * The path to use for path-base APIs.
     * <p>
     * For example, for S3 GET, you can set path to <code>bucket/key</code>.
     * For lambda, you can set path to <code>2015-03-31/functions/${function-arn}/invocations</code>
     * <p>
     * Mutually exclusive with the <code>action</code> options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
        return null;
    }

    /**
     * Use AWS_PROXY integration.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getProxy() {
        return null;
    }

    /**
     * A designated subdomain supported by certain AWS service for fast host-name lookup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubdomain() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AwsIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AwsIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String service;
        private java.lang.String action;
        private java.util.Map<java.lang.String, java.lang.String> actionParameters;
        private java.lang.String integrationHttpMethod;
        private software.amazon.awscdk.services.apigateway.IntegrationOptions options;
        private java.lang.String path;
        private java.lang.Boolean proxy;
        private java.lang.String subdomain;

        /**
         * Sets the value of {@link AwsIntegrationProps#getService}
         * @param service The name of the integrated AWS service (e.g. `s3`). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(java.lang.String service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of {@link AwsIntegrationProps#getAction}
         * @param action The AWS action to perform in the integration.
         *               Use <code>actionParams</code> to specify key-value params for the action.
         *               <p>
         *               Mutually exclusive with <code>path</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(java.lang.String action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link AwsIntegrationProps#getActionParameters}
         * @param actionParameters Parameters for the action.
         *                         <code>action</code> must be set, and <code>path</code> must be undefined.
         *                         The action params will be URL encoded.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionParameters(java.util.Map<java.lang.String, java.lang.String> actionParameters) {
            this.actionParameters = actionParameters;
            return this;
        }

        /**
         * Sets the value of {@link AwsIntegrationProps#getIntegrationHttpMethod}
         * @param integrationHttpMethod The integration's HTTP method type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationHttpMethod(java.lang.String integrationHttpMethod) {
            this.integrationHttpMethod = integrationHttpMethod;
            return this;
        }

        /**
         * Sets the value of {@link AwsIntegrationProps#getOptions}
         * @param options Integration options, such as content handling, request/response mapping, etc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(software.amazon.awscdk.services.apigateway.IntegrationOptions options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link AwsIntegrationProps#getPath}
         * @param path The path to use for path-base APIs.
         *             For example, for S3 GET, you can set path to <code>bucket/key</code>.
         *             For lambda, you can set path to <code>2015-03-31/functions/${function-arn}/invocations</code>
         *             <p>
         *             Mutually exclusive with the <code>action</code> options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link AwsIntegrationProps#getProxy}
         * @param proxy Use AWS_PROXY integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxy(java.lang.Boolean proxy) {
            this.proxy = proxy;
            return this;
        }

        /**
         * Sets the value of {@link AwsIntegrationProps#getSubdomain}
         * @param subdomain A designated subdomain supported by certain AWS service for fast host-name lookup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subdomain(java.lang.String subdomain) {
            this.subdomain = subdomain;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsIntegrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public AwsIntegrationProps build() {
            return new Jsii$Proxy(service, action, actionParameters, integrationHttpMethod, options, path, proxy, subdomain);
        }
    }

    /**
     * An implementation for {@link AwsIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsIntegrationProps {
        private final java.lang.String service;
        private final java.lang.String action;
        private final java.util.Map<java.lang.String, java.lang.String> actionParameters;
        private final java.lang.String integrationHttpMethod;
        private final software.amazon.awscdk.services.apigateway.IntegrationOptions options;
        private final java.lang.String path;
        private final java.lang.Boolean proxy;
        private final java.lang.String subdomain;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.service = this.jsiiGet("service", java.lang.String.class);
            this.action = this.jsiiGet("action", java.lang.String.class);
            this.actionParameters = this.jsiiGet("actionParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.integrationHttpMethod = this.jsiiGet("integrationHttpMethod", java.lang.String.class);
            this.options = this.jsiiGet("options", software.amazon.awscdk.services.apigateway.IntegrationOptions.class);
            this.path = this.jsiiGet("path", java.lang.String.class);
            this.proxy = this.jsiiGet("proxy", java.lang.Boolean.class);
            this.subdomain = this.jsiiGet("subdomain", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String service, final java.lang.String action, final java.util.Map<java.lang.String, java.lang.String> actionParameters, final java.lang.String integrationHttpMethod, final software.amazon.awscdk.services.apigateway.IntegrationOptions options, final java.lang.String path, final java.lang.Boolean proxy, final java.lang.String subdomain) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.service = java.util.Objects.requireNonNull(service, "service is required");
            this.action = action;
            this.actionParameters = actionParameters;
            this.integrationHttpMethod = integrationHttpMethod;
            this.options = options;
            this.path = path;
            this.proxy = proxy;
            this.subdomain = subdomain;
        }

        @Override
        public java.lang.String getService() {
            return this.service;
        }

        @Override
        public java.lang.String getAction() {
            return this.action;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getActionParameters() {
            return this.actionParameters;
        }

        @Override
        public java.lang.String getIntegrationHttpMethod() {
            return this.integrationHttpMethod;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions() {
            return this.options;
        }

        @Override
        public java.lang.String getPath() {
            return this.path;
        }

        @Override
        public java.lang.Boolean getProxy() {
            return this.proxy;
        }

        @Override
        public java.lang.String getSubdomain() {
            return this.subdomain;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("service", om.valueToTree(this.getService()));
            if (this.getAction() != null) {
                data.set("action", om.valueToTree(this.getAction()));
            }
            if (this.getActionParameters() != null) {
                data.set("actionParameters", om.valueToTree(this.getActionParameters()));
            }
            if (this.getIntegrationHttpMethod() != null) {
                data.set("integrationHttpMethod", om.valueToTree(this.getIntegrationHttpMethod()));
            }
            if (this.getOptions() != null) {
                data.set("options", om.valueToTree(this.getOptions()));
            }
            if (this.getPath() != null) {
                data.set("path", om.valueToTree(this.getPath()));
            }
            if (this.getProxy() != null) {
                data.set("proxy", om.valueToTree(this.getProxy()));
            }
            if (this.getSubdomain() != null) {
                data.set("subdomain", om.valueToTree(this.getSubdomain()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.AwsIntegrationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AwsIntegrationProps.Jsii$Proxy that = (AwsIntegrationProps.Jsii$Proxy) o;

            if (!service.equals(that.service)) return false;
            if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
            if (this.actionParameters != null ? !this.actionParameters.equals(that.actionParameters) : that.actionParameters != null) return false;
            if (this.integrationHttpMethod != null ? !this.integrationHttpMethod.equals(that.integrationHttpMethod) : that.integrationHttpMethod != null) return false;
            if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
            if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
            if (this.proxy != null ? !this.proxy.equals(that.proxy) : that.proxy != null) return false;
            return this.subdomain != null ? this.subdomain.equals(that.subdomain) : that.subdomain == null;
        }

        @Override
        public int hashCode() {
            int result = this.service.hashCode();
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            result = 31 * result + (this.actionParameters != null ? this.actionParameters.hashCode() : 0);
            result = 31 * result + (this.integrationHttpMethod != null ? this.integrationHttpMethod.hashCode() : 0);
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.proxy != null ? this.proxy.hashCode() : 0);
            result = 31 * result + (this.subdomain != null ? this.subdomain.hashCode() : 0);
            return result;
        }
    }
}
