package software.amazon.awscdk.services.apigateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-14T08:24:29.223Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AwsIntegrationProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The name of the integrated AWS service (e.g. `s3`).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getService();
    /**
     * The AWS action to perform in the integration.
     * 
     * Use `actionParams` to specify key-value params for the action.
     * 
     * Mutually exclusive with `path`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getAction();
    /**
     * Parameters for the action.
     * 
     * `action` must be set, and `path` must be undefined.
     * The action params will be URL encoded.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.Map<java.lang.String, java.lang.String> getActionParameters();
    /**
     * The integration's HTTP method type.
     * 
     * Default: POST
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getIntegrationHttpMethod();
    /**
     * Integration options, such as content handling, request/response mapping, etc.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions();
    /**
     * The path to use for path-base APIs.
     * 
     * For example, for S3 GET, you can set path to `bucket/key`.
     * For lambda, you can set path to `2015-03-31/functions/${function-arn}/invocations`
     * 
     * Mutually exclusive with the `action` options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getPath();
    /**
     * Use AWS_PROXY integration.
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getProxy();
    /**
     * A designated subdomain supported by certain AWS service for fast host-name lookup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getSubdomain();

    /**
     * @return a {@link Builder} of {@link AwsIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link AwsIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String _service;
        @javax.annotation.Nullable
        private java.lang.String _action;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _actionParameters;
        @javax.annotation.Nullable
        private java.lang.String _integrationHttpMethod;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.IntegrationOptions _options;
        @javax.annotation.Nullable
        private java.lang.String _path;
        @javax.annotation.Nullable
        private java.lang.Boolean _proxy;
        @javax.annotation.Nullable
        private java.lang.String _subdomain;

        /**
         * Sets the value of Service
         * @param value The name of the integrated AWS service (e.g. `s3`).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withService(final java.lang.String value) {
            this._service = java.util.Objects.requireNonNull(value, "service is required");
            return this;
        }
        /**
         * Sets the value of Action
         * @param value The AWS action to perform in the integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withAction(@javax.annotation.Nullable final java.lang.String value) {
            this._action = value;
            return this;
        }
        /**
         * Sets the value of ActionParameters
         * @param value Parameters for the action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withActionParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._actionParameters = value;
            return this;
        }
        /**
         * Sets the value of IntegrationHttpMethod
         * @param value The integration's HTTP method type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withIntegrationHttpMethod(@javax.annotation.Nullable final java.lang.String value) {
            this._integrationHttpMethod = value;
            return this;
        }
        /**
         * Sets the value of Options
         * @param value Integration options, such as content handling, request/response mapping, etc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.IntegrationOptions value) {
            this._options = value;
            return this;
        }
        /**
         * Sets the value of Path
         * @param value The path to use for path-base APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPath(@javax.annotation.Nullable final java.lang.String value) {
            this._path = value;
            return this;
        }
        /**
         * Sets the value of Proxy
         * @param value Use AWS_PROXY integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withProxy(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._proxy = value;
            return this;
        }
        /**
         * Sets the value of Subdomain
         * @param value A designated subdomain supported by certain AWS service for fast host-name lookup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withSubdomain(@javax.annotation.Nullable final java.lang.String value) {
            this._subdomain = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsIntegrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public AwsIntegrationProps build() {
            return new AwsIntegrationProps() {
                private final java.lang.String $service = java.util.Objects.requireNonNull(_service, "service is required");
                @javax.annotation.Nullable
                private final java.lang.String $action = _action;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.String> $actionParameters = _actionParameters;
                @javax.annotation.Nullable
                private final java.lang.String $integrationHttpMethod = _integrationHttpMethod;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.IntegrationOptions $options = _options;
                @javax.annotation.Nullable
                private final java.lang.String $path = _path;
                @javax.annotation.Nullable
                private final java.lang.Boolean $proxy = _proxy;
                @javax.annotation.Nullable
                private final java.lang.String $subdomain = _subdomain;

                @Override
                public java.lang.String getService() {
                    return this.$service;
                }

                @Override
                public java.lang.String getAction() {
                    return this.$action;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getActionParameters() {
                    return this.$actionParameters;
                }

                @Override
                public java.lang.String getIntegrationHttpMethod() {
                    return this.$integrationHttpMethod;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions() {
                    return this.$options;
                }

                @Override
                public java.lang.String getPath() {
                    return this.$path;
                }

                @Override
                public java.lang.Boolean getProxy() {
                    return this.$proxy;
                }

                @Override
                public java.lang.String getSubdomain() {
                    return this.$subdomain;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("service", om.valueToTree(this.getService()));
                    if (this.getAction() != null) {
                        obj.set("action", om.valueToTree(this.getAction()));
                    }
                    if (this.getActionParameters() != null) {
                        obj.set("actionParameters", om.valueToTree(this.getActionParameters()));
                    }
                    if (this.getIntegrationHttpMethod() != null) {
                        obj.set("integrationHttpMethod", om.valueToTree(this.getIntegrationHttpMethod()));
                    }
                    if (this.getOptions() != null) {
                        obj.set("options", om.valueToTree(this.getOptions()));
                    }
                    if (this.getPath() != null) {
                        obj.set("path", om.valueToTree(this.getPath()));
                    }
                    if (this.getProxy() != null) {
                        obj.set("proxy", om.valueToTree(this.getProxy()));
                    }
                    if (this.getSubdomain() != null) {
                        obj.set("subdomain", om.valueToTree(this.getSubdomain()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.AwsIntegrationProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The name of the integrated AWS service (e.g. `s3`).
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getService() {
            return this.jsiiGet("service", java.lang.String.class);
        }

        /**
         * The AWS action to perform in the integration.
         * 
         * Use `actionParams` to specify key-value params for the action.
         * 
         * Mutually exclusive with `path`.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getAction() {
            return this.jsiiGet("action", java.lang.String.class);
        }

        /**
         * Parameters for the action.
         * 
         * `action` must be set, and `path` must be undefined.
         * The action params will be URL encoded.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getActionParameters() {
            return this.jsiiGet("actionParameters", java.util.Map.class);
        }

        /**
         * The integration's HTTP method type.
         * 
         * Default: POST
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getIntegrationHttpMethod() {
            return this.jsiiGet("integrationHttpMethod", java.lang.String.class);
        }

        /**
         * Integration options, such as content handling, request/response mapping, etc.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions() {
            return this.jsiiGet("options", software.amazon.awscdk.services.apigateway.IntegrationOptions.class);
        }

        /**
         * The path to use for path-base APIs.
         * 
         * For example, for S3 GET, you can set path to `bucket/key`.
         * For lambda, you can set path to `2015-03-31/functions/${function-arn}/invocations`
         * 
         * Mutually exclusive with the `action` options.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getPath() {
            return this.jsiiGet("path", java.lang.String.class);
        }

        /**
         * Use AWS_PROXY integration.
         * 
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getProxy() {
            return this.jsiiGet("proxy", java.lang.Boolean.class);
        }

        /**
         * A designated subdomain supported by certain AWS service for fast host-name lookup.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getSubdomain() {
            return this.jsiiGet("subdomain", java.lang.String.class);
        }
    }
}
