package software.amazon.awscdk.services.apigateway;

/**
 * A CloudFormation `AWS::ApiGateway::Method`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-14T08:24:29.256Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnMethod")
public class CfnMethod extends software.amazon.awscdk.core.CfnResource {
    protected CfnMethod(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnMethod.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }
    /**
     * Create a new `AWS::ApiGateway::Method`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnMethod(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.apigateway.CfnMethodProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return this.jsiiGet("cfnProperties", java.util.Map.class);
    }

    /**
     * `AWS::ApiGateway::Method.HttpMethod`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getHttpMethod() {
        return this.jsiiGet("httpMethod", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Method.HttpMethod`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setHttpMethod(final java.lang.String value) {
        this.jsiiSet("httpMethod", java.util.Objects.requireNonNull(value, "httpMethod is required"));
    }

    /**
     * `AWS::ApiGateway::Method.ResourceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getResourceId() {
        return this.jsiiGet("resourceId", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Method.ResourceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setResourceId(final java.lang.String value) {
        this.jsiiSet("resourceId", java.util.Objects.requireNonNull(value, "resourceId is required"));
    }

    /**
     * `AWS::ApiGateway::Method.RestApiId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getRestApiId() {
        return this.jsiiGet("restApiId", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Method.RestApiId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRestApiId(final java.lang.String value) {
        this.jsiiSet("restApiId", java.util.Objects.requireNonNull(value, "restApiId is required"));
    }

    /**
     * `AWS::ApiGateway::Method.ApiKeyRequired`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getApiKeyRequired() {
        return this.jsiiGet("apiKeyRequired", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Method.ApiKeyRequired`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setApiKeyRequired(@javax.annotation.Nullable final java.lang.Boolean value) {
        this.jsiiSet("apiKeyRequired", value);
    }

    /**
     * `AWS::ApiGateway::Method.ApiKeyRequired`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setApiKeyRequired(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("apiKeyRequired", value);
    }

    /**
     * `AWS::ApiGateway::Method.AuthorizationScopes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.util.List<java.lang.String> getAuthorizationScopes() {
        return this.jsiiGet("authorizationScopes", java.util.List.class);
    }

    /**
     * `AWS::ApiGateway::Method.AuthorizationScopes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAuthorizationScopes(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
        this.jsiiSet("authorizationScopes", value);
    }

    /**
     * `AWS::ApiGateway::Method.AuthorizationType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getAuthorizationType() {
        return this.jsiiGet("authorizationType", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Method.AuthorizationType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAuthorizationType(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("authorizationType", value);
    }

    /**
     * `AWS::ApiGateway::Method.AuthorizerId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getAuthorizerId() {
        return this.jsiiGet("authorizerId", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Method.AuthorizerId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAuthorizerId(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("authorizerId", value);
    }

    /**
     * `AWS::ApiGateway::Method.Integration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getIntegration() {
        return this.jsiiGet("integration", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Method.Integration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setIntegration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("integration", value);
    }

    /**
     * `AWS::ApiGateway::Method.Integration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setIntegration(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.CfnMethod.IntegrationProperty value) {
        this.jsiiSet("integration", value);
    }

    /**
     * `AWS::ApiGateway::Method.MethodResponses`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getMethodResponses() {
        return this.jsiiGet("methodResponses", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Method.MethodResponses`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMethodResponses(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("methodResponses", value);
    }

    /**
     * `AWS::ApiGateway::Method.MethodResponses`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMethodResponses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
        this.jsiiSet("methodResponses", value);
    }

    /**
     * `AWS::ApiGateway::Method.OperationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getOperationName() {
        return this.jsiiGet("operationName", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Method.OperationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setOperationName(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("operationName", value);
    }

    /**
     * `AWS::ApiGateway::Method.RequestModels`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getRequestModels() {
        return this.jsiiGet("requestModels", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Method.RequestModels`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRequestModels(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("requestModels", value);
    }

    /**
     * `AWS::ApiGateway::Method.RequestModels`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRequestModels(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
        this.jsiiSet("requestModels", value);
    }

    /**
     * `AWS::ApiGateway::Method.RequestParameters`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getRequestParameters() {
        return this.jsiiGet("requestParameters", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Method.RequestParameters`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRequestParameters(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("requestParameters", value);
    }

    /**
     * `AWS::ApiGateway::Method.RequestParameters`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRequestParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
        this.jsiiSet("requestParameters", value);
    }

    /**
     * `AWS::ApiGateway::Method.RequestValidatorId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getRequestValidatorId() {
        return this.jsiiGet("requestValidatorId", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Method.RequestValidatorId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRequestValidatorId(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("requestValidatorId", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface IntegrationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnMethod.IntegrationProperty.CacheKeyParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachekeyparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getCacheKeyParameters();
        /**
         * `CfnMethod.IntegrationProperty.CacheNamespace`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachenamespace
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCacheNamespace();
        /**
         * `CfnMethod.IntegrationProperty.ConnectionId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-connectionid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getConnectionId();
        /**
         * `CfnMethod.IntegrationProperty.ConnectionType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-connectiontype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getConnectionType();
        /**
         * `CfnMethod.IntegrationProperty.ContentHandling`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-contenthandling
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getContentHandling();
        /**
         * `CfnMethod.IntegrationProperty.Credentials`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-credentials
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCredentials();
        /**
         * `CfnMethod.IntegrationProperty.IntegrationHttpMethod`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationhttpmethod
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getIntegrationHttpMethod();
        /**
         * `CfnMethod.IntegrationProperty.IntegrationResponses`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationresponses
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getIntegrationResponses();
        /**
         * `CfnMethod.IntegrationProperty.PassthroughBehavior`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-passthroughbehavior
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPassthroughBehavior();
        /**
         * `CfnMethod.IntegrationProperty.RequestParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requestparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRequestParameters();
        /**
         * `CfnMethod.IntegrationProperty.RequestTemplates`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requesttemplates
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRequestTemplates();
        /**
         * `CfnMethod.IntegrationProperty.TimeoutInMillis`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-timeoutinmillis
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getTimeoutInMillis();
        /**
         * `CfnMethod.IntegrationProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getType();
        /**
         * `CfnMethod.IntegrationProperty.Uri`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-uri
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getUri();

        /**
         * @return a {@link Builder} of {@link IntegrationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link IntegrationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _cacheKeyParameters;
            @javax.annotation.Nullable
            private java.lang.String _cacheNamespace;
            @javax.annotation.Nullable
            private java.lang.String _connectionId;
            @javax.annotation.Nullable
            private java.lang.String _connectionType;
            @javax.annotation.Nullable
            private java.lang.String _contentHandling;
            @javax.annotation.Nullable
            private java.lang.String _credentials;
            @javax.annotation.Nullable
            private java.lang.String _integrationHttpMethod;
            @javax.annotation.Nullable
            private java.lang.Object _integrationResponses;
            @javax.annotation.Nullable
            private java.lang.String _passthroughBehavior;
            @javax.annotation.Nullable
            private java.lang.Object _requestParameters;
            @javax.annotation.Nullable
            private java.lang.Object _requestTemplates;
            @javax.annotation.Nullable
            private java.lang.Number _timeoutInMillis;
            @javax.annotation.Nullable
            private java.lang.String _type;
            @javax.annotation.Nullable
            private java.lang.String _uri;

            /**
             * Sets the value of CacheKeyParameters
             * @param value `CfnMethod.IntegrationProperty.CacheKeyParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCacheKeyParameters(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._cacheKeyParameters = value;
                return this;
            }
            /**
             * Sets the value of CacheNamespace
             * @param value `CfnMethod.IntegrationProperty.CacheNamespace`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCacheNamespace(@javax.annotation.Nullable final java.lang.String value) {
                this._cacheNamespace = value;
                return this;
            }
            /**
             * Sets the value of ConnectionId
             * @param value `CfnMethod.IntegrationProperty.ConnectionId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withConnectionId(@javax.annotation.Nullable final java.lang.String value) {
                this._connectionId = value;
                return this;
            }
            /**
             * Sets the value of ConnectionType
             * @param value `CfnMethod.IntegrationProperty.ConnectionType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withConnectionType(@javax.annotation.Nullable final java.lang.String value) {
                this._connectionType = value;
                return this;
            }
            /**
             * Sets the value of ContentHandling
             * @param value `CfnMethod.IntegrationProperty.ContentHandling`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withContentHandling(@javax.annotation.Nullable final java.lang.String value) {
                this._contentHandling = value;
                return this;
            }
            /**
             * Sets the value of Credentials
             * @param value `CfnMethod.IntegrationProperty.Credentials`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCredentials(@javax.annotation.Nullable final java.lang.String value) {
                this._credentials = value;
                return this;
            }
            /**
             * Sets the value of IntegrationHttpMethod
             * @param value `CfnMethod.IntegrationProperty.IntegrationHttpMethod`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withIntegrationHttpMethod(@javax.annotation.Nullable final java.lang.String value) {
                this._integrationHttpMethod = value;
                return this;
            }
            /**
             * Sets the value of IntegrationResponses
             * @param value `CfnMethod.IntegrationProperty.IntegrationResponses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withIntegrationResponses(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._integrationResponses = value;
                return this;
            }
            /**
             * Sets the value of IntegrationResponses
             * @param value `CfnMethod.IntegrationProperty.IntegrationResponses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withIntegrationResponses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._integrationResponses = value;
                return this;
            }
            /**
             * Sets the value of PassthroughBehavior
             * @param value `CfnMethod.IntegrationProperty.PassthroughBehavior`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withPassthroughBehavior(@javax.annotation.Nullable final java.lang.String value) {
                this._passthroughBehavior = value;
                return this;
            }
            /**
             * Sets the value of RequestParameters
             * @param value `CfnMethod.IntegrationProperty.RequestParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withRequestParameters(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._requestParameters = value;
                return this;
            }
            /**
             * Sets the value of RequestParameters
             * @param value `CfnMethod.IntegrationProperty.RequestParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withRequestParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                this._requestParameters = value;
                return this;
            }
            /**
             * Sets the value of RequestTemplates
             * @param value `CfnMethod.IntegrationProperty.RequestTemplates`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withRequestTemplates(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._requestTemplates = value;
                return this;
            }
            /**
             * Sets the value of RequestTemplates
             * @param value `CfnMethod.IntegrationProperty.RequestTemplates`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withRequestTemplates(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                this._requestTemplates = value;
                return this;
            }
            /**
             * Sets the value of TimeoutInMillis
             * @param value `CfnMethod.IntegrationProperty.TimeoutInMillis`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withTimeoutInMillis(@javax.annotation.Nullable final java.lang.Number value) {
                this._timeoutInMillis = value;
                return this;
            }
            /**
             * Sets the value of Type
             * @param value `CfnMethod.IntegrationProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withType(@javax.annotation.Nullable final java.lang.String value) {
                this._type = value;
                return this;
            }
            /**
             * Sets the value of Uri
             * @param value `CfnMethod.IntegrationProperty.Uri`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withUri(@javax.annotation.Nullable final java.lang.String value) {
                this._uri = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntegrationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public IntegrationProperty build() {
                return new IntegrationProperty() {
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $cacheKeyParameters = _cacheKeyParameters;
                    @javax.annotation.Nullable
                    private final java.lang.String $cacheNamespace = _cacheNamespace;
                    @javax.annotation.Nullable
                    private final java.lang.String $connectionId = _connectionId;
                    @javax.annotation.Nullable
                    private final java.lang.String $connectionType = _connectionType;
                    @javax.annotation.Nullable
                    private final java.lang.String $contentHandling = _contentHandling;
                    @javax.annotation.Nullable
                    private final java.lang.String $credentials = _credentials;
                    @javax.annotation.Nullable
                    private final java.lang.String $integrationHttpMethod = _integrationHttpMethod;
                    @javax.annotation.Nullable
                    private final java.lang.Object $integrationResponses = _integrationResponses;
                    @javax.annotation.Nullable
                    private final java.lang.String $passthroughBehavior = _passthroughBehavior;
                    @javax.annotation.Nullable
                    private final java.lang.Object $requestParameters = _requestParameters;
                    @javax.annotation.Nullable
                    private final java.lang.Object $requestTemplates = _requestTemplates;
                    @javax.annotation.Nullable
                    private final java.lang.Number $timeoutInMillis = _timeoutInMillis;
                    @javax.annotation.Nullable
                    private final java.lang.String $type = _type;
                    @javax.annotation.Nullable
                    private final java.lang.String $uri = _uri;

                    @Override
                    public java.util.List<java.lang.String> getCacheKeyParameters() {
                        return this.$cacheKeyParameters;
                    }

                    @Override
                    public java.lang.String getCacheNamespace() {
                        return this.$cacheNamespace;
                    }

                    @Override
                    public java.lang.String getConnectionId() {
                        return this.$connectionId;
                    }

                    @Override
                    public java.lang.String getConnectionType() {
                        return this.$connectionType;
                    }

                    @Override
                    public java.lang.String getContentHandling() {
                        return this.$contentHandling;
                    }

                    @Override
                    public java.lang.String getCredentials() {
                        return this.$credentials;
                    }

                    @Override
                    public java.lang.String getIntegrationHttpMethod() {
                        return this.$integrationHttpMethod;
                    }

                    @Override
                    public java.lang.Object getIntegrationResponses() {
                        return this.$integrationResponses;
                    }

                    @Override
                    public java.lang.String getPassthroughBehavior() {
                        return this.$passthroughBehavior;
                    }

                    @Override
                    public java.lang.Object getRequestParameters() {
                        return this.$requestParameters;
                    }

                    @Override
                    public java.lang.Object getRequestTemplates() {
                        return this.$requestTemplates;
                    }

                    @Override
                    public java.lang.Number getTimeoutInMillis() {
                        return this.$timeoutInMillis;
                    }

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    @Override
                    public java.lang.String getUri() {
                        return this.$uri;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getCacheKeyParameters() != null) {
                            obj.set("cacheKeyParameters", om.valueToTree(this.getCacheKeyParameters()));
                        }
                        if (this.getCacheNamespace() != null) {
                            obj.set("cacheNamespace", om.valueToTree(this.getCacheNamespace()));
                        }
                        if (this.getConnectionId() != null) {
                            obj.set("connectionId", om.valueToTree(this.getConnectionId()));
                        }
                        if (this.getConnectionType() != null) {
                            obj.set("connectionType", om.valueToTree(this.getConnectionType()));
                        }
                        if (this.getContentHandling() != null) {
                            obj.set("contentHandling", om.valueToTree(this.getContentHandling()));
                        }
                        if (this.getCredentials() != null) {
                            obj.set("credentials", om.valueToTree(this.getCredentials()));
                        }
                        if (this.getIntegrationHttpMethod() != null) {
                            obj.set("integrationHttpMethod", om.valueToTree(this.getIntegrationHttpMethod()));
                        }
                        if (this.getIntegrationResponses() != null) {
                            obj.set("integrationResponses", om.valueToTree(this.getIntegrationResponses()));
                        }
                        if (this.getPassthroughBehavior() != null) {
                            obj.set("passthroughBehavior", om.valueToTree(this.getPassthroughBehavior()));
                        }
                        if (this.getRequestParameters() != null) {
                            obj.set("requestParameters", om.valueToTree(this.getRequestParameters()));
                        }
                        if (this.getRequestTemplates() != null) {
                            obj.set("requestTemplates", om.valueToTree(this.getRequestTemplates()));
                        }
                        if (this.getTimeoutInMillis() != null) {
                            obj.set("timeoutInMillis", om.valueToTree(this.getTimeoutInMillis()));
                        }
                        if (this.getType() != null) {
                            obj.set("type", om.valueToTree(this.getType()));
                        }
                        if (this.getUri() != null) {
                            obj.set("uri", om.valueToTree(this.getUri()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.CfnMethod.IntegrationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnMethod.IntegrationProperty.CacheKeyParameters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachekeyparameters
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getCacheKeyParameters() {
                return this.jsiiGet("cacheKeyParameters", java.util.List.class);
            }

            /**
             * `CfnMethod.IntegrationProperty.CacheNamespace`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachenamespace
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getCacheNamespace() {
                return this.jsiiGet("cacheNamespace", java.lang.String.class);
            }

            /**
             * `CfnMethod.IntegrationProperty.ConnectionId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-connectionid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getConnectionId() {
                return this.jsiiGet("connectionId", java.lang.String.class);
            }

            /**
             * `CfnMethod.IntegrationProperty.ConnectionType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-connectiontype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getConnectionType() {
                return this.jsiiGet("connectionType", java.lang.String.class);
            }

            /**
             * `CfnMethod.IntegrationProperty.ContentHandling`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-contenthandling
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getContentHandling() {
                return this.jsiiGet("contentHandling", java.lang.String.class);
            }

            /**
             * `CfnMethod.IntegrationProperty.Credentials`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-credentials
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getCredentials() {
                return this.jsiiGet("credentials", java.lang.String.class);
            }

            /**
             * `CfnMethod.IntegrationProperty.IntegrationHttpMethod`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationhttpmethod
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getIntegrationHttpMethod() {
                return this.jsiiGet("integrationHttpMethod", java.lang.String.class);
            }

            /**
             * `CfnMethod.IntegrationProperty.IntegrationResponses`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationresponses
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getIntegrationResponses() {
                return this.jsiiGet("integrationResponses", java.lang.Object.class);
            }

            /**
             * `CfnMethod.IntegrationProperty.PassthroughBehavior`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-passthroughbehavior
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getPassthroughBehavior() {
                return this.jsiiGet("passthroughBehavior", java.lang.String.class);
            }

            /**
             * `CfnMethod.IntegrationProperty.RequestParameters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requestparameters
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getRequestParameters() {
                return this.jsiiGet("requestParameters", java.lang.Object.class);
            }

            /**
             * `CfnMethod.IntegrationProperty.RequestTemplates`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requesttemplates
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getRequestTemplates() {
                return this.jsiiGet("requestTemplates", java.lang.Object.class);
            }

            /**
             * `CfnMethod.IntegrationProperty.TimeoutInMillis`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-timeoutinmillis
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Number getTimeoutInMillis() {
                return this.jsiiGet("timeoutInMillis", java.lang.Number.class);
            }

            /**
             * `CfnMethod.IntegrationProperty.Type`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-type
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }

            /**
             * `CfnMethod.IntegrationProperty.Uri`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-uri
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getUri() {
                return this.jsiiGet("uri", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface IntegrationResponseProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnMethod.IntegrationResponseProperty.StatusCode`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStatusCode();
        /**
         * `CfnMethod.IntegrationResponseProperty.ContentHandling`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getContentHandling();
        /**
         * `CfnMethod.IntegrationResponseProperty.ResponseParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getResponseParameters();
        /**
         * `CfnMethod.IntegrationResponseProperty.ResponseTemplates`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getResponseTemplates();
        /**
         * `CfnMethod.IntegrationResponseProperty.SelectionPattern`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSelectionPattern();

        /**
         * @return a {@link Builder} of {@link IntegrationResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link IntegrationResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _statusCode;
            @javax.annotation.Nullable
            private java.lang.String _contentHandling;
            @javax.annotation.Nullable
            private java.lang.Object _responseParameters;
            @javax.annotation.Nullable
            private java.lang.Object _responseTemplates;
            @javax.annotation.Nullable
            private java.lang.String _selectionPattern;

            /**
             * Sets the value of StatusCode
             * @param value `CfnMethod.IntegrationResponseProperty.StatusCode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withStatusCode(final java.lang.String value) {
                this._statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                return this;
            }
            /**
             * Sets the value of ContentHandling
             * @param value `CfnMethod.IntegrationResponseProperty.ContentHandling`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withContentHandling(@javax.annotation.Nullable final java.lang.String value) {
                this._contentHandling = value;
                return this;
            }
            /**
             * Sets the value of ResponseParameters
             * @param value `CfnMethod.IntegrationResponseProperty.ResponseParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withResponseParameters(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._responseParameters = value;
                return this;
            }
            /**
             * Sets the value of ResponseParameters
             * @param value `CfnMethod.IntegrationResponseProperty.ResponseParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withResponseParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                this._responseParameters = value;
                return this;
            }
            /**
             * Sets the value of ResponseTemplates
             * @param value `CfnMethod.IntegrationResponseProperty.ResponseTemplates`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withResponseTemplates(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._responseTemplates = value;
                return this;
            }
            /**
             * Sets the value of ResponseTemplates
             * @param value `CfnMethod.IntegrationResponseProperty.ResponseTemplates`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withResponseTemplates(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                this._responseTemplates = value;
                return this;
            }
            /**
             * Sets the value of SelectionPattern
             * @param value `CfnMethod.IntegrationResponseProperty.SelectionPattern`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSelectionPattern(@javax.annotation.Nullable final java.lang.String value) {
                this._selectionPattern = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntegrationResponseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public IntegrationResponseProperty build() {
                return new IntegrationResponseProperty() {
                    private final java.lang.String $statusCode = java.util.Objects.requireNonNull(_statusCode, "statusCode is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $contentHandling = _contentHandling;
                    @javax.annotation.Nullable
                    private final java.lang.Object $responseParameters = _responseParameters;
                    @javax.annotation.Nullable
                    private final java.lang.Object $responseTemplates = _responseTemplates;
                    @javax.annotation.Nullable
                    private final java.lang.String $selectionPattern = _selectionPattern;

                    @Override
                    public java.lang.String getStatusCode() {
                        return this.$statusCode;
                    }

                    @Override
                    public java.lang.String getContentHandling() {
                        return this.$contentHandling;
                    }

                    @Override
                    public java.lang.Object getResponseParameters() {
                        return this.$responseParameters;
                    }

                    @Override
                    public java.lang.Object getResponseTemplates() {
                        return this.$responseTemplates;
                    }

                    @Override
                    public java.lang.String getSelectionPattern() {
                        return this.$selectionPattern;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("statusCode", om.valueToTree(this.getStatusCode()));
                        if (this.getContentHandling() != null) {
                            obj.set("contentHandling", om.valueToTree(this.getContentHandling()));
                        }
                        if (this.getResponseParameters() != null) {
                            obj.set("responseParameters", om.valueToTree(this.getResponseParameters()));
                        }
                        if (this.getResponseTemplates() != null) {
                            obj.set("responseTemplates", om.valueToTree(this.getResponseTemplates()));
                        }
                        if (this.getSelectionPattern() != null) {
                            obj.set("selectionPattern", om.valueToTree(this.getSelectionPattern()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.CfnMethod.IntegrationResponseProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnMethod.IntegrationResponseProperty.StatusCode`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getStatusCode() {
                return this.jsiiGet("statusCode", java.lang.String.class);
            }

            /**
             * `CfnMethod.IntegrationResponseProperty.ContentHandling`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getContentHandling() {
                return this.jsiiGet("contentHandling", java.lang.String.class);
            }

            /**
             * `CfnMethod.IntegrationResponseProperty.ResponseParameters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getResponseParameters() {
                return this.jsiiGet("responseParameters", java.lang.Object.class);
            }

            /**
             * `CfnMethod.IntegrationResponseProperty.ResponseTemplates`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getResponseTemplates() {
                return this.jsiiGet("responseTemplates", java.lang.Object.class);
            }

            /**
             * `CfnMethod.IntegrationResponseProperty.SelectionPattern`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getSelectionPattern() {
                return this.jsiiGet("selectionPattern", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface MethodResponseProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnMethod.MethodResponseProperty.StatusCode`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStatusCode();
        /**
         * `CfnMethod.MethodResponseProperty.ResponseModels`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getResponseModels();
        /**
         * `CfnMethod.MethodResponseProperty.ResponseParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getResponseParameters();

        /**
         * @return a {@link Builder} of {@link MethodResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MethodResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _statusCode;
            @javax.annotation.Nullable
            private java.lang.Object _responseModels;
            @javax.annotation.Nullable
            private java.lang.Object _responseParameters;

            /**
             * Sets the value of StatusCode
             * @param value `CfnMethod.MethodResponseProperty.StatusCode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withStatusCode(final java.lang.String value) {
                this._statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                return this;
            }
            /**
             * Sets the value of ResponseModels
             * @param value `CfnMethod.MethodResponseProperty.ResponseModels`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withResponseModels(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._responseModels = value;
                return this;
            }
            /**
             * Sets the value of ResponseModels
             * @param value `CfnMethod.MethodResponseProperty.ResponseModels`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withResponseModels(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                this._responseModels = value;
                return this;
            }
            /**
             * Sets the value of ResponseParameters
             * @param value `CfnMethod.MethodResponseProperty.ResponseParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withResponseParameters(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._responseParameters = value;
                return this;
            }
            /**
             * Sets the value of ResponseParameters
             * @param value `CfnMethod.MethodResponseProperty.ResponseParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withResponseParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this._responseParameters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MethodResponseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public MethodResponseProperty build() {
                return new MethodResponseProperty() {
                    private final java.lang.String $statusCode = java.util.Objects.requireNonNull(_statusCode, "statusCode is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $responseModels = _responseModels;
                    @javax.annotation.Nullable
                    private final java.lang.Object $responseParameters = _responseParameters;

                    @Override
                    public java.lang.String getStatusCode() {
                        return this.$statusCode;
                    }

                    @Override
                    public java.lang.Object getResponseModels() {
                        return this.$responseModels;
                    }

                    @Override
                    public java.lang.Object getResponseParameters() {
                        return this.$responseParameters;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("statusCode", om.valueToTree(this.getStatusCode()));
                        if (this.getResponseModels() != null) {
                            obj.set("responseModels", om.valueToTree(this.getResponseModels()));
                        }
                        if (this.getResponseParameters() != null) {
                            obj.set("responseParameters", om.valueToTree(this.getResponseParameters()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.CfnMethod.MethodResponseProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnMethod.MethodResponseProperty.StatusCode`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getStatusCode() {
                return this.jsiiGet("statusCode", java.lang.String.class);
            }

            /**
             * `CfnMethod.MethodResponseProperty.ResponseModels`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getResponseModels() {
                return this.jsiiGet("responseModels", java.lang.Object.class);
            }

            /**
             * `CfnMethod.MethodResponseProperty.ResponseParameters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getResponseParameters() {
                return this.jsiiGet("responseParameters", java.lang.Object.class);
            }
        }
    }
}
