package software.amazon.awscdk.services.apigateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-14T08:24:29.295Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IntegrationOptions extends software.amazon.jsii.JsiiSerializable {
    /**
     * A list of request parameters whose values are to be cached.
     * 
     * It determines
     * request parameters that will make it into the cache key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getCacheKeyParameters();
    /**
     * An API-specific tag group of related cached parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getCacheNamespace();
    /**
     * The type of network connection to the integration endpoint.
     * 
     * Default: ConnectionType.Internet
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.ConnectionType getConnectionType();
    /**
     * Specifies how to handle request payload content type conversions.
     * 
     * Default: none if this property isn't defined, the request payload is passed
     * through from the method request to the integration request without
     * modification, provided that the `passthroughBehaviors` property is
     * configured to support payload pass-through.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.ContentHandling getContentHandling();
    /**
     * Requires that the caller's identity be passed through from the request.
     * 
     * Default: Caller identity is not passed through
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getCredentialsPassthrough();
    /**
     * An IAM role that API Gateway assumes.
     * 
     * Mutually exclusive with `credentialsPassThrough`.
     * 
     * Default: A role is not assumed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.iam.IRole getCredentialsRole();
    /**
     * The response that API Gateway provides after a method's backend completes processing a request.
     * 
     * API Gateway intercepts the response from the
     * backend so that you can control how API Gateway surfaces backend
     * responses. For example, you can map the backend status codes to codes
     * that you define.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> getIntegrationResponses();
    /**
     * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.PassthroughBehavior getPassthroughBehavior();
    /**
     * The request parameters that API Gateway sends with the backend request. Specify request parameters as key-value pairs (string-to-string mappings), with a destination as the key and a source as the value.
     * 
     * Specify the destination by using the following pattern
     * integration.request.location.name, where location is querystring, path,
     * or header, and name is a valid, unique parameter name.
     * 
     * The source must be an existing method request parameter or a static
     * value. You must enclose static values in single quotation marks and
     * pre-encode these values based on their destination in the request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.Map<java.lang.String, java.lang.String> getRequestParameters();
    /**
     * A map of Apache Velocity templates that are applied on the request payload.
     * 
     * The template that API Gateway uses is based on the value of the
     * Content-Type header that's sent by the client. The content type value is
     * the key, and the template is the value (specified as a string), such as
     * the following snippet:
     * 
     *    { "application/json": "{\n  \"statusCode\": \"200\"\n}" }
     * 
     * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.Map<java.lang.String, java.lang.String> getRequestTemplates();
    /**
     * The VpcLink used for the integration. Required if connectionType is VPC_LINK.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.VpcLink getVpcLink();

    /**
     * @return a {@link Builder} of {@link IntegrationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link IntegrationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _cacheKeyParameters;
        @javax.annotation.Nullable
        private java.lang.String _cacheNamespace;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.ConnectionType _connectionType;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.ContentHandling _contentHandling;
        @javax.annotation.Nullable
        private java.lang.Boolean _credentialsPassthrough;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.iam.IRole _credentialsRole;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> _integrationResponses;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.PassthroughBehavior _passthroughBehavior;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _requestParameters;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _requestTemplates;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.VpcLink _vpcLink;

        /**
         * Sets the value of CacheKeyParameters
         * @param value A list of request parameters whose values are to be cached.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withCacheKeyParameters(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._cacheKeyParameters = value;
            return this;
        }
        /**
         * Sets the value of CacheNamespace
         * @param value An API-specific tag group of related cached parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withCacheNamespace(@javax.annotation.Nullable final java.lang.String value) {
            this._cacheNamespace = value;
            return this;
        }
        /**
         * Sets the value of ConnectionType
         * @param value The type of network connection to the integration endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withConnectionType(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.ConnectionType value) {
            this._connectionType = value;
            return this;
        }
        /**
         * Sets the value of ContentHandling
         * @param value Specifies how to handle request payload content type conversions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withContentHandling(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.ContentHandling value) {
            this._contentHandling = value;
            return this;
        }
        /**
         * Sets the value of CredentialsPassthrough
         * @param value Requires that the caller's identity be passed through from the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withCredentialsPassthrough(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._credentialsPassthrough = value;
            return this;
        }
        /**
         * Sets the value of CredentialsRole
         * @param value An IAM role that API Gateway assumes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withCredentialsRole(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IRole value) {
            this._credentialsRole = value;
            return this;
        }
        /**
         * Sets the value of IntegrationResponses
         * @param value The response that API Gateway provides after a method's backend completes processing a request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withIntegrationResponses(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> value) {
            this._integrationResponses = value;
            return this;
        }
        /**
         * Sets the value of PassthroughBehavior
         * @param value Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPassthroughBehavior(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.PassthroughBehavior value) {
            this._passthroughBehavior = value;
            return this;
        }
        /**
         * Sets the value of RequestParameters
         * @param value The request parameters that API Gateway sends with the backend request. Specify request parameters as key-value pairs (string-to-string mappings), with a destination as the key and a source as the value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withRequestParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._requestParameters = value;
            return this;
        }
        /**
         * Sets the value of RequestTemplates
         * @param value A map of Apache Velocity templates that are applied on the request payload.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withRequestTemplates(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._requestTemplates = value;
            return this;
        }
        /**
         * Sets the value of VpcLink
         * @param value The VpcLink used for the integration. Required if connectionType is VPC_LINK.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withVpcLink(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.VpcLink value) {
            this._vpcLink = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IntegrationOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public IntegrationOptions build() {
            return new IntegrationOptions() {
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $cacheKeyParameters = _cacheKeyParameters;
                @javax.annotation.Nullable
                private final java.lang.String $cacheNamespace = _cacheNamespace;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.ConnectionType $connectionType = _connectionType;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.ContentHandling $contentHandling = _contentHandling;
                @javax.annotation.Nullable
                private final java.lang.Boolean $credentialsPassthrough = _credentialsPassthrough;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.iam.IRole $credentialsRole = _credentialsRole;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> $integrationResponses = _integrationResponses;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.PassthroughBehavior $passthroughBehavior = _passthroughBehavior;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.String> $requestParameters = _requestParameters;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.String> $requestTemplates = _requestTemplates;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.VpcLink $vpcLink = _vpcLink;

                @Override
                public java.util.List<java.lang.String> getCacheKeyParameters() {
                    return this.$cacheKeyParameters;
                }

                @Override
                public java.lang.String getCacheNamespace() {
                    return this.$cacheNamespace;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.ConnectionType getConnectionType() {
                    return this.$connectionType;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.ContentHandling getContentHandling() {
                    return this.$contentHandling;
                }

                @Override
                public java.lang.Boolean getCredentialsPassthrough() {
                    return this.$credentialsPassthrough;
                }

                @Override
                public software.amazon.awscdk.services.iam.IRole getCredentialsRole() {
                    return this.$credentialsRole;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> getIntegrationResponses() {
                    return this.$integrationResponses;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.PassthroughBehavior getPassthroughBehavior() {
                    return this.$passthroughBehavior;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getRequestParameters() {
                    return this.$requestParameters;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getRequestTemplates() {
                    return this.$requestTemplates;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.VpcLink getVpcLink() {
                    return this.$vpcLink;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getCacheKeyParameters() != null) {
                        obj.set("cacheKeyParameters", om.valueToTree(this.getCacheKeyParameters()));
                    }
                    if (this.getCacheNamespace() != null) {
                        obj.set("cacheNamespace", om.valueToTree(this.getCacheNamespace()));
                    }
                    if (this.getConnectionType() != null) {
                        obj.set("connectionType", om.valueToTree(this.getConnectionType()));
                    }
                    if (this.getContentHandling() != null) {
                        obj.set("contentHandling", om.valueToTree(this.getContentHandling()));
                    }
                    if (this.getCredentialsPassthrough() != null) {
                        obj.set("credentialsPassthrough", om.valueToTree(this.getCredentialsPassthrough()));
                    }
                    if (this.getCredentialsRole() != null) {
                        obj.set("credentialsRole", om.valueToTree(this.getCredentialsRole()));
                    }
                    if (this.getIntegrationResponses() != null) {
                        obj.set("integrationResponses", om.valueToTree(this.getIntegrationResponses()));
                    }
                    if (this.getPassthroughBehavior() != null) {
                        obj.set("passthroughBehavior", om.valueToTree(this.getPassthroughBehavior()));
                    }
                    if (this.getRequestParameters() != null) {
                        obj.set("requestParameters", om.valueToTree(this.getRequestParameters()));
                    }
                    if (this.getRequestTemplates() != null) {
                        obj.set("requestTemplates", om.valueToTree(this.getRequestTemplates()));
                    }
                    if (this.getVpcLink() != null) {
                        obj.set("vpcLink", om.valueToTree(this.getVpcLink()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.IntegrationOptions {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * A list of request parameters whose values are to be cached.
         * 
         * It determines
         * request parameters that will make it into the cache key.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getCacheKeyParameters() {
            return this.jsiiGet("cacheKeyParameters", java.util.List.class);
        }

        /**
         * An API-specific tag group of related cached parameters.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getCacheNamespace() {
            return this.jsiiGet("cacheNamespace", java.lang.String.class);
        }

        /**
         * The type of network connection to the integration endpoint.
         * 
         * Default: ConnectionType.Internet
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.ConnectionType getConnectionType() {
            return this.jsiiGet("connectionType", software.amazon.awscdk.services.apigateway.ConnectionType.class);
        }

        /**
         * Specifies how to handle request payload content type conversions.
         * 
         * Default: none if this property isn't defined, the request payload is passed
         * through from the method request to the integration request without
         * modification, provided that the `passthroughBehaviors` property is
         * configured to support payload pass-through.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.ContentHandling getContentHandling() {
            return this.jsiiGet("contentHandling", software.amazon.awscdk.services.apigateway.ContentHandling.class);
        }

        /**
         * Requires that the caller's identity be passed through from the request.
         * 
         * Default: Caller identity is not passed through
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getCredentialsPassthrough() {
            return this.jsiiGet("credentialsPassthrough", java.lang.Boolean.class);
        }

        /**
         * An IAM role that API Gateway assumes.
         * 
         * Mutually exclusive with `credentialsPassThrough`.
         * 
         * Default: A role is not assumed
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.iam.IRole getCredentialsRole() {
            return this.jsiiGet("credentialsRole", software.amazon.awscdk.services.iam.IRole.class);
        }

        /**
         * The response that API Gateway provides after a method's backend completes processing a request.
         * 
         * API Gateway intercepts the response from the
         * backend so that you can control how API Gateway surfaces backend
         * responses. For example, you can map the backend status codes to codes
         * that you define.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> getIntegrationResponses() {
            return this.jsiiGet("integrationResponses", java.util.List.class);
        }

        /**
         * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.PassthroughBehavior getPassthroughBehavior() {
            return this.jsiiGet("passthroughBehavior", software.amazon.awscdk.services.apigateway.PassthroughBehavior.class);
        }

        /**
         * The request parameters that API Gateway sends with the backend request. Specify request parameters as key-value pairs (string-to-string mappings), with a destination as the key and a source as the value.
         * 
         * Specify the destination by using the following pattern
         * integration.request.location.name, where location is querystring, path,
         * or header, and name is a valid, unique parameter name.
         * 
         * The source must be an existing method request parameter or a static
         * value. You must enclose static values in single quotation marks and
         * pre-encode these values based on their destination in the request.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getRequestParameters() {
            return this.jsiiGet("requestParameters", java.util.Map.class);
        }

        /**
         * A map of Apache Velocity templates that are applied on the request payload.
         * 
         * The template that API Gateway uses is based on the value of the
         * Content-Type header that's sent by the client. The content type value is
         * the key, and the template is the value (specified as a string), such as
         * the following snippet:
         * 
         *    { "application/json": "{\n  \"statusCode\": \"200\"\n}" }
         * 
         * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getRequestTemplates() {
            return this.jsiiGet("requestTemplates", java.util.Map.class);
        }

        /**
         * The VpcLink used for the integration. Required if connectionType is VPC_LINK.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.VpcLink getVpcLink() {
            return this.jsiiGet("vpcLink", software.amazon.awscdk.services.apigateway.VpcLink.class);
        }
    }
}
