package software.amazon.awscdk.services.apigateway;

/**
 * Represents a REST API in Amazon API Gateway.
 * 
 * Use `addResource` and `addMethod` to configure the API model.
 * 
 * By default, the API will automatically be deployed and accessible from a
 * public endpoint.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-14T08:24:29.318Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.RestApi")
public class RestApi extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.apigateway.IRestApi {
    protected RestApi(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RestApi(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.RestApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RestApi(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.apigateway.IRestApi fromRestApiId(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String restApiId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.RestApi.class, "fromRestApiId", software.amazon.awscdk.services.apigateway.IRestApi.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(restApiId, "restApiId is required") });
    }

    /**
     * Add an ApiKey.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.apigateway.IApiKey addApiKey(final java.lang.String id) {
        return this.jsiiCall("addApiKey", software.amazon.awscdk.services.apigateway.IApiKey.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines an API Gateway domain name and maps it to this API.
     * 
     * @param id The construct id.
     * @param options custom domain options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.apigateway.DomainName addDomainName(final java.lang.String id, final software.amazon.awscdk.services.apigateway.DomainNameOptions options) {
        return this.jsiiCall("addDomainName", software.amazon.awscdk.services.apigateway.DomainName.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds a new model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.apigateway.Model addModel(final java.lang.String id, final software.amazon.awscdk.services.apigateway.ModelOptions props) {
        return this.jsiiCall("addModel", software.amazon.awscdk.services.apigateway.Model.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds a new model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.apigateway.RequestValidator addRequestValidator(final java.lang.String id, final software.amazon.awscdk.services.apigateway.RequestValidatorOptions props) {
        return this.jsiiCall("addRequestValidator", software.amazon.awscdk.services.apigateway.RequestValidator.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds a usage plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.apigateway.UsagePlan addUsagePlan(final java.lang.String id, final software.amazon.awscdk.services.apigateway.UsagePlanProps props) {
        return this.jsiiCall("addUsagePlan", software.amazon.awscdk.services.apigateway.UsagePlan.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Default: "*" returns the execute API ARN for all methods/resources in
     * this API.
     * 
     * @return The "execute-api" ARN.
     * @param method The method (default `*`).
     * @param path The resource path.
     * @param stage The stage (default `*`).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String arnForExecuteApi(@javax.annotation.Nullable final java.lang.String method, @javax.annotation.Nullable final java.lang.String path, @javax.annotation.Nullable final java.lang.String stage) {
        return this.jsiiCall("arnForExecuteApi", java.lang.String.class, new Object[] { method, path, stage });
    }

    /**
     * Default: "*" returns the execute API ARN for all methods/resources in
     * this API.
     * 
     * @return The "execute-api" ARN.
     * @param method The method (default `*`).
     * @param path The resource path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String arnForExecuteApi(@javax.annotation.Nullable final java.lang.String method, @javax.annotation.Nullable final java.lang.String path) {
        return this.jsiiCall("arnForExecuteApi", java.lang.String.class, new Object[] { method, path });
    }

    /**
     * Default: "*" returns the execute API ARN for all methods/resources in
     * this API.
     * 
     * @return The "execute-api" ARN.
     * @param method The method (default `*`).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String arnForExecuteApi(@javax.annotation.Nullable final java.lang.String method) {
        return this.jsiiCall("arnForExecuteApi", java.lang.String.class, new Object[] { method });
    }

    /**
     * Default: "*" returns the execute API ARN for all methods/resources in
     * this API.
     * 
     * @return The "execute-api" ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String arnForExecuteApi() {
        return this.jsiiCall("arnForExecuteApi", java.lang.String.class);
    }

    /**
     * Returns the URL for an HTTP path.
     * 
     * Fails if `deploymentStage` is not set either by `deploy` or explicitly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String urlForPath(@javax.annotation.Nullable final java.lang.String path) {
        return this.jsiiCall("urlForPath", java.lang.String.class, new Object[] { path });
    }

    /**
     * Returns the URL for an HTTP path.
     * 
     * Fails if `deploymentStage` is not set either by `deploy` or explicitly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String urlForPath() {
        return this.jsiiCall("urlForPath", java.lang.String.class);
    }

    /**
     * Performs validation of the REST API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected java.util.List<java.lang.String> validate() {
        return this.jsiiCall("validate", java.util.List.class);
    }

    /**
     * The ID of this API Gateway RestApi.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getRestApiId() {
        return this.jsiiGet("restApiId", java.lang.String.class);
    }

    /**
     * The resource ID of the root resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getRestApiRootResourceId() {
        return this.jsiiGet("restApiRootResourceId", java.lang.String.class);
    }

    /**
     * Represents the root resource ("/") of this API. Use it to define the API model:.
     * 
     * api.root.addMethod('ANY', redirectToHomePage); // "ANY /"
     *     api.root.addResource('friends').addMethod('GET', getFriendsHandler); // "GET /friends"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.apigateway.IResource getRoot() {
        return this.jsiiGet("root", software.amazon.awscdk.services.apigateway.IResource.class);
    }

    /**
     * The deployed root URL of this REST API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getUrl() {
        return this.jsiiGet("url", java.lang.String.class);
    }

    /**
     * The domain name mapped to this API, if defined through the `domainName` configuration prop.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.apigateway.DomainName getDomainName() {
        return this.jsiiGet("domainName", software.amazon.awscdk.services.apigateway.DomainName.class);
    }

    /**
     * API Gateway deployment that represents the latest changes of the API. This resource will be automatically updated every time the REST API model changes. This will be undefined if `deploy` is false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.apigateway.Deployment getLatestDeployment() {
        return this.jsiiGet("latestDeployment", software.amazon.awscdk.services.apigateway.Deployment.class);
    }

    /**
     * API Gateway stage that points to the latest deployment (if defined).
     * 
     * If `deploy` is disabled, you will need to explicitly assign this value in order to
     * set up integrations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.apigateway.Stage getDeploymentStage() {
        return this.jsiiGet("deploymentStage", software.amazon.awscdk.services.apigateway.Stage.class);
    }

    /**
     * API Gateway stage that points to the latest deployment (if defined).
     * 
     * If `deploy` is disabled, you will need to explicitly assign this value in order to
     * set up integrations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentStage(final software.amazon.awscdk.services.apigateway.Stage value) {
        this.jsiiSet("deploymentStage", java.util.Objects.requireNonNull(value, "deploymentStage is required"));
    }
}
