package software.amazon.awscdk.services.apigateway;

/**
 * Represents per-method throttling for a resource.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-14T08:24:29.322Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ThrottlingPerMethod extends software.amazon.jsii.JsiiSerializable {
    /**
     * [disable-awslint:ref-via-interface] The method for which you specify the throttling settings.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.Method getMethod();
    /**
     * Specifies the overall request rate (average requests per second) and burst capacity.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.ThrottleSettings getThrottle();

    /**
     * @return a {@link Builder} of {@link ThrottlingPerMethod}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ThrottlingPerMethod}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.apigateway.Method _method;
        private software.amazon.awscdk.services.apigateway.ThrottleSettings _throttle;

        /**
         * Sets the value of Method
         * @param value [disable-awslint:ref-via-interface] The method for which you specify the throttling settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withMethod(final software.amazon.awscdk.services.apigateway.Method value) {
            this._method = java.util.Objects.requireNonNull(value, "method is required");
            return this;
        }
        /**
         * Sets the value of Throttle
         * @param value Specifies the overall request rate (average requests per second) and burst capacity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withThrottle(final software.amazon.awscdk.services.apigateway.ThrottleSettings value) {
            this._throttle = java.util.Objects.requireNonNull(value, "throttle is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ThrottlingPerMethod}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ThrottlingPerMethod build() {
            return new ThrottlingPerMethod() {
                private final software.amazon.awscdk.services.apigateway.Method $method = java.util.Objects.requireNonNull(_method, "method is required");
                private final software.amazon.awscdk.services.apigateway.ThrottleSettings $throttle = java.util.Objects.requireNonNull(_throttle, "throttle is required");

                @Override
                public software.amazon.awscdk.services.apigateway.Method getMethod() {
                    return this.$method;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.ThrottleSettings getThrottle() {
                    return this.$throttle;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("method", om.valueToTree(this.getMethod()));
                    obj.set("throttle", om.valueToTree(this.getThrottle()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.ThrottlingPerMethod {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * [disable-awslint:ref-via-interface] The method for which you specify the throttling settings.
         * 
         * Default: none
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.apigateway.Method getMethod() {
            return this.jsiiGet("method", software.amazon.awscdk.services.apigateway.Method.class);
        }

        /**
         * Specifies the overall request rate (average requests per second) and burst capacity.
         * 
         * Default: none
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.apigateway.ThrottleSettings getThrottle() {
            return this.jsiiGet("throttle", software.amazon.awscdk.services.apigateway.ThrottleSettings.class);
        }
    }
}
