package software.amazon.awscdk.services.apigateway;

/**
 * Properties for a VpcLink.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-14T08:24:29.323Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpcLinkProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The description of the VPC link.
     * 
     * Default: no description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDescription();
    /**
     * The network load balancers of the VPC targeted by the VPC link. The network load balancers must be owned by the same AWS account of the API owner.
     * 
     * Default: - no targets. Use `addTargets` to add targets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> getTargets();
    /**
     * The name used to label and identify the VPC link.
     * 
     * Default: - automatically generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getVpcLinkName();

    /**
     * @return a {@link Builder} of {@link VpcLinkProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VpcLinkProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> _targets;
        @javax.annotation.Nullable
        private java.lang.String _vpcLinkName;

        /**
         * Sets the value of Description
         * @param value The description of the VPC link.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of Targets
         * @param value The network load balancers of the VPC targeted by the VPC link. The network load balancers must be owned by the same AWS account of the API owner.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> value) {
            this._targets = value;
            return this;
        }
        /**
         * Sets the value of VpcLinkName
         * @param value The name used to label and identify the VPC link.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withVpcLinkName(@javax.annotation.Nullable final java.lang.String value) {
            this._vpcLinkName = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcLinkProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public VpcLinkProps build() {
            return new VpcLinkProps() {
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> $targets = _targets;
                @javax.annotation.Nullable
                private final java.lang.String $vpcLinkName = _vpcLinkName;

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> getTargets() {
                    return this.$targets;
                }

                @Override
                public java.lang.String getVpcLinkName() {
                    return this.$vpcLinkName;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree(this.getDescription()));
                    }
                    if (this.getTargets() != null) {
                        obj.set("targets", om.valueToTree(this.getTargets()));
                    }
                    if (this.getVpcLinkName() != null) {
                        obj.set("vpcLinkName", om.valueToTree(this.getVpcLinkName()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.VpcLinkProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The description of the VPC link.
         * 
         * Default: no description
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * The network load balancers of the VPC targeted by the VPC link. The network load balancers must be owned by the same AWS account of the API owner.
         * 
         * Default: - no targets. Use `addTargets` to add targets
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> getTargets() {
            return this.jsiiGet("targets", java.util.List.class);
        }

        /**
         * The name used to label and identify the VPC link.
         * 
         * Default: - automatically generated name
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getVpcLinkName() {
            return this.jsiiGet("vpcLinkName", java.lang.String.class);
        }
    }
}
