package software.amazon.awscdk.services.apigateway;

/**
 * A CloudFormation `AWS::ApiGateway::Method`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-05-20T13:23:27.540Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnMethod")
public class CfnMethod extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnMethod(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMethod(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnMethod.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ApiGateway::Method`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnMethod(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.CfnMethodProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A factory method that creates a new instance of this class from an object containing the CloudFormation properties of this resource.
     * <p>
     * Used in the &#64;aws-cdk/cloudformation-include module.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param resourceAttributes This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.CfnMethod fromCloudFormation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.Object resourceAttributes, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FromCloudFormationOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.CfnMethod.class, "fromCloudFormation", software.amazon.awscdk.services.apigateway.CfnMethod.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), resourceAttributes, java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::ApiGateway::Method.HttpMethod`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getHttpMethod() {
        return this.jsiiGet("httpMethod", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Method.HttpMethod`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setHttpMethod(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("httpMethod", java.util.Objects.requireNonNull(value, "httpMethod is required"));
    }

    /**
     * `AWS::ApiGateway::Method.ResourceId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceId() {
        return this.jsiiGet("resourceId", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Method.ResourceId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setResourceId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("resourceId", java.util.Objects.requireNonNull(value, "resourceId is required"));
    }

    /**
     * `AWS::ApiGateway::Method.RestApiId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getRestApiId() {
        return this.jsiiGet("restApiId", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Method.RestApiId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRestApiId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("restApiId", java.util.Objects.requireNonNull(value, "restApiId is required"));
    }

    /**
     * `AWS::ApiGateway::Method.ApiKeyRequired`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getApiKeyRequired() {
        return this.jsiiGet("apiKeyRequired", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Method.ApiKeyRequired`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setApiKeyRequired(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        this.jsiiSet("apiKeyRequired", value);
    }

    /**
     * `AWS::ApiGateway::Method.ApiKeyRequired`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setApiKeyRequired(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("apiKeyRequired", value);
    }

    /**
     * `AWS::ApiGateway::Method.AuthorizationScopes`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAuthorizationScopes() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("authorizationScopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::ApiGateway::Method.AuthorizationScopes`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAuthorizationScopes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("authorizationScopes", value);
    }

    /**
     * `AWS::ApiGateway::Method.AuthorizationType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getAuthorizationType() {
        return this.jsiiGet("authorizationType", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Method.AuthorizationType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAuthorizationType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("authorizationType", value);
    }

    /**
     * `AWS::ApiGateway::Method.AuthorizerId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerId() {
        return this.jsiiGet("authorizerId", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Method.AuthorizerId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAuthorizerId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("authorizerId", value);
    }

    /**
     * `AWS::ApiGateway::Method.Integration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIntegration() {
        return this.jsiiGet("integration", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Method.Integration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setIntegration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("integration", value);
    }

    /**
     * `AWS::ApiGateway::Method.Integration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setIntegration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CfnMethod.IntegrationProperty value) {
        this.jsiiSet("integration", value);
    }

    /**
     * `AWS::ApiGateway::Method.MethodResponses`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMethodResponses() {
        return this.jsiiGet("methodResponses", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Method.MethodResponses`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMethodResponses(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("methodResponses", value);
    }

    /**
     * `AWS::ApiGateway::Method.MethodResponses`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMethodResponses(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("methodResponses", value);
    }

    /**
     * `AWS::ApiGateway::Method.OperationName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getOperationName() {
        return this.jsiiGet("operationName", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Method.OperationName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setOperationName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("operationName", value);
    }

    /**
     * `AWS::ApiGateway::Method.RequestModels`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRequestModels() {
        return this.jsiiGet("requestModels", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Method.RequestModels`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRequestModels(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("requestModels", value);
    }

    /**
     * `AWS::ApiGateway::Method.RequestModels`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRequestModels(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        this.jsiiSet("requestModels", value);
    }

    /**
     * `AWS::ApiGateway::Method.RequestParameters`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRequestParameters() {
        return this.jsiiGet("requestParameters", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Method.RequestParameters`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRequestParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("requestParameters", value);
    }

    /**
     * `AWS::ApiGateway::Method.RequestParameters`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRequestParameters(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        this.jsiiSet("requestParameters", value);
    }

    /**
     * `AWS::ApiGateway::Method.RequestValidatorId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getRequestValidatorId() {
        return this.jsiiGet("requestValidatorId", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Method.RequestValidatorId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRequestValidatorId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("requestValidatorId", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnMethod.IntegrationProperty")
    @software.amazon.jsii.Jsii.Proxy(IntegrationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface IntegrationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMethod.IntegrationProperty.CacheKeyParameters`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachekeyparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCacheKeyParameters() {
            return null;
        }

        /**
         * `CfnMethod.IntegrationProperty.CacheNamespace`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachenamespace
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getCacheNamespace() {
            return null;
        }

        /**
         * `CfnMethod.IntegrationProperty.ConnectionId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-connectionid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionId() {
            return null;
        }

        /**
         * `CfnMethod.IntegrationProperty.ConnectionType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-connectiontype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionType() {
            return null;
        }

        /**
         * `CfnMethod.IntegrationProperty.ContentHandling`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-contenthandling
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getContentHandling() {
            return null;
        }

        /**
         * `CfnMethod.IntegrationProperty.Credentials`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-credentials
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getCredentials() {
            return null;
        }

        /**
         * `CfnMethod.IntegrationProperty.IntegrationHttpMethod`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationhttpmethod
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getIntegrationHttpMethod() {
            return null;
        }

        /**
         * `CfnMethod.IntegrationProperty.IntegrationResponses`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationresponses
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntegrationResponses() {
            return null;
        }

        /**
         * `CfnMethod.IntegrationProperty.PassthroughBehavior`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-passthroughbehavior
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassthroughBehavior() {
            return null;
        }

        /**
         * `CfnMethod.IntegrationProperty.RequestParameters`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requestparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequestParameters() {
            return null;
        }

        /**
         * `CfnMethod.IntegrationProperty.RequestTemplates`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requesttemplates
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequestTemplates() {
            return null;
        }

        /**
         * `CfnMethod.IntegrationProperty.TimeoutInMillis`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-timeoutinmillis
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInMillis() {
            return null;
        }

        /**
         * `CfnMethod.IntegrationProperty.Type`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * `CfnMethod.IntegrationProperty.Uri`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-uri
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getUri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IntegrationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntegrationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.util.List<java.lang.String> cacheKeyParameters;
            private java.lang.String cacheNamespace;
            private java.lang.String connectionId;
            private java.lang.String connectionType;
            private java.lang.String contentHandling;
            private java.lang.String credentials;
            private java.lang.String integrationHttpMethod;
            private java.lang.Object integrationResponses;
            private java.lang.String passthroughBehavior;
            private java.lang.Object requestParameters;
            private java.lang.Object requestTemplates;
            private java.lang.Number timeoutInMillis;
            private java.lang.String type;
            private java.lang.String uri;

            /**
             * Sets the value of {@link IntegrationProperty#getCacheKeyParameters}
             * @param cacheKeyParameters `CfnMethod.IntegrationProperty.CacheKeyParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cacheKeyParameters(java.util.List<java.lang.String> cacheKeyParameters) {
                this.cacheKeyParameters = cacheKeyParameters;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getCacheNamespace}
             * @param cacheNamespace `CfnMethod.IntegrationProperty.CacheNamespace`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cacheNamespace(java.lang.String cacheNamespace) {
                this.cacheNamespace = cacheNamespace;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getConnectionId}
             * @param connectionId `CfnMethod.IntegrationProperty.ConnectionId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder connectionId(java.lang.String connectionId) {
                this.connectionId = connectionId;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getConnectionType}
             * @param connectionType `CfnMethod.IntegrationProperty.ConnectionType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder connectionType(java.lang.String connectionType) {
                this.connectionType = connectionType;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getContentHandling}
             * @param contentHandling `CfnMethod.IntegrationProperty.ContentHandling`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder contentHandling(java.lang.String contentHandling) {
                this.contentHandling = contentHandling;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getCredentials}
             * @param credentials `CfnMethod.IntegrationProperty.Credentials`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder credentials(java.lang.String credentials) {
                this.credentials = credentials;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getIntegrationHttpMethod}
             * @param integrationHttpMethod `CfnMethod.IntegrationProperty.IntegrationHttpMethod`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder integrationHttpMethod(java.lang.String integrationHttpMethod) {
                this.integrationHttpMethod = integrationHttpMethod;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getIntegrationResponses}
             * @param integrationResponses `CfnMethod.IntegrationProperty.IntegrationResponses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder integrationResponses(software.amazon.awscdk.core.IResolvable integrationResponses) {
                this.integrationResponses = integrationResponses;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getIntegrationResponses}
             * @param integrationResponses `CfnMethod.IntegrationProperty.IntegrationResponses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder integrationResponses(java.util.List<java.lang.Object> integrationResponses) {
                this.integrationResponses = integrationResponses;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getPassthroughBehavior}
             * @param passthroughBehavior `CfnMethod.IntegrationProperty.PassthroughBehavior`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder passthroughBehavior(java.lang.String passthroughBehavior) {
                this.passthroughBehavior = passthroughBehavior;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getRequestParameters}
             * @param requestParameters `CfnMethod.IntegrationProperty.RequestParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder requestParameters(software.amazon.awscdk.core.IResolvable requestParameters) {
                this.requestParameters = requestParameters;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getRequestParameters}
             * @param requestParameters `CfnMethod.IntegrationProperty.RequestParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder requestParameters(java.util.Map<java.lang.String, java.lang.String> requestParameters) {
                this.requestParameters = requestParameters;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getRequestTemplates}
             * @param requestTemplates `CfnMethod.IntegrationProperty.RequestTemplates`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder requestTemplates(software.amazon.awscdk.core.IResolvable requestTemplates) {
                this.requestTemplates = requestTemplates;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getRequestTemplates}
             * @param requestTemplates `CfnMethod.IntegrationProperty.RequestTemplates`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder requestTemplates(java.util.Map<java.lang.String, java.lang.String> requestTemplates) {
                this.requestTemplates = requestTemplates;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getTimeoutInMillis}
             * @param timeoutInMillis `CfnMethod.IntegrationProperty.TimeoutInMillis`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder timeoutInMillis(java.lang.Number timeoutInMillis) {
                this.timeoutInMillis = timeoutInMillis;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getType}
             * @param type `CfnMethod.IntegrationProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getUri}
             * @param uri `CfnMethod.IntegrationProperty.Uri`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder uri(java.lang.String uri) {
                this.uri = uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntegrationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public IntegrationProperty build() {
                return new Jsii$Proxy(cacheKeyParameters, cacheNamespace, connectionId, connectionType, contentHandling, credentials, integrationHttpMethod, integrationResponses, passthroughBehavior, requestParameters, requestTemplates, timeoutInMillis, type, uri);
            }
        }

        /**
         * An implementation for {@link IntegrationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegrationProperty {
            private final java.util.List<java.lang.String> cacheKeyParameters;
            private final java.lang.String cacheNamespace;
            private final java.lang.String connectionId;
            private final java.lang.String connectionType;
            private final java.lang.String contentHandling;
            private final java.lang.String credentials;
            private final java.lang.String integrationHttpMethod;
            private final java.lang.Object integrationResponses;
            private final java.lang.String passthroughBehavior;
            private final java.lang.Object requestParameters;
            private final java.lang.Object requestTemplates;
            private final java.lang.Number timeoutInMillis;
            private final java.lang.String type;
            private final java.lang.String uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cacheKeyParameters = this.jsiiGet("cacheKeyParameters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cacheNamespace = this.jsiiGet("cacheNamespace", java.lang.String.class);
                this.connectionId = this.jsiiGet("connectionId", java.lang.String.class);
                this.connectionType = this.jsiiGet("connectionType", java.lang.String.class);
                this.contentHandling = this.jsiiGet("contentHandling", java.lang.String.class);
                this.credentials = this.jsiiGet("credentials", java.lang.String.class);
                this.integrationHttpMethod = this.jsiiGet("integrationHttpMethod", java.lang.String.class);
                this.integrationResponses = this.jsiiGet("integrationResponses", java.lang.Object.class);
                this.passthroughBehavior = this.jsiiGet("passthroughBehavior", java.lang.String.class);
                this.requestParameters = this.jsiiGet("requestParameters", java.lang.Object.class);
                this.requestTemplates = this.jsiiGet("requestTemplates", java.lang.Object.class);
                this.timeoutInMillis = this.jsiiGet("timeoutInMillis", java.lang.Number.class);
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.uri = this.jsiiGet("uri", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.util.List<java.lang.String> cacheKeyParameters, final java.lang.String cacheNamespace, final java.lang.String connectionId, final java.lang.String connectionType, final java.lang.String contentHandling, final java.lang.String credentials, final java.lang.String integrationHttpMethod, final java.lang.Object integrationResponses, final java.lang.String passthroughBehavior, final java.lang.Object requestParameters, final java.lang.Object requestTemplates, final java.lang.Number timeoutInMillis, final java.lang.String type, final java.lang.String uri) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cacheKeyParameters = cacheKeyParameters;
                this.cacheNamespace = cacheNamespace;
                this.connectionId = connectionId;
                this.connectionType = connectionType;
                this.contentHandling = contentHandling;
                this.credentials = credentials;
                this.integrationHttpMethod = integrationHttpMethod;
                this.integrationResponses = integrationResponses;
                this.passthroughBehavior = passthroughBehavior;
                this.requestParameters = requestParameters;
                this.requestTemplates = requestTemplates;
                this.timeoutInMillis = timeoutInMillis;
                this.type = type;
                this.uri = uri;
            }

            @Override
            public java.util.List<java.lang.String> getCacheKeyParameters() {
                return this.cacheKeyParameters;
            }

            @Override
            public java.lang.String getCacheNamespace() {
                return this.cacheNamespace;
            }

            @Override
            public java.lang.String getConnectionId() {
                return this.connectionId;
            }

            @Override
            public java.lang.String getConnectionType() {
                return this.connectionType;
            }

            @Override
            public java.lang.String getContentHandling() {
                return this.contentHandling;
            }

            @Override
            public java.lang.String getCredentials() {
                return this.credentials;
            }

            @Override
            public java.lang.String getIntegrationHttpMethod() {
                return this.integrationHttpMethod;
            }

            @Override
            public java.lang.Object getIntegrationResponses() {
                return this.integrationResponses;
            }

            @Override
            public java.lang.String getPassthroughBehavior() {
                return this.passthroughBehavior;
            }

            @Override
            public java.lang.Object getRequestParameters() {
                return this.requestParameters;
            }

            @Override
            public java.lang.Object getRequestTemplates() {
                return this.requestTemplates;
            }

            @Override
            public java.lang.Number getTimeoutInMillis() {
                return this.timeoutInMillis;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.lang.String getUri() {
                return this.uri;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCacheKeyParameters() != null) {
                    data.set("cacheKeyParameters", om.valueToTree(this.getCacheKeyParameters()));
                }
                if (this.getCacheNamespace() != null) {
                    data.set("cacheNamespace", om.valueToTree(this.getCacheNamespace()));
                }
                if (this.getConnectionId() != null) {
                    data.set("connectionId", om.valueToTree(this.getConnectionId()));
                }
                if (this.getConnectionType() != null) {
                    data.set("connectionType", om.valueToTree(this.getConnectionType()));
                }
                if (this.getContentHandling() != null) {
                    data.set("contentHandling", om.valueToTree(this.getContentHandling()));
                }
                if (this.getCredentials() != null) {
                    data.set("credentials", om.valueToTree(this.getCredentials()));
                }
                if (this.getIntegrationHttpMethod() != null) {
                    data.set("integrationHttpMethod", om.valueToTree(this.getIntegrationHttpMethod()));
                }
                if (this.getIntegrationResponses() != null) {
                    data.set("integrationResponses", om.valueToTree(this.getIntegrationResponses()));
                }
                if (this.getPassthroughBehavior() != null) {
                    data.set("passthroughBehavior", om.valueToTree(this.getPassthroughBehavior()));
                }
                if (this.getRequestParameters() != null) {
                    data.set("requestParameters", om.valueToTree(this.getRequestParameters()));
                }
                if (this.getRequestTemplates() != null) {
                    data.set("requestTemplates", om.valueToTree(this.getRequestTemplates()));
                }
                if (this.getTimeoutInMillis() != null) {
                    data.set("timeoutInMillis", om.valueToTree(this.getTimeoutInMillis()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getUri() != null) {
                    data.set("uri", om.valueToTree(this.getUri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnMethod.IntegrationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntegrationProperty.Jsii$Proxy that = (IntegrationProperty.Jsii$Proxy) o;

                if (this.cacheKeyParameters != null ? !this.cacheKeyParameters.equals(that.cacheKeyParameters) : that.cacheKeyParameters != null) return false;
                if (this.cacheNamespace != null ? !this.cacheNamespace.equals(that.cacheNamespace) : that.cacheNamespace != null) return false;
                if (this.connectionId != null ? !this.connectionId.equals(that.connectionId) : that.connectionId != null) return false;
                if (this.connectionType != null ? !this.connectionType.equals(that.connectionType) : that.connectionType != null) return false;
                if (this.contentHandling != null ? !this.contentHandling.equals(that.contentHandling) : that.contentHandling != null) return false;
                if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
                if (this.integrationHttpMethod != null ? !this.integrationHttpMethod.equals(that.integrationHttpMethod) : that.integrationHttpMethod != null) return false;
                if (this.integrationResponses != null ? !this.integrationResponses.equals(that.integrationResponses) : that.integrationResponses != null) return false;
                if (this.passthroughBehavior != null ? !this.passthroughBehavior.equals(that.passthroughBehavior) : that.passthroughBehavior != null) return false;
                if (this.requestParameters != null ? !this.requestParameters.equals(that.requestParameters) : that.requestParameters != null) return false;
                if (this.requestTemplates != null ? !this.requestTemplates.equals(that.requestTemplates) : that.requestTemplates != null) return false;
                if (this.timeoutInMillis != null ? !this.timeoutInMillis.equals(that.timeoutInMillis) : that.timeoutInMillis != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                return this.uri != null ? this.uri.equals(that.uri) : that.uri == null;
            }

            @Override
            public int hashCode() {
                int result = this.cacheKeyParameters != null ? this.cacheKeyParameters.hashCode() : 0;
                result = 31 * result + (this.cacheNamespace != null ? this.cacheNamespace.hashCode() : 0);
                result = 31 * result + (this.connectionId != null ? this.connectionId.hashCode() : 0);
                result = 31 * result + (this.connectionType != null ? this.connectionType.hashCode() : 0);
                result = 31 * result + (this.contentHandling != null ? this.contentHandling.hashCode() : 0);
                result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
                result = 31 * result + (this.integrationHttpMethod != null ? this.integrationHttpMethod.hashCode() : 0);
                result = 31 * result + (this.integrationResponses != null ? this.integrationResponses.hashCode() : 0);
                result = 31 * result + (this.passthroughBehavior != null ? this.passthroughBehavior.hashCode() : 0);
                result = 31 * result + (this.requestParameters != null ? this.requestParameters.hashCode() : 0);
                result = 31 * result + (this.requestTemplates != null ? this.requestTemplates.hashCode() : 0);
                result = 31 * result + (this.timeoutInMillis != null ? this.timeoutInMillis.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnMethod.IntegrationResponseProperty")
    @software.amazon.jsii.Jsii.Proxy(IntegrationResponseProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface IntegrationResponseProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMethod.IntegrationResponseProperty.StatusCode`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getStatusCode();

        /**
         * `CfnMethod.IntegrationResponseProperty.ContentHandling`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getContentHandling() {
            return null;
        }

        /**
         * `CfnMethod.IntegrationResponseProperty.ResponseParameters`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResponseParameters() {
            return null;
        }

        /**
         * `CfnMethod.IntegrationResponseProperty.ResponseTemplates`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResponseTemplates() {
            return null;
        }

        /**
         * `CfnMethod.IntegrationResponseProperty.SelectionPattern`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getSelectionPattern() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IntegrationResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntegrationResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String statusCode;
            private java.lang.String contentHandling;
            private java.lang.Object responseParameters;
            private java.lang.Object responseTemplates;
            private java.lang.String selectionPattern;

            /**
             * Sets the value of {@link IntegrationResponseProperty#getStatusCode}
             * @param statusCode `CfnMethod.IntegrationResponseProperty.StatusCode`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder statusCode(java.lang.String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationResponseProperty#getContentHandling}
             * @param contentHandling `CfnMethod.IntegrationResponseProperty.ContentHandling`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder contentHandling(java.lang.String contentHandling) {
                this.contentHandling = contentHandling;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationResponseProperty#getResponseParameters}
             * @param responseParameters `CfnMethod.IntegrationResponseProperty.ResponseParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder responseParameters(software.amazon.awscdk.core.IResolvable responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationResponseProperty#getResponseParameters}
             * @param responseParameters `CfnMethod.IntegrationResponseProperty.ResponseParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder responseParameters(java.util.Map<java.lang.String, java.lang.String> responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationResponseProperty#getResponseTemplates}
             * @param responseTemplates `CfnMethod.IntegrationResponseProperty.ResponseTemplates`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder responseTemplates(software.amazon.awscdk.core.IResolvable responseTemplates) {
                this.responseTemplates = responseTemplates;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationResponseProperty#getResponseTemplates}
             * @param responseTemplates `CfnMethod.IntegrationResponseProperty.ResponseTemplates`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder responseTemplates(java.util.Map<java.lang.String, java.lang.String> responseTemplates) {
                this.responseTemplates = responseTemplates;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationResponseProperty#getSelectionPattern}
             * @param selectionPattern `CfnMethod.IntegrationResponseProperty.SelectionPattern`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder selectionPattern(java.lang.String selectionPattern) {
                this.selectionPattern = selectionPattern;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntegrationResponseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public IntegrationResponseProperty build() {
                return new Jsii$Proxy(statusCode, contentHandling, responseParameters, responseTemplates, selectionPattern);
            }
        }

        /**
         * An implementation for {@link IntegrationResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegrationResponseProperty {
            private final java.lang.String statusCode;
            private final java.lang.String contentHandling;
            private final java.lang.Object responseParameters;
            private final java.lang.Object responseTemplates;
            private final java.lang.String selectionPattern;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statusCode = this.jsiiGet("statusCode", java.lang.String.class);
                this.contentHandling = this.jsiiGet("contentHandling", java.lang.String.class);
                this.responseParameters = this.jsiiGet("responseParameters", java.lang.Object.class);
                this.responseTemplates = this.jsiiGet("responseTemplates", java.lang.Object.class);
                this.selectionPattern = this.jsiiGet("selectionPattern", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String statusCode, final java.lang.String contentHandling, final java.lang.Object responseParameters, final java.lang.Object responseTemplates, final java.lang.String selectionPattern) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statusCode = java.util.Objects.requireNonNull(statusCode, "statusCode is required");
                this.contentHandling = contentHandling;
                this.responseParameters = responseParameters;
                this.responseTemplates = responseTemplates;
                this.selectionPattern = selectionPattern;
            }

            @Override
            public java.lang.String getStatusCode() {
                return this.statusCode;
            }

            @Override
            public java.lang.String getContentHandling() {
                return this.contentHandling;
            }

            @Override
            public java.lang.Object getResponseParameters() {
                return this.responseParameters;
            }

            @Override
            public java.lang.Object getResponseTemplates() {
                return this.responseTemplates;
            }

            @Override
            public java.lang.String getSelectionPattern() {
                return this.selectionPattern;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statusCode", om.valueToTree(this.getStatusCode()));
                if (this.getContentHandling() != null) {
                    data.set("contentHandling", om.valueToTree(this.getContentHandling()));
                }
                if (this.getResponseParameters() != null) {
                    data.set("responseParameters", om.valueToTree(this.getResponseParameters()));
                }
                if (this.getResponseTemplates() != null) {
                    data.set("responseTemplates", om.valueToTree(this.getResponseTemplates()));
                }
                if (this.getSelectionPattern() != null) {
                    data.set("selectionPattern", om.valueToTree(this.getSelectionPattern()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnMethod.IntegrationResponseProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntegrationResponseProperty.Jsii$Proxy that = (IntegrationResponseProperty.Jsii$Proxy) o;

                if (!statusCode.equals(that.statusCode)) return false;
                if (this.contentHandling != null ? !this.contentHandling.equals(that.contentHandling) : that.contentHandling != null) return false;
                if (this.responseParameters != null ? !this.responseParameters.equals(that.responseParameters) : that.responseParameters != null) return false;
                if (this.responseTemplates != null ? !this.responseTemplates.equals(that.responseTemplates) : that.responseTemplates != null) return false;
                return this.selectionPattern != null ? this.selectionPattern.equals(that.selectionPattern) : that.selectionPattern == null;
            }

            @Override
            public int hashCode() {
                int result = this.statusCode.hashCode();
                result = 31 * result + (this.contentHandling != null ? this.contentHandling.hashCode() : 0);
                result = 31 * result + (this.responseParameters != null ? this.responseParameters.hashCode() : 0);
                result = 31 * result + (this.responseTemplates != null ? this.responseTemplates.hashCode() : 0);
                result = 31 * result + (this.selectionPattern != null ? this.selectionPattern.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnMethod.MethodResponseProperty")
    @software.amazon.jsii.Jsii.Proxy(MethodResponseProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface MethodResponseProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMethod.MethodResponseProperty.StatusCode`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getStatusCode();

        /**
         * `CfnMethod.MethodResponseProperty.ResponseModels`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResponseModels() {
            return null;
        }

        /**
         * `CfnMethod.MethodResponseProperty.ResponseParameters`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResponseParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MethodResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MethodResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String statusCode;
            private java.lang.Object responseModels;
            private java.lang.Object responseParameters;

            /**
             * Sets the value of {@link MethodResponseProperty#getStatusCode}
             * @param statusCode `CfnMethod.MethodResponseProperty.StatusCode`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder statusCode(java.lang.String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            /**
             * Sets the value of {@link MethodResponseProperty#getResponseModels}
             * @param responseModels `CfnMethod.MethodResponseProperty.ResponseModels`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder responseModels(software.amazon.awscdk.core.IResolvable responseModels) {
                this.responseModels = responseModels;
                return this;
            }

            /**
             * Sets the value of {@link MethodResponseProperty#getResponseModels}
             * @param responseModels `CfnMethod.MethodResponseProperty.ResponseModels`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder responseModels(java.util.Map<java.lang.String, java.lang.String> responseModels) {
                this.responseModels = responseModels;
                return this;
            }

            /**
             * Sets the value of {@link MethodResponseProperty#getResponseParameters}
             * @param responseParameters `CfnMethod.MethodResponseProperty.ResponseParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder responseParameters(software.amazon.awscdk.core.IResolvable responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            /**
             * Sets the value of {@link MethodResponseProperty#getResponseParameters}
             * @param responseParameters `CfnMethod.MethodResponseProperty.ResponseParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder responseParameters(java.util.Map<java.lang.String, java.lang.Object> responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MethodResponseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public MethodResponseProperty build() {
                return new Jsii$Proxy(statusCode, responseModels, responseParameters);
            }
        }

        /**
         * An implementation for {@link MethodResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MethodResponseProperty {
            private final java.lang.String statusCode;
            private final java.lang.Object responseModels;
            private final java.lang.Object responseParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statusCode = this.jsiiGet("statusCode", java.lang.String.class);
                this.responseModels = this.jsiiGet("responseModels", java.lang.Object.class);
                this.responseParameters = this.jsiiGet("responseParameters", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String statusCode, final java.lang.Object responseModels, final java.lang.Object responseParameters) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statusCode = java.util.Objects.requireNonNull(statusCode, "statusCode is required");
                this.responseModels = responseModels;
                this.responseParameters = responseParameters;
            }

            @Override
            public java.lang.String getStatusCode() {
                return this.statusCode;
            }

            @Override
            public java.lang.Object getResponseModels() {
                return this.responseModels;
            }

            @Override
            public java.lang.Object getResponseParameters() {
                return this.responseParameters;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statusCode", om.valueToTree(this.getStatusCode()));
                if (this.getResponseModels() != null) {
                    data.set("responseModels", om.valueToTree(this.getResponseModels()));
                }
                if (this.getResponseParameters() != null) {
                    data.set("responseParameters", om.valueToTree(this.getResponseParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnMethod.MethodResponseProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MethodResponseProperty.Jsii$Proxy that = (MethodResponseProperty.Jsii$Proxy) o;

                if (!statusCode.equals(that.statusCode)) return false;
                if (this.responseModels != null ? !this.responseModels.equals(that.responseModels) : that.responseModels != null) return false;
                return this.responseParameters != null ? this.responseParameters.equals(that.responseParameters) : that.responseParameters == null;
            }

            @Override
            public int hashCode() {
                int result = this.statusCode.hashCode();
                result = 31 * result + (this.responseModels != null ? this.responseModels.hashCode() : 0);
                result = 31 * result + (this.responseParameters != null ? this.responseParameters.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.CfnMethod}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.CfnMethodProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.CfnMethodProps.Builder();
        }

        /**
         * `AWS::ApiGateway::Method.HttpMethod`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
         * @param httpMethod `AWS::ApiGateway::Method.HttpMethod`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder httpMethod(final java.lang.String httpMethod) {
            this.props.httpMethod(httpMethod);
            return this;
        }

        /**
         * `AWS::ApiGateway::Method.ResourceId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
         * @param resourceId `AWS::ApiGateway::Method.ResourceId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder resourceId(final java.lang.String resourceId) {
            this.props.resourceId(resourceId);
            return this;
        }

        /**
         * `AWS::ApiGateway::Method.RestApiId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
         * @param restApiId `AWS::ApiGateway::Method.RestApiId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder restApiId(final java.lang.String restApiId) {
            this.props.restApiId(restApiId);
            return this;
        }

        /**
         * `AWS::ApiGateway::Method.ApiKeyRequired`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
         * @param apiKeyRequired `AWS::ApiGateway::Method.ApiKeyRequired`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder apiKeyRequired(final java.lang.Boolean apiKeyRequired) {
            this.props.apiKeyRequired(apiKeyRequired);
            return this;
        }
        /**
         * `AWS::ApiGateway::Method.ApiKeyRequired`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
         * @param apiKeyRequired `AWS::ApiGateway::Method.ApiKeyRequired`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder apiKeyRequired(final software.amazon.awscdk.core.IResolvable apiKeyRequired) {
            this.props.apiKeyRequired(apiKeyRequired);
            return this;
        }

        /**
         * `AWS::ApiGateway::Method.AuthorizationScopes`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes
         * @param authorizationScopes `AWS::ApiGateway::Method.AuthorizationScopes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder authorizationScopes(final java.util.List<java.lang.String> authorizationScopes) {
            this.props.authorizationScopes(authorizationScopes);
            return this;
        }

        /**
         * `AWS::ApiGateway::Method.AuthorizationType`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
         * @param authorizationType `AWS::ApiGateway::Method.AuthorizationType`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder authorizationType(final java.lang.String authorizationType) {
            this.props.authorizationType(authorizationType);
            return this;
        }

        /**
         * `AWS::ApiGateway::Method.AuthorizerId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
         * @param authorizerId `AWS::ApiGateway::Method.AuthorizerId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder authorizerId(final java.lang.String authorizerId) {
            this.props.authorizerId(authorizerId);
            return this;
        }

        /**
         * `AWS::ApiGateway::Method.Integration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
         * @param integration `AWS::ApiGateway::Method.Integration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder integration(final software.amazon.awscdk.core.IResolvable integration) {
            this.props.integration(integration);
            return this;
        }
        /**
         * `AWS::ApiGateway::Method.Integration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
         * @param integration `AWS::ApiGateway::Method.Integration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder integration(final software.amazon.awscdk.services.apigateway.CfnMethod.IntegrationProperty integration) {
            this.props.integration(integration);
            return this;
        }

        /**
         * `AWS::ApiGateway::Method.MethodResponses`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
         * @param methodResponses `AWS::ApiGateway::Method.MethodResponses`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder methodResponses(final software.amazon.awscdk.core.IResolvable methodResponses) {
            this.props.methodResponses(methodResponses);
            return this;
        }
        /**
         * `AWS::ApiGateway::Method.MethodResponses`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
         * @param methodResponses `AWS::ApiGateway::Method.MethodResponses`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder methodResponses(final java.util.List<java.lang.Object> methodResponses) {
            this.props.methodResponses(methodResponses);
            return this;
        }

        /**
         * `AWS::ApiGateway::Method.OperationName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
         * @param operationName `AWS::ApiGateway::Method.OperationName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder operationName(final java.lang.String operationName) {
            this.props.operationName(operationName);
            return this;
        }

        /**
         * `AWS::ApiGateway::Method.RequestModels`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
         * @param requestModels `AWS::ApiGateway::Method.RequestModels`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder requestModels(final software.amazon.awscdk.core.IResolvable requestModels) {
            this.props.requestModels(requestModels);
            return this;
        }
        /**
         * `AWS::ApiGateway::Method.RequestModels`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
         * @param requestModels `AWS::ApiGateway::Method.RequestModels`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder requestModels(final java.util.Map<java.lang.String, java.lang.String> requestModels) {
            this.props.requestModels(requestModels);
            return this;
        }

        /**
         * `AWS::ApiGateway::Method.RequestParameters`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
         * @param requestParameters `AWS::ApiGateway::Method.RequestParameters`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder requestParameters(final software.amazon.awscdk.core.IResolvable requestParameters) {
            this.props.requestParameters(requestParameters);
            return this;
        }
        /**
         * `AWS::ApiGateway::Method.RequestParameters`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
         * @param requestParameters `AWS::ApiGateway::Method.RequestParameters`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder requestParameters(final java.util.Map<java.lang.String, java.lang.Object> requestParameters) {
            this.props.requestParameters(requestParameters);
            return this;
        }

        /**
         * `AWS::ApiGateway::Method.RequestValidatorId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
         * @param requestValidatorId `AWS::ApiGateway::Method.RequestValidatorId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder requestValidatorId(final java.lang.String requestValidatorId) {
            this.props.requestValidatorId(requestValidatorId);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.CfnMethod}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.apigateway.CfnMethod build() {
            return new software.amazon.awscdk.services.apigateway.CfnMethod(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
