package software.amazon.awscdk.services.apigateway;

/**
 * Properties for a VpcLink.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-05-27T11:34:37.123Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.VpcLinkProps")
@software.amazon.jsii.Jsii.Proxy(VpcLinkProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpcLinkProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The description of the VPC link.
     * <p>
     * Default: no description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The network load balancers of the VPC targeted by the VPC link.
     * <p>
     * The network load balancers must be owned by the same AWS account of the API owner.
     * <p>
     * Default: - no targets. Use `addTargets` to add targets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> getTargets() {
        return null;
    }

    /**
     * The name used to label and identify the VPC link.
     * <p>
     * Default: - automatically generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcLinkName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VpcLinkProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpcLinkProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String description;
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> targets;
        private java.lang.String vpcLinkName;

        /**
         * Sets the value of {@link VpcLinkProps#getDescription}
         * @param description The description of the VPC link.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link VpcLinkProps#getTargets}
         * @param targets The network load balancers of the VPC targeted by the VPC link.
         *                The network load balancers must be owned by the same AWS account of the API owner.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> targets) {
            this.targets = targets;
            return this;
        }

        /**
         * Sets the value of {@link VpcLinkProps#getVpcLinkName}
         * @param vpcLinkName The name used to label and identify the VPC link.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcLinkName(java.lang.String vpcLinkName) {
            this.vpcLinkName = vpcLinkName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcLinkProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public VpcLinkProps build() {
            return new Jsii$Proxy(description, targets, vpcLinkName);
        }
    }

    /**
     * An implementation for {@link VpcLinkProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcLinkProps {
        private final java.lang.String description;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> targets;
        private final java.lang.String vpcLinkName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.targets = this.jsiiGet("targets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer.class)));
            this.vpcLinkName = this.jsiiGet("vpcLinkName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String description, final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> targets, final java.lang.String vpcLinkName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = description;
            this.targets = targets;
            this.vpcLinkName = vpcLinkName;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> getTargets() {
            return this.targets;
        }

        @Override
        public java.lang.String getVpcLinkName() {
            return this.vpcLinkName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getTargets() != null) {
                data.set("targets", om.valueToTree(this.getTargets()));
            }
            if (this.getVpcLinkName() != null) {
                data.set("vpcLinkName", om.valueToTree(this.getVpcLinkName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.VpcLinkProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcLinkProps.Jsii$Proxy that = (VpcLinkProps.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.targets != null ? !this.targets.equals(that.targets) : that.targets != null) return false;
            return this.vpcLinkName != null ? this.vpcLinkName.equals(that.vpcLinkName) : that.vpcLinkName == null;
        }

        @Override
        public int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
            result = 31 * result + (this.vpcLinkName != null ? this.vpcLinkName.hashCode() : 0);
            return result;
        }
    }
}
