package software.amazon.awscdk.services.apigateway;

/**
 * Represents a REST API in Amazon API Gateway, created with an OpenAPI specification.
 * <p>
 * Some properties normally accessible on &#64;see {&#64;link RestApi} - such as the description -
 * must be declared in the specification. All Resources and Methods need to be defined as
 * part of the OpenAPI specification file, and cannot be added via the CDK.
 * <p>
 * By default, the API will automatically be deployed and accessible from a
 * public endpoint.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-06-01T16:52:53.617Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.SpecRestApi")
public class SpecRestApi extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.apigateway.IRestApi {

    protected SpecRestApi(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SpecRestApi(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SpecRestApi(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.SpecRestApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Defines an API Gateway domain name and maps it to this API.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param id The construct id. This parameter is required.
     * @param options custom domain options. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.DomainName addDomainName(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.DomainNameOptions options) {
        return this.jsiiCall("addDomainName", software.amazon.awscdk.services.apigateway.DomainName.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds a new gateway response.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.GatewayResponse addGatewayResponse(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.GatewayResponseOptions options) {
        return this.jsiiCall("addGatewayResponse", software.amazon.awscdk.services.apigateway.GatewayResponse.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds a usage plan.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.UsagePlan addUsagePlan(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.UsagePlanProps props) {
        return this.jsiiCall("addUsagePlan", software.amazon.awscdk.services.apigateway.UsagePlan.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Adds a usage plan.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.UsagePlan addUsagePlan(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return this.jsiiCall("addUsagePlan", software.amazon.awscdk.services.apigateway.UsagePlan.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Gets the "execute-api" ARN.
     * <p>
     * Default: "*" returns the execute API ARN for all methods/resources in
     * this API.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @return The "execute-api" ARN.
     * @param method The method (default `*`).
     * @param path The resource path.
     * @param stage The stage (default `*`).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi(final @org.jetbrains.annotations.Nullable java.lang.String method, final @org.jetbrains.annotations.Nullable java.lang.String path, final @org.jetbrains.annotations.Nullable java.lang.String stage) {
        return this.jsiiCall("arnForExecuteApi", java.lang.String.class, new Object[] { method, path, stage });
    }

    /**
     * Gets the "execute-api" ARN.
     * <p>
     * Default: "*" returns the execute API ARN for all methods/resources in
     * this API.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @return The "execute-api" ARN.
     * @param method The method (default `*`).
     * @param path The resource path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi(final @org.jetbrains.annotations.Nullable java.lang.String method, final @org.jetbrains.annotations.Nullable java.lang.String path) {
        return this.jsiiCall("arnForExecuteApi", java.lang.String.class, new Object[] { method, path });
    }

    /**
     * Gets the "execute-api" ARN.
     * <p>
     * Default: "*" returns the execute API ARN for all methods/resources in
     * this API.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @return The "execute-api" ARN.
     * @param method The method (default `*`).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi(final @org.jetbrains.annotations.Nullable java.lang.String method) {
        return this.jsiiCall("arnForExecuteApi", java.lang.String.class, new Object[] { method });
    }

    /**
     * Gets the "execute-api" ARN.
     * <p>
     * Default: "*" returns the execute API ARN for all methods/resources in
     * this API.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @return The "execute-api" ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi() {
        return this.jsiiCall("arnForExecuteApi", java.lang.String.class);
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param apiResource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void configureCloudWatchRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.CfnRestApi apiResource) {
        this.jsiiCall("configureCloudWatchRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(apiResource, "apiResource is required") });
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void configureDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.RestApiOptions props) {
        this.jsiiCall("configureDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns the URL for an HTTP path.
     * <p>
     * Fails if <code>deploymentStage</code> is not set either by <code>deploy</code> or explicitly.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param path
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String urlForPath(final @org.jetbrains.annotations.Nullable java.lang.String path) {
        return this.jsiiCall("urlForPath", java.lang.String.class, new Object[] { path });
    }

    /**
     * Returns the URL for an HTTP path.
     * <p>
     * Fails if <code>deploymentStage</code> is not set either by <code>deploy</code> or explicitly.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String urlForPath() {
        return this.jsiiCall("urlForPath", java.lang.String.class);
    }

    /**
     * The ID of this API Gateway RestApi.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRestApiId() {
        return this.jsiiGet("restApiId", java.lang.String.class);
    }

    /**
     * The resource ID of the root resource.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRestApiRootResourceId() {
        return this.jsiiGet("restApiRootResourceId", java.lang.String.class);
    }

    /**
     * The first domain name mapped to this API, if defined through the `domainName` configuration prop, or added via `addDomainName`.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.DomainName getDomainName() {
        return this.jsiiGet("domainName", software.amazon.awscdk.services.apigateway.DomainName.class);
    }

    /**
     * API Gateway deployment that represents the latest changes of the API.
     * <p>
     * This resource will be automatically updated every time the REST API model changes.
     * This will be undefined if <code>deploy</code> is false.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.Deployment getLatestDeployment() {
        return this.jsiiGet("latestDeployment", software.amazon.awscdk.services.apigateway.Deployment.class);
    }

    /**
     * API Gateway stage that points to the latest deployment (if defined).
     * <p>
     * If <code>deploy</code> is disabled, you will need to explicitly assign this value in order to
     * set up integrations.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.Stage getDeploymentStage() {
        return this.jsiiGet("deploymentStage", software.amazon.awscdk.services.apigateway.Stage.class);
    }

    /**
     * API Gateway stage that points to the latest deployment (if defined).
     * <p>
     * If <code>deploy</code> is disabled, you will need to explicitly assign this value in order to
     * set up integrations.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setDeploymentStage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.Stage value) {
        this.jsiiSet("deploymentStage", java.util.Objects.requireNonNull(value, "deploymentStage is required"));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.SpecRestApi}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        /**
         * EXPERIMENTAL
         * <p>
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.SpecRestApiProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.SpecRestApiProps.Builder();
        }

        /**
         * Adds a CORS preflight OPTIONS method to this resource and all child resources.
         * <p>
         * You can add CORS at the resource-level using <code>addCorsPreflight</code>.
         * <p>
         * Default: - CORS is disabled
         * <p>
         * @return {@code this}
         * @param defaultCorsPreflightOptions Adds a CORS preflight OPTIONS method to this resource and all child resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCorsPreflightOptions(final software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions) {
            this.props.defaultCorsPreflightOptions(defaultCorsPreflightOptions);
            return this;
        }

        /**
         * An integration to use as a default for all methods created within this API unless an integration is specified.
         * <p>
         * Default: - Inherited from parent.
         * <p>
         * @return {@code this}
         * @param defaultIntegration An integration to use as a default for all methods created within this API unless an integration is specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultIntegration(final software.amazon.awscdk.services.apigateway.Integration defaultIntegration) {
            this.props.defaultIntegration(defaultIntegration);
            return this;
        }

        /**
         * Method options to use as a default for all methods created within this API unless custom options are specified.
         * <p>
         * Default: - Inherited from parent.
         * <p>
         * @return {@code this}
         * @param defaultMethodOptions Method options to use as a default for all methods created within this API unless custom options are specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultMethodOptions(final software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions) {
            this.props.defaultMethodOptions(defaultMethodOptions);
            return this;
        }

        /**
         * Automatically configure an AWS CloudWatch role for API Gateway.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param cloudWatchRole Automatically configure an AWS CloudWatch role for API Gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchRole(final java.lang.Boolean cloudWatchRole) {
            this.props.cloudWatchRole(cloudWatchRole);
            return this;
        }

        /**
         * Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes.
         * <p>
         * Since API Gateway deployments are immutable, When this option is enabled
         * (by default), an AWS::ApiGateway::Deployment resource will automatically
         * created with a logical ID that hashes the API model (methods, resources
         * and options). This means that when the model changes, the logical ID of
         * this CloudFormation resource will change, and a new deployment will be
         * created.
         * <p>
         * If this is set, <code>latestDeployment</code> will refer to the <code>Deployment</code> object
         * and <code>deploymentStage</code> will refer to a <code>Stage</code> that points to this
         * deployment. To customize the stage options, use the <code>deployOptions</code>
         * property.
         * <p>
         * A CloudFormation Output will also be defined with the root URL endpoint
         * of this REST API.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param deploy Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploy(final java.lang.Boolean deploy) {
            this.props.deploy(deploy);
            return this;
        }

        /**
         * Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled.
         * <p>
         * If <code>deploy</code> is disabled,
         * this value cannot be set.
         * <p>
         * Default: - Based on defaults of `StageOptions`.
         * <p>
         * @return {@code this}
         * @param deployOptions Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployOptions(final software.amazon.awscdk.services.apigateway.StageOptions deployOptions) {
            this.props.deployOptions(deployOptions);
            return this;
        }

        /**
         * Configure a custom domain name and map it to this API.
         * <p>
         * Default: - no domain name is defined, use `addDomainName` or directly define a `DomainName`.
         * <p>
         * @return {@code this}
         * @param domainName Configure a custom domain name and map it to this API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final software.amazon.awscdk.services.apigateway.DomainNameOptions domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * Export name for the CfnOutput containing the API endpoint.
         * <p>
         * Default: - when no export name is given, output will be created without export
         * <p>
         * @return {@code this}
         * @param endpointExportName Export name for the CfnOutput containing the API endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointExportName(final java.lang.String endpointExportName) {
            this.props.endpointExportName(endpointExportName);
            return this;
        }

        /**
         * Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param failOnWarnings Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(final java.lang.Boolean failOnWarnings) {
            this.props.failOnWarnings(failOnWarnings);
            return this;
        }

        /**
         * Custom header parameters for the request.
         * <p>
         * Default: - No parameters.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html
         * @param parameters Custom header parameters for the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * A policy document that contains the permissions for this RestApi.
         * <p>
         * Default: - No policy.
         * <p>
         * @return {@code this}
         * @param policy A policy document that contains the permissions for this RestApi. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(final software.amazon.awscdk.services.iam.PolicyDocument policy) {
            this.props.policy(policy);
            return this;
        }

        /**
         * A name for the API Gateway RestApi resource.
         * <p>
         * Default: - ID of the RestApi construct.
         * <p>
         * @return {@code this}
         * @param restApiName A name for the API Gateway RestApi resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiName(final java.lang.String restApiName) {
            this.props.restApiName(restApiName);
            return this;
        }

        /**
         * Retains old deployment resources when the API changes.
         * <p>
         * This allows
         * manually reverting stages to point to old deployments via the AWS
         * Console.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param retainDeployments Retains old deployment resources when the API changes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainDeployments(final java.lang.Boolean retainDeployments) {
            this.props.retainDeployments(retainDeployments);
            return this;
        }

        /**
         * An OpenAPI definition compatible with API Gateway.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api.html
         * @param apiDefinition An OpenAPI definition compatible with API Gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder apiDefinition(final software.amazon.awscdk.services.apigateway.ApiDefinition apiDefinition) {
            this.props.apiDefinition(apiDefinition);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.SpecRestApi}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.apigateway.SpecRestApi build() {
            return new software.amazon.awscdk.services.apigateway.SpecRestApi(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
