/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.apigateway.$Module;
import software.amazon.awscdk.services.apigateway.ApiDefinition;
import software.amazon.awscdk.services.apigateway.CfnRestApi;
import software.amazon.awscdk.services.apigateway.CorsOptions;
import software.amazon.awscdk.services.apigateway.Deployment;
import software.amazon.awscdk.services.apigateway.DomainName;
import software.amazon.awscdk.services.apigateway.DomainNameOptions;
import software.amazon.awscdk.services.apigateway.GatewayResponse;
import software.amazon.awscdk.services.apigateway.GatewayResponseOptions;
import software.amazon.awscdk.services.apigateway.IRestApi;
import software.amazon.awscdk.services.apigateway.Integration;
import software.amazon.awscdk.services.apigateway.MethodOptions;
import software.amazon.awscdk.services.apigateway.RestApiOptions;
import software.amazon.awscdk.services.apigateway.SpecRestApiProps;
import software.amazon.awscdk.services.apigateway.Stage;
import software.amazon.awscdk.services.apigateway.StageOptions;
import software.amazon.awscdk.services.apigateway.UsagePlan;
import software.amazon.awscdk.services.apigateway.UsagePlanProps;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-apigateway.SpecRestApi")
public class SpecRestApi
extends Resource
implements IRestApi {
    protected SpecRestApi(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SpecRestApi(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public SpecRestApi(@NotNull Construct scope, @NotNull String id, @NotNull SpecRestApiProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public DomainName addDomainName(@NotNull String id, @NotNull DomainNameOptions options) {
        return (DomainName)this.jsiiCall("addDomainName", DomainName.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public GatewayResponse addGatewayResponse(@NotNull String id, @NotNull GatewayResponseOptions options) {
        return (GatewayResponse)this.jsiiCall("addGatewayResponse", GatewayResponse.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public UsagePlan addUsagePlan(@NotNull String id, @Nullable UsagePlanProps props) {
        return (UsagePlan)((Object)this.jsiiCall("addUsagePlan", UsagePlan.class, new Object[]{Objects.requireNonNull(id, "id is required"), props}));
    }

    @NotNull
    public UsagePlan addUsagePlan(@NotNull String id) {
        return (UsagePlan)((Object)this.jsiiCall("addUsagePlan", UsagePlan.class, new Object[]{Objects.requireNonNull(id, "id is required")}));
    }

    @NotNull
    public String arnForExecuteApi(@Nullable String method, @Nullable String path, @Nullable String stage) {
        return (String)this.jsiiCall("arnForExecuteApi", String.class, new Object[]{method, path, stage});
    }

    @NotNull
    public String arnForExecuteApi(@Nullable String method, @Nullable String path) {
        return (String)this.jsiiCall("arnForExecuteApi", String.class, new Object[]{method, path});
    }

    @NotNull
    public String arnForExecuteApi(@Nullable String method) {
        return (String)this.jsiiCall("arnForExecuteApi", String.class, new Object[]{method});
    }

    @NotNull
    public String arnForExecuteApi() {
        return (String)this.jsiiCall("arnForExecuteApi", String.class, new Object[0]);
    }

    protected void configureCloudWatchRole(@NotNull CfnRestApi apiResource) {
        this.jsiiCall("configureCloudWatchRole", NativeType.VOID, new Object[]{Objects.requireNonNull(apiResource, "apiResource is required")});
    }

    protected void configureDeployment(@NotNull RestApiOptions props) {
        this.jsiiCall("configureDeployment", NativeType.VOID, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public String urlForPath(@Nullable String path) {
        return (String)this.jsiiCall("urlForPath", String.class, new Object[]{path});
    }

    @NotNull
    public String urlForPath() {
        return (String)this.jsiiCall("urlForPath", String.class, new Object[0]);
    }

    @Override
    @NotNull
    public String getRestApiId() {
        return (String)this.jsiiGet("restApiId", String.class);
    }

    @NotNull
    public String getRestApiRootResourceId() {
        return (String)this.jsiiGet("restApiRootResourceId", String.class);
    }

    @Nullable
    public DomainName getDomainName() {
        return (DomainName)this.jsiiGet("domainName", DomainName.class);
    }

    @Nullable
    public Deployment getLatestDeployment() {
        return (Deployment)((Object)this.jsiiGet("latestDeployment", Deployment.class));
    }

    @NotNull
    public Stage getDeploymentStage() {
        return (Stage)this.jsiiGet("deploymentStage", Stage.class);
    }

    public void setDeploymentStage(@NotNull Stage value) {
        this.jsiiSet("deploymentStage", Objects.requireNonNull(value, "deploymentStage is required"));
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final SpecRestApiProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new SpecRestApiProps.Builder();
        }

        public Builder defaultCorsPreflightOptions(CorsOptions defaultCorsPreflightOptions) {
            this.props.defaultCorsPreflightOptions(defaultCorsPreflightOptions);
            return this;
        }

        public Builder defaultIntegration(Integration defaultIntegration) {
            this.props.defaultIntegration(defaultIntegration);
            return this;
        }

        public Builder defaultMethodOptions(MethodOptions defaultMethodOptions) {
            this.props.defaultMethodOptions(defaultMethodOptions);
            return this;
        }

        public Builder cloudWatchRole(Boolean cloudWatchRole) {
            this.props.cloudWatchRole(cloudWatchRole);
            return this;
        }

        public Builder deploy(Boolean deploy) {
            this.props.deploy(deploy);
            return this;
        }

        public Builder deployOptions(StageOptions deployOptions) {
            this.props.deployOptions(deployOptions);
            return this;
        }

        public Builder domainName(DomainNameOptions domainName) {
            this.props.domainName(domainName);
            return this;
        }

        public Builder endpointExportName(String endpointExportName) {
            this.props.endpointExportName(endpointExportName);
            return this;
        }

        public Builder failOnWarnings(Boolean failOnWarnings) {
            this.props.failOnWarnings(failOnWarnings);
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        public Builder policy(PolicyDocument policy) {
            this.props.policy(policy);
            return this;
        }

        public Builder restApiName(String restApiName) {
            this.props.restApiName(restApiName);
            return this;
        }

        public Builder retainDeployments(Boolean retainDeployments) {
            this.props.retainDeployments(retainDeployments);
            return this;
        }

        public Builder apiDefinition(ApiDefinition apiDefinition) {
            this.props.apiDefinition(apiDefinition);
            return this;
        }

        public SpecRestApi build() {
            return new SpecRestApi(this.scope, this.id, this.props.build());
        }
    }
}

