package software.amazon.awscdk.services.apigateway;

/**
 * Result of binding an Integration to a Method.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-28T21:12:36.473Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.IntegrationConfig")
@software.amazon.jsii.Jsii.Proxy(IntegrationConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IntegrationConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies an API method integration type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IntegrationType getType();

    /**
     * This value is included in computing the Deployment's fingerprint.
     * <p>
     * When the fingerprint
     * changes, a new deployment is triggered.
     * This property should contain values associated with the Integration that upon changing
     * should trigger a fresh the Deployment needs to be refreshed.
     * <p>
     * Default: undefined deployments are not triggered for any change to this integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeploymentToken() {
        return null;
    }

    /**
     * The integration's HTTP method type.
     * <p>
     * Default: - no integration method specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIntegrationHttpMethod() {
        return null;
    }

    /**
     * Integration options.
     * <p>
     * Default: - no integration options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions() {
        return null;
    }

    /**
     * The Uniform Resource Identifier (URI) for the integration.
     * <p>
     * Default: - no URI. Usually applies to MOCK integration
     * <p>
     * @see https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#uri
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUri() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link IntegrationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IntegrationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IntegrationConfig> {
        private software.amazon.awscdk.services.apigateway.IntegrationType type;
        private java.lang.String deploymentToken;
        private java.lang.String integrationHttpMethod;
        private software.amazon.awscdk.services.apigateway.IntegrationOptions options;
        private java.lang.String uri;

        /**
         * Sets the value of {@link IntegrationConfig#getType}
         * @param type Specifies an API method integration type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.apigateway.IntegrationType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationConfig#getDeploymentToken}
         * @param deploymentToken This value is included in computing the Deployment's fingerprint.
         *                        When the fingerprint
         *                        changes, a new deployment is triggered.
         *                        This property should contain values associated with the Integration that upon changing
         *                        should trigger a fresh the Deployment needs to be refreshed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentToken(java.lang.String deploymentToken) {
            this.deploymentToken = deploymentToken;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationConfig#getIntegrationHttpMethod}
         * @param integrationHttpMethod The integration's HTTP method type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationHttpMethod(java.lang.String integrationHttpMethod) {
            this.integrationHttpMethod = integrationHttpMethod;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationConfig#getOptions}
         * @param options Integration options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(software.amazon.awscdk.services.apigateway.IntegrationOptions options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationConfig#getUri}
         * @param uri The Uniform Resource Identifier (URI) for the integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uri(java.lang.String uri) {
            this.uri = uri;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IntegrationConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IntegrationConfig build() {
            return new Jsii$Proxy(type, deploymentToken, integrationHttpMethod, options, uri);
        }
    }

    /**
     * An implementation for {@link IntegrationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegrationConfig {
        private final software.amazon.awscdk.services.apigateway.IntegrationType type;
        private final java.lang.String deploymentToken;
        private final java.lang.String integrationHttpMethod;
        private final software.amazon.awscdk.services.apigateway.IntegrationOptions options;
        private final java.lang.String uri;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = this.jsiiGet("type", software.amazon.awscdk.services.apigateway.IntegrationType.class);
            this.deploymentToken = this.jsiiGet("deploymentToken", java.lang.String.class);
            this.integrationHttpMethod = this.jsiiGet("integrationHttpMethod", java.lang.String.class);
            this.options = this.jsiiGet("options", software.amazon.awscdk.services.apigateway.IntegrationOptions.class);
            this.uri = this.jsiiGet("uri", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.apigateway.IntegrationType type, final java.lang.String deploymentToken, final java.lang.String integrationHttpMethod, final software.amazon.awscdk.services.apigateway.IntegrationOptions options, final java.lang.String uri) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(type, "type is required");
            this.deploymentToken = deploymentToken;
            this.integrationHttpMethod = integrationHttpMethod;
            this.options = options;
            this.uri = uri;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.IntegrationType getType() {
            return this.type;
        }

        @Override
        public java.lang.String getDeploymentToken() {
            return this.deploymentToken;
        }

        @Override
        public java.lang.String getIntegrationHttpMethod() {
            return this.integrationHttpMethod;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions() {
            return this.options;
        }

        @Override
        public java.lang.String getUri() {
            return this.uri;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getDeploymentToken() != null) {
                data.set("deploymentToken", om.valueToTree(this.getDeploymentToken()));
            }
            if (this.getIntegrationHttpMethod() != null) {
                data.set("integrationHttpMethod", om.valueToTree(this.getIntegrationHttpMethod()));
            }
            if (this.getOptions() != null) {
                data.set("options", om.valueToTree(this.getOptions()));
            }
            if (this.getUri() != null) {
                data.set("uri", om.valueToTree(this.getUri()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.IntegrationConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IntegrationConfig.Jsii$Proxy that = (IntegrationConfig.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.deploymentToken != null ? !this.deploymentToken.equals(that.deploymentToken) : that.deploymentToken != null) return false;
            if (this.integrationHttpMethod != null ? !this.integrationHttpMethod.equals(that.integrationHttpMethod) : that.integrationHttpMethod != null) return false;
            if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
            return this.uri != null ? this.uri.equals(that.uri) : that.uri == null;
        }

        @Override
        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.deploymentToken != null ? this.deploymentToken.hashCode() : 0);
            result = 31 * result + (this.integrationHttpMethod != null ? this.integrationHttpMethod.hashCode() : 0);
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
            return result;
        }
    }
}
