package software.amazon.awscdk.services.apigateway;

/**
 * Props to create a new instance of RestApi.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-28T21:12:36.513Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.RestApiProps")
@software.amazon.jsii.Jsii.Proxy(RestApiProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RestApiProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.RestApiOptions {

    /**
     * The source of the API key for metering requests according to a usage plan.
     * <p>
     * Default: - Metering is disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.ApiKeySourceType getApiKeySourceType() {
        return null;
    }

    /**
     * The list of binary media mime-types that are supported by the RestApi resource, such as "image/png" or "application/octet-stream".
     * <p>
     * Default: - RestApi supports only UTF-8-encoded text payloads.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBinaryMediaTypes() {
        return null;
    }

    /**
     * The ID of the API Gateway RestApi resource that you want to clone.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.IRestApi getCloneFrom() {
        return null;
    }

    /**
     * A description of the purpose of this API Gateway RestApi resource.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The EndpointConfiguration property type specifies the endpoint types of a REST API.
     * <p>
     * Default: - No endpoint configuration
     * <p>
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.EndpointConfiguration getEndpointConfiguration() {
        return null;
    }

    /**
     * A list of the endpoint types of the API.
     * <p>
     * Use this property when creating
     * an API.
     * <p>
     * Default: - No endpoint types.
     * <p>
     * @deprecated this property is deprecated, use endpointConfiguration instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> getEndpointTypes() {
        return null;
    }

    /**
     * A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (when undefined) on an API.
     * <p>
     * When compression is enabled, compression or
     * decompression is not applied on the payload if the payload size is
     * smaller than this value. Setting it to zero allows compression for any
     * payload size.
     * <p>
     * Default: - Compression is disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinimumCompressionSize() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RestApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RestApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RestApiProps> {
        private software.amazon.awscdk.services.apigateway.ApiKeySourceType apiKeySourceType;
        private java.util.List<java.lang.String> binaryMediaTypes;
        private software.amazon.awscdk.services.apigateway.IRestApi cloneFrom;
        private java.lang.String description;
        private software.amazon.awscdk.services.apigateway.EndpointConfiguration endpointConfiguration;
        private java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> endpointTypes;
        private java.lang.Number minimumCompressionSize;
        private java.lang.Boolean cloudWatchRole;
        private java.lang.Boolean deploy;
        private software.amazon.awscdk.services.apigateway.StageOptions deployOptions;
        private software.amazon.awscdk.services.apigateway.DomainNameOptions domainName;
        private java.lang.String endpointExportName;
        private java.lang.Boolean failOnWarnings;
        private java.util.Map<java.lang.String, java.lang.String> parameters;
        private software.amazon.awscdk.services.iam.PolicyDocument policy;
        private java.lang.String restApiName;
        private java.lang.Boolean retainDeployments;
        private software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions;
        private software.amazon.awscdk.services.apigateway.Integration defaultIntegration;
        private software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions;

        /**
         * Sets the value of {@link RestApiProps#getApiKeySourceType}
         * @param apiKeySourceType The source of the API key for metering requests according to a usage plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeySourceType(software.amazon.awscdk.services.apigateway.ApiKeySourceType apiKeySourceType) {
            this.apiKeySourceType = apiKeySourceType;
            return this;
        }

        /**
         * Sets the value of {@link RestApiProps#getBinaryMediaTypes}
         * @param binaryMediaTypes The list of binary media mime-types that are supported by the RestApi resource, such as "image/png" or "application/octet-stream".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder binaryMediaTypes(java.util.List<java.lang.String> binaryMediaTypes) {
            this.binaryMediaTypes = binaryMediaTypes;
            return this;
        }

        /**
         * Sets the value of {@link RestApiProps#getCloneFrom}
         * @param cloneFrom The ID of the API Gateway RestApi resource that you want to clone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloneFrom(software.amazon.awscdk.services.apigateway.IRestApi cloneFrom) {
            this.cloneFrom = cloneFrom;
            return this;
        }

        /**
         * Sets the value of {@link RestApiProps#getDescription}
         * @param description A description of the purpose of this API Gateway RestApi resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link RestApiProps#getEndpointConfiguration}
         * @param endpointConfiguration The EndpointConfiguration property type specifies the endpoint types of a REST API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfiguration(software.amazon.awscdk.services.apigateway.EndpointConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link RestApiProps#getEndpointTypes}
         * @param endpointTypes A list of the endpoint types of the API.
         *                      Use this property when creating
         *                      an API.
         * @return {@code this}
         * @deprecated this property is deprecated, use endpointConfiguration instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder endpointTypes(java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> endpointTypes) {
            this.endpointTypes = endpointTypes;
            return this;
        }

        /**
         * Sets the value of {@link RestApiProps#getMinimumCompressionSize}
         * @param minimumCompressionSize A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (when undefined) on an API.
         *                               When compression is enabled, compression or
         *                               decompression is not applied on the payload if the payload size is
         *                               smaller than this value. Setting it to zero allows compression for any
         *                               payload size.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumCompressionSize(java.lang.Number minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
            return this;
        }

        /**
         * Sets the value of {@link RestApiProps#getCloudWatchRole}
         * @param cloudWatchRole Automatically configure an AWS CloudWatch role for API Gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchRole(java.lang.Boolean cloudWatchRole) {
            this.cloudWatchRole = cloudWatchRole;
            return this;
        }

        /**
         * Sets the value of {@link RestApiProps#getDeploy}
         * @param deploy Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes.
         *               Since API Gateway deployments are immutable, When this option is enabled
         *               (by default), an AWS::ApiGateway::Deployment resource will automatically
         *               created with a logical ID that hashes the API model (methods, resources
         *               and options). This means that when the model changes, the logical ID of
         *               this CloudFormation resource will change, and a new deployment will be
         *               created.
         *               <p>
         *               If this is set, <code>latestDeployment</code> will refer to the <code>Deployment</code> object
         *               and <code>deploymentStage</code> will refer to a <code>Stage</code> that points to this
         *               deployment. To customize the stage options, use the <code>deployOptions</code>
         *               property.
         *               <p>
         *               A CloudFormation Output will also be defined with the root URL endpoint
         *               of this REST API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploy(java.lang.Boolean deploy) {
            this.deploy = deploy;
            return this;
        }

        /**
         * Sets the value of {@link RestApiProps#getDeployOptions}
         * @param deployOptions Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled.
         *                      If <code>deploy</code> is disabled,
         *                      this value cannot be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployOptions(software.amazon.awscdk.services.apigateway.StageOptions deployOptions) {
            this.deployOptions = deployOptions;
            return this;
        }

        /**
         * Sets the value of {@link RestApiProps#getDomainName}
         * @param domainName Configure a custom domain name and map it to this API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(software.amazon.awscdk.services.apigateway.DomainNameOptions domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link RestApiProps#getEndpointExportName}
         * @param endpointExportName Export name for the CfnOutput containing the API endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointExportName(java.lang.String endpointExportName) {
            this.endpointExportName = endpointExportName;
            return this;
        }

        /**
         * Sets the value of {@link RestApiProps#getFailOnWarnings}
         * @param failOnWarnings Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(java.lang.Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        /**
         * Sets the value of {@link RestApiProps#getParameters}
         * @param parameters Custom header parameters for the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link RestApiProps#getPolicy}
         * @param policy A policy document that contains the permissions for this RestApi.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(software.amazon.awscdk.services.iam.PolicyDocument policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of {@link RestApiProps#getRestApiName}
         * @param restApiName A name for the API Gateway RestApi resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiName(java.lang.String restApiName) {
            this.restApiName = restApiName;
            return this;
        }

        /**
         * Sets the value of {@link RestApiProps#getRetainDeployments}
         * @param retainDeployments Retains old deployment resources when the API changes.
         *                          This allows
         *                          manually reverting stages to point to old deployments via the AWS
         *                          Console.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainDeployments(java.lang.Boolean retainDeployments) {
            this.retainDeployments = retainDeployments;
            return this;
        }

        /**
         * Sets the value of {@link RestApiProps#getDefaultCorsPreflightOptions}
         * @param defaultCorsPreflightOptions Adds a CORS preflight OPTIONS method to this resource and all child resources.
         *                                    You can add CORS at the resource-level using <code>addCorsPreflight</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCorsPreflightOptions(software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions) {
            this.defaultCorsPreflightOptions = defaultCorsPreflightOptions;
            return this;
        }

        /**
         * Sets the value of {@link RestApiProps#getDefaultIntegration}
         * @param defaultIntegration An integration to use as a default for all methods created within this API unless an integration is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultIntegration(software.amazon.awscdk.services.apigateway.Integration defaultIntegration) {
            this.defaultIntegration = defaultIntegration;
            return this;
        }

        /**
         * Sets the value of {@link RestApiProps#getDefaultMethodOptions}
         * @param defaultMethodOptions Method options to use as a default for all methods created within this API unless custom options are specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultMethodOptions(software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions) {
            this.defaultMethodOptions = defaultMethodOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RestApiProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RestApiProps build() {
            return new Jsii$Proxy(apiKeySourceType, binaryMediaTypes, cloneFrom, description, endpointConfiguration, endpointTypes, minimumCompressionSize, cloudWatchRole, deploy, deployOptions, domainName, endpointExportName, failOnWarnings, parameters, policy, restApiName, retainDeployments, defaultCorsPreflightOptions, defaultIntegration, defaultMethodOptions);
        }
    }

    /**
     * An implementation for {@link RestApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RestApiProps {
        private final software.amazon.awscdk.services.apigateway.ApiKeySourceType apiKeySourceType;
        private final java.util.List<java.lang.String> binaryMediaTypes;
        private final software.amazon.awscdk.services.apigateway.IRestApi cloneFrom;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.apigateway.EndpointConfiguration endpointConfiguration;
        private final java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> endpointTypes;
        private final java.lang.Number minimumCompressionSize;
        private final java.lang.Boolean cloudWatchRole;
        private final java.lang.Boolean deploy;
        private final software.amazon.awscdk.services.apigateway.StageOptions deployOptions;
        private final software.amazon.awscdk.services.apigateway.DomainNameOptions domainName;
        private final java.lang.String endpointExportName;
        private final java.lang.Boolean failOnWarnings;
        private final java.util.Map<java.lang.String, java.lang.String> parameters;
        private final software.amazon.awscdk.services.iam.PolicyDocument policy;
        private final java.lang.String restApiName;
        private final java.lang.Boolean retainDeployments;
        private final software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions;
        private final software.amazon.awscdk.services.apigateway.Integration defaultIntegration;
        private final software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiKeySourceType = this.jsiiGet("apiKeySourceType", software.amazon.awscdk.services.apigateway.ApiKeySourceType.class);
            this.binaryMediaTypes = this.jsiiGet("binaryMediaTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cloneFrom = this.jsiiGet("cloneFrom", software.amazon.awscdk.services.apigateway.IRestApi.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.endpointConfiguration = this.jsiiGet("endpointConfiguration", software.amazon.awscdk.services.apigateway.EndpointConfiguration.class);
            this.endpointTypes = this.jsiiGet("endpointTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.EndpointType.class)));
            this.minimumCompressionSize = this.jsiiGet("minimumCompressionSize", java.lang.Number.class);
            this.cloudWatchRole = this.jsiiGet("cloudWatchRole", java.lang.Boolean.class);
            this.deploy = this.jsiiGet("deploy", java.lang.Boolean.class);
            this.deployOptions = this.jsiiGet("deployOptions", software.amazon.awscdk.services.apigateway.StageOptions.class);
            this.domainName = this.jsiiGet("domainName", software.amazon.awscdk.services.apigateway.DomainNameOptions.class);
            this.endpointExportName = this.jsiiGet("endpointExportName", java.lang.String.class);
            this.failOnWarnings = this.jsiiGet("failOnWarnings", java.lang.Boolean.class);
            this.parameters = this.jsiiGet("parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.policy = this.jsiiGet("policy", software.amazon.awscdk.services.iam.PolicyDocument.class);
            this.restApiName = this.jsiiGet("restApiName", java.lang.String.class);
            this.retainDeployments = this.jsiiGet("retainDeployments", java.lang.Boolean.class);
            this.defaultCorsPreflightOptions = this.jsiiGet("defaultCorsPreflightOptions", software.amazon.awscdk.services.apigateway.CorsOptions.class);
            this.defaultIntegration = this.jsiiGet("defaultIntegration", software.amazon.awscdk.services.apigateway.Integration.class);
            this.defaultMethodOptions = this.jsiiGet("defaultMethodOptions", software.amazon.awscdk.services.apigateway.MethodOptions.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.apigateway.ApiKeySourceType apiKeySourceType, final java.util.List<java.lang.String> binaryMediaTypes, final software.amazon.awscdk.services.apigateway.IRestApi cloneFrom, final java.lang.String description, final software.amazon.awscdk.services.apigateway.EndpointConfiguration endpointConfiguration, final java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> endpointTypes, final java.lang.Number minimumCompressionSize, final java.lang.Boolean cloudWatchRole, final java.lang.Boolean deploy, final software.amazon.awscdk.services.apigateway.StageOptions deployOptions, final software.amazon.awscdk.services.apigateway.DomainNameOptions domainName, final java.lang.String endpointExportName, final java.lang.Boolean failOnWarnings, final java.util.Map<java.lang.String, java.lang.String> parameters, final software.amazon.awscdk.services.iam.PolicyDocument policy, final java.lang.String restApiName, final java.lang.Boolean retainDeployments, final software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions, final software.amazon.awscdk.services.apigateway.Integration defaultIntegration, final software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiKeySourceType = apiKeySourceType;
            this.binaryMediaTypes = binaryMediaTypes;
            this.cloneFrom = cloneFrom;
            this.description = description;
            this.endpointConfiguration = endpointConfiguration;
            this.endpointTypes = endpointTypes;
            this.minimumCompressionSize = minimumCompressionSize;
            this.cloudWatchRole = cloudWatchRole;
            this.deploy = deploy;
            this.deployOptions = deployOptions;
            this.domainName = domainName;
            this.endpointExportName = endpointExportName;
            this.failOnWarnings = failOnWarnings;
            this.parameters = parameters;
            this.policy = policy;
            this.restApiName = restApiName;
            this.retainDeployments = retainDeployments;
            this.defaultCorsPreflightOptions = defaultCorsPreflightOptions;
            this.defaultIntegration = defaultIntegration;
            this.defaultMethodOptions = defaultMethodOptions;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.ApiKeySourceType getApiKeySourceType() {
            return this.apiKeySourceType;
        }

        @Override
        public java.util.List<java.lang.String> getBinaryMediaTypes() {
            return this.binaryMediaTypes;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.IRestApi getCloneFrom() {
            return this.cloneFrom;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.EndpointConfiguration getEndpointConfiguration() {
            return this.endpointConfiguration;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> getEndpointTypes() {
            return this.endpointTypes;
        }

        @Override
        public java.lang.Number getMinimumCompressionSize() {
            return this.minimumCompressionSize;
        }

        @Override
        public java.lang.Boolean getCloudWatchRole() {
            return this.cloudWatchRole;
        }

        @Override
        public java.lang.Boolean getDeploy() {
            return this.deploy;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.StageOptions getDeployOptions() {
            return this.deployOptions;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.DomainNameOptions getDomainName() {
            return this.domainName;
        }

        @Override
        public java.lang.String getEndpointExportName() {
            return this.endpointExportName;
        }

        @Override
        public java.lang.Boolean getFailOnWarnings() {
            return this.failOnWarnings;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getParameters() {
            return this.parameters;
        }

        @Override
        public software.amazon.awscdk.services.iam.PolicyDocument getPolicy() {
            return this.policy;
        }

        @Override
        public java.lang.String getRestApiName() {
            return this.restApiName;
        }

        @Override
        public java.lang.Boolean getRetainDeployments() {
            return this.retainDeployments;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.CorsOptions getDefaultCorsPreflightOptions() {
            return this.defaultCorsPreflightOptions;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.Integration getDefaultIntegration() {
            return this.defaultIntegration;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.MethodOptions getDefaultMethodOptions() {
            return this.defaultMethodOptions;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApiKeySourceType() != null) {
                data.set("apiKeySourceType", om.valueToTree(this.getApiKeySourceType()));
            }
            if (this.getBinaryMediaTypes() != null) {
                data.set("binaryMediaTypes", om.valueToTree(this.getBinaryMediaTypes()));
            }
            if (this.getCloneFrom() != null) {
                data.set("cloneFrom", om.valueToTree(this.getCloneFrom()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEndpointConfiguration() != null) {
                data.set("endpointConfiguration", om.valueToTree(this.getEndpointConfiguration()));
            }
            if (this.getEndpointTypes() != null) {
                data.set("endpointTypes", om.valueToTree(this.getEndpointTypes()));
            }
            if (this.getMinimumCompressionSize() != null) {
                data.set("minimumCompressionSize", om.valueToTree(this.getMinimumCompressionSize()));
            }
            if (this.getCloudWatchRole() != null) {
                data.set("cloudWatchRole", om.valueToTree(this.getCloudWatchRole()));
            }
            if (this.getDeploy() != null) {
                data.set("deploy", om.valueToTree(this.getDeploy()));
            }
            if (this.getDeployOptions() != null) {
                data.set("deployOptions", om.valueToTree(this.getDeployOptions()));
            }
            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getEndpointExportName() != null) {
                data.set("endpointExportName", om.valueToTree(this.getEndpointExportName()));
            }
            if (this.getFailOnWarnings() != null) {
                data.set("failOnWarnings", om.valueToTree(this.getFailOnWarnings()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getPolicy() != null) {
                data.set("policy", om.valueToTree(this.getPolicy()));
            }
            if (this.getRestApiName() != null) {
                data.set("restApiName", om.valueToTree(this.getRestApiName()));
            }
            if (this.getRetainDeployments() != null) {
                data.set("retainDeployments", om.valueToTree(this.getRetainDeployments()));
            }
            if (this.getDefaultCorsPreflightOptions() != null) {
                data.set("defaultCorsPreflightOptions", om.valueToTree(this.getDefaultCorsPreflightOptions()));
            }
            if (this.getDefaultIntegration() != null) {
                data.set("defaultIntegration", om.valueToTree(this.getDefaultIntegration()));
            }
            if (this.getDefaultMethodOptions() != null) {
                data.set("defaultMethodOptions", om.valueToTree(this.getDefaultMethodOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.RestApiProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RestApiProps.Jsii$Proxy that = (RestApiProps.Jsii$Proxy) o;

            if (this.apiKeySourceType != null ? !this.apiKeySourceType.equals(that.apiKeySourceType) : that.apiKeySourceType != null) return false;
            if (this.binaryMediaTypes != null ? !this.binaryMediaTypes.equals(that.binaryMediaTypes) : that.binaryMediaTypes != null) return false;
            if (this.cloneFrom != null ? !this.cloneFrom.equals(that.cloneFrom) : that.cloneFrom != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.endpointConfiguration != null ? !this.endpointConfiguration.equals(that.endpointConfiguration) : that.endpointConfiguration != null) return false;
            if (this.endpointTypes != null ? !this.endpointTypes.equals(that.endpointTypes) : that.endpointTypes != null) return false;
            if (this.minimumCompressionSize != null ? !this.minimumCompressionSize.equals(that.minimumCompressionSize) : that.minimumCompressionSize != null) return false;
            if (this.cloudWatchRole != null ? !this.cloudWatchRole.equals(that.cloudWatchRole) : that.cloudWatchRole != null) return false;
            if (this.deploy != null ? !this.deploy.equals(that.deploy) : that.deploy != null) return false;
            if (this.deployOptions != null ? !this.deployOptions.equals(that.deployOptions) : that.deployOptions != null) return false;
            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.endpointExportName != null ? !this.endpointExportName.equals(that.endpointExportName) : that.endpointExportName != null) return false;
            if (this.failOnWarnings != null ? !this.failOnWarnings.equals(that.failOnWarnings) : that.failOnWarnings != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.policy != null ? !this.policy.equals(that.policy) : that.policy != null) return false;
            if (this.restApiName != null ? !this.restApiName.equals(that.restApiName) : that.restApiName != null) return false;
            if (this.retainDeployments != null ? !this.retainDeployments.equals(that.retainDeployments) : that.retainDeployments != null) return false;
            if (this.defaultCorsPreflightOptions != null ? !this.defaultCorsPreflightOptions.equals(that.defaultCorsPreflightOptions) : that.defaultCorsPreflightOptions != null) return false;
            if (this.defaultIntegration != null ? !this.defaultIntegration.equals(that.defaultIntegration) : that.defaultIntegration != null) return false;
            return this.defaultMethodOptions != null ? this.defaultMethodOptions.equals(that.defaultMethodOptions) : that.defaultMethodOptions == null;
        }

        @Override
        public int hashCode() {
            int result = this.apiKeySourceType != null ? this.apiKeySourceType.hashCode() : 0;
            result = 31 * result + (this.binaryMediaTypes != null ? this.binaryMediaTypes.hashCode() : 0);
            result = 31 * result + (this.cloneFrom != null ? this.cloneFrom.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.endpointConfiguration != null ? this.endpointConfiguration.hashCode() : 0);
            result = 31 * result + (this.endpointTypes != null ? this.endpointTypes.hashCode() : 0);
            result = 31 * result + (this.minimumCompressionSize != null ? this.minimumCompressionSize.hashCode() : 0);
            result = 31 * result + (this.cloudWatchRole != null ? this.cloudWatchRole.hashCode() : 0);
            result = 31 * result + (this.deploy != null ? this.deploy.hashCode() : 0);
            result = 31 * result + (this.deployOptions != null ? this.deployOptions.hashCode() : 0);
            result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
            result = 31 * result + (this.endpointExportName != null ? this.endpointExportName.hashCode() : 0);
            result = 31 * result + (this.failOnWarnings != null ? this.failOnWarnings.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
            result = 31 * result + (this.restApiName != null ? this.restApiName.hashCode() : 0);
            result = 31 * result + (this.retainDeployments != null ? this.retainDeployments.hashCode() : 0);
            result = 31 * result + (this.defaultCorsPreflightOptions != null ? this.defaultCorsPreflightOptions.hashCode() : 0);
            result = 31 * result + (this.defaultIntegration != null ? this.defaultIntegration.hashCode() : 0);
            result = 31 * result + (this.defaultMethodOptions != null ? this.defaultMethodOptions.hashCode() : 0);
            return result;
        }
    }
}
