package software.amazon.awscdk.services.apigateway;

/**
 * Base implementation that are common to various implementations of IRestApi.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-12T19:02:38.514Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.RestApiBase")
public abstract class RestApiBase extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.apigateway.IRestApi {

    protected RestApiBase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RestApiBase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected RestApiBase(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.RestApiBaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected RestApiBase(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines an API Gateway domain name and maps it to this API.
     * <p>
     * @param id The construct id. This parameter is required.
     * @param options custom domain options. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.DomainName addDomainName(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.DomainNameOptions options) {
        return this.jsiiCall("addDomainName", software.amazon.awscdk.services.apigateway.DomainName.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds a new gateway response.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.GatewayResponse addGatewayResponse(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.GatewayResponseOptions options) {
        return this.jsiiCall("addGatewayResponse", software.amazon.awscdk.services.apigateway.GatewayResponse.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds a usage plan.
     * <p>
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.UsagePlan addUsagePlan(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.UsagePlanProps props) {
        return this.jsiiCall("addUsagePlan", software.amazon.awscdk.services.apigateway.UsagePlan.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Adds a usage plan.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.UsagePlan addUsagePlan(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return this.jsiiCall("addUsagePlan", software.amazon.awscdk.services.apigateway.UsagePlan.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Gets the "execute-api" ARN.
     * <p>
     * @param method
     * @param path
     * @param stage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi(final @org.jetbrains.annotations.Nullable java.lang.String method, final @org.jetbrains.annotations.Nullable java.lang.String path, final @org.jetbrains.annotations.Nullable java.lang.String stage) {
        return this.jsiiCall("arnForExecuteApi", java.lang.String.class, new Object[] { method, path, stage });
    }

    /**
     * Gets the "execute-api" ARN.
     * <p>
     * @param method
     * @param path
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi(final @org.jetbrains.annotations.Nullable java.lang.String method, final @org.jetbrains.annotations.Nullable java.lang.String path) {
        return this.jsiiCall("arnForExecuteApi", java.lang.String.class, new Object[] { method, path });
    }

    /**
     * Gets the "execute-api" ARN.
     * <p>
     * @param method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi(final @org.jetbrains.annotations.Nullable java.lang.String method) {
        return this.jsiiCall("arnForExecuteApi", java.lang.String.class, new Object[] { method });
    }

    /**
     * Gets the "execute-api" ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi() {
        return this.jsiiCall("arnForExecuteApi", java.lang.String.class);
    }

    /**
     * @param apiResource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void configureCloudWatchRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.CfnRestApi apiResource) {
        this.jsiiCall("configureCloudWatchRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(apiResource, "apiResource is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void configureDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.RestApiOptions props) {
        this.jsiiCall("configureDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns the URL for an HTTP path.
     * <p>
     * Fails if <code>deploymentStage</code> is not set either by <code>deploy</code> or explicitly.
     * <p>
     * @param path
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String urlForPath(final @org.jetbrains.annotations.Nullable java.lang.String path) {
        return this.jsiiCall("urlForPath", java.lang.String.class, new Object[] { path });
    }

    /**
     * Returns the URL for an HTTP path.
     * <p>
     * Fails if <code>deploymentStage</code> is not set either by <code>deploy</code> or explicitly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String urlForPath() {
        return this.jsiiCall("urlForPath", java.lang.String.class);
    }

    /**
     * The ID of this API Gateway RestApi.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getRestApiId();

    /**
     * The resource ID of the root resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getRestApiRootResourceId();

    /**
     * Represents the root resource of this API endpoint ('/').
     * <p>
     * Resources and Methods are added to this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IResource getRoot();

    /**
     * The first domain name mapped to this API, if defined through the `domainName` configuration prop, or added via `addDomainName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.DomainName getDomainName() {
        return this.jsiiGet("domainName", software.amazon.awscdk.services.apigateway.DomainName.class);
    }

    /**
     * API Gateway deployment that represents the latest changes of the API.
     * <p>
     * This resource will be automatically updated every time the REST API model changes.
     * This will be undefined if <code>deploy</code> is false.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.Deployment getLatestDeployment() {
        return this.jsiiGet("latestDeployment", software.amazon.awscdk.services.apigateway.Deployment.class);
    }

    /**
     * API Gateway stage that points to the latest deployment (if defined).
     * <p>
     * If <code>deploy</code> is disabled, you will need to explicitly assign this value in order to
     * set up integrations.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.Stage getDeploymentStage() {
        return this.jsiiGet("deploymentStage", software.amazon.awscdk.services.apigateway.Stage.class);
    }

    /**
     * API Gateway stage that points to the latest deployment (if defined).
     * <p>
     * If <code>deploy</code> is disabled, you will need to explicitly assign this value in order to
     * set up integrations.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentStage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.Stage value) {
        this.jsiiSet("deploymentStage", java.util.Objects.requireNonNull(value, "deploymentStage is required"));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.apigateway.RestApiBase {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The ID of this API Gateway RestApi.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getRestApiId() {
            return this.jsiiGet("restApiId", java.lang.String.class);
        }

        /**
         * The resource ID of the root resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getRestApiRootResourceId() {
            return this.jsiiGet("restApiRootResourceId", java.lang.String.class);
        }

        /**
         * Represents the root resource ("/") of this API. Use it to define the API model:.
         * <p>
         * api.root.addMethod('ANY', redirectToHomePage); // "ANY /"
         * api.root.addResource('friends').addMethod('GET', getFriendsHandler); // "GET /friends"
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IResource getRoot() {
            return this.jsiiGet("root", software.amazon.awscdk.services.apigateway.IResource.class);
        }

        /**
         * API Gateway deployment that represents the latest changes of the API.
         * <p>
         * This resource will be automatically updated every time the REST API model changes.
         * <code>undefined</code> when no deployment is configured.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.Deployment getLatestDeployment() {
            return this.jsiiGet("latestDeployment", software.amazon.awscdk.services.apigateway.Deployment.class);
        }

        /**
         * API Gateway stage that points to the latest deployment (if defined).
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.Stage getDeploymentStage() {
            return this.jsiiGet("deploymentStage", software.amazon.awscdk.services.apigateway.Stage.class);
        }

        /**
         * API Gateway stage that points to the latest deployment (if defined).
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public void setDeploymentStage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.Stage value) {
            this.jsiiSet("deploymentStage", java.util.Objects.requireNonNull(value, "deploymentStage is required"));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
        }

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }

        /**
         * Gets the "execute-api" ARN.
         * <p>
         * Default: "*" returns the execute API ARN for all methods/resources in
         * this API.
         * <p>
         * @return The "execute-api" ARN.
         * @param method The method (default `*`).
         * @param path The resource path.
         * @param stage The stage (default `*`).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi(final @org.jetbrains.annotations.Nullable java.lang.String method, final @org.jetbrains.annotations.Nullable java.lang.String path, final @org.jetbrains.annotations.Nullable java.lang.String stage) {
            return this.jsiiCall("arnForExecuteApi", java.lang.String.class, new Object[] { method, path, stage });
        }

        /**
         * Gets the "execute-api" ARN.
         * <p>
         * Default: "*" returns the execute API ARN for all methods/resources in
         * this API.
         * <p>
         * @return The "execute-api" ARN.
         * @param method The method (default `*`).
         * @param path The resource path.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi(final @org.jetbrains.annotations.Nullable java.lang.String method, final @org.jetbrains.annotations.Nullable java.lang.String path) {
            return this.jsiiCall("arnForExecuteApi", java.lang.String.class, new Object[] { method, path });
        }

        /**
         * Gets the "execute-api" ARN.
         * <p>
         * Default: "*" returns the execute API ARN for all methods/resources in
         * this API.
         * <p>
         * @return The "execute-api" ARN.
         * @param method The method (default `*`).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi(final @org.jetbrains.annotations.Nullable java.lang.String method) {
            return this.jsiiCall("arnForExecuteApi", java.lang.String.class, new Object[] { method });
        }

        /**
         * Gets the "execute-api" ARN.
         * <p>
         * Default: "*" returns the execute API ARN for all methods/resources in
         * this API.
         * <p>
         * @return The "execute-api" ARN.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi() {
            return this.jsiiCall("arnForExecuteApi", java.lang.String.class);
        }
    }
}
