package software.amazon.awscdk.services.apigateway;

/**
 * Represents the props that all Rest APIs share.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-12T19:02:38.515Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.RestApiBaseProps")
@software.amazon.jsii.Jsii.Proxy(RestApiBaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RestApiBaseProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Automatically configure an AWS CloudWatch role for API Gateway.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCloudWatchRole() {
        return null;
    }

    /**
     * Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes.
     * <p>
     * Since API Gateway deployments are immutable, When this option is enabled
     * (by default), an AWS::ApiGateway::Deployment resource will automatically
     * created with a logical ID that hashes the API model (methods, resources
     * and options). This means that when the model changes, the logical ID of
     * this CloudFormation resource will change, and a new deployment will be
     * created.
     * <p>
     * If this is set, <code>latestDeployment</code> will refer to the <code>Deployment</code> object
     * and <code>deploymentStage</code> will refer to a <code>Stage</code> that points to this
     * deployment. To customize the stage options, use the <code>deployOptions</code>
     * property.
     * <p>
     * A CloudFormation Output will also be defined with the root URL endpoint
     * of this REST API.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDeploy() {
        return null;
    }

    /**
     * Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled.
     * <p>
     * If <code>deploy</code> is disabled,
     * this value cannot be set.
     * <p>
     * Default: - Based on defaults of `StageOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.StageOptions getDeployOptions() {
        return null;
    }

    /**
     * Configure a custom domain name and map it to this API.
     * <p>
     * Default: - no domain name is defined, use `addDomainName` or directly define a `DomainName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.DomainNameOptions getDomainName() {
        return null;
    }

    /**
     * Export name for the CfnOutput containing the API endpoint.
     * <p>
     * Default: - when no export name is given, output will be created without export
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndpointExportName() {
        return null;
    }

    /**
     * A list of the endpoint types of the API.
     * <p>
     * Use this property when creating
     * an API.
     * <p>
     * Default: EndpointType.EDGE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> getEndpointTypes() {
        return null;
    }

    /**
     * Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getFailOnWarnings() {
        return null;
    }

    /**
     * Custom header parameters for the request.
     * <p>
     * Default: - No parameters.
     * <p>
     * @see https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getParameters() {
        return null;
    }

    /**
     * A policy document that contains the permissions for this RestApi.
     * <p>
     * Default: - No policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocument getPolicy() {
        return null;
    }

    /**
     * A name for the API Gateway RestApi resource.
     * <p>
     * Default: - ID of the RestApi construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRestApiName() {
        return null;
    }

    /**
     * Retains old deployment resources when the API changes.
     * <p>
     * This allows
     * manually reverting stages to point to old deployments via the AWS
     * Console.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRetainDeployments() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RestApiBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RestApiBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RestApiBaseProps> {
        private java.lang.Boolean cloudWatchRole;
        private java.lang.Boolean deploy;
        private software.amazon.awscdk.services.apigateway.StageOptions deployOptions;
        private software.amazon.awscdk.services.apigateway.DomainNameOptions domainName;
        private java.lang.String endpointExportName;
        private java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> endpointTypes;
        private java.lang.Boolean failOnWarnings;
        private java.util.Map<java.lang.String, java.lang.String> parameters;
        private software.amazon.awscdk.services.iam.PolicyDocument policy;
        private java.lang.String restApiName;
        private java.lang.Boolean retainDeployments;

        /**
         * Sets the value of {@link RestApiBaseProps#getCloudWatchRole}
         * @param cloudWatchRole Automatically configure an AWS CloudWatch role for API Gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchRole(java.lang.Boolean cloudWatchRole) {
            this.cloudWatchRole = cloudWatchRole;
            return this;
        }

        /**
         * Sets the value of {@link RestApiBaseProps#getDeploy}
         * @param deploy Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes.
         *               Since API Gateway deployments are immutable, When this option is enabled
         *               (by default), an AWS::ApiGateway::Deployment resource will automatically
         *               created with a logical ID that hashes the API model (methods, resources
         *               and options). This means that when the model changes, the logical ID of
         *               this CloudFormation resource will change, and a new deployment will be
         *               created.
         *               <p>
         *               If this is set, <code>latestDeployment</code> will refer to the <code>Deployment</code> object
         *               and <code>deploymentStage</code> will refer to a <code>Stage</code> that points to this
         *               deployment. To customize the stage options, use the <code>deployOptions</code>
         *               property.
         *               <p>
         *               A CloudFormation Output will also be defined with the root URL endpoint
         *               of this REST API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploy(java.lang.Boolean deploy) {
            this.deploy = deploy;
            return this;
        }

        /**
         * Sets the value of {@link RestApiBaseProps#getDeployOptions}
         * @param deployOptions Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled.
         *                      If <code>deploy</code> is disabled,
         *                      this value cannot be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployOptions(software.amazon.awscdk.services.apigateway.StageOptions deployOptions) {
            this.deployOptions = deployOptions;
            return this;
        }

        /**
         * Sets the value of {@link RestApiBaseProps#getDomainName}
         * @param domainName Configure a custom domain name and map it to this API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(software.amazon.awscdk.services.apigateway.DomainNameOptions domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link RestApiBaseProps#getEndpointExportName}
         * @param endpointExportName Export name for the CfnOutput containing the API endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointExportName(java.lang.String endpointExportName) {
            this.endpointExportName = endpointExportName;
            return this;
        }

        /**
         * Sets the value of {@link RestApiBaseProps#getEndpointTypes}
         * @param endpointTypes A list of the endpoint types of the API.
         *                      Use this property when creating
         *                      an API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointTypes(java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> endpointTypes) {
            this.endpointTypes = endpointTypes;
            return this;
        }

        /**
         * Sets the value of {@link RestApiBaseProps#getFailOnWarnings}
         * @param failOnWarnings Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(java.lang.Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        /**
         * Sets the value of {@link RestApiBaseProps#getParameters}
         * @param parameters Custom header parameters for the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link RestApiBaseProps#getPolicy}
         * @param policy A policy document that contains the permissions for this RestApi.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(software.amazon.awscdk.services.iam.PolicyDocument policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of {@link RestApiBaseProps#getRestApiName}
         * @param restApiName A name for the API Gateway RestApi resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiName(java.lang.String restApiName) {
            this.restApiName = restApiName;
            return this;
        }

        /**
         * Sets the value of {@link RestApiBaseProps#getRetainDeployments}
         * @param retainDeployments Retains old deployment resources when the API changes.
         *                          This allows
         *                          manually reverting stages to point to old deployments via the AWS
         *                          Console.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainDeployments(java.lang.Boolean retainDeployments) {
            this.retainDeployments = retainDeployments;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RestApiBaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RestApiBaseProps build() {
            return new Jsii$Proxy(cloudWatchRole, deploy, deployOptions, domainName, endpointExportName, endpointTypes, failOnWarnings, parameters, policy, restApiName, retainDeployments);
        }
    }

    /**
     * An implementation for {@link RestApiBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RestApiBaseProps {
        private final java.lang.Boolean cloudWatchRole;
        private final java.lang.Boolean deploy;
        private final software.amazon.awscdk.services.apigateway.StageOptions deployOptions;
        private final software.amazon.awscdk.services.apigateway.DomainNameOptions domainName;
        private final java.lang.String endpointExportName;
        private final java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> endpointTypes;
        private final java.lang.Boolean failOnWarnings;
        private final java.util.Map<java.lang.String, java.lang.String> parameters;
        private final software.amazon.awscdk.services.iam.PolicyDocument policy;
        private final java.lang.String restApiName;
        private final java.lang.Boolean retainDeployments;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cloudWatchRole = this.jsiiGet("cloudWatchRole", java.lang.Boolean.class);
            this.deploy = this.jsiiGet("deploy", java.lang.Boolean.class);
            this.deployOptions = this.jsiiGet("deployOptions", software.amazon.awscdk.services.apigateway.StageOptions.class);
            this.domainName = this.jsiiGet("domainName", software.amazon.awscdk.services.apigateway.DomainNameOptions.class);
            this.endpointExportName = this.jsiiGet("endpointExportName", java.lang.String.class);
            this.endpointTypes = this.jsiiGet("endpointTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.EndpointType.class)));
            this.failOnWarnings = this.jsiiGet("failOnWarnings", java.lang.Boolean.class);
            this.parameters = this.jsiiGet("parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.policy = this.jsiiGet("policy", software.amazon.awscdk.services.iam.PolicyDocument.class);
            this.restApiName = this.jsiiGet("restApiName", java.lang.String.class);
            this.retainDeployments = this.jsiiGet("retainDeployments", java.lang.Boolean.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Boolean cloudWatchRole, final java.lang.Boolean deploy, final software.amazon.awscdk.services.apigateway.StageOptions deployOptions, final software.amazon.awscdk.services.apigateway.DomainNameOptions domainName, final java.lang.String endpointExportName, final java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> endpointTypes, final java.lang.Boolean failOnWarnings, final java.util.Map<java.lang.String, java.lang.String> parameters, final software.amazon.awscdk.services.iam.PolicyDocument policy, final java.lang.String restApiName, final java.lang.Boolean retainDeployments) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cloudWatchRole = cloudWatchRole;
            this.deploy = deploy;
            this.deployOptions = deployOptions;
            this.domainName = domainName;
            this.endpointExportName = endpointExportName;
            this.endpointTypes = endpointTypes;
            this.failOnWarnings = failOnWarnings;
            this.parameters = parameters;
            this.policy = policy;
            this.restApiName = restApiName;
            this.retainDeployments = retainDeployments;
        }

        @Override
        public java.lang.Boolean getCloudWatchRole() {
            return this.cloudWatchRole;
        }

        @Override
        public java.lang.Boolean getDeploy() {
            return this.deploy;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.StageOptions getDeployOptions() {
            return this.deployOptions;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.DomainNameOptions getDomainName() {
            return this.domainName;
        }

        @Override
        public java.lang.String getEndpointExportName() {
            return this.endpointExportName;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> getEndpointTypes() {
            return this.endpointTypes;
        }

        @Override
        public java.lang.Boolean getFailOnWarnings() {
            return this.failOnWarnings;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getParameters() {
            return this.parameters;
        }

        @Override
        public software.amazon.awscdk.services.iam.PolicyDocument getPolicy() {
            return this.policy;
        }

        @Override
        public java.lang.String getRestApiName() {
            return this.restApiName;
        }

        @Override
        public java.lang.Boolean getRetainDeployments() {
            return this.retainDeployments;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCloudWatchRole() != null) {
                data.set("cloudWatchRole", om.valueToTree(this.getCloudWatchRole()));
            }
            if (this.getDeploy() != null) {
                data.set("deploy", om.valueToTree(this.getDeploy()));
            }
            if (this.getDeployOptions() != null) {
                data.set("deployOptions", om.valueToTree(this.getDeployOptions()));
            }
            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getEndpointExportName() != null) {
                data.set("endpointExportName", om.valueToTree(this.getEndpointExportName()));
            }
            if (this.getEndpointTypes() != null) {
                data.set("endpointTypes", om.valueToTree(this.getEndpointTypes()));
            }
            if (this.getFailOnWarnings() != null) {
                data.set("failOnWarnings", om.valueToTree(this.getFailOnWarnings()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getPolicy() != null) {
                data.set("policy", om.valueToTree(this.getPolicy()));
            }
            if (this.getRestApiName() != null) {
                data.set("restApiName", om.valueToTree(this.getRestApiName()));
            }
            if (this.getRetainDeployments() != null) {
                data.set("retainDeployments", om.valueToTree(this.getRetainDeployments()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.RestApiBaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RestApiBaseProps.Jsii$Proxy that = (RestApiBaseProps.Jsii$Proxy) o;

            if (this.cloudWatchRole != null ? !this.cloudWatchRole.equals(that.cloudWatchRole) : that.cloudWatchRole != null) return false;
            if (this.deploy != null ? !this.deploy.equals(that.deploy) : that.deploy != null) return false;
            if (this.deployOptions != null ? !this.deployOptions.equals(that.deployOptions) : that.deployOptions != null) return false;
            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.endpointExportName != null ? !this.endpointExportName.equals(that.endpointExportName) : that.endpointExportName != null) return false;
            if (this.endpointTypes != null ? !this.endpointTypes.equals(that.endpointTypes) : that.endpointTypes != null) return false;
            if (this.failOnWarnings != null ? !this.failOnWarnings.equals(that.failOnWarnings) : that.failOnWarnings != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.policy != null ? !this.policy.equals(that.policy) : that.policy != null) return false;
            if (this.restApiName != null ? !this.restApiName.equals(that.restApiName) : that.restApiName != null) return false;
            return this.retainDeployments != null ? this.retainDeployments.equals(that.retainDeployments) : that.retainDeployments == null;
        }

        @Override
        public int hashCode() {
            int result = this.cloudWatchRole != null ? this.cloudWatchRole.hashCode() : 0;
            result = 31 * result + (this.deploy != null ? this.deploy.hashCode() : 0);
            result = 31 * result + (this.deployOptions != null ? this.deployOptions.hashCode() : 0);
            result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
            result = 31 * result + (this.endpointExportName != null ? this.endpointExportName.hashCode() : 0);
            result = 31 * result + (this.endpointTypes != null ? this.endpointTypes.hashCode() : 0);
            result = 31 * result + (this.failOnWarnings != null ? this.failOnWarnings.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
            result = 31 * result + (this.restApiName != null ? this.restApiName.hashCode() : 0);
            result = 31 * result + (this.retainDeployments != null ? this.retainDeployments.hashCode() : 0);
            return result;
        }
    }
}
