package software.amazon.awscdk.services.apigateway;

/**
 * A CloudFormation `AWS::ApiGateway::Deployment`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-14T23:36:16.853Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnDeployment")
public class CfnDeployment extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnDeployment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDeployment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnDeployment.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ApiGateway::Deployment`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.CfnDeploymentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::ApiGateway::Deployment.RestApiId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-restapiid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRestApiId() {
        return this.jsiiGet("restApiId", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Deployment.RestApiId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-restapiid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestApiId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("restApiId", java.util.Objects.requireNonNull(value, "restApiId is required"));
    }

    /**
     * `AWS::ApiGateway::Deployment.DeploymentCanarySettings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-deploymentcanarysettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentCanarySettings() {
        return this.jsiiGet("deploymentCanarySettings", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Deployment.DeploymentCanarySettings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-deploymentcanarysettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentCanarySettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("deploymentCanarySettings", value);
    }

    /**
     * `AWS::ApiGateway::Deployment.DeploymentCanarySettings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-deploymentcanarysettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentCanarySettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CfnDeployment.DeploymentCanarySettingsProperty value) {
        this.jsiiSet("deploymentCanarySettings", value);
    }

    /**
     * `AWS::ApiGateway::Deployment.Description`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Deployment.Description`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("description", value);
    }

    /**
     * `AWS::ApiGateway::Deployment.StageDescription`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagedescription
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStageDescription() {
        return this.jsiiGet("stageDescription", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Deployment.StageDescription`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagedescription
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStageDescription(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("stageDescription", value);
    }

    /**
     * `AWS::ApiGateway::Deployment.StageDescription`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagedescription
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStageDescription(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CfnDeployment.StageDescriptionProperty value) {
        this.jsiiSet("stageDescription", value);
    }

    /**
     * `AWS::ApiGateway::Deployment.StageName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStageName() {
        return this.jsiiGet("stageName", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Deployment.StageName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStageName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("stageName", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-accesslogsetting.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnDeployment.AccessLogSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessLogSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessLogSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeployment.AccessLogSettingProperty.DestinationArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-accesslogsetting.html#cfn-apigateway-deployment-accesslogsetting-destinationarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationArn() {
            return null;
        }

        /**
         * `CfnDeployment.AccessLogSettingProperty.Format`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-accesslogsetting.html#cfn-apigateway-deployment-accesslogsetting-format
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccessLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccessLogSettingProperty> {
            private java.lang.String destinationArn;
            private java.lang.String format;

            /**
             * Sets the value of {@link AccessLogSettingProperty#getDestinationArn}
             * @param destinationArn `CfnDeployment.AccessLogSettingProperty.DestinationArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationArn(java.lang.String destinationArn) {
                this.destinationArn = destinationArn;
                return this;
            }

            /**
             * Sets the value of {@link AccessLogSettingProperty#getFormat}
             * @param format `CfnDeployment.AccessLogSettingProperty.Format`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessLogSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccessLogSettingProperty build() {
                return new Jsii$Proxy(destinationArn, format);
            }
        }

        /**
         * An implementation for {@link AccessLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessLogSettingProperty {
            private final java.lang.String destinationArn;
            private final java.lang.String format;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationArn = this.jsiiGet("destinationArn", java.lang.String.class);
                this.format = this.jsiiGet("format", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String destinationArn, final java.lang.String format) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationArn = destinationArn;
                this.format = format;
            }

            @Override
            public java.lang.String getDestinationArn() {
                return this.destinationArn;
            }

            @Override
            public java.lang.String getFormat() {
                return this.format;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinationArn() != null) {
                    data.set("destinationArn", om.valueToTree(this.getDestinationArn()));
                }
                if (this.getFormat() != null) {
                    data.set("format", om.valueToTree(this.getFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnDeployment.AccessLogSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessLogSettingProperty.Jsii$Proxy that = (AccessLogSettingProperty.Jsii$Proxy) o;

                if (this.destinationArn != null ? !this.destinationArn.equals(that.destinationArn) : that.destinationArn != null) return false;
                return this.format != null ? this.format.equals(that.format) : that.format == null;
            }

            @Override
            public int hashCode() {
                int result = this.destinationArn != null ? this.destinationArn.hashCode() : 0;
                result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnDeployment.CanarySettingProperty")
    @software.amazon.jsii.Jsii.Proxy(CanarySettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CanarySettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeployment.CanarySettingProperty.PercentTraffic`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html#cfn-apigateway-deployment-canarysetting-percenttraffic
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPercentTraffic() {
            return null;
        }

        /**
         * `CfnDeployment.CanarySettingProperty.StageVariableOverrides`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html#cfn-apigateway-deployment-canarysetting-stagevariableoverrides
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStageVariableOverrides() {
            return null;
        }

        /**
         * `CfnDeployment.CanarySettingProperty.UseStageCache`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html#cfn-apigateway-deployment-canarysetting-usestagecache
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseStageCache() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CanarySettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CanarySettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CanarySettingProperty> {
            private java.lang.Number percentTraffic;
            private java.lang.Object stageVariableOverrides;
            private java.lang.Object useStageCache;

            /**
             * Sets the value of {@link CanarySettingProperty#getPercentTraffic}
             * @param percentTraffic `CfnDeployment.CanarySettingProperty.PercentTraffic`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder percentTraffic(java.lang.Number percentTraffic) {
                this.percentTraffic = percentTraffic;
                return this;
            }

            /**
             * Sets the value of {@link CanarySettingProperty#getStageVariableOverrides}
             * @param stageVariableOverrides `CfnDeployment.CanarySettingProperty.StageVariableOverrides`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stageVariableOverrides(software.amazon.awscdk.core.IResolvable stageVariableOverrides) {
                this.stageVariableOverrides = stageVariableOverrides;
                return this;
            }

            /**
             * Sets the value of {@link CanarySettingProperty#getStageVariableOverrides}
             * @param stageVariableOverrides `CfnDeployment.CanarySettingProperty.StageVariableOverrides`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stageVariableOverrides(java.util.Map<java.lang.String, java.lang.String> stageVariableOverrides) {
                this.stageVariableOverrides = stageVariableOverrides;
                return this;
            }

            /**
             * Sets the value of {@link CanarySettingProperty#getUseStageCache}
             * @param useStageCache `CfnDeployment.CanarySettingProperty.UseStageCache`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useStageCache(java.lang.Boolean useStageCache) {
                this.useStageCache = useStageCache;
                return this;
            }

            /**
             * Sets the value of {@link CanarySettingProperty#getUseStageCache}
             * @param useStageCache `CfnDeployment.CanarySettingProperty.UseStageCache`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useStageCache(software.amazon.awscdk.core.IResolvable useStageCache) {
                this.useStageCache = useStageCache;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CanarySettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CanarySettingProperty build() {
                return new Jsii$Proxy(percentTraffic, stageVariableOverrides, useStageCache);
            }
        }

        /**
         * An implementation for {@link CanarySettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CanarySettingProperty {
            private final java.lang.Number percentTraffic;
            private final java.lang.Object stageVariableOverrides;
            private final java.lang.Object useStageCache;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.percentTraffic = this.jsiiGet("percentTraffic", java.lang.Number.class);
                this.stageVariableOverrides = this.jsiiGet("stageVariableOverrides", java.lang.Object.class);
                this.useStageCache = this.jsiiGet("useStageCache", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number percentTraffic, final java.lang.Object stageVariableOverrides, final java.lang.Object useStageCache) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.percentTraffic = percentTraffic;
                this.stageVariableOverrides = stageVariableOverrides;
                this.useStageCache = useStageCache;
            }

            @Override
            public java.lang.Number getPercentTraffic() {
                return this.percentTraffic;
            }

            @Override
            public java.lang.Object getStageVariableOverrides() {
                return this.stageVariableOverrides;
            }

            @Override
            public java.lang.Object getUseStageCache() {
                return this.useStageCache;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPercentTraffic() != null) {
                    data.set("percentTraffic", om.valueToTree(this.getPercentTraffic()));
                }
                if (this.getStageVariableOverrides() != null) {
                    data.set("stageVariableOverrides", om.valueToTree(this.getStageVariableOverrides()));
                }
                if (this.getUseStageCache() != null) {
                    data.set("useStageCache", om.valueToTree(this.getUseStageCache()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnDeployment.CanarySettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CanarySettingProperty.Jsii$Proxy that = (CanarySettingProperty.Jsii$Proxy) o;

                if (this.percentTraffic != null ? !this.percentTraffic.equals(that.percentTraffic) : that.percentTraffic != null) return false;
                if (this.stageVariableOverrides != null ? !this.stageVariableOverrides.equals(that.stageVariableOverrides) : that.stageVariableOverrides != null) return false;
                return this.useStageCache != null ? this.useStageCache.equals(that.useStageCache) : that.useStageCache == null;
            }

            @Override
            public int hashCode() {
                int result = this.percentTraffic != null ? this.percentTraffic.hashCode() : 0;
                result = 31 * result + (this.stageVariableOverrides != null ? this.stageVariableOverrides.hashCode() : 0);
                result = 31 * result + (this.useStageCache != null ? this.useStageCache.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnDeployment.DeploymentCanarySettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentCanarySettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentCanarySettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeployment.DeploymentCanarySettingsProperty.PercentTraffic`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html#cfn-apigateway-deployment-deploymentcanarysettings-percenttraffic
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPercentTraffic() {
            return null;
        }

        /**
         * `CfnDeployment.DeploymentCanarySettingsProperty.StageVariableOverrides`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html#cfn-apigateway-deployment-deploymentcanarysettings-stagevariableoverrides
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStageVariableOverrides() {
            return null;
        }

        /**
         * `CfnDeployment.DeploymentCanarySettingsProperty.UseStageCache`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html#cfn-apigateway-deployment-deploymentcanarysettings-usestagecache
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseStageCache() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeploymentCanarySettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentCanarySettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentCanarySettingsProperty> {
            private java.lang.Number percentTraffic;
            private java.lang.Object stageVariableOverrides;
            private java.lang.Object useStageCache;

            /**
             * Sets the value of {@link DeploymentCanarySettingsProperty#getPercentTraffic}
             * @param percentTraffic `CfnDeployment.DeploymentCanarySettingsProperty.PercentTraffic`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder percentTraffic(java.lang.Number percentTraffic) {
                this.percentTraffic = percentTraffic;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentCanarySettingsProperty#getStageVariableOverrides}
             * @param stageVariableOverrides `CfnDeployment.DeploymentCanarySettingsProperty.StageVariableOverrides`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stageVariableOverrides(software.amazon.awscdk.core.IResolvable stageVariableOverrides) {
                this.stageVariableOverrides = stageVariableOverrides;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentCanarySettingsProperty#getStageVariableOverrides}
             * @param stageVariableOverrides `CfnDeployment.DeploymentCanarySettingsProperty.StageVariableOverrides`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stageVariableOverrides(java.util.Map<java.lang.String, java.lang.String> stageVariableOverrides) {
                this.stageVariableOverrides = stageVariableOverrides;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentCanarySettingsProperty#getUseStageCache}
             * @param useStageCache `CfnDeployment.DeploymentCanarySettingsProperty.UseStageCache`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useStageCache(java.lang.Boolean useStageCache) {
                this.useStageCache = useStageCache;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentCanarySettingsProperty#getUseStageCache}
             * @param useStageCache `CfnDeployment.DeploymentCanarySettingsProperty.UseStageCache`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useStageCache(software.amazon.awscdk.core.IResolvable useStageCache) {
                this.useStageCache = useStageCache;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentCanarySettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentCanarySettingsProperty build() {
                return new Jsii$Proxy(percentTraffic, stageVariableOverrides, useStageCache);
            }
        }

        /**
         * An implementation for {@link DeploymentCanarySettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentCanarySettingsProperty {
            private final java.lang.Number percentTraffic;
            private final java.lang.Object stageVariableOverrides;
            private final java.lang.Object useStageCache;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.percentTraffic = this.jsiiGet("percentTraffic", java.lang.Number.class);
                this.stageVariableOverrides = this.jsiiGet("stageVariableOverrides", java.lang.Object.class);
                this.useStageCache = this.jsiiGet("useStageCache", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number percentTraffic, final java.lang.Object stageVariableOverrides, final java.lang.Object useStageCache) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.percentTraffic = percentTraffic;
                this.stageVariableOverrides = stageVariableOverrides;
                this.useStageCache = useStageCache;
            }

            @Override
            public java.lang.Number getPercentTraffic() {
                return this.percentTraffic;
            }

            @Override
            public java.lang.Object getStageVariableOverrides() {
                return this.stageVariableOverrides;
            }

            @Override
            public java.lang.Object getUseStageCache() {
                return this.useStageCache;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPercentTraffic() != null) {
                    data.set("percentTraffic", om.valueToTree(this.getPercentTraffic()));
                }
                if (this.getStageVariableOverrides() != null) {
                    data.set("stageVariableOverrides", om.valueToTree(this.getStageVariableOverrides()));
                }
                if (this.getUseStageCache() != null) {
                    data.set("useStageCache", om.valueToTree(this.getUseStageCache()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnDeployment.DeploymentCanarySettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentCanarySettingsProperty.Jsii$Proxy that = (DeploymentCanarySettingsProperty.Jsii$Proxy) o;

                if (this.percentTraffic != null ? !this.percentTraffic.equals(that.percentTraffic) : that.percentTraffic != null) return false;
                if (this.stageVariableOverrides != null ? !this.stageVariableOverrides.equals(that.stageVariableOverrides) : that.stageVariableOverrides != null) return false;
                return this.useStageCache != null ? this.useStageCache.equals(that.useStageCache) : that.useStageCache == null;
            }

            @Override
            public int hashCode() {
                int result = this.percentTraffic != null ? this.percentTraffic.hashCode() : 0;
                result = 31 * result + (this.stageVariableOverrides != null ? this.stageVariableOverrides.hashCode() : 0);
                result = 31 * result + (this.useStageCache != null ? this.useStageCache.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnDeployment.MethodSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(MethodSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MethodSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeployment.MethodSettingProperty.CacheDataEncrypted`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachedataencrypted
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCacheDataEncrypted() {
            return null;
        }

        /**
         * `CfnDeployment.MethodSettingProperty.CacheTtlInSeconds`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachettlinseconds
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCacheTtlInSeconds() {
            return null;
        }

        /**
         * `CfnDeployment.MethodSettingProperty.CachingEnabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachingenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCachingEnabled() {
            return null;
        }

        /**
         * `CfnDeployment.MethodSettingProperty.DataTraceEnabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-datatraceenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataTraceEnabled() {
            return null;
        }

        /**
         * `CfnDeployment.MethodSettingProperty.HttpMethod`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-httpmethod
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpMethod() {
            return null;
        }

        /**
         * `CfnDeployment.MethodSettingProperty.LoggingLevel`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-logginglevel
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLoggingLevel() {
            return null;
        }

        /**
         * `CfnDeployment.MethodSettingProperty.MetricsEnabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-metricsenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetricsEnabled() {
            return null;
        }

        /**
         * `CfnDeployment.MethodSettingProperty.ResourcePath`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-resourcepath
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourcePath() {
            return null;
        }

        /**
         * `CfnDeployment.MethodSettingProperty.ThrottlingBurstLimit`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingburstlimit
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThrottlingBurstLimit() {
            return null;
        }

        /**
         * `CfnDeployment.MethodSettingProperty.ThrottlingRateLimit`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingratelimit
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThrottlingRateLimit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MethodSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MethodSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MethodSettingProperty> {
            private java.lang.Object cacheDataEncrypted;
            private java.lang.Number cacheTtlInSeconds;
            private java.lang.Object cachingEnabled;
            private java.lang.Object dataTraceEnabled;
            private java.lang.String httpMethod;
            private java.lang.String loggingLevel;
            private java.lang.Object metricsEnabled;
            private java.lang.String resourcePath;
            private java.lang.Number throttlingBurstLimit;
            private java.lang.Number throttlingRateLimit;

            /**
             * Sets the value of {@link MethodSettingProperty#getCacheDataEncrypted}
             * @param cacheDataEncrypted `CfnDeployment.MethodSettingProperty.CacheDataEncrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheDataEncrypted(java.lang.Boolean cacheDataEncrypted) {
                this.cacheDataEncrypted = cacheDataEncrypted;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getCacheDataEncrypted}
             * @param cacheDataEncrypted `CfnDeployment.MethodSettingProperty.CacheDataEncrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheDataEncrypted(software.amazon.awscdk.core.IResolvable cacheDataEncrypted) {
                this.cacheDataEncrypted = cacheDataEncrypted;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getCacheTtlInSeconds}
             * @param cacheTtlInSeconds `CfnDeployment.MethodSettingProperty.CacheTtlInSeconds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheTtlInSeconds(java.lang.Number cacheTtlInSeconds) {
                this.cacheTtlInSeconds = cacheTtlInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getCachingEnabled}
             * @param cachingEnabled `CfnDeployment.MethodSettingProperty.CachingEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachingEnabled(java.lang.Boolean cachingEnabled) {
                this.cachingEnabled = cachingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getCachingEnabled}
             * @param cachingEnabled `CfnDeployment.MethodSettingProperty.CachingEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachingEnabled(software.amazon.awscdk.core.IResolvable cachingEnabled) {
                this.cachingEnabled = cachingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getDataTraceEnabled}
             * @param dataTraceEnabled `CfnDeployment.MethodSettingProperty.DataTraceEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTraceEnabled(java.lang.Boolean dataTraceEnabled) {
                this.dataTraceEnabled = dataTraceEnabled;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getDataTraceEnabled}
             * @param dataTraceEnabled `CfnDeployment.MethodSettingProperty.DataTraceEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTraceEnabled(software.amazon.awscdk.core.IResolvable dataTraceEnabled) {
                this.dataTraceEnabled = dataTraceEnabled;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getHttpMethod}
             * @param httpMethod `CfnDeployment.MethodSettingProperty.HttpMethod`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpMethod(java.lang.String httpMethod) {
                this.httpMethod = httpMethod;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getLoggingLevel}
             * @param loggingLevel `CfnDeployment.MethodSettingProperty.LoggingLevel`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loggingLevel(java.lang.String loggingLevel) {
                this.loggingLevel = loggingLevel;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getMetricsEnabled}
             * @param metricsEnabled `CfnDeployment.MethodSettingProperty.MetricsEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricsEnabled(java.lang.Boolean metricsEnabled) {
                this.metricsEnabled = metricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getMetricsEnabled}
             * @param metricsEnabled `CfnDeployment.MethodSettingProperty.MetricsEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricsEnabled(software.amazon.awscdk.core.IResolvable metricsEnabled) {
                this.metricsEnabled = metricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getResourcePath}
             * @param resourcePath `CfnDeployment.MethodSettingProperty.ResourcePath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourcePath(java.lang.String resourcePath) {
                this.resourcePath = resourcePath;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getThrottlingBurstLimit}
             * @param throttlingBurstLimit `CfnDeployment.MethodSettingProperty.ThrottlingBurstLimit`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throttlingBurstLimit(java.lang.Number throttlingBurstLimit) {
                this.throttlingBurstLimit = throttlingBurstLimit;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getThrottlingRateLimit}
             * @param throttlingRateLimit `CfnDeployment.MethodSettingProperty.ThrottlingRateLimit`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throttlingRateLimit(java.lang.Number throttlingRateLimit) {
                this.throttlingRateLimit = throttlingRateLimit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MethodSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MethodSettingProperty build() {
                return new Jsii$Proxy(cacheDataEncrypted, cacheTtlInSeconds, cachingEnabled, dataTraceEnabled, httpMethod, loggingLevel, metricsEnabled, resourcePath, throttlingBurstLimit, throttlingRateLimit);
            }
        }

        /**
         * An implementation for {@link MethodSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MethodSettingProperty {
            private final java.lang.Object cacheDataEncrypted;
            private final java.lang.Number cacheTtlInSeconds;
            private final java.lang.Object cachingEnabled;
            private final java.lang.Object dataTraceEnabled;
            private final java.lang.String httpMethod;
            private final java.lang.String loggingLevel;
            private final java.lang.Object metricsEnabled;
            private final java.lang.String resourcePath;
            private final java.lang.Number throttlingBurstLimit;
            private final java.lang.Number throttlingRateLimit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cacheDataEncrypted = this.jsiiGet("cacheDataEncrypted", java.lang.Object.class);
                this.cacheTtlInSeconds = this.jsiiGet("cacheTtlInSeconds", java.lang.Number.class);
                this.cachingEnabled = this.jsiiGet("cachingEnabled", java.lang.Object.class);
                this.dataTraceEnabled = this.jsiiGet("dataTraceEnabled", java.lang.Object.class);
                this.httpMethod = this.jsiiGet("httpMethod", java.lang.String.class);
                this.loggingLevel = this.jsiiGet("loggingLevel", java.lang.String.class);
                this.metricsEnabled = this.jsiiGet("metricsEnabled", java.lang.Object.class);
                this.resourcePath = this.jsiiGet("resourcePath", java.lang.String.class);
                this.throttlingBurstLimit = this.jsiiGet("throttlingBurstLimit", java.lang.Number.class);
                this.throttlingRateLimit = this.jsiiGet("throttlingRateLimit", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object cacheDataEncrypted, final java.lang.Number cacheTtlInSeconds, final java.lang.Object cachingEnabled, final java.lang.Object dataTraceEnabled, final java.lang.String httpMethod, final java.lang.String loggingLevel, final java.lang.Object metricsEnabled, final java.lang.String resourcePath, final java.lang.Number throttlingBurstLimit, final java.lang.Number throttlingRateLimit) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cacheDataEncrypted = cacheDataEncrypted;
                this.cacheTtlInSeconds = cacheTtlInSeconds;
                this.cachingEnabled = cachingEnabled;
                this.dataTraceEnabled = dataTraceEnabled;
                this.httpMethod = httpMethod;
                this.loggingLevel = loggingLevel;
                this.metricsEnabled = metricsEnabled;
                this.resourcePath = resourcePath;
                this.throttlingBurstLimit = throttlingBurstLimit;
                this.throttlingRateLimit = throttlingRateLimit;
            }

            @Override
            public java.lang.Object getCacheDataEncrypted() {
                return this.cacheDataEncrypted;
            }

            @Override
            public java.lang.Number getCacheTtlInSeconds() {
                return this.cacheTtlInSeconds;
            }

            @Override
            public java.lang.Object getCachingEnabled() {
                return this.cachingEnabled;
            }

            @Override
            public java.lang.Object getDataTraceEnabled() {
                return this.dataTraceEnabled;
            }

            @Override
            public java.lang.String getHttpMethod() {
                return this.httpMethod;
            }

            @Override
            public java.lang.String getLoggingLevel() {
                return this.loggingLevel;
            }

            @Override
            public java.lang.Object getMetricsEnabled() {
                return this.metricsEnabled;
            }

            @Override
            public java.lang.String getResourcePath() {
                return this.resourcePath;
            }

            @Override
            public java.lang.Number getThrottlingBurstLimit() {
                return this.throttlingBurstLimit;
            }

            @Override
            public java.lang.Number getThrottlingRateLimit() {
                return this.throttlingRateLimit;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCacheDataEncrypted() != null) {
                    data.set("cacheDataEncrypted", om.valueToTree(this.getCacheDataEncrypted()));
                }
                if (this.getCacheTtlInSeconds() != null) {
                    data.set("cacheTtlInSeconds", om.valueToTree(this.getCacheTtlInSeconds()));
                }
                if (this.getCachingEnabled() != null) {
                    data.set("cachingEnabled", om.valueToTree(this.getCachingEnabled()));
                }
                if (this.getDataTraceEnabled() != null) {
                    data.set("dataTraceEnabled", om.valueToTree(this.getDataTraceEnabled()));
                }
                if (this.getHttpMethod() != null) {
                    data.set("httpMethod", om.valueToTree(this.getHttpMethod()));
                }
                if (this.getLoggingLevel() != null) {
                    data.set("loggingLevel", om.valueToTree(this.getLoggingLevel()));
                }
                if (this.getMetricsEnabled() != null) {
                    data.set("metricsEnabled", om.valueToTree(this.getMetricsEnabled()));
                }
                if (this.getResourcePath() != null) {
                    data.set("resourcePath", om.valueToTree(this.getResourcePath()));
                }
                if (this.getThrottlingBurstLimit() != null) {
                    data.set("throttlingBurstLimit", om.valueToTree(this.getThrottlingBurstLimit()));
                }
                if (this.getThrottlingRateLimit() != null) {
                    data.set("throttlingRateLimit", om.valueToTree(this.getThrottlingRateLimit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnDeployment.MethodSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MethodSettingProperty.Jsii$Proxy that = (MethodSettingProperty.Jsii$Proxy) o;

                if (this.cacheDataEncrypted != null ? !this.cacheDataEncrypted.equals(that.cacheDataEncrypted) : that.cacheDataEncrypted != null) return false;
                if (this.cacheTtlInSeconds != null ? !this.cacheTtlInSeconds.equals(that.cacheTtlInSeconds) : that.cacheTtlInSeconds != null) return false;
                if (this.cachingEnabled != null ? !this.cachingEnabled.equals(that.cachingEnabled) : that.cachingEnabled != null) return false;
                if (this.dataTraceEnabled != null ? !this.dataTraceEnabled.equals(that.dataTraceEnabled) : that.dataTraceEnabled != null) return false;
                if (this.httpMethod != null ? !this.httpMethod.equals(that.httpMethod) : that.httpMethod != null) return false;
                if (this.loggingLevel != null ? !this.loggingLevel.equals(that.loggingLevel) : that.loggingLevel != null) return false;
                if (this.metricsEnabled != null ? !this.metricsEnabled.equals(that.metricsEnabled) : that.metricsEnabled != null) return false;
                if (this.resourcePath != null ? !this.resourcePath.equals(that.resourcePath) : that.resourcePath != null) return false;
                if (this.throttlingBurstLimit != null ? !this.throttlingBurstLimit.equals(that.throttlingBurstLimit) : that.throttlingBurstLimit != null) return false;
                return this.throttlingRateLimit != null ? this.throttlingRateLimit.equals(that.throttlingRateLimit) : that.throttlingRateLimit == null;
            }

            @Override
            public int hashCode() {
                int result = this.cacheDataEncrypted != null ? this.cacheDataEncrypted.hashCode() : 0;
                result = 31 * result + (this.cacheTtlInSeconds != null ? this.cacheTtlInSeconds.hashCode() : 0);
                result = 31 * result + (this.cachingEnabled != null ? this.cachingEnabled.hashCode() : 0);
                result = 31 * result + (this.dataTraceEnabled != null ? this.dataTraceEnabled.hashCode() : 0);
                result = 31 * result + (this.httpMethod != null ? this.httpMethod.hashCode() : 0);
                result = 31 * result + (this.loggingLevel != null ? this.loggingLevel.hashCode() : 0);
                result = 31 * result + (this.metricsEnabled != null ? this.metricsEnabled.hashCode() : 0);
                result = 31 * result + (this.resourcePath != null ? this.resourcePath.hashCode() : 0);
                result = 31 * result + (this.throttlingBurstLimit != null ? this.throttlingBurstLimit.hashCode() : 0);
                result = 31 * result + (this.throttlingRateLimit != null ? this.throttlingRateLimit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnDeployment.StageDescriptionProperty")
    @software.amazon.jsii.Jsii.Proxy(StageDescriptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StageDescriptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeployment.StageDescriptionProperty.AccessLogSetting`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-accesslogsetting
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAccessLogSetting() {
            return null;
        }

        /**
         * `CfnDeployment.StageDescriptionProperty.CacheClusterEnabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclusterenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCacheClusterEnabled() {
            return null;
        }

        /**
         * `CfnDeployment.StageDescriptionProperty.CacheClusterSize`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclustersize
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCacheClusterSize() {
            return null;
        }

        /**
         * `CfnDeployment.StageDescriptionProperty.CacheDataEncrypted`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachedataencrypted
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCacheDataEncrypted() {
            return null;
        }

        /**
         * `CfnDeployment.StageDescriptionProperty.CacheTtlInSeconds`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachettlinseconds
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCacheTtlInSeconds() {
            return null;
        }

        /**
         * `CfnDeployment.StageDescriptionProperty.CachingEnabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachingenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCachingEnabled() {
            return null;
        }

        /**
         * `CfnDeployment.StageDescriptionProperty.CanarySetting`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-canarysetting
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCanarySetting() {
            return null;
        }

        /**
         * `CfnDeployment.StageDescriptionProperty.ClientCertificateId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-clientcertificateid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientCertificateId() {
            return null;
        }

        /**
         * `CfnDeployment.StageDescriptionProperty.DataTraceEnabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-datatraceenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataTraceEnabled() {
            return null;
        }

        /**
         * `CfnDeployment.StageDescriptionProperty.Description`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-description
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * `CfnDeployment.StageDescriptionProperty.DocumentationVersion`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-documentationversion
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocumentationVersion() {
            return null;
        }

        /**
         * `CfnDeployment.StageDescriptionProperty.LoggingLevel`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-logginglevel
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLoggingLevel() {
            return null;
        }

        /**
         * `CfnDeployment.StageDescriptionProperty.MethodSettings`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-methodsettings
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMethodSettings() {
            return null;
        }

        /**
         * `CfnDeployment.StageDescriptionProperty.MetricsEnabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-metricsenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetricsEnabled() {
            return null;
        }

        /**
         * `CfnDeployment.StageDescriptionProperty.Tags`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-tags
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return null;
        }

        /**
         * `CfnDeployment.StageDescriptionProperty.ThrottlingBurstLimit`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingburstlimit
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThrottlingBurstLimit() {
            return null;
        }

        /**
         * `CfnDeployment.StageDescriptionProperty.ThrottlingRateLimit`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingratelimit
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThrottlingRateLimit() {
            return null;
        }

        /**
         * `CfnDeployment.StageDescriptionProperty.TracingEnabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-tracingenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTracingEnabled() {
            return null;
        }

        /**
         * `CfnDeployment.StageDescriptionProperty.Variables`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-variables
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVariables() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StageDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StageDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StageDescriptionProperty> {
            private java.lang.Object accessLogSetting;
            private java.lang.Object cacheClusterEnabled;
            private java.lang.String cacheClusterSize;
            private java.lang.Object cacheDataEncrypted;
            private java.lang.Number cacheTtlInSeconds;
            private java.lang.Object cachingEnabled;
            private java.lang.Object canarySetting;
            private java.lang.String clientCertificateId;
            private java.lang.Object dataTraceEnabled;
            private java.lang.String description;
            private java.lang.String documentationVersion;
            private java.lang.String loggingLevel;
            private java.lang.Object methodSettings;
            private java.lang.Object metricsEnabled;
            private java.util.List<software.amazon.awscdk.core.CfnTag> tags;
            private java.lang.Number throttlingBurstLimit;
            private java.lang.Number throttlingRateLimit;
            private java.lang.Object tracingEnabled;
            private java.lang.Object variables;

            /**
             * Sets the value of {@link StageDescriptionProperty#getAccessLogSetting}
             * @param accessLogSetting `CfnDeployment.StageDescriptionProperty.AccessLogSetting`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessLogSetting(software.amazon.awscdk.core.IResolvable accessLogSetting) {
                this.accessLogSetting = accessLogSetting;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getAccessLogSetting}
             * @param accessLogSetting `CfnDeployment.StageDescriptionProperty.AccessLogSetting`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessLogSetting(software.amazon.awscdk.services.apigateway.CfnDeployment.AccessLogSettingProperty accessLogSetting) {
                this.accessLogSetting = accessLogSetting;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getCacheClusterEnabled}
             * @param cacheClusterEnabled `CfnDeployment.StageDescriptionProperty.CacheClusterEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheClusterEnabled(java.lang.Boolean cacheClusterEnabled) {
                this.cacheClusterEnabled = cacheClusterEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getCacheClusterEnabled}
             * @param cacheClusterEnabled `CfnDeployment.StageDescriptionProperty.CacheClusterEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheClusterEnabled(software.amazon.awscdk.core.IResolvable cacheClusterEnabled) {
                this.cacheClusterEnabled = cacheClusterEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getCacheClusterSize}
             * @param cacheClusterSize `CfnDeployment.StageDescriptionProperty.CacheClusterSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheClusterSize(java.lang.String cacheClusterSize) {
                this.cacheClusterSize = cacheClusterSize;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getCacheDataEncrypted}
             * @param cacheDataEncrypted `CfnDeployment.StageDescriptionProperty.CacheDataEncrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheDataEncrypted(java.lang.Boolean cacheDataEncrypted) {
                this.cacheDataEncrypted = cacheDataEncrypted;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getCacheDataEncrypted}
             * @param cacheDataEncrypted `CfnDeployment.StageDescriptionProperty.CacheDataEncrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheDataEncrypted(software.amazon.awscdk.core.IResolvable cacheDataEncrypted) {
                this.cacheDataEncrypted = cacheDataEncrypted;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getCacheTtlInSeconds}
             * @param cacheTtlInSeconds `CfnDeployment.StageDescriptionProperty.CacheTtlInSeconds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheTtlInSeconds(java.lang.Number cacheTtlInSeconds) {
                this.cacheTtlInSeconds = cacheTtlInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getCachingEnabled}
             * @param cachingEnabled `CfnDeployment.StageDescriptionProperty.CachingEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachingEnabled(java.lang.Boolean cachingEnabled) {
                this.cachingEnabled = cachingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getCachingEnabled}
             * @param cachingEnabled `CfnDeployment.StageDescriptionProperty.CachingEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachingEnabled(software.amazon.awscdk.core.IResolvable cachingEnabled) {
                this.cachingEnabled = cachingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getCanarySetting}
             * @param canarySetting `CfnDeployment.StageDescriptionProperty.CanarySetting`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canarySetting(software.amazon.awscdk.core.IResolvable canarySetting) {
                this.canarySetting = canarySetting;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getCanarySetting}
             * @param canarySetting `CfnDeployment.StageDescriptionProperty.CanarySetting`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canarySetting(software.amazon.awscdk.services.apigateway.CfnDeployment.CanarySettingProperty canarySetting) {
                this.canarySetting = canarySetting;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getClientCertificateId}
             * @param clientCertificateId `CfnDeployment.StageDescriptionProperty.ClientCertificateId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientCertificateId(java.lang.String clientCertificateId) {
                this.clientCertificateId = clientCertificateId;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getDataTraceEnabled}
             * @param dataTraceEnabled `CfnDeployment.StageDescriptionProperty.DataTraceEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTraceEnabled(java.lang.Boolean dataTraceEnabled) {
                this.dataTraceEnabled = dataTraceEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getDataTraceEnabled}
             * @param dataTraceEnabled `CfnDeployment.StageDescriptionProperty.DataTraceEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTraceEnabled(software.amazon.awscdk.core.IResolvable dataTraceEnabled) {
                this.dataTraceEnabled = dataTraceEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getDescription}
             * @param description `CfnDeployment.StageDescriptionProperty.Description`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getDocumentationVersion}
             * @param documentationVersion `CfnDeployment.StageDescriptionProperty.DocumentationVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentationVersion(java.lang.String documentationVersion) {
                this.documentationVersion = documentationVersion;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getLoggingLevel}
             * @param loggingLevel `CfnDeployment.StageDescriptionProperty.LoggingLevel`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loggingLevel(java.lang.String loggingLevel) {
                this.loggingLevel = loggingLevel;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getMethodSettings}
             * @param methodSettings `CfnDeployment.StageDescriptionProperty.MethodSettings`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder methodSettings(software.amazon.awscdk.core.IResolvable methodSettings) {
                this.methodSettings = methodSettings;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getMethodSettings}
             * @param methodSettings `CfnDeployment.StageDescriptionProperty.MethodSettings`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder methodSettings(java.util.List<java.lang.Object> methodSettings) {
                this.methodSettings = methodSettings;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getMetricsEnabled}
             * @param metricsEnabled `CfnDeployment.StageDescriptionProperty.MetricsEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricsEnabled(java.lang.Boolean metricsEnabled) {
                this.metricsEnabled = metricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getMetricsEnabled}
             * @param metricsEnabled `CfnDeployment.StageDescriptionProperty.MetricsEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricsEnabled(software.amazon.awscdk.core.IResolvable metricsEnabled) {
                this.metricsEnabled = metricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getTags}
             * @param tags `CfnDeployment.StageDescriptionProperty.Tags`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
                this.tags = tags;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getThrottlingBurstLimit}
             * @param throttlingBurstLimit `CfnDeployment.StageDescriptionProperty.ThrottlingBurstLimit`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throttlingBurstLimit(java.lang.Number throttlingBurstLimit) {
                this.throttlingBurstLimit = throttlingBurstLimit;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getThrottlingRateLimit}
             * @param throttlingRateLimit `CfnDeployment.StageDescriptionProperty.ThrottlingRateLimit`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throttlingRateLimit(java.lang.Number throttlingRateLimit) {
                this.throttlingRateLimit = throttlingRateLimit;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getTracingEnabled}
             * @param tracingEnabled `CfnDeployment.StageDescriptionProperty.TracingEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tracingEnabled(java.lang.Boolean tracingEnabled) {
                this.tracingEnabled = tracingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getTracingEnabled}
             * @param tracingEnabled `CfnDeployment.StageDescriptionProperty.TracingEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tracingEnabled(software.amazon.awscdk.core.IResolvable tracingEnabled) {
                this.tracingEnabled = tracingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getVariables}
             * @param variables `CfnDeployment.StageDescriptionProperty.Variables`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variables(software.amazon.awscdk.core.IResolvable variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getVariables}
             * @param variables `CfnDeployment.StageDescriptionProperty.Variables`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variables(java.util.Map<java.lang.String, java.lang.String> variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StageDescriptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StageDescriptionProperty build() {
                return new Jsii$Proxy(accessLogSetting, cacheClusterEnabled, cacheClusterSize, cacheDataEncrypted, cacheTtlInSeconds, cachingEnabled, canarySetting, clientCertificateId, dataTraceEnabled, description, documentationVersion, loggingLevel, methodSettings, metricsEnabled, tags, throttlingBurstLimit, throttlingRateLimit, tracingEnabled, variables);
            }
        }

        /**
         * An implementation for {@link StageDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StageDescriptionProperty {
            private final java.lang.Object accessLogSetting;
            private final java.lang.Object cacheClusterEnabled;
            private final java.lang.String cacheClusterSize;
            private final java.lang.Object cacheDataEncrypted;
            private final java.lang.Number cacheTtlInSeconds;
            private final java.lang.Object cachingEnabled;
            private final java.lang.Object canarySetting;
            private final java.lang.String clientCertificateId;
            private final java.lang.Object dataTraceEnabled;
            private final java.lang.String description;
            private final java.lang.String documentationVersion;
            private final java.lang.String loggingLevel;
            private final java.lang.Object methodSettings;
            private final java.lang.Object metricsEnabled;
            private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
            private final java.lang.Number throttlingBurstLimit;
            private final java.lang.Number throttlingRateLimit;
            private final java.lang.Object tracingEnabled;
            private final java.lang.Object variables;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessLogSetting = this.jsiiGet("accessLogSetting", java.lang.Object.class);
                this.cacheClusterEnabled = this.jsiiGet("cacheClusterEnabled", java.lang.Object.class);
                this.cacheClusterSize = this.jsiiGet("cacheClusterSize", java.lang.String.class);
                this.cacheDataEncrypted = this.jsiiGet("cacheDataEncrypted", java.lang.Object.class);
                this.cacheTtlInSeconds = this.jsiiGet("cacheTtlInSeconds", java.lang.Number.class);
                this.cachingEnabled = this.jsiiGet("cachingEnabled", java.lang.Object.class);
                this.canarySetting = this.jsiiGet("canarySetting", java.lang.Object.class);
                this.clientCertificateId = this.jsiiGet("clientCertificateId", java.lang.String.class);
                this.dataTraceEnabled = this.jsiiGet("dataTraceEnabled", java.lang.Object.class);
                this.description = this.jsiiGet("description", java.lang.String.class);
                this.documentationVersion = this.jsiiGet("documentationVersion", java.lang.String.class);
                this.loggingLevel = this.jsiiGet("loggingLevel", java.lang.String.class);
                this.methodSettings = this.jsiiGet("methodSettings", java.lang.Object.class);
                this.metricsEnabled = this.jsiiGet("metricsEnabled", java.lang.Object.class);
                this.tags = this.jsiiGet("tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
                this.throttlingBurstLimit = this.jsiiGet("throttlingBurstLimit", java.lang.Number.class);
                this.throttlingRateLimit = this.jsiiGet("throttlingRateLimit", java.lang.Number.class);
                this.tracingEnabled = this.jsiiGet("tracingEnabled", java.lang.Object.class);
                this.variables = this.jsiiGet("variables", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object accessLogSetting, final java.lang.Object cacheClusterEnabled, final java.lang.String cacheClusterSize, final java.lang.Object cacheDataEncrypted, final java.lang.Number cacheTtlInSeconds, final java.lang.Object cachingEnabled, final java.lang.Object canarySetting, final java.lang.String clientCertificateId, final java.lang.Object dataTraceEnabled, final java.lang.String description, final java.lang.String documentationVersion, final java.lang.String loggingLevel, final java.lang.Object methodSettings, final java.lang.Object metricsEnabled, final java.util.List<software.amazon.awscdk.core.CfnTag> tags, final java.lang.Number throttlingBurstLimit, final java.lang.Number throttlingRateLimit, final java.lang.Object tracingEnabled, final java.lang.Object variables) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessLogSetting = accessLogSetting;
                this.cacheClusterEnabled = cacheClusterEnabled;
                this.cacheClusterSize = cacheClusterSize;
                this.cacheDataEncrypted = cacheDataEncrypted;
                this.cacheTtlInSeconds = cacheTtlInSeconds;
                this.cachingEnabled = cachingEnabled;
                this.canarySetting = canarySetting;
                this.clientCertificateId = clientCertificateId;
                this.dataTraceEnabled = dataTraceEnabled;
                this.description = description;
                this.documentationVersion = documentationVersion;
                this.loggingLevel = loggingLevel;
                this.methodSettings = methodSettings;
                this.metricsEnabled = metricsEnabled;
                this.tags = tags;
                this.throttlingBurstLimit = throttlingBurstLimit;
                this.throttlingRateLimit = throttlingRateLimit;
                this.tracingEnabled = tracingEnabled;
                this.variables = variables;
            }

            @Override
            public java.lang.Object getAccessLogSetting() {
                return this.accessLogSetting;
            }

            @Override
            public java.lang.Object getCacheClusterEnabled() {
                return this.cacheClusterEnabled;
            }

            @Override
            public java.lang.String getCacheClusterSize() {
                return this.cacheClusterSize;
            }

            @Override
            public java.lang.Object getCacheDataEncrypted() {
                return this.cacheDataEncrypted;
            }

            @Override
            public java.lang.Number getCacheTtlInSeconds() {
                return this.cacheTtlInSeconds;
            }

            @Override
            public java.lang.Object getCachingEnabled() {
                return this.cachingEnabled;
            }

            @Override
            public java.lang.Object getCanarySetting() {
                return this.canarySetting;
            }

            @Override
            public java.lang.String getClientCertificateId() {
                return this.clientCertificateId;
            }

            @Override
            public java.lang.Object getDataTraceEnabled() {
                return this.dataTraceEnabled;
            }

            @Override
            public java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public java.lang.String getDocumentationVersion() {
                return this.documentationVersion;
            }

            @Override
            public java.lang.String getLoggingLevel() {
                return this.loggingLevel;
            }

            @Override
            public java.lang.Object getMethodSettings() {
                return this.methodSettings;
            }

            @Override
            public java.lang.Object getMetricsEnabled() {
                return this.metricsEnabled;
            }

            @Override
            public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            public java.lang.Number getThrottlingBurstLimit() {
                return this.throttlingBurstLimit;
            }

            @Override
            public java.lang.Number getThrottlingRateLimit() {
                return this.throttlingRateLimit;
            }

            @Override
            public java.lang.Object getTracingEnabled() {
                return this.tracingEnabled;
            }

            @Override
            public java.lang.Object getVariables() {
                return this.variables;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessLogSetting() != null) {
                    data.set("accessLogSetting", om.valueToTree(this.getAccessLogSetting()));
                }
                if (this.getCacheClusterEnabled() != null) {
                    data.set("cacheClusterEnabled", om.valueToTree(this.getCacheClusterEnabled()));
                }
                if (this.getCacheClusterSize() != null) {
                    data.set("cacheClusterSize", om.valueToTree(this.getCacheClusterSize()));
                }
                if (this.getCacheDataEncrypted() != null) {
                    data.set("cacheDataEncrypted", om.valueToTree(this.getCacheDataEncrypted()));
                }
                if (this.getCacheTtlInSeconds() != null) {
                    data.set("cacheTtlInSeconds", om.valueToTree(this.getCacheTtlInSeconds()));
                }
                if (this.getCachingEnabled() != null) {
                    data.set("cachingEnabled", om.valueToTree(this.getCachingEnabled()));
                }
                if (this.getCanarySetting() != null) {
                    data.set("canarySetting", om.valueToTree(this.getCanarySetting()));
                }
                if (this.getClientCertificateId() != null) {
                    data.set("clientCertificateId", om.valueToTree(this.getClientCertificateId()));
                }
                if (this.getDataTraceEnabled() != null) {
                    data.set("dataTraceEnabled", om.valueToTree(this.getDataTraceEnabled()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getDocumentationVersion() != null) {
                    data.set("documentationVersion", om.valueToTree(this.getDocumentationVersion()));
                }
                if (this.getLoggingLevel() != null) {
                    data.set("loggingLevel", om.valueToTree(this.getLoggingLevel()));
                }
                if (this.getMethodSettings() != null) {
                    data.set("methodSettings", om.valueToTree(this.getMethodSettings()));
                }
                if (this.getMetricsEnabled() != null) {
                    data.set("metricsEnabled", om.valueToTree(this.getMetricsEnabled()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }
                if (this.getThrottlingBurstLimit() != null) {
                    data.set("throttlingBurstLimit", om.valueToTree(this.getThrottlingBurstLimit()));
                }
                if (this.getThrottlingRateLimit() != null) {
                    data.set("throttlingRateLimit", om.valueToTree(this.getThrottlingRateLimit()));
                }
                if (this.getTracingEnabled() != null) {
                    data.set("tracingEnabled", om.valueToTree(this.getTracingEnabled()));
                }
                if (this.getVariables() != null) {
                    data.set("variables", om.valueToTree(this.getVariables()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnDeployment.StageDescriptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StageDescriptionProperty.Jsii$Proxy that = (StageDescriptionProperty.Jsii$Proxy) o;

                if (this.accessLogSetting != null ? !this.accessLogSetting.equals(that.accessLogSetting) : that.accessLogSetting != null) return false;
                if (this.cacheClusterEnabled != null ? !this.cacheClusterEnabled.equals(that.cacheClusterEnabled) : that.cacheClusterEnabled != null) return false;
                if (this.cacheClusterSize != null ? !this.cacheClusterSize.equals(that.cacheClusterSize) : that.cacheClusterSize != null) return false;
                if (this.cacheDataEncrypted != null ? !this.cacheDataEncrypted.equals(that.cacheDataEncrypted) : that.cacheDataEncrypted != null) return false;
                if (this.cacheTtlInSeconds != null ? !this.cacheTtlInSeconds.equals(that.cacheTtlInSeconds) : that.cacheTtlInSeconds != null) return false;
                if (this.cachingEnabled != null ? !this.cachingEnabled.equals(that.cachingEnabled) : that.cachingEnabled != null) return false;
                if (this.canarySetting != null ? !this.canarySetting.equals(that.canarySetting) : that.canarySetting != null) return false;
                if (this.clientCertificateId != null ? !this.clientCertificateId.equals(that.clientCertificateId) : that.clientCertificateId != null) return false;
                if (this.dataTraceEnabled != null ? !this.dataTraceEnabled.equals(that.dataTraceEnabled) : that.dataTraceEnabled != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.documentationVersion != null ? !this.documentationVersion.equals(that.documentationVersion) : that.documentationVersion != null) return false;
                if (this.loggingLevel != null ? !this.loggingLevel.equals(that.loggingLevel) : that.loggingLevel != null) return false;
                if (this.methodSettings != null ? !this.methodSettings.equals(that.methodSettings) : that.methodSettings != null) return false;
                if (this.metricsEnabled != null ? !this.metricsEnabled.equals(that.metricsEnabled) : that.metricsEnabled != null) return false;
                if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
                if (this.throttlingBurstLimit != null ? !this.throttlingBurstLimit.equals(that.throttlingBurstLimit) : that.throttlingBurstLimit != null) return false;
                if (this.throttlingRateLimit != null ? !this.throttlingRateLimit.equals(that.throttlingRateLimit) : that.throttlingRateLimit != null) return false;
                if (this.tracingEnabled != null ? !this.tracingEnabled.equals(that.tracingEnabled) : that.tracingEnabled != null) return false;
                return this.variables != null ? this.variables.equals(that.variables) : that.variables == null;
            }

            @Override
            public int hashCode() {
                int result = this.accessLogSetting != null ? this.accessLogSetting.hashCode() : 0;
                result = 31 * result + (this.cacheClusterEnabled != null ? this.cacheClusterEnabled.hashCode() : 0);
                result = 31 * result + (this.cacheClusterSize != null ? this.cacheClusterSize.hashCode() : 0);
                result = 31 * result + (this.cacheDataEncrypted != null ? this.cacheDataEncrypted.hashCode() : 0);
                result = 31 * result + (this.cacheTtlInSeconds != null ? this.cacheTtlInSeconds.hashCode() : 0);
                result = 31 * result + (this.cachingEnabled != null ? this.cachingEnabled.hashCode() : 0);
                result = 31 * result + (this.canarySetting != null ? this.canarySetting.hashCode() : 0);
                result = 31 * result + (this.clientCertificateId != null ? this.clientCertificateId.hashCode() : 0);
                result = 31 * result + (this.dataTraceEnabled != null ? this.dataTraceEnabled.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.documentationVersion != null ? this.documentationVersion.hashCode() : 0);
                result = 31 * result + (this.loggingLevel != null ? this.loggingLevel.hashCode() : 0);
                result = 31 * result + (this.methodSettings != null ? this.methodSettings.hashCode() : 0);
                result = 31 * result + (this.metricsEnabled != null ? this.metricsEnabled.hashCode() : 0);
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                result = 31 * result + (this.throttlingBurstLimit != null ? this.throttlingBurstLimit.hashCode() : 0);
                result = 31 * result + (this.throttlingRateLimit != null ? this.throttlingRateLimit.hashCode() : 0);
                result = 31 * result + (this.tracingEnabled != null ? this.tracingEnabled.hashCode() : 0);
                result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.CfnDeployment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.CfnDeployment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.CfnDeploymentProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.CfnDeploymentProps.Builder();
        }

        /**
         * `AWS::ApiGateway::Deployment.RestApiId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-restapiid
         * @param restApiId `AWS::ApiGateway::Deployment.RestApiId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiId(final java.lang.String restApiId) {
            this.props.restApiId(restApiId);
            return this;
        }

        /**
         * `AWS::ApiGateway::Deployment.DeploymentCanarySettings`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-deploymentcanarysettings
         * @param deploymentCanarySettings `AWS::ApiGateway::Deployment.DeploymentCanarySettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentCanarySettings(final software.amazon.awscdk.core.IResolvable deploymentCanarySettings) {
            this.props.deploymentCanarySettings(deploymentCanarySettings);
            return this;
        }
        /**
         * `AWS::ApiGateway::Deployment.DeploymentCanarySettings`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-deploymentcanarysettings
         * @param deploymentCanarySettings `AWS::ApiGateway::Deployment.DeploymentCanarySettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentCanarySettings(final software.amazon.awscdk.services.apigateway.CfnDeployment.DeploymentCanarySettingsProperty deploymentCanarySettings) {
            this.props.deploymentCanarySettings(deploymentCanarySettings);
            return this;
        }

        /**
         * `AWS::ApiGateway::Deployment.Description`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-description
         * @param description `AWS::ApiGateway::Deployment.Description`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * `AWS::ApiGateway::Deployment.StageDescription`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagedescription
         * @param stageDescription `AWS::ApiGateway::Deployment.StageDescription`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageDescription(final software.amazon.awscdk.core.IResolvable stageDescription) {
            this.props.stageDescription(stageDescription);
            return this;
        }
        /**
         * `AWS::ApiGateway::Deployment.StageDescription`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagedescription
         * @param stageDescription `AWS::ApiGateway::Deployment.StageDescription`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageDescription(final software.amazon.awscdk.services.apigateway.CfnDeployment.StageDescriptionProperty stageDescription) {
            this.props.stageDescription(stageDescription);
            return this;
        }

        /**
         * `AWS::ApiGateway::Deployment.StageName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagename
         * @param stageName `AWS::ApiGateway::Deployment.StageName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageName(final java.lang.String stageName) {
            this.props.stageName(stageName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.CfnDeployment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.CfnDeployment build() {
            return new software.amazon.awscdk.services.apigateway.CfnDeployment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
