package software.amazon.awscdk.services.apigateway;

/**
 * A CloudFormation `AWS::ApiGateway::RestApi`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.11.0 (build 1e9b8e1)", date = "2020-09-13T06:03:04.332Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnRestApi")
public class CfnRestApi extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnRestApi(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRestApi(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnRestApi.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ApiGateway::RestApi`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRestApi(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CfnRestApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::ApiGateway::RestApi`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRestApi(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRootResourceId() {
        return this.jsiiGet("attrRootResourceId", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::ApiGateway::RestApi.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::ApiGateway::RestApi.Body`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-body
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getBody() {
        return this.jsiiGet("body", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::RestApi.Body`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-body
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBody(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        this.jsiiSet("body", java.util.Objects.requireNonNull(value, "body is required"));
    }

    /**
     * `AWS::ApiGateway::RestApi.Policy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getPolicy() {
        return this.jsiiGet("policy", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::RestApi.Policy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicy(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        this.jsiiSet("policy", java.util.Objects.requireNonNull(value, "policy is required"));
    }

    /**
     * `AWS::ApiGateway::RestApi.ApiKeySourceType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-apikeysourcetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getApiKeySourceType() {
        return this.jsiiGet("apiKeySourceType", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::RestApi.ApiKeySourceType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-apikeysourcetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApiKeySourceType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("apiKeySourceType", value);
    }

    /**
     * `AWS::ApiGateway::RestApi.BinaryMediaTypes`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-binarymediatypes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBinaryMediaTypes() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("binaryMediaTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::ApiGateway::RestApi.BinaryMediaTypes`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-binarymediatypes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBinaryMediaTypes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("binaryMediaTypes", value);
    }

    /**
     * `AWS::ApiGateway::RestApi.BodyS3Location`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-bodys3location
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBodyS3Location() {
        return this.jsiiGet("bodyS3Location", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::RestApi.BodyS3Location`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-bodys3location
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBodyS3Location(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("bodyS3Location", value);
    }

    /**
     * `AWS::ApiGateway::RestApi.BodyS3Location`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-bodys3location
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBodyS3Location(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CfnRestApi.S3LocationProperty value) {
        this.jsiiSet("bodyS3Location", value);
    }

    /**
     * `AWS::ApiGateway::RestApi.CloneFrom`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-clonefrom
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCloneFrom() {
        return this.jsiiGet("cloneFrom", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::RestApi.CloneFrom`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-clonefrom
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCloneFrom(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("cloneFrom", value);
    }

    /**
     * `AWS::ApiGateway::RestApi.Description`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::RestApi.Description`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("description", value);
    }

    /**
     * `AWS::ApiGateway::RestApi.EndpointConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-endpointconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEndpointConfiguration() {
        return this.jsiiGet("endpointConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::RestApi.EndpointConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-endpointconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("endpointConfiguration", value);
    }

    /**
     * `AWS::ApiGateway::RestApi.EndpointConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-endpointconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CfnRestApi.EndpointConfigurationProperty value) {
        this.jsiiSet("endpointConfiguration", value);
    }

    /**
     * `AWS::ApiGateway::RestApi.FailOnWarnings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-failonwarnings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFailOnWarnings() {
        return this.jsiiGet("failOnWarnings", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::RestApi.FailOnWarnings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-failonwarnings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFailOnWarnings(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        this.jsiiSet("failOnWarnings", value);
    }

    /**
     * `AWS::ApiGateway::RestApi.FailOnWarnings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-failonwarnings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFailOnWarnings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("failOnWarnings", value);
    }

    /**
     * `AWS::ApiGateway::RestApi.MinimumCompressionSize`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-minimumcompressionsize
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMinimumCompressionSize() {
        return this.jsiiGet("minimumCompressionSize", java.lang.Number.class);
    }

    /**
     * `AWS::ApiGateway::RestApi.MinimumCompressionSize`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-minimumcompressionsize
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMinimumCompressionSize(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        this.jsiiSet("minimumCompressionSize", value);
    }

    /**
     * `AWS::ApiGateway::RestApi.Name`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return this.jsiiGet("name", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::RestApi.Name`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("name", value);
    }

    /**
     * `AWS::ApiGateway::RestApi.Parameters`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return this.jsiiGet("parameters", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::RestApi.Parameters`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("parameters", value);
    }

    /**
     * `AWS::ApiGateway::RestApi.Parameters`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        this.jsiiSet("parameters", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnRestApi.EndpointConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EndpointConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EndpointConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnRestApi.EndpointConfigurationProperty.Types`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-types
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTypes() {
            return null;
        }

        /**
         * `CfnRestApi.EndpointConfigurationProperty.VpcEndpointIds`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-vpcendpointids
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcEndpointIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EndpointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EndpointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EndpointConfigurationProperty> {
            private java.util.List<java.lang.String> types;
            private java.util.List<java.lang.String> vpcEndpointIds;

            /**
             * Sets the value of {@link EndpointConfigurationProperty#getTypes}
             * @param types `CfnRestApi.EndpointConfigurationProperty.Types`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder types(java.util.List<java.lang.String> types) {
                this.types = types;
                return this;
            }

            /**
             * Sets the value of {@link EndpointConfigurationProperty#getVpcEndpointIds}
             * @param vpcEndpointIds `CfnRestApi.EndpointConfigurationProperty.VpcEndpointIds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcEndpointIds(java.util.List<java.lang.String> vpcEndpointIds) {
                this.vpcEndpointIds = vpcEndpointIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EndpointConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EndpointConfigurationProperty build() {
                return new Jsii$Proxy(types, vpcEndpointIds);
            }
        }

        /**
         * An implementation for {@link EndpointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EndpointConfigurationProperty {
            private final java.util.List<java.lang.String> types;
            private final java.util.List<java.lang.String> vpcEndpointIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.types = this.jsiiGet("types", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.vpcEndpointIds = this.jsiiGet("vpcEndpointIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.util.List<java.lang.String> types, final java.util.List<java.lang.String> vpcEndpointIds) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.types = types;
                this.vpcEndpointIds = vpcEndpointIds;
            }

            @Override
            public java.util.List<java.lang.String> getTypes() {
                return this.types;
            }

            @Override
            public java.util.List<java.lang.String> getVpcEndpointIds() {
                return this.vpcEndpointIds;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTypes() != null) {
                    data.set("types", om.valueToTree(this.getTypes()));
                }
                if (this.getVpcEndpointIds() != null) {
                    data.set("vpcEndpointIds", om.valueToTree(this.getVpcEndpointIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnRestApi.EndpointConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EndpointConfigurationProperty.Jsii$Proxy that = (EndpointConfigurationProperty.Jsii$Proxy) o;

                if (this.types != null ? !this.types.equals(that.types) : that.types != null) return false;
                return this.vpcEndpointIds != null ? this.vpcEndpointIds.equals(that.vpcEndpointIds) : that.vpcEndpointIds == null;
            }

            @Override
            public int hashCode() {
                int result = this.types != null ? this.types.hashCode() : 0;
                result = 31 * result + (this.vpcEndpointIds != null ? this.vpcEndpointIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnRestApi.S3LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnRestApi.S3LocationProperty.Bucket`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-bucket
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucket() {
            return null;
        }

        /**
         * `CfnRestApi.S3LocationProperty.ETag`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-etag
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getETag() {
            return null;
        }

        /**
         * `CfnRestApi.S3LocationProperty.Key`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * `CfnRestApi.S3LocationProperty.Version`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-version
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LocationProperty> {
            private java.lang.String bucket;
            private java.lang.String eTag;
            private java.lang.String key;
            private java.lang.String version;

            /**
             * Sets the value of {@link S3LocationProperty#getBucket}
             * @param bucket `CfnRestApi.S3LocationProperty.Bucket`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getETag}
             * @param eTag `CfnRestApi.S3LocationProperty.ETag`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eTag(java.lang.String eTag) {
                this.eTag = eTag;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getKey}
             * @param key `CfnRestApi.S3LocationProperty.Key`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getVersion}
             * @param version `CfnRestApi.S3LocationProperty.Version`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LocationProperty build() {
                return new Jsii$Proxy(bucket, eTag, key, version);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String eTag;
            private final java.lang.String key;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = this.jsiiGet("bucket", java.lang.String.class);
                this.eTag = this.jsiiGet("eTag", java.lang.String.class);
                this.key = this.jsiiGet("key", java.lang.String.class);
                this.version = this.jsiiGet("version", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String bucket, final java.lang.String eTag, final java.lang.String key, final java.lang.String version) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = bucket;
                this.eTag = eTag;
                this.key = key;
                this.version = version;
            }

            @Override
            public java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public java.lang.String getETag() {
                return this.eTag;
            }

            @Override
            public java.lang.String getKey() {
                return this.key;
            }

            @Override
            public java.lang.String getVersion() {
                return this.version;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBucket() != null) {
                    data.set("bucket", om.valueToTree(this.getBucket()));
                }
                if (this.getETag() != null) {
                    data.set("eTag", om.valueToTree(this.getETag()));
                }
                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnRestApi.S3LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                if (this.bucket != null ? !this.bucket.equals(that.bucket) : that.bucket != null) return false;
                if (this.eTag != null ? !this.eTag.equals(that.eTag) : that.eTag != null) return false;
                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public int hashCode() {
                int result = this.bucket != null ? this.bucket.hashCode() : 0;
                result = 31 * result + (this.eTag != null ? this.eTag.hashCode() : 0);
                result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.CfnRestApi}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.CfnRestApi> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.apigateway.CfnRestApiProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * `AWS::ApiGateway::RestApi.ApiKeySourceType`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-apikeysourcetype
         * @param apiKeySourceType `AWS::ApiGateway::RestApi.ApiKeySourceType`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeySourceType(final java.lang.String apiKeySourceType) {
            this.props().apiKeySourceType(apiKeySourceType);
            return this;
        }

        /**
         * `AWS::ApiGateway::RestApi.BinaryMediaTypes`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-binarymediatypes
         * @param binaryMediaTypes `AWS::ApiGateway::RestApi.BinaryMediaTypes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder binaryMediaTypes(final java.util.List<java.lang.String> binaryMediaTypes) {
            this.props().binaryMediaTypes(binaryMediaTypes);
            return this;
        }

        /**
         * `AWS::ApiGateway::RestApi.Body`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-body
         * @param body `AWS::ApiGateway::RestApi.Body`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder body(final java.lang.Object body) {
            this.props().body(body);
            return this;
        }

        /**
         * `AWS::ApiGateway::RestApi.BodyS3Location`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-bodys3location
         * @param bodyS3Location `AWS::ApiGateway::RestApi.BodyS3Location`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bodyS3Location(final software.amazon.awscdk.core.IResolvable bodyS3Location) {
            this.props().bodyS3Location(bodyS3Location);
            return this;
        }
        /**
         * `AWS::ApiGateway::RestApi.BodyS3Location`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-bodys3location
         * @param bodyS3Location `AWS::ApiGateway::RestApi.BodyS3Location`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bodyS3Location(final software.amazon.awscdk.services.apigateway.CfnRestApi.S3LocationProperty bodyS3Location) {
            this.props().bodyS3Location(bodyS3Location);
            return this;
        }

        /**
         * `AWS::ApiGateway::RestApi.CloneFrom`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-clonefrom
         * @param cloneFrom `AWS::ApiGateway::RestApi.CloneFrom`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloneFrom(final java.lang.String cloneFrom) {
            this.props().cloneFrom(cloneFrom);
            return this;
        }

        /**
         * `AWS::ApiGateway::RestApi.Description`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-description
         * @param description `AWS::ApiGateway::RestApi.Description`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * `AWS::ApiGateway::RestApi.EndpointConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-endpointconfiguration
         * @param endpointConfiguration `AWS::ApiGateway::RestApi.EndpointConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfiguration(final software.amazon.awscdk.core.IResolvable endpointConfiguration) {
            this.props().endpointConfiguration(endpointConfiguration);
            return this;
        }
        /**
         * `AWS::ApiGateway::RestApi.EndpointConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-endpointconfiguration
         * @param endpointConfiguration `AWS::ApiGateway::RestApi.EndpointConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfiguration(final software.amazon.awscdk.services.apigateway.CfnRestApi.EndpointConfigurationProperty endpointConfiguration) {
            this.props().endpointConfiguration(endpointConfiguration);
            return this;
        }

        /**
         * `AWS::ApiGateway::RestApi.FailOnWarnings`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-failonwarnings
         * @param failOnWarnings `AWS::ApiGateway::RestApi.FailOnWarnings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(final java.lang.Boolean failOnWarnings) {
            this.props().failOnWarnings(failOnWarnings);
            return this;
        }
        /**
         * `AWS::ApiGateway::RestApi.FailOnWarnings`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-failonwarnings
         * @param failOnWarnings `AWS::ApiGateway::RestApi.FailOnWarnings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(final software.amazon.awscdk.core.IResolvable failOnWarnings) {
            this.props().failOnWarnings(failOnWarnings);
            return this;
        }

        /**
         * `AWS::ApiGateway::RestApi.MinimumCompressionSize`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-minimumcompressionsize
         * @param minimumCompressionSize `AWS::ApiGateway::RestApi.MinimumCompressionSize`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumCompressionSize(final java.lang.Number minimumCompressionSize) {
            this.props().minimumCompressionSize(minimumCompressionSize);
            return this;
        }

        /**
         * `AWS::ApiGateway::RestApi.Name`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-name
         * @param name `AWS::ApiGateway::RestApi.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * `AWS::ApiGateway::RestApi.Parameters`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-parameters
         * @param parameters `AWS::ApiGateway::RestApi.Parameters`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final software.amazon.awscdk.core.IResolvable parameters) {
            this.props().parameters(parameters);
            return this;
        }
        /**
         * `AWS::ApiGateway::RestApi.Parameters`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-parameters
         * @param parameters `AWS::ApiGateway::RestApi.Parameters`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.props().parameters(parameters);
            return this;
        }

        /**
         * `AWS::ApiGateway::RestApi.Policy`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-policy
         * @param policy `AWS::ApiGateway::RestApi.Policy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(final java.lang.Object policy) {
            this.props().policy(policy);
            return this;
        }

        /**
         * `AWS::ApiGateway::RestApi.Tags`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-tags
         * @param tags `AWS::ApiGateway::RestApi.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.CfnRestApi}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.CfnRestApi build() {
            return new software.amazon.awscdk.services.apigateway.CfnRestApi(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.apigateway.CfnRestApiProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.apigateway.CfnRestApiProps.Builder();
            }
            return this.props;
        }
    }
}
