package software.amazon.awscdk.services.apigateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-19T20:38:33.046Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.DeploymentProps")
@software.amazon.jsii.Jsii.Proxy(DeploymentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeploymentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Rest API to deploy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IRestApi getApi();

    /**
     * A description of the purpose of the API Gateway deployment.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * When an API Gateway model is updated, a new deployment will automatically be created.
     * <p>
     * If this is true, the old API Gateway Deployment resource will not be deleted.
     * This will allow manually reverting back to a previous deployment in case for example
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRetainDeployments() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeploymentProps> {
        private software.amazon.awscdk.services.apigateway.IRestApi api;
        private java.lang.String description;
        private java.lang.Boolean retainDeployments;

        /**
         * Sets the value of {@link DeploymentProps#getApi}
         * @param api The Rest API to deploy. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder api(software.amazon.awscdk.services.apigateway.IRestApi api) {
            this.api = api;
            return this;
        }

        /**
         * Sets the value of {@link DeploymentProps#getDescription}
         * @param description A description of the purpose of the API Gateway deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link DeploymentProps#getRetainDeployments}
         * @param retainDeployments When an API Gateway model is updated, a new deployment will automatically be created.
         *                          If this is true, the old API Gateway Deployment resource will not be deleted.
         *                          This will allow manually reverting back to a previous deployment in case for example
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainDeployments(java.lang.Boolean retainDeployments) {
            this.retainDeployments = retainDeployments;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeploymentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeploymentProps build() {
            return new Jsii$Proxy(api, description, retainDeployments);
        }
    }

    /**
     * An implementation for {@link DeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentProps {
        private final software.amazon.awscdk.services.apigateway.IRestApi api;
        private final java.lang.String description;
        private final java.lang.Boolean retainDeployments;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.api = this.jsiiGet("api", software.amazon.awscdk.services.apigateway.IRestApi.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.retainDeployments = this.jsiiGet("retainDeployments", java.lang.Boolean.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.apigateway.IRestApi api, final java.lang.String description, final java.lang.Boolean retainDeployments) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.api = java.util.Objects.requireNonNull(api, "api is required");
            this.description = description;
            this.retainDeployments = retainDeployments;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.IRestApi getApi() {
            return this.api;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.Boolean getRetainDeployments() {
            return this.retainDeployments;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("api", om.valueToTree(this.getApi()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getRetainDeployments() != null) {
                data.set("retainDeployments", om.valueToTree(this.getRetainDeployments()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.DeploymentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeploymentProps.Jsii$Proxy that = (DeploymentProps.Jsii$Proxy) o;

            if (!api.equals(that.api)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.retainDeployments != null ? this.retainDeployments.equals(that.retainDeployments) : that.retainDeployments == null;
        }

        @Override
        public int hashCode() {
            int result = this.api.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.retainDeployments != null ? this.retainDeployments.hashCode() : 0);
            return result;
        }
    }
}
