package software.amazon.awscdk.services.apigateway;

/**
 * Attributes that can be specified when importing a RestApi.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-19T20:38:33.091Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.RestApiAttributes")
@software.amazon.jsii.Jsii.Proxy(RestApiAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RestApiAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the API Gateway RestApi.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRestApiId();

    /**
     * The resource ID of the root resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRootResourceId();

    /**
     * @return a {@link Builder} of {@link RestApiAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RestApiAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RestApiAttributes> {
        private java.lang.String restApiId;
        private java.lang.String rootResourceId;

        /**
         * Sets the value of {@link RestApiAttributes#getRestApiId}
         * @param restApiId The ID of the API Gateway RestApi. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiId(java.lang.String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        /**
         * Sets the value of {@link RestApiAttributes#getRootResourceId}
         * @param rootResourceId The resource ID of the root resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rootResourceId(java.lang.String rootResourceId) {
            this.rootResourceId = rootResourceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RestApiAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RestApiAttributes build() {
            return new Jsii$Proxy(restApiId, rootResourceId);
        }
    }

    /**
     * An implementation for {@link RestApiAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RestApiAttributes {
        private final java.lang.String restApiId;
        private final java.lang.String rootResourceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.restApiId = this.jsiiGet("restApiId", java.lang.String.class);
            this.rootResourceId = this.jsiiGet("rootResourceId", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String restApiId, final java.lang.String rootResourceId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.restApiId = java.util.Objects.requireNonNull(restApiId, "restApiId is required");
            this.rootResourceId = java.util.Objects.requireNonNull(rootResourceId, "rootResourceId is required");
        }

        @Override
        public java.lang.String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public java.lang.String getRootResourceId() {
            return this.rootResourceId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("restApiId", om.valueToTree(this.getRestApiId()));
            data.set("rootResourceId", om.valueToTree(this.getRootResourceId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.RestApiAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RestApiAttributes.Jsii$Proxy that = (RestApiAttributes.Jsii$Proxy) o;

            if (!restApiId.equals(that.restApiId)) return false;
            return this.rootResourceId.equals(that.rootResourceId);
        }

        @Override
        public int hashCode() {
            int result = this.restApiId.hashCode();
            result = 31 * result + (this.rootResourceId.hashCode());
            return result;
        }
    }
}
