package software.amazon.awscdk.services.apigateway;

/**
 * Token based lambda authorizer that recognizes the caller's identity as a bearer token, such as a JSON Web Token (JWT) or an OAuth token.
 * <p>
 * Based on the token, authorization is performed by a lambda function.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-19T20:38:33.108Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.TokenAuthorizer")
public class TokenAuthorizer extends software.amazon.awscdk.services.apigateway.Authorizer implements software.amazon.awscdk.services.apigateway.IAuthorizer {

    protected TokenAuthorizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TokenAuthorizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public TokenAuthorizer(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.TokenAuthorizerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns a token that resolves to the Rest Api Id at the time of synthesis.
     * <p>
     * Throws an error, during token resolution, if no RestApi is attached to this authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.String lazyRestApiId() {
        return this.jsiiCall("lazyRestApiId", java.lang.String.class);
    }

    /**
     * Sets up the permissions necessary for the API Gateway service to invoke the Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setupPermissions() {
        this.jsiiCall("setupPermissions", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * The ARN of the authorizer to be used in permission policies, such as IAM and resource-based grants.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuthorizerArn() {
        return this.jsiiGet("authorizerArn", java.lang.String.class);
    }

    /**
     * The id of the authorizer.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuthorizerId() {
        return this.jsiiGet("authorizerId", java.lang.String.class);
    }

    /**
     * The Lambda function handler that this authorizer uses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction getHandler() {
        return this.jsiiGet("handler", software.amazon.awscdk.services.lambda.IFunction.class);
    }

    /**
     * The IAM role that the API Gateway service assumes while invoking the Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.String getRestApiId() {
        return this.jsiiGet("restApiId", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setRestApiId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("restApiId", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.TokenAuthorizer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.TokenAuthorizer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.TokenAuthorizerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.TokenAuthorizerProps.Builder();
        }

        /**
         * The handler for the authorizer lambda function.
         * <p>
         * The handler must follow a very specific protocol on the input it receives and the output it needs to produce.
         * API Gateway has documented the handler's input specification
         * {&#64;link https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-input.html | here} and output specification
         * {&#64;link https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html | here}.
         * <p>
         * @return {@code this}
         * @param handler The handler for the authorizer lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder handler(final software.amazon.awscdk.services.lambda.IFunction handler) {
            this.props.handler(handler);
            return this;
        }

        /**
         * An optional IAM role for APIGateway to assume before calling the Lambda-based authorizer.
         * <p>
         * The IAM role must be
         * assumable by 'apigateway.amazonaws.com'.
         * <p>
         * Default: - A resource policy is added to the Lambda function allowing apigateway.amazonaws.com to invoke the function.
         * <p>
         * @return {@code this}
         * @param assumeRole An optional IAM role for APIGateway to assume before calling the Lambda-based authorizer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumeRole(final software.amazon.awscdk.services.iam.IRole assumeRole) {
            this.props.assumeRole(assumeRole);
            return this;
        }

        /**
         * An optional human friendly name for the authorizer.
         * <p>
         * Note that, this is not the primary identifier of the authorizer.
         * <p>
         * Default: this.node.uniqueId
         * <p>
         * @return {@code this}
         * @param authorizerName An optional human friendly name for the authorizer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerName(final java.lang.String authorizerName) {
            this.props.authorizerName(authorizerName);
            return this;
        }

        /**
         * How long APIGateway should cache the results.
         * <p>
         * Max 1 hour.
         * Disable caching by setting this to 0.
         * <p>
         * Default: Duration.minutes(5)
         * <p>
         * @return {@code this}
         * @param resultsCacheTtl How long APIGateway should cache the results. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultsCacheTtl(final software.amazon.awscdk.core.Duration resultsCacheTtl) {
            this.props.resultsCacheTtl(resultsCacheTtl);
            return this;
        }

        /**
         * The request header mapping expression for the bearer token.
         * <p>
         * This is typically passed as part of the header, in which case
         * this should be <code>method.request.header.Authorizer</code> where Authorizer is the header containing the bearer token.
         * <p>
         * Default: `IdentitySource.header('Authorization')`
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/apigateway/api-reference/link-relation/authorizer-create/#identitySource
         * @param identitySource The request header mapping expression for the bearer token. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identitySource(final java.lang.String identitySource) {
            this.props.identitySource(identitySource);
            return this;
        }

        /**
         * An optional regex to be matched against the authorization token.
         * <p>
         * When matched the authorizer lambda is invoked,
         * otherwise a 401 Unauthorized is returned to the client.
         * <p>
         * Default: - no regex filter will be applied.
         * <p>
         * @return {@code this}
         * @param validationRegex An optional regex to be matched against the authorization token. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationRegex(final java.lang.String validationRegex) {
            this.props.validationRegex(validationRegex);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.TokenAuthorizer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.TokenAuthorizer build() {
            return new software.amazon.awscdk.services.apigateway.TokenAuthorizer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
