/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.apigateway.MethodDeploymentOptions;
import software.amazon.awscdk.services.apigateway.MethodLoggingLevel;
import software.amazon.jsii.JsiiSerializable;

public interface MethodDeploymentOptions
extends JsiiSerializable {
    public Boolean getCacheDataEncrypted();

    public Duration getCacheTtl();

    public Boolean getCachingEnabled();

    public Boolean getDataTraceEnabled();

    public MethodLoggingLevel getLoggingLevel();

    public Boolean getMetricsEnabled();

    public Number getThrottlingBurstLimit();

    public Number getThrottlingRateLimit();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean cacheDataEncrypted;
        private Duration cacheTtl;
        private Boolean cachingEnabled;
        private Boolean dataTraceEnabled;
        private MethodLoggingLevel loggingLevel;
        private Boolean metricsEnabled;
        private Number throttlingBurstLimit;
        private Number throttlingRateLimit;

        public Builder cacheDataEncrypted(Boolean cacheDataEncrypted) {
            this.cacheDataEncrypted = cacheDataEncrypted;
            return this;
        }

        public Builder cacheTtl(Duration cacheTtl) {
            this.cacheTtl = cacheTtl;
            return this;
        }

        public Builder cachingEnabled(Boolean cachingEnabled) {
            this.cachingEnabled = cachingEnabled;
            return this;
        }

        public Builder dataTraceEnabled(Boolean dataTraceEnabled) {
            this.dataTraceEnabled = dataTraceEnabled;
            return this;
        }

        public Builder loggingLevel(MethodLoggingLevel loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        public Builder metricsEnabled(Boolean metricsEnabled) {
            this.metricsEnabled = metricsEnabled;
            return this;
        }

        public Builder throttlingBurstLimit(Number throttlingBurstLimit) {
            this.throttlingBurstLimit = throttlingBurstLimit;
            return this;
        }

        public Builder throttlingRateLimit(Number throttlingRateLimit) {
            this.throttlingRateLimit = throttlingRateLimit;
            return this;
        }

        public MethodDeploymentOptions build() {
            return new Jsii.Proxy(this.cacheDataEncrypted, this.cacheTtl, this.cachingEnabled, this.dataTraceEnabled, this.loggingLevel, this.metricsEnabled, this.throttlingBurstLimit, this.throttlingRateLimit, null);
        }
    }
}

