package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a `AWS::ApiGateway::RestApi`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.14.1 (build 828de8a)", date = "2020-11-06T04:41:55.542Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnRestApiProps")
@software.amazon.jsii.Jsii.Proxy(CfnRestApiProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRestApiProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::ApiGateway::RestApi.ApiKeySourceType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-apikeysourcetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApiKeySourceType() {
        return null;
    }

    /**
     * `AWS::ApiGateway::RestApi.BinaryMediaTypes`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-binarymediatypes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBinaryMediaTypes() {
        return null;
    }

    /**
     * `AWS::ApiGateway::RestApi.Body`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-body
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBody() {
        return null;
    }

    /**
     * `AWS::ApiGateway::RestApi.BodyS3Location`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-bodys3location
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBodyS3Location() {
        return null;
    }

    /**
     * `AWS::ApiGateway::RestApi.CloneFrom`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-clonefrom
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCloneFrom() {
        return null;
    }

    /**
     * `AWS::ApiGateway::RestApi.Description`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * `AWS::ApiGateway::RestApi.EndpointConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-endpointconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEndpointConfiguration() {
        return null;
    }

    /**
     * `AWS::ApiGateway::RestApi.FailOnWarnings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-failonwarnings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFailOnWarnings() {
        return null;
    }

    /**
     * `AWS::ApiGateway::RestApi.MinimumCompressionSize`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-minimumcompressionsize
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinimumCompressionSize() {
        return null;
    }

    /**
     * `AWS::ApiGateway::RestApi.Name`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * `AWS::ApiGateway::RestApi.Parameters`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return null;
    }

    /**
     * `AWS::ApiGateway::RestApi.Policy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPolicy() {
        return null;
    }

    /**
     * `AWS::ApiGateway::RestApi.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRestApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRestApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRestApiProps> {
        private java.lang.String apiKeySourceType;
        private java.util.List<java.lang.String> binaryMediaTypes;
        private java.lang.Object body;
        private java.lang.Object bodyS3Location;
        private java.lang.String cloneFrom;
        private java.lang.String description;
        private java.lang.Object endpointConfiguration;
        private java.lang.Object failOnWarnings;
        private java.lang.Number minimumCompressionSize;
        private java.lang.String name;
        private java.lang.Object parameters;
        private java.lang.Object policy;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnRestApiProps#getApiKeySourceType}
         * @param apiKeySourceType `AWS::ApiGateway::RestApi.ApiKeySourceType`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeySourceType(java.lang.String apiKeySourceType) {
            this.apiKeySourceType = apiKeySourceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getBinaryMediaTypes}
         * @param binaryMediaTypes `AWS::ApiGateway::RestApi.BinaryMediaTypes`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder binaryMediaTypes(java.util.List<java.lang.String> binaryMediaTypes) {
            this.binaryMediaTypes = binaryMediaTypes;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getBody}
         * @param body `AWS::ApiGateway::RestApi.Body`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder body(java.lang.Object body) {
            this.body = body;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getBodyS3Location}
         * @param bodyS3Location `AWS::ApiGateway::RestApi.BodyS3Location`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bodyS3Location(software.amazon.awscdk.core.IResolvable bodyS3Location) {
            this.bodyS3Location = bodyS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getBodyS3Location}
         * @param bodyS3Location `AWS::ApiGateway::RestApi.BodyS3Location`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bodyS3Location(software.amazon.awscdk.services.apigateway.CfnRestApi.S3LocationProperty bodyS3Location) {
            this.bodyS3Location = bodyS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getCloneFrom}
         * @param cloneFrom `AWS::ApiGateway::RestApi.CloneFrom`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloneFrom(java.lang.String cloneFrom) {
            this.cloneFrom = cloneFrom;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getDescription}
         * @param description `AWS::ApiGateway::RestApi.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getEndpointConfiguration}
         * @param endpointConfiguration `AWS::ApiGateway::RestApi.EndpointConfiguration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfiguration(software.amazon.awscdk.core.IResolvable endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getEndpointConfiguration}
         * @param endpointConfiguration `AWS::ApiGateway::RestApi.EndpointConfiguration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfiguration(software.amazon.awscdk.services.apigateway.CfnRestApi.EndpointConfigurationProperty endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getFailOnWarnings}
         * @param failOnWarnings `AWS::ApiGateway::RestApi.FailOnWarnings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(java.lang.Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getFailOnWarnings}
         * @param failOnWarnings `AWS::ApiGateway::RestApi.FailOnWarnings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(software.amazon.awscdk.core.IResolvable failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getMinimumCompressionSize}
         * @param minimumCompressionSize `AWS::ApiGateway::RestApi.MinimumCompressionSize`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumCompressionSize(java.lang.Number minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getName}
         * @param name `AWS::ApiGateway::RestApi.Name`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getParameters}
         * @param parameters `AWS::ApiGateway::RestApi.Parameters`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(software.amazon.awscdk.core.IResolvable parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getParameters}
         * @param parameters `AWS::ApiGateway::RestApi.Parameters`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getPolicy}
         * @param policy `AWS::ApiGateway::RestApi.Policy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(java.lang.Object policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getTags}
         * @param tags `AWS::ApiGateway::RestApi.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRestApiProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRestApiProps build() {
            return new Jsii$Proxy(apiKeySourceType, binaryMediaTypes, body, bodyS3Location, cloneFrom, description, endpointConfiguration, failOnWarnings, minimumCompressionSize, name, parameters, policy, tags);
        }
    }

    /**
     * An implementation for {@link CfnRestApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRestApiProps {
        private final java.lang.String apiKeySourceType;
        private final java.util.List<java.lang.String> binaryMediaTypes;
        private final java.lang.Object body;
        private final java.lang.Object bodyS3Location;
        private final java.lang.String cloneFrom;
        private final java.lang.String description;
        private final java.lang.Object endpointConfiguration;
        private final java.lang.Object failOnWarnings;
        private final java.lang.Number minimumCompressionSize;
        private final java.lang.String name;
        private final java.lang.Object parameters;
        private final java.lang.Object policy;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiKeySourceType = software.amazon.jsii.Kernel.get(this, "apiKeySourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.binaryMediaTypes = software.amazon.jsii.Kernel.get(this, "binaryMediaTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.body = software.amazon.jsii.Kernel.get(this, "body", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.bodyS3Location = software.amazon.jsii.Kernel.get(this, "bodyS3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cloneFrom = software.amazon.jsii.Kernel.get(this, "cloneFrom", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endpointConfiguration = software.amazon.jsii.Kernel.get(this, "endpointConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.failOnWarnings = software.amazon.jsii.Kernel.get(this, "failOnWarnings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.minimumCompressionSize = software.amazon.jsii.Kernel.get(this, "minimumCompressionSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.policy = software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.String apiKeySourceType, final java.util.List<java.lang.String> binaryMediaTypes, final java.lang.Object body, final java.lang.Object bodyS3Location, final java.lang.String cloneFrom, final java.lang.String description, final java.lang.Object endpointConfiguration, final java.lang.Object failOnWarnings, final java.lang.Number minimumCompressionSize, final java.lang.String name, final java.lang.Object parameters, final java.lang.Object policy, final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiKeySourceType = apiKeySourceType;
            this.binaryMediaTypes = binaryMediaTypes;
            this.body = body;
            this.bodyS3Location = bodyS3Location;
            this.cloneFrom = cloneFrom;
            this.description = description;
            this.endpointConfiguration = endpointConfiguration;
            this.failOnWarnings = failOnWarnings;
            this.minimumCompressionSize = minimumCompressionSize;
            this.name = name;
            this.parameters = parameters;
            this.policy = policy;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
        }

        @Override
        public final java.lang.String getApiKeySourceType() {
            return this.apiKeySourceType;
        }

        @Override
        public final java.util.List<java.lang.String> getBinaryMediaTypes() {
            return this.binaryMediaTypes;
        }

        @Override
        public final java.lang.Object getBody() {
            return this.body;
        }

        @Override
        public final java.lang.Object getBodyS3Location() {
            return this.bodyS3Location;
        }

        @Override
        public final java.lang.String getCloneFrom() {
            return this.cloneFrom;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getEndpointConfiguration() {
            return this.endpointConfiguration;
        }

        @Override
        public final java.lang.Object getFailOnWarnings() {
            return this.failOnWarnings;
        }

        @Override
        public final java.lang.Number getMinimumCompressionSize() {
            return this.minimumCompressionSize;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        public final java.lang.Object getPolicy() {
            return this.policy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApiKeySourceType() != null) {
                data.set("apiKeySourceType", om.valueToTree(this.getApiKeySourceType()));
            }
            if (this.getBinaryMediaTypes() != null) {
                data.set("binaryMediaTypes", om.valueToTree(this.getBinaryMediaTypes()));
            }
            if (this.getBody() != null) {
                data.set("body", om.valueToTree(this.getBody()));
            }
            if (this.getBodyS3Location() != null) {
                data.set("bodyS3Location", om.valueToTree(this.getBodyS3Location()));
            }
            if (this.getCloneFrom() != null) {
                data.set("cloneFrom", om.valueToTree(this.getCloneFrom()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEndpointConfiguration() != null) {
                data.set("endpointConfiguration", om.valueToTree(this.getEndpointConfiguration()));
            }
            if (this.getFailOnWarnings() != null) {
                data.set("failOnWarnings", om.valueToTree(this.getFailOnWarnings()));
            }
            if (this.getMinimumCompressionSize() != null) {
                data.set("minimumCompressionSize", om.valueToTree(this.getMinimumCompressionSize()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getPolicy() != null) {
                data.set("policy", om.valueToTree(this.getPolicy()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnRestApiProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRestApiProps.Jsii$Proxy that = (CfnRestApiProps.Jsii$Proxy) o;

            if (this.apiKeySourceType != null ? !this.apiKeySourceType.equals(that.apiKeySourceType) : that.apiKeySourceType != null) return false;
            if (this.binaryMediaTypes != null ? !this.binaryMediaTypes.equals(that.binaryMediaTypes) : that.binaryMediaTypes != null) return false;
            if (this.body != null ? !this.body.equals(that.body) : that.body != null) return false;
            if (this.bodyS3Location != null ? !this.bodyS3Location.equals(that.bodyS3Location) : that.bodyS3Location != null) return false;
            if (this.cloneFrom != null ? !this.cloneFrom.equals(that.cloneFrom) : that.cloneFrom != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.endpointConfiguration != null ? !this.endpointConfiguration.equals(that.endpointConfiguration) : that.endpointConfiguration != null) return false;
            if (this.failOnWarnings != null ? !this.failOnWarnings.equals(that.failOnWarnings) : that.failOnWarnings != null) return false;
            if (this.minimumCompressionSize != null ? !this.minimumCompressionSize.equals(that.minimumCompressionSize) : that.minimumCompressionSize != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.policy != null ? !this.policy.equals(that.policy) : that.policy != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiKeySourceType != null ? this.apiKeySourceType.hashCode() : 0;
            result = 31 * result + (this.binaryMediaTypes != null ? this.binaryMediaTypes.hashCode() : 0);
            result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
            result = 31 * result + (this.bodyS3Location != null ? this.bodyS3Location.hashCode() : 0);
            result = 31 * result + (this.cloneFrom != null ? this.cloneFrom.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.endpointConfiguration != null ? this.endpointConfiguration.hashCode() : 0);
            result = 31 * result + (this.failOnWarnings != null ? this.failOnWarnings.hashCode() : 0);
            result = 31 * result + (this.minimumCompressionSize != null ? this.minimumCompressionSize.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
