package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a `AWS::ApiGatewayV2::Api`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-10T21:22:40.385Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnApiV2Props extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::ApiGatewayV2::Api.Name`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getName();

    /**
     * `AWS::ApiGatewayV2::Api.ProtocolType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-protocoltype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getProtocolType();

    /**
     * `AWS::ApiGatewayV2::Api.RouteSelectionExpression`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-routeselectionexpression
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getRouteSelectionExpression();

    /**
     * `AWS::ApiGatewayV2::Api.ApiKeySelectionExpression`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-apikeyselectionexpression
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getApiKeySelectionExpression();

    /**
     * `AWS::ApiGatewayV2::Api.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDescription();

    /**
     * `AWS::ApiGatewayV2::Api.DisableSchemaValidation`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-disableschemavalidation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getDisableSchemaValidation();

    /**
     * `AWS::ApiGatewayV2::Api.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getTags();

    /**
     * `AWS::ApiGatewayV2::Api.Version`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-version
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getVersion();

    /**
     * @return a {@link Builder} of {@link CfnApiV2Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnApiV2Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Builder {
        private java.lang.String name;
        private java.lang.String protocolType;
        private java.lang.String routeSelectionExpression;
        private java.lang.String apiKeySelectionExpression;
        private java.lang.String description;
        private java.lang.Object disableSchemaValidation;
        private java.lang.Object tags;
        private java.lang.String version;

        /**
         * Sets the value of Name
         * @param name `AWS::ApiGatewayV2::Api.Name`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of ProtocolType
         * @param protocolType `AWS::ApiGatewayV2::Api.ProtocolType`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder protocolType(java.lang.String protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        /**
         * Sets the value of RouteSelectionExpression
         * @param routeSelectionExpression `AWS::ApiGatewayV2::Api.RouteSelectionExpression`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder routeSelectionExpression(java.lang.String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
            return this;
        }

        /**
         * Sets the value of ApiKeySelectionExpression
         * @param apiKeySelectionExpression `AWS::ApiGatewayV2::Api.ApiKeySelectionExpression`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder apiKeySelectionExpression(java.lang.String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
            return this;
        }

        /**
         * Sets the value of Description
         * @param description `AWS::ApiGatewayV2::Api.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of DisableSchemaValidation
         * @param disableSchemaValidation `AWS::ApiGatewayV2::Api.DisableSchemaValidation`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder disableSchemaValidation(java.lang.Boolean disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
            return this;
        }

        /**
         * Sets the value of DisableSchemaValidation
         * @param disableSchemaValidation `AWS::ApiGatewayV2::Api.DisableSchemaValidation`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder disableSchemaValidation(software.amazon.awscdk.core.IResolvable disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
            return this;
        }

        /**
         * Sets the value of Tags
         * @param tags `AWS::ApiGatewayV2::Api.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of Version
         * @param version `AWS::ApiGatewayV2::Api.Version`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApiV2Props}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnApiV2Props build() {
            return new Jsii$Proxy(name, protocolType, routeSelectionExpression, apiKeySelectionExpression, description, disableSchemaValidation, tags, version);
        }

    }

    /**
     * An implementation for {@link CfnApiV2Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApiV2Props {
        private final java.lang.String name;
        private final java.lang.String protocolType;
        private final java.lang.String routeSelectionExpression;
        private final java.lang.String apiKeySelectionExpression;
        private final java.lang.String description;
        private final java.lang.Object disableSchemaValidation;
        private final java.lang.Object tags;
        private final java.lang.String version;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.name = this.jsiiGet("name", java.lang.String.class);
            this.protocolType = this.jsiiGet("protocolType", java.lang.String.class);
            this.routeSelectionExpression = this.jsiiGet("routeSelectionExpression", java.lang.String.class);
            this.apiKeySelectionExpression = this.jsiiGet("apiKeySelectionExpression", java.lang.String.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.disableSchemaValidation = this.jsiiGet("disableSchemaValidation", java.lang.Object.class);
            this.tags = this.jsiiGet("tags", java.lang.Object.class);
            this.version = this.jsiiGet("version", java.lang.String.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String name, java.lang.String protocolType, java.lang.String routeSelectionExpression, java.lang.String apiKeySelectionExpression, java.lang.String description, java.lang.Object disableSchemaValidation, java.lang.Object tags, java.lang.String version) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(name, "name is required");
            this.protocolType = java.util.Objects.requireNonNull(protocolType, "protocolType is required");
            this.routeSelectionExpression = java.util.Objects.requireNonNull(routeSelectionExpression, "routeSelectionExpression is required");
            this.apiKeySelectionExpression = apiKeySelectionExpression;
            this.description = description;
            this.disableSchemaValidation = disableSchemaValidation;
            this.tags = tags;
            this.version = version;
        }

        @Override
        public java.lang.String getName() {
            return this.name;
        }

        @Override
        public java.lang.String getProtocolType() {
            return this.protocolType;
        }

        @Override
        public java.lang.String getRouteSelectionExpression() {
            return this.routeSelectionExpression;
        }

        @Override
        public java.lang.String getApiKeySelectionExpression() {
            return this.apiKeySelectionExpression;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.Object getDisableSchemaValidation() {
            return this.disableSchemaValidation;
        }

        @Override
        public java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        public java.lang.String getVersion() {
            return this.version;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("name", om.valueToTree(this.getName()));
            obj.set("protocolType", om.valueToTree(this.getProtocolType()));
            obj.set("routeSelectionExpression", om.valueToTree(this.getRouteSelectionExpression()));
            if (this.getApiKeySelectionExpression() != null) {
                obj.set("apiKeySelectionExpression", om.valueToTree(this.getApiKeySelectionExpression()));
            }
            if (this.getDescription() != null) {
                obj.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDisableSchemaValidation() != null) {
                obj.set("disableSchemaValidation", om.valueToTree(this.getDisableSchemaValidation()));
            }
            if (this.getTags() != null) {
                obj.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVersion() != null) {
                obj.set("version", om.valueToTree(this.getVersion()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApiV2Props.Jsii$Proxy that = (CfnApiV2Props.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!protocolType.equals(that.protocolType)) return false;
            if (!routeSelectionExpression.equals(that.routeSelectionExpression)) return false;
            if (this.apiKeySelectionExpression != null ? !this.apiKeySelectionExpression.equals(that.apiKeySelectionExpression) : that.apiKeySelectionExpression != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.disableSchemaValidation != null ? !this.disableSchemaValidation.equals(that.disableSchemaValidation) : that.disableSchemaValidation != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.version != null ? this.version.equals(that.version) : that.version == null;
        }

        @Override
        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.protocolType.hashCode());
            result = 31 * result + (this.routeSelectionExpression.hashCode());
            result = 31 * result + (this.apiKeySelectionExpression != null ? this.apiKeySelectionExpression.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.disableSchemaValidation != null ? this.disableSchemaValidation.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            return result;
        }

    }
}
