package software.amazon.awscdk.services.apigateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-10T21:22:40.451Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DomainNameOptions extends software.amazon.jsii.JsiiSerializable {
    /**
     * The reference to an AWS-managed certificate for use by the edge-optimized endpoint for the domain name.
     * 
     * For "EDGE" domain names, the certificate
     * needs to be in the US East (N. Virginia) region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate();

    /**
     * The custom domain name for your API.
     * 
     * Uppercase letters are not supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDomainName();

    /**
     * The type of endpoint for this DomainName.
     * 
     * Default: REGIONAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.EndpointType getEndpointType();

    /**
     * @return a {@link Builder} of {@link DomainNameOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link DomainNameOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        private java.lang.String domainName;
        private software.amazon.awscdk.services.apigateway.EndpointType endpointType;

        /**
         * Sets the value of Certificate
         * @param certificate The reference to an AWS-managed certificate for use by the edge-optimized endpoint for the domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificate(software.amazon.awscdk.services.certificatemanager.ICertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Sets the value of DomainName
         * @param domainName The custom domain name for your API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of EndpointType
         * @param endpointType The type of endpoint for this DomainName.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointType(software.amazon.awscdk.services.apigateway.EndpointType endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DomainNameOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public DomainNameOptions build() {
            return new Jsii$Proxy(certificate, domainName, endpointType);
        }

    }

    /**
     * An implementation for {@link DomainNameOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainNameOptions {
        private final software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        private final java.lang.String domainName;
        private final software.amazon.awscdk.services.apigateway.EndpointType endpointType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.certificate = this.jsiiGet("certificate", software.amazon.awscdk.services.certificatemanager.ICertificate.class);
            this.domainName = this.jsiiGet("domainName", java.lang.String.class);
            this.endpointType = this.jsiiGet("endpointType", software.amazon.awscdk.services.apigateway.EndpointType.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.services.certificatemanager.ICertificate certificate, java.lang.String domainName, software.amazon.awscdk.services.apigateway.EndpointType endpointType) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.certificate = java.util.Objects.requireNonNull(certificate, "certificate is required");
            this.domainName = java.util.Objects.requireNonNull(domainName, "domainName is required");
            this.endpointType = endpointType;
        }

        @Override
        public software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
            return this.certificate;
        }

        @Override
        public java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.EndpointType getEndpointType() {
            return this.endpointType;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("certificate", om.valueToTree(this.getCertificate()));
            obj.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getEndpointType() != null) {
                obj.set("endpointType", om.valueToTree(this.getEndpointType()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DomainNameOptions.Jsii$Proxy that = (DomainNameOptions.Jsii$Proxy) o;

            if (!certificate.equals(that.certificate)) return false;
            if (!domainName.equals(that.domainName)) return false;
            return this.endpointType != null ? this.endpointType.equals(that.endpointType) : that.endpointType == null;
        }

        @Override
        public int hashCode() {
            int result = this.certificate.hashCode();
            result = 31 * result + (this.domainName.hashCode());
            result = 31 * result + (this.endpointType != null ? this.endpointType.hashCode() : 0);
            return result;
        }

    }
}
