package software.amazon.awscdk.services.apigateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-10T21:22:40.467Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LambdaRestApiProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.RestApiProps {
    /**
     * The default Lambda function that handles all requests from this API.
     * 
     * This handler will be used as a the default integration for all methods in
     * this API, unless specified otherwise in `addMethod`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.lambda.IFunction getHandler();

    /**
     * Default: - no options.
     * 
     * @deprecated the `LambdaRestApiProps` now extends `RestApiProps`, so all
     * options are just available here. Note that the options specified in
     * `options` will be overridden by any props specified at the root level.
     */
    @Deprecated
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    software.amazon.awscdk.services.apigateway.RestApiProps getOptions();

    /**
     * If true, route all requests to the Lambda Function.
     * 
     * If set to false, you will need to explicitly define the API model using
     * `addResource` and `addMethod` (or `addProxy`).
     * 
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getProxy();

    /**
     * @return a {@link Builder} of {@link LambdaRestApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link LambdaRestApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.lambda.IFunction handler;
        private software.amazon.awscdk.services.apigateway.RestApiProps options;
        private java.lang.Boolean proxy;
        private software.amazon.awscdk.services.apigateway.ApiKeySourceType apiKeySourceType;
        private java.util.List<java.lang.String> binaryMediaTypes;
        private software.amazon.awscdk.services.apigateway.IRestApi cloneFrom;
        private java.lang.Boolean cloudWatchRole;
        private java.lang.Boolean deploy;
        private software.amazon.awscdk.services.apigateway.StageOptions deployOptions;
        private java.lang.String description;
        private software.amazon.awscdk.services.apigateway.DomainNameOptions domainName;
        private java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> endpointTypes;
        private java.lang.Boolean failOnWarnings;
        private java.lang.Number minimumCompressionSize;
        private java.util.Map<java.lang.String, java.lang.String> parameters;
        private software.amazon.awscdk.services.iam.PolicyDocument policy;
        private java.lang.String restApiName;
        private java.lang.Boolean retainDeployments;
        private software.amazon.awscdk.services.apigateway.Integration defaultIntegration;
        private software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions;

        /**
         * Sets the value of Handler
         * @param handler The default Lambda function that handles all requests from this API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder handler(software.amazon.awscdk.services.lambda.IFunction handler) {
            this.handler = handler;
            return this;
        }

        /**
         * Sets the value of Options
         * @param options the value to be set
         * @return {@code this}
         * @deprecated the `LambdaRestApiProps` now extends `RestApiProps`, so all
options are just available here. Note that the options specified in
`options` will be overridden by any props specified at the root level.
         */
        @Deprecated
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        public Builder options(software.amazon.awscdk.services.apigateway.RestApiProps options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of Proxy
         * @param proxy If true, route all requests to the Lambda Function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxy(java.lang.Boolean proxy) {
            this.proxy = proxy;
            return this;
        }

        /**
         * Sets the value of ApiKeySourceType
         * @param apiKeySourceType The source of the API key for metering requests according to a usage plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeySourceType(software.amazon.awscdk.services.apigateway.ApiKeySourceType apiKeySourceType) {
            this.apiKeySourceType = apiKeySourceType;
            return this;
        }

        /**
         * Sets the value of BinaryMediaTypes
         * @param binaryMediaTypes The list of binary media mime-types that are supported by the RestApi resource, such as "image/png" or "application/octet-stream".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder binaryMediaTypes(java.util.List<java.lang.String> binaryMediaTypes) {
            this.binaryMediaTypes = binaryMediaTypes;
            return this;
        }

        /**
         * Sets the value of CloneFrom
         * @param cloneFrom The ID of the API Gateway RestApi resource that you want to clone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloneFrom(software.amazon.awscdk.services.apigateway.IRestApi cloneFrom) {
            this.cloneFrom = cloneFrom;
            return this;
        }

        /**
         * Sets the value of CloudWatchRole
         * @param cloudWatchRole Automatically configure an AWS CloudWatch role for API Gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchRole(java.lang.Boolean cloudWatchRole) {
            this.cloudWatchRole = cloudWatchRole;
            return this;
        }

        /**
         * Sets the value of Deploy
         * @param deploy Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploy(java.lang.Boolean deploy) {
            this.deploy = deploy;
            return this;
        }

        /**
         * Sets the value of DeployOptions
         * @param deployOptions Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployOptions(software.amazon.awscdk.services.apigateway.StageOptions deployOptions) {
            this.deployOptions = deployOptions;
            return this;
        }

        /**
         * Sets the value of Description
         * @param description A description of the purpose of this API Gateway RestApi resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of DomainName
         * @param domainName Configure a custom domain name and map it to this API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(software.amazon.awscdk.services.apigateway.DomainNameOptions domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of EndpointTypes
         * @param endpointTypes A list of the endpoint types of the API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointTypes(java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> endpointTypes) {
            this.endpointTypes = endpointTypes;
            return this;
        }

        /**
         * Sets the value of FailOnWarnings
         * @param failOnWarnings Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(java.lang.Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        /**
         * Sets the value of MinimumCompressionSize
         * @param minimumCompressionSize A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (when undefined) on an API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumCompressionSize(java.lang.Number minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
            return this;
        }

        /**
         * Sets the value of Parameters
         * @param parameters Custom header parameters for the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of Policy
         * @param policy A policy document that contains the permissions for this RestApi.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(software.amazon.awscdk.services.iam.PolicyDocument policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of RestApiName
         * @param restApiName A name for the API Gateway RestApi resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiName(java.lang.String restApiName) {
            this.restApiName = restApiName;
            return this;
        }

        /**
         * Sets the value of RetainDeployments
         * @param retainDeployments Retains old deployment resources when the API changes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainDeployments(java.lang.Boolean retainDeployments) {
            this.retainDeployments = retainDeployments;
            return this;
        }

        /**
         * Sets the value of DefaultIntegration
         * @param defaultIntegration An integration to use as a default for all methods created within this API unless an integration is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultIntegration(software.amazon.awscdk.services.apigateway.Integration defaultIntegration) {
            this.defaultIntegration = defaultIntegration;
            return this;
        }

        /**
         * Sets the value of DefaultMethodOptions
         * @param defaultMethodOptions Method options to use as a default for all methods created within this API unless custom options are specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultMethodOptions(software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions) {
            this.defaultMethodOptions = defaultMethodOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaRestApiProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public LambdaRestApiProps build() {
            return new Jsii$Proxy(handler, options, proxy, apiKeySourceType, binaryMediaTypes, cloneFrom, cloudWatchRole, deploy, deployOptions, description, domainName, endpointTypes, failOnWarnings, minimumCompressionSize, parameters, policy, restApiName, retainDeployments, defaultIntegration, defaultMethodOptions);
        }

    }

    /**
     * An implementation for {@link LambdaRestApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaRestApiProps {
        private final software.amazon.awscdk.services.lambda.IFunction handler;
        private final software.amazon.awscdk.services.apigateway.RestApiProps options;
        private final java.lang.Boolean proxy;
        private final software.amazon.awscdk.services.apigateway.ApiKeySourceType apiKeySourceType;
        private final java.util.List<java.lang.String> binaryMediaTypes;
        private final software.amazon.awscdk.services.apigateway.IRestApi cloneFrom;
        private final java.lang.Boolean cloudWatchRole;
        private final java.lang.Boolean deploy;
        private final software.amazon.awscdk.services.apigateway.StageOptions deployOptions;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.apigateway.DomainNameOptions domainName;
        private final java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> endpointTypes;
        private final java.lang.Boolean failOnWarnings;
        private final java.lang.Number minimumCompressionSize;
        private final java.util.Map<java.lang.String, java.lang.String> parameters;
        private final software.amazon.awscdk.services.iam.PolicyDocument policy;
        private final java.lang.String restApiName;
        private final java.lang.Boolean retainDeployments;
        private final software.amazon.awscdk.services.apigateway.Integration defaultIntegration;
        private final software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.handler = this.jsiiGet("handler", software.amazon.awscdk.services.lambda.IFunction.class);
            this.options = this.jsiiGet("options", software.amazon.awscdk.services.apigateway.RestApiProps.class);
            this.proxy = this.jsiiGet("proxy", java.lang.Boolean.class);
            this.apiKeySourceType = this.jsiiGet("apiKeySourceType", software.amazon.awscdk.services.apigateway.ApiKeySourceType.class);
            this.binaryMediaTypes = this.jsiiGet("binaryMediaTypes", java.util.List.class);
            this.cloneFrom = this.jsiiGet("cloneFrom", software.amazon.awscdk.services.apigateway.IRestApi.class);
            this.cloudWatchRole = this.jsiiGet("cloudWatchRole", java.lang.Boolean.class);
            this.deploy = this.jsiiGet("deploy", java.lang.Boolean.class);
            this.deployOptions = this.jsiiGet("deployOptions", software.amazon.awscdk.services.apigateway.StageOptions.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.domainName = this.jsiiGet("domainName", software.amazon.awscdk.services.apigateway.DomainNameOptions.class);
            this.endpointTypes = this.jsiiGet("endpointTypes", java.util.List.class);
            this.failOnWarnings = this.jsiiGet("failOnWarnings", java.lang.Boolean.class);
            this.minimumCompressionSize = this.jsiiGet("minimumCompressionSize", java.lang.Number.class);
            this.parameters = this.jsiiGet("parameters", java.util.Map.class);
            this.policy = this.jsiiGet("policy", software.amazon.awscdk.services.iam.PolicyDocument.class);
            this.restApiName = this.jsiiGet("restApiName", java.lang.String.class);
            this.retainDeployments = this.jsiiGet("retainDeployments", java.lang.Boolean.class);
            this.defaultIntegration = this.jsiiGet("defaultIntegration", software.amazon.awscdk.services.apigateway.Integration.class);
            this.defaultMethodOptions = this.jsiiGet("defaultMethodOptions", software.amazon.awscdk.services.apigateway.MethodOptions.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.services.lambda.IFunction handler, software.amazon.awscdk.services.apigateway.RestApiProps options, java.lang.Boolean proxy, software.amazon.awscdk.services.apigateway.ApiKeySourceType apiKeySourceType, java.util.List<java.lang.String> binaryMediaTypes, software.amazon.awscdk.services.apigateway.IRestApi cloneFrom, java.lang.Boolean cloudWatchRole, java.lang.Boolean deploy, software.amazon.awscdk.services.apigateway.StageOptions deployOptions, java.lang.String description, software.amazon.awscdk.services.apigateway.DomainNameOptions domainName, java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> endpointTypes, java.lang.Boolean failOnWarnings, java.lang.Number minimumCompressionSize, java.util.Map<java.lang.String, java.lang.String> parameters, software.amazon.awscdk.services.iam.PolicyDocument policy, java.lang.String restApiName, java.lang.Boolean retainDeployments, software.amazon.awscdk.services.apigateway.Integration defaultIntegration, software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.handler = java.util.Objects.requireNonNull(handler, "handler is required");
            this.options = options;
            this.proxy = proxy;
            this.apiKeySourceType = apiKeySourceType;
            this.binaryMediaTypes = binaryMediaTypes;
            this.cloneFrom = cloneFrom;
            this.cloudWatchRole = cloudWatchRole;
            this.deploy = deploy;
            this.deployOptions = deployOptions;
            this.description = description;
            this.domainName = domainName;
            this.endpointTypes = endpointTypes;
            this.failOnWarnings = failOnWarnings;
            this.minimumCompressionSize = minimumCompressionSize;
            this.parameters = parameters;
            this.policy = policy;
            this.restApiName = restApiName;
            this.retainDeployments = retainDeployments;
            this.defaultIntegration = defaultIntegration;
            this.defaultMethodOptions = defaultMethodOptions;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IFunction getHandler() {
            return this.handler;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.RestApiProps getOptions() {
            return this.options;
        }

        @Override
        public java.lang.Boolean getProxy() {
            return this.proxy;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.ApiKeySourceType getApiKeySourceType() {
            return this.apiKeySourceType;
        }

        @Override
        public java.util.List<java.lang.String> getBinaryMediaTypes() {
            return this.binaryMediaTypes;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.IRestApi getCloneFrom() {
            return this.cloneFrom;
        }

        @Override
        public java.lang.Boolean getCloudWatchRole() {
            return this.cloudWatchRole;
        }

        @Override
        public java.lang.Boolean getDeploy() {
            return this.deploy;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.StageOptions getDeployOptions() {
            return this.deployOptions;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.DomainNameOptions getDomainName() {
            return this.domainName;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> getEndpointTypes() {
            return this.endpointTypes;
        }

        @Override
        public java.lang.Boolean getFailOnWarnings() {
            return this.failOnWarnings;
        }

        @Override
        public java.lang.Number getMinimumCompressionSize() {
            return this.minimumCompressionSize;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getParameters() {
            return this.parameters;
        }

        @Override
        public software.amazon.awscdk.services.iam.PolicyDocument getPolicy() {
            return this.policy;
        }

        @Override
        public java.lang.String getRestApiName() {
            return this.restApiName;
        }

        @Override
        public java.lang.Boolean getRetainDeployments() {
            return this.retainDeployments;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.Integration getDefaultIntegration() {
            return this.defaultIntegration;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.MethodOptions getDefaultMethodOptions() {
            return this.defaultMethodOptions;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("handler", om.valueToTree(this.getHandler()));
            if (this.getOptions() != null) {
                obj.set("options", om.valueToTree(this.getOptions()));
            }
            if (this.getProxy() != null) {
                obj.set("proxy", om.valueToTree(this.getProxy()));
            }
            if (this.getApiKeySourceType() != null) {
                obj.set("apiKeySourceType", om.valueToTree(this.getApiKeySourceType()));
            }
            if (this.getBinaryMediaTypes() != null) {
                obj.set("binaryMediaTypes", om.valueToTree(this.getBinaryMediaTypes()));
            }
            if (this.getCloneFrom() != null) {
                obj.set("cloneFrom", om.valueToTree(this.getCloneFrom()));
            }
            if (this.getCloudWatchRole() != null) {
                obj.set("cloudWatchRole", om.valueToTree(this.getCloudWatchRole()));
            }
            if (this.getDeploy() != null) {
                obj.set("deploy", om.valueToTree(this.getDeploy()));
            }
            if (this.getDeployOptions() != null) {
                obj.set("deployOptions", om.valueToTree(this.getDeployOptions()));
            }
            if (this.getDescription() != null) {
                obj.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDomainName() != null) {
                obj.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getEndpointTypes() != null) {
                obj.set("endpointTypes", om.valueToTree(this.getEndpointTypes()));
            }
            if (this.getFailOnWarnings() != null) {
                obj.set("failOnWarnings", om.valueToTree(this.getFailOnWarnings()));
            }
            if (this.getMinimumCompressionSize() != null) {
                obj.set("minimumCompressionSize", om.valueToTree(this.getMinimumCompressionSize()));
            }
            if (this.getParameters() != null) {
                obj.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getPolicy() != null) {
                obj.set("policy", om.valueToTree(this.getPolicy()));
            }
            if (this.getRestApiName() != null) {
                obj.set("restApiName", om.valueToTree(this.getRestApiName()));
            }
            if (this.getRetainDeployments() != null) {
                obj.set("retainDeployments", om.valueToTree(this.getRetainDeployments()));
            }
            if (this.getDefaultIntegration() != null) {
                obj.set("defaultIntegration", om.valueToTree(this.getDefaultIntegration()));
            }
            if (this.getDefaultMethodOptions() != null) {
                obj.set("defaultMethodOptions", om.valueToTree(this.getDefaultMethodOptions()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LambdaRestApiProps.Jsii$Proxy that = (LambdaRestApiProps.Jsii$Proxy) o;

            if (!handler.equals(that.handler)) return false;
            if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
            if (this.proxy != null ? !this.proxy.equals(that.proxy) : that.proxy != null) return false;
            if (this.apiKeySourceType != null ? !this.apiKeySourceType.equals(that.apiKeySourceType) : that.apiKeySourceType != null) return false;
            if (this.binaryMediaTypes != null ? !this.binaryMediaTypes.equals(that.binaryMediaTypes) : that.binaryMediaTypes != null) return false;
            if (this.cloneFrom != null ? !this.cloneFrom.equals(that.cloneFrom) : that.cloneFrom != null) return false;
            if (this.cloudWatchRole != null ? !this.cloudWatchRole.equals(that.cloudWatchRole) : that.cloudWatchRole != null) return false;
            if (this.deploy != null ? !this.deploy.equals(that.deploy) : that.deploy != null) return false;
            if (this.deployOptions != null ? !this.deployOptions.equals(that.deployOptions) : that.deployOptions != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.endpointTypes != null ? !this.endpointTypes.equals(that.endpointTypes) : that.endpointTypes != null) return false;
            if (this.failOnWarnings != null ? !this.failOnWarnings.equals(that.failOnWarnings) : that.failOnWarnings != null) return false;
            if (this.minimumCompressionSize != null ? !this.minimumCompressionSize.equals(that.minimumCompressionSize) : that.minimumCompressionSize != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.policy != null ? !this.policy.equals(that.policy) : that.policy != null) return false;
            if (this.restApiName != null ? !this.restApiName.equals(that.restApiName) : that.restApiName != null) return false;
            if (this.retainDeployments != null ? !this.retainDeployments.equals(that.retainDeployments) : that.retainDeployments != null) return false;
            if (this.defaultIntegration != null ? !this.defaultIntegration.equals(that.defaultIntegration) : that.defaultIntegration != null) return false;
            return this.defaultMethodOptions != null ? this.defaultMethodOptions.equals(that.defaultMethodOptions) : that.defaultMethodOptions == null;
        }

        @Override
        public int hashCode() {
            int result = this.handler.hashCode();
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.proxy != null ? this.proxy.hashCode() : 0);
            result = 31 * result + (this.apiKeySourceType != null ? this.apiKeySourceType.hashCode() : 0);
            result = 31 * result + (this.binaryMediaTypes != null ? this.binaryMediaTypes.hashCode() : 0);
            result = 31 * result + (this.cloneFrom != null ? this.cloneFrom.hashCode() : 0);
            result = 31 * result + (this.cloudWatchRole != null ? this.cloudWatchRole.hashCode() : 0);
            result = 31 * result + (this.deploy != null ? this.deploy.hashCode() : 0);
            result = 31 * result + (this.deployOptions != null ? this.deployOptions.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
            result = 31 * result + (this.endpointTypes != null ? this.endpointTypes.hashCode() : 0);
            result = 31 * result + (this.failOnWarnings != null ? this.failOnWarnings.hashCode() : 0);
            result = 31 * result + (this.minimumCompressionSize != null ? this.minimumCompressionSize.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
            result = 31 * result + (this.restApiName != null ? this.restApiName.hashCode() : 0);
            result = 31 * result + (this.retainDeployments != null ? this.retainDeployments.hashCode() : 0);
            result = 31 * result + (this.defaultIntegration != null ? this.defaultIntegration.hashCode() : 0);
            result = 31 * result + (this.defaultMethodOptions != null ? this.defaultMethodOptions.hashCode() : 0);
            return result;
        }

    }
}
