package software.amazon.awscdk.services.apigateway;

/**
 * Represents per-method throttling for a resource.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-10T21:22:40.492Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ThrottlingPerMethod extends software.amazon.jsii.JsiiSerializable {
    /**
     * [disable-awslint:ref-via-interface] The method for which you specify the throttling settings.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.Method getMethod();

    /**
     * Specifies the overall request rate (average requests per second) and burst capacity.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.ThrottleSettings getThrottle();

    /**
     * @return a {@link Builder} of {@link ThrottlingPerMethod}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ThrottlingPerMethod}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.apigateway.Method method;
        private software.amazon.awscdk.services.apigateway.ThrottleSettings throttle;

        /**
         * Sets the value of Method
         * @param method [disable-awslint:ref-via-interface] The method for which you specify the throttling settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder method(software.amazon.awscdk.services.apigateway.Method method) {
            this.method = method;
            return this;
        }

        /**
         * Sets the value of Throttle
         * @param throttle Specifies the overall request rate (average requests per second) and burst capacity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttle(software.amazon.awscdk.services.apigateway.ThrottleSettings throttle) {
            this.throttle = throttle;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ThrottlingPerMethod}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ThrottlingPerMethod build() {
            return new Jsii$Proxy(method, throttle);
        }

    }

    /**
     * An implementation for {@link ThrottlingPerMethod}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThrottlingPerMethod {
        private final software.amazon.awscdk.services.apigateway.Method method;
        private final software.amazon.awscdk.services.apigateway.ThrottleSettings throttle;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.method = this.jsiiGet("method", software.amazon.awscdk.services.apigateway.Method.class);
            this.throttle = this.jsiiGet("throttle", software.amazon.awscdk.services.apigateway.ThrottleSettings.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.services.apigateway.Method method, software.amazon.awscdk.services.apigateway.ThrottleSettings throttle) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.method = java.util.Objects.requireNonNull(method, "method is required");
            this.throttle = java.util.Objects.requireNonNull(throttle, "throttle is required");
        }

        @Override
        public software.amazon.awscdk.services.apigateway.Method getMethod() {
            return this.method;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.ThrottleSettings getThrottle() {
            return this.throttle;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("method", om.valueToTree(this.getMethod()));
            obj.set("throttle", om.valueToTree(this.getThrottle()));
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ThrottlingPerMethod.Jsii$Proxy that = (ThrottlingPerMethod.Jsii$Proxy) o;

            if (!method.equals(that.method)) return false;
            return this.throttle.equals(that.throttle);
        }

        @Override
        public int hashCode() {
            int result = this.method.hashCode();
            result = 31 * result + (this.throttle.hashCode());
            return result;
        }

    }
}
